# WebLogo: A Sequence Logo Generator

WebLogo is a web based application designed to make the generation of sequence logos as easy and painless as possible.

WebLogo can create output in several common graphics' formats, including the bitmap formats GIF and PNG, suitable for on-screen display, and the vector formats EPS and PDF, more suitable for printing, publication, and further editing. Additional graphics options include bitmap resolution, titles, optional axis, and axis labels, antialiasing, error bars, and alternative symbol formats.

A sequence logo is a graphical representation of an amino acid or nucleic acid multiple sequence alignment. Each logo consists of stacks of symbols, one stack for each position in the sequence. The overall height of the stack indicates the sequence conservation at that position, while the height of symbols within the stack indicates the relative frequency of each amino or nucleic acid at that position. The width of the stack is proportional to the fraction of valid symbols in that position.

> References

> Crooks GE, Hon G, Chandonia JM, Brenner SE WebLogo: A sequence logo generator, Genome Research, 14:1188-1190, (2004) [Full Text ](http://www.ncbi.nlm.nih.gov/pmc/articles/PMC419797/)

> Schneider TD, Stephens RM. 1990. Sequence Logos: A New Way to Display Consensus Sequences. Nucleic Acids Res. 18:6097-6100

## Current Software Version

3.7

## WebLogo 2

The legacy WebLogo 2 server can be found <a href="http://weblogo.berkeley.edu/">here.</a>

## Installation

To install with pip:

```sh
$ pip install weblogo
```

To install with conda:

```sh
$ conda install -c conda-forge weblogo
```

## Development

To install the development version of WebLogo, clone the github repository.

```sh
$ git clone git clone https://github.com/WebLogo/weblogo.git weblogo
```

Please consult the developer notes, <code>DEVELOPERS.txt</code> and software license <code>LICENSE.txt</code>

Outstanding bugs and feature requests are listed on the <a href="https://github.com/CrooksEnsemble/weblogo/issues">WebLogo issue tracker.</a>

## Open Source License

This package is distributed under the <a href="http://opensource.org/licenses/MIT">The MIT Open Source License Open Source License</a>. Much of the code was written by Gavin E. Crooks, Gary Hon, Steven Brenner, John-Marc Chandonia, Liana Lareau, David Ding, Clare Gollnick and other contributors.

## Copyright Notice

Copyright (c) 2006, The Regents of the University of California, through Copyright (c) 2006-2011, The Regents of the University of California, through Lawrence Berkeley National Laboratory (subject to receipt of any required approvals from the U.S. Dept. of Energy). All rights reserved.

Parts of this software package are covered by the individual copyrights of the contributors. Please refer to individual source code files for further details.

Notice:
This software was developed under funding from the U.S. Department of Energy. As such, the U.S. Government has been granted for itself and others acting on its behalf a paid-up, nonexclusive, irrevocable, worldwide license in the Software to reproduce, prepare derivative works, and perform publicly and display publicly. Beginning five (5) years after the date permission to assert copyright is obtained from the U.S. Department of Energy, and subject to any subsequent five (5) year renewals, the U.S. Government is granted for itself and others acting on its behalf a paid-up, nonexclusive, irrevocable, worldwide license in the Software to reproduce, prepare derivative works, distribute
copies to the public, perform publicly and display publicly, and to permit others to do so.

## Disclaimer

While no permanent records are kept of submitted sequences, we cannot undertake to guarantee that data sent to WebLogo remains secure. Moreover, no guarantees whatsoever are provided about data generated by WebLogo.

## Labels:

bioinformatics, python, biology, science, visualization
