# Official extensions

Official extensions are developed and maintained within the mkdocstrings organization on GitHub, in separated repositories. They generally bring support for various third-party libraries or other documentation-related features that are part of Python's standard library.

Extension | Description | Sponsors only?
--------- | ----------- | --------------
[`autodocstringstyle`](official/autodocstringstyle.md) | Set docstring style to `auto` for external packages. | [:octicons-heart-fill-24:{ .pulse }](../insiders/index.md){ .insiders }
[`inherited-docstrings`](official/inherited-docstrings.md) | Inherit docstrings from parent classes.
[`public-redundant-aliases`](official/public-redundant-aliases.md) | Mark objects imported with redundant aliases as public. | [:octicons-heart-fill-24:{ .pulse }](../insiders/index.md){ .insiders }
[`public-wildcard-imports`](official/public-wildcard-imports.md) | Mark wildcard imported objects as public. | [:octicons-heart-fill-24:{ .pulse }](../insiders/index.md){ .insiders }
[`pydantic`](official/pydantic.md) | Support for [Pydantic](https://docs.pydantic.dev/latest/) models.
[`runtime-objects`](official/runtime-objects.md) | Access runtime objects corresponding to each loaded Griffe object through their `extra` attribute. | [:octicons-heart-fill-24:{ .pulse }](../insiders/index.md){ .insiders }
[`sphinx`](official/sphinx.md) | Parse [Sphinx](https://www.sphinx-doc.org/)-comments above attributes (`#:`) as docstrings. | [:octicons-heart-fill-24:{ .pulse }](../insiders/index.md){ .insiders }
[`typing-doc`](official/typingdoc.md) | Support for [PEP 727](https://peps.python.org/pep-0727/)'s [`typing.Doc`][typing_extensions.Doc], "Documentation in Annotated Metadata".
[`warnings-deprecated`](official/warnings-deprecated.md) | Support for [PEP 702](https://peps.python.org/pep-0702/)'s [`warnings.deprecated`][], "Marking deprecations using the type system".
