# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storage import StorageManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageManagementTableServicesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_services_list(self, resource_group):
        response = self.client.table_services.list(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_services_set_service_properties(self, resource_group):
        response = self.client.table_services.set_service_properties(
            resource_group_name=resource_group.name,
            account_name="str",
            parameters={
                "cors": {
                    "corsRules": [
                        {
                            "allowedHeaders": ["str"],
                            "allowedMethods": ["str"],
                            "allowedOrigins": ["str"],
                            "exposedHeaders": ["str"],
                            "maxAgeInSeconds": 0,
                        }
                    ]
                },
                "id": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2023-05-01",
            table_service_name="default",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_services_get_service_properties(self, resource_group):
        response = self.client.table_services.get_service_properties(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2023-05-01",
            table_service_name="default",
        )

        # please add some check logic here by yourself
        # ...
