# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storage import StorageManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageManagementStorageTaskAssignmentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_task_assignments_begin_create(self, resource_group):
        response = self.client.storage_task_assignments.begin_create(
            resource_group_name=resource_group.name,
            account_name="str",
            storage_task_assignment_name="str",
            parameters={
                "properties": {
                    "description": "str",
                    "enabled": bool,
                    "executionContext": {
                        "trigger": {
                            "parameters": {
                                "endBy": "2020-02-20 00:00:00",
                                "interval": 0,
                                "intervalUnit": "Days",
                                "startFrom": "2020-02-20 00:00:00",
                                "startOn": "2020-02-20 00:00:00",
                            },
                            "type": "str",
                        },
                        "target": {"excludePrefix": ["str"], "prefix": ["str"]},
                    },
                    "report": {"prefix": "str"},
                    "taskId": "str",
                    "provisioningState": "str",
                    "runStatus": {
                        "finishTime": "str",
                        "objectFailedCount": "str",
                        "objectsOperatedOnCount": "str",
                        "objectsSucceededCount": "str",
                        "objectsTargetedCount": "str",
                        "runResult": "str",
                        "runStatusEnum": "str",
                        "runStatusError": "str",
                        "startTime": "str",
                        "storageAccountId": "str",
                        "summaryReportPath": "str",
                        "taskAssignmentId": "str",
                        "taskId": "str",
                        "taskVersion": "str",
                    },
                },
                "id": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2023-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_task_assignments_begin_update(self, resource_group):
        response = self.client.storage_task_assignments.begin_update(
            resource_group_name=resource_group.name,
            account_name="str",
            storage_task_assignment_name="str",
            parameters={
                "properties": {
                    "description": "str",
                    "enabled": bool,
                    "executionContext": {
                        "target": {"excludePrefix": ["str"], "prefix": ["str"]},
                        "trigger": {
                            "parameters": {
                                "endBy": "2020-02-20 00:00:00",
                                "interval": 0,
                                "intervalUnit": "Days",
                                "startFrom": "2020-02-20 00:00:00",
                                "startOn": "2020-02-20 00:00:00",
                            },
                            "type": "str",
                        },
                    },
                    "provisioningState": "str",
                    "report": {"prefix": "str"},
                    "runStatus": {
                        "finishTime": "str",
                        "objectFailedCount": "str",
                        "objectsOperatedOnCount": "str",
                        "objectsSucceededCount": "str",
                        "objectsTargetedCount": "str",
                        "runResult": "str",
                        "runStatusEnum": "str",
                        "runStatusError": "str",
                        "startTime": "str",
                        "storageAccountId": "str",
                        "summaryReportPath": "str",
                        "taskAssignmentId": "str",
                        "taskId": "str",
                        "taskVersion": "str",
                    },
                    "taskId": "str",
                }
            },
            api_version="2023-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_task_assignments_get(self, resource_group):
        response = self.client.storage_task_assignments.get(
            resource_group_name=resource_group.name,
            account_name="str",
            storage_task_assignment_name="str",
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_task_assignments_begin_delete(self, resource_group):
        response = self.client.storage_task_assignments.begin_delete(
            resource_group_name=resource_group.name,
            account_name="str",
            storage_task_assignment_name="str",
            api_version="2023-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_task_assignments_list(self, resource_group):
        response = self.client.storage_task_assignments.list(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2023-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
