# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storage.aio import StorageManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageManagementStorageAccountsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_check_name_availability(self, resource_group):
        response = await self.client.storage_accounts.check_name_availability(
            account_name={"name": "str", "type": "Microsoft.Storage/storageAccounts"},
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_begin_create(self, resource_group):
        response = await (
            await self.client.storage_accounts.begin_create(
                resource_group_name=resource_group.name,
                account_name="str",
                parameters={
                    "kind": "str",
                    "location": "str",
                    "sku": {"name": "str", "tier": "str"},
                    "accessTier": "str",
                    "allowBlobPublicAccess": bool,
                    "allowCrossTenantReplication": bool,
                    "allowSharedKeyAccess": bool,
                    "allowedCopyScope": "str",
                    "azureFilesIdentityBasedAuthentication": {
                        "directoryServiceOptions": "str",
                        "activeDirectoryProperties": {
                            "domainGuid": "str",
                            "domainName": "str",
                            "accountType": "str",
                            "azureStorageSid": "str",
                            "domainSid": "str",
                            "forestName": "str",
                            "netBiosDomainName": "str",
                            "samAccountName": "str",
                        },
                        "defaultSharePermission": "str",
                    },
                    "customDomain": {"name": "str", "useSubDomainName": bool},
                    "defaultToOAuthAuthentication": bool,
                    "dnsEndpointType": "str",
                    "enableExtendedGroups": bool,
                    "encryption": {
                        "identity": {"federatedIdentityClientId": "str", "userAssignedIdentity": "str"},
                        "keySource": "Microsoft.Storage",
                        "keyvaultproperties": {
                            "currentVersionedKeyExpirationTimestamp": "2020-02-20 00:00:00",
                            "currentVersionedKeyIdentifier": "str",
                            "keyname": "str",
                            "keyvaulturi": "str",
                            "keyversion": "str",
                            "lastKeyRotationTimestamp": "2020-02-20 00:00:00",
                        },
                        "requireInfrastructureEncryption": bool,
                        "services": {
                            "blob": {"enabled": bool, "keyType": "str", "lastEnabledTime": "2020-02-20 00:00:00"},
                            "file": {"enabled": bool, "keyType": "str", "lastEnabledTime": "2020-02-20 00:00:00"},
                            "queue": {"enabled": bool, "keyType": "str", "lastEnabledTime": "2020-02-20 00:00:00"},
                            "table": {"enabled": bool, "keyType": "str", "lastEnabledTime": "2020-02-20 00:00:00"},
                        },
                    },
                    "extendedLocation": {"name": "str", "type": "str"},
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "immutableStorageWithVersioning": {
                        "enabled": bool,
                        "immutabilityPolicy": {
                            "allowProtectedAppendWrites": bool,
                            "immutabilityPeriodSinceCreationInDays": 0,
                            "state": "str",
                        },
                    },
                    "isHnsEnabled": bool,
                    "isLocalUserEnabled": bool,
                    "isNfsV3Enabled": bool,
                    "isSftpEnabled": bool,
                    "keyPolicy": {"keyExpirationPeriodInDays": 0},
                    "largeFileSharesState": "str",
                    "minimumTlsVersion": "str",
                    "networkAcls": {
                        "defaultAction": "Allow",
                        "bypass": "AzureServices",
                        "ipRules": [{"value": "str", "action": "Allow"}],
                        "resourceAccessRules": [{"resourceId": "str", "tenantId": "str"}],
                        "virtualNetworkRules": [{"id": "str", "action": "Allow", "state": "str"}],
                    },
                    "publicNetworkAccess": "str",
                    "routingPreference": {
                        "publishInternetEndpoints": bool,
                        "publishMicrosoftEndpoints": bool,
                        "routingChoice": "str",
                    },
                    "sasPolicy": {"expirationAction": "Log", "sasExpirationPeriod": "str"},
                    "supportsHttpsTrafficOnly": bool,
                    "tags": {"str": "str"},
                },
                api_version="2023-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_delete(self, resource_group):
        response = await self.client.storage_accounts.delete(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_get_properties(self, resource_group):
        response = await self.client.storage_accounts.get_properties(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_update(self, resource_group):
        response = await self.client.storage_accounts.update(
            resource_group_name=resource_group.name,
            account_name="str",
            parameters={
                "accessTier": "str",
                "allowBlobPublicAccess": bool,
                "allowCrossTenantReplication": bool,
                "allowSharedKeyAccess": bool,
                "allowedCopyScope": "str",
                "azureFilesIdentityBasedAuthentication": {
                    "directoryServiceOptions": "str",
                    "activeDirectoryProperties": {
                        "domainGuid": "str",
                        "domainName": "str",
                        "accountType": "str",
                        "azureStorageSid": "str",
                        "domainSid": "str",
                        "forestName": "str",
                        "netBiosDomainName": "str",
                        "samAccountName": "str",
                    },
                    "defaultSharePermission": "str",
                },
                "customDomain": {"name": "str", "useSubDomainName": bool},
                "defaultToOAuthAuthentication": bool,
                "dnsEndpointType": "str",
                "enableExtendedGroups": bool,
                "encryption": {
                    "identity": {"federatedIdentityClientId": "str", "userAssignedIdentity": "str"},
                    "keySource": "Microsoft.Storage",
                    "keyvaultproperties": {
                        "currentVersionedKeyExpirationTimestamp": "2020-02-20 00:00:00",
                        "currentVersionedKeyIdentifier": "str",
                        "keyname": "str",
                        "keyvaulturi": "str",
                        "keyversion": "str",
                        "lastKeyRotationTimestamp": "2020-02-20 00:00:00",
                    },
                    "requireInfrastructureEncryption": bool,
                    "services": {
                        "blob": {"enabled": bool, "keyType": "str", "lastEnabledTime": "2020-02-20 00:00:00"},
                        "file": {"enabled": bool, "keyType": "str", "lastEnabledTime": "2020-02-20 00:00:00"},
                        "queue": {"enabled": bool, "keyType": "str", "lastEnabledTime": "2020-02-20 00:00:00"},
                        "table": {"enabled": bool, "keyType": "str", "lastEnabledTime": "2020-02-20 00:00:00"},
                    },
                },
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "immutableStorageWithVersioning": {
                    "enabled": bool,
                    "immutabilityPolicy": {
                        "allowProtectedAppendWrites": bool,
                        "immutabilityPeriodSinceCreationInDays": 0,
                        "state": "str",
                    },
                },
                "isLocalUserEnabled": bool,
                "isSftpEnabled": bool,
                "keyPolicy": {"keyExpirationPeriodInDays": 0},
                "kind": "str",
                "largeFileSharesState": "str",
                "minimumTlsVersion": "str",
                "networkAcls": {
                    "defaultAction": "Allow",
                    "bypass": "AzureServices",
                    "ipRules": [{"value": "str", "action": "Allow"}],
                    "resourceAccessRules": [{"resourceId": "str", "tenantId": "str"}],
                    "virtualNetworkRules": [{"id": "str", "action": "Allow", "state": "str"}],
                },
                "publicNetworkAccess": "str",
                "routingPreference": {
                    "publishInternetEndpoints": bool,
                    "publishMicrosoftEndpoints": bool,
                    "routingChoice": "str",
                },
                "sasPolicy": {"expirationAction": "Log", "sasExpirationPeriod": "str"},
                "sku": {"name": "str", "tier": "str"},
                "supportsHttpsTrafficOnly": bool,
                "tags": {"str": "str"},
            },
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_list(self, resource_group):
        response = self.client.storage_accounts.list(
            api_version="2023-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_list_by_resource_group(self, resource_group):
        response = self.client.storage_accounts.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_list_keys(self, resource_group):
        response = await self.client.storage_accounts.list_keys(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_regenerate_key(self, resource_group):
        response = await self.client.storage_accounts.regenerate_key(
            resource_group_name=resource_group.name,
            account_name="str",
            regenerate_key={"keyName": "str"},
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_list_account_sas(self, resource_group):
        response = await self.client.storage_accounts.list_account_sas(
            resource_group_name=resource_group.name,
            account_name="str",
            parameters={
                "signedExpiry": "2020-02-20 00:00:00",
                "signedPermission": "str",
                "signedResourceTypes": "str",
                "signedServices": "str",
                "keyToSign": "str",
                "signedIp": "str",
                "signedProtocol": "str",
                "signedStart": "2020-02-20 00:00:00",
            },
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_list_service_sas(self, resource_group):
        response = await self.client.storage_accounts.list_service_sas(
            resource_group_name=resource_group.name,
            account_name="str",
            parameters={
                "canonicalizedResource": "str",
                "endPk": "str",
                "endRk": "str",
                "keyToSign": "str",
                "rscc": "str",
                "rscd": "str",
                "rsce": "str",
                "rscl": "str",
                "rsct": "str",
                "signedExpiry": "2020-02-20 00:00:00",
                "signedIdentifier": "str",
                "signedIp": "str",
                "signedPermission": "str",
                "signedProtocol": "str",
                "signedResource": "str",
                "signedStart": "2020-02-20 00:00:00",
                "startPk": "str",
                "startRk": "str",
            },
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_begin_failover(self, resource_group):
        response = await (
            await self.client.storage_accounts.begin_failover(
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2023-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_begin_hierarchical_namespace_migration(self, resource_group):
        response = await (
            await self.client.storage_accounts.begin_hierarchical_namespace_migration(
                resource_group_name=resource_group.name,
                account_name="str",
                request_type="str",
                api_version="2023-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_begin_abort_hierarchical_namespace_migration(self, resource_group):
        response = await (
            await self.client.storage_accounts.begin_abort_hierarchical_namespace_migration(
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2023-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_begin_customer_initiated_migration(self, resource_group):
        response = await (
            await self.client.storage_accounts.begin_customer_initiated_migration(
                resource_group_name=resource_group.name,
                account_name="str",
                parameters={
                    "targetSkuName": "str",
                    "id": "str",
                    "migrationFailedDetailedReason": "str",
                    "migrationFailedReason": "str",
                    "migrationStatus": "str",
                    "name": "str",
                    "type": "str",
                },
                api_version="2023-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_get_customer_initiated_migration(self, resource_group):
        response = await self.client.storage_accounts.get_customer_initiated_migration(
            resource_group_name=resource_group.name,
            account_name="str",
            migration_name="str",
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_begin_restore_blob_ranges(self, resource_group):
        response = await (
            await self.client.storage_accounts.begin_restore_blob_ranges(
                resource_group_name=resource_group.name,
                account_name="str",
                parameters={
                    "blobRanges": [{"endRange": "str", "startRange": "str"}],
                    "timeToRestore": "2020-02-20 00:00:00",
                },
                api_version="2023-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_accounts_revoke_user_delegation_keys(self, resource_group):
        response = await self.client.storage_accounts.revoke_user_delegation_keys(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...
