# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource import DeploymentScriptsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDeploymentScriptsDeploymentScriptsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DeploymentScriptsClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create(self, resource_group):
        response = self.client.deployment_scripts.begin_create(
            resource_group_name=resource_group.name,
            script_name="str",
            deployment_script={
                "azCliVersion": "str",
                "kind": "AzureCLI",
                "location": "str",
                "retentionInterval": "1 day, 0:00:00",
                "arguments": "str",
                "cleanupPreference": "Always",
                "containerSettings": {"containerGroupName": "str"},
                "environmentVariables": [{"name": "str", "secureValue": "str", "value": "str"}],
                "forceUpdateTag": "str",
                "id": "str",
                "identity": {
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "outputs": {"str": {}},
                "primaryScriptUri": "str",
                "provisioningState": "str",
                "scriptContent": "str",
                "status": {
                    "containerInstanceId": "str",
                    "endTime": "2020-02-20 00:00:00",
                    "error": {
                        "additionalInfo": [{"info": {}, "type": "str"}],
                        "code": "str",
                        "details": [...],
                        "message": "str",
                        "target": "str",
                    },
                    "expirationTime": "2020-02-20 00:00:00",
                    "startTime": "2020-02-20 00:00:00",
                    "storageAccountId": "str",
                },
                "storageAccountSettings": {"storageAccountKey": "str", "storageAccountName": "str"},
                "supportingScriptUris": ["str"],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "timeout": "P1D",
                "type": "str",
            },
            api_version="2020-10-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.deployment_scripts.update(
            resource_group_name=resource_group.name,
            script_name="str",
            api_version="2020-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.deployment_scripts.get(
            resource_group_name=resource_group.name,
            script_name="str",
            api_version="2020-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.deployment_scripts.delete(
            resource_group_name=resource_group.name,
            script_name="str",
            api_version="2020-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscription(self, resource_group):
        response = self.client.deployment_scripts.list_by_subscription(
            api_version="2020-10-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_logs(self, resource_group):
        response = self.client.deployment_scripts.get_logs(
            resource_group_name=resource_group.name,
            script_name="str",
            api_version="2020-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_logs_default(self, resource_group):
        response = self.client.deployment_scripts.get_logs_default(
            resource_group_name=resource_group.name,
            script_name="str",
            api_version="2020-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.deployment_scripts.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2020-10-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
