# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Optional, Type, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from ..._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_data_boundaries_put_request(default: Union[str, _models.DefaultName], **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/providers/Microsoft.Resources/dataBoundaries/{default}")
    path_format_arguments = {
        "default": _SERIALIZER.url("default", default, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_data_boundaries_get_tenant_request(default: Union[str, _models.DefaultName], **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/providers/Microsoft.Resources/dataBoundaries/{default}")
    path_format_arguments = {
        "default": _SERIALIZER.url("default", default, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_data_boundaries_get_scope_request(
    scope: str, default: Union[str, _models.DefaultName], **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}")
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True, min_length=1),
        "default": _SERIALIZER.url("default", default, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class DataBoundariesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.resource.databoundaries.v2024_08_01.DataBoundaryMgmtClient`'s
        :attr:`data_boundaries` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @overload
    def put(
        self,
        default: Union[str, _models.DefaultName],
        data_boundary_definition: _models.DataBoundaryDefinition,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DataBoundaryDefinition:
        """Opt-in tenant to data boundary.

        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DefaultName
        :param data_boundary_definition: The data boundary to opt the tenant to. Required.
        :type data_boundary_definition:
         ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DataBoundaryDefinition
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def put(
        self,
        default: Union[str, _models.DefaultName],
        data_boundary_definition: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DataBoundaryDefinition:
        """Opt-in tenant to data boundary.

        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DefaultName
        :param data_boundary_definition: The data boundary to opt the tenant to. Required.
        :type data_boundary_definition: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def put(
        self,
        default: Union[str, _models.DefaultName],
        data_boundary_definition: Union[_models.DataBoundaryDefinition, IO[bytes]],
        **kwargs: Any
    ) -> _models.DataBoundaryDefinition:
        """Opt-in tenant to data boundary.

        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DefaultName
        :param data_boundary_definition: The data boundary to opt the tenant to. Is either a
         DataBoundaryDefinition type or a IO[bytes] type. Required.
        :type data_boundary_definition:
         ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DataBoundaryDefinition or IO[bytes]
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DataBoundaryDefinition] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(data_boundary_definition, (IOBase, bytes)):
            _content = data_boundary_definition
        else:
            _json = self._serialize.body(data_boundary_definition, "DataBoundaryDefinition")

        _request = build_data_boundaries_put_request(
            default=default,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DataBoundaryDefinition", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_tenant(self, default: Union[str, _models.DefaultName], **kwargs: Any) -> _models.DataBoundaryDefinition:
        """Get data boundary of tenant.

        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DefaultName
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-08-01"))
        cls: ClsType[_models.DataBoundaryDefinition] = kwargs.pop("cls", None)

        _request = build_data_boundaries_get_tenant_request(
            default=default,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DataBoundaryDefinition", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_scope(
        self, scope: str, default: Union[str, _models.DefaultName], **kwargs: Any
    ) -> _models.DataBoundaryDefinition:
        """Get data boundary at specified scope.

        :param scope: The scope at which the operation is performed. Required.
        :type scope: str
        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DefaultName
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.v2024_08_01.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-08-01"))
        cls: ClsType[_models.DataBoundaryDefinition] = kwargs.pop("cls", None)

        _request = build_data_boundaries_get_scope_request(
            scope=scope,
            default=default,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DataBoundaryDefinition", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
