# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.redisenterprise.aio import RedisEnterpriseManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestRedisEnterpriseManagementRedisEnterpriseOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(RedisEnterpriseManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create(self, resource_group):
        response = await (
            await self.client.redis_enterprise.begin_create(
                resource_group_name=resource_group.name,
                cluster_name="str",
                parameters={
                    "location": "str",
                    "sku": {"name": "str", "capacity": 0},
                    "encryption": {
                        "customerManagedKeyEncryption": {
                            "keyEncryptionKeyIdentity": {
                                "identityType": "str",
                                "userAssignedIdentityResourceId": "str",
                            },
                            "keyEncryptionKeyUrl": "str",
                        }
                    },
                    "highAvailability": "str",
                    "hostName": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "minimumTlsVersion": "str",
                    "name": "str",
                    "privateEndpointConnections": [
                        {
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "redisVersion": "str",
                    "redundancyMode": "str",
                    "resourceState": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                    "zones": ["str"],
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.redis_enterprise.begin_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                parameters={
                    "encryption": {
                        "customerManagedKeyEncryption": {
                            "keyEncryptionKeyIdentity": {
                                "identityType": "str",
                                "userAssignedIdentityResourceId": "str",
                            },
                            "keyEncryptionKeyUrl": "str",
                        }
                    },
                    "highAvailability": "str",
                    "hostName": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "minimumTlsVersion": "str",
                    "privateEndpointConnections": [
                        {
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "redisVersion": "str",
                    "redundancyMode": "str",
                    "resourceState": "str",
                    "sku": {"name": "str", "capacity": 0},
                    "tags": {"str": "str"},
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.redis_enterprise.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.redis_enterprise.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.redis_enterprise.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.redis_enterprise.list(
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
