# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Iterable, Iterator, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from .._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_update_request(
    management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-18-preview"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/groupQuotaLimits/{location}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url(
            "management_group_id", management_group_id, "str", max_length=63, min_length=3
        ),
        "groupQuotaName": _SERIALIZER.url(
            "group_quota_name", group_quota_name, "str", max_length=63, min_length=3, pattern=r"^[a-z][a-z0-9]*$"
        ),
        "resourceProviderName": _SERIALIZER.url(
            "resource_provider_name",
            resource_provider_name,
            "str",
            pattern=r"^((?!-)[a-zA-Z0-9-]{1,63}(?<!-)\.)+[a-zA-Z]{2,63}$",
        ),
        "location": _SERIALIZER.url("location", location, "str", min_length=1),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(
    management_group_id: str, group_quota_name: str, request_id_parameter: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/groupQuotaRequests/{requestId}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url(
            "management_group_id", management_group_id, "str", max_length=63, min_length=3
        ),
        "groupQuotaName": _SERIALIZER.url(
            "group_quota_name", group_quota_name, "str", max_length=63, min_length=3, pattern=r"^[a-z][a-z0-9]*$"
        ),
        "requestId": _SERIALIZER.url("request_id_parameter", request_id_parameter, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_request(
    management_group_id: str, group_quota_name: str, resource_provider_name: str, *, filter: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-12-18-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/groupQuotaRequests",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url(
            "management_group_id", management_group_id, "str", max_length=63, min_length=3
        ),
        "groupQuotaName": _SERIALIZER.url(
            "group_quota_name", group_quota_name, "str", max_length=63, min_length=3, pattern=r"^[a-z][a-z0-9]*$"
        ),
        "resourceProviderName": _SERIALIZER.url(
            "resource_provider_name",
            resource_provider_name,
            "str",
            pattern=r"^((?!-)[a-zA-Z0-9-]{1,63}(?<!-)\.)+[a-zA-Z]{2,63}$",
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["$filter"] = _SERIALIZER.query("filter", filter, "str", min_length=12)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class GroupQuotaLimitsRequestOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quota_limits_request` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    def _update_initial(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        group_quota_request: Optional[Union[_models.GroupQuotaLimitList, IO[bytes]]] = None,
        **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(group_quota_request, (IOBase, bytes)):
            _content = group_quota_request
        else:
            if group_quota_request is not None:
                _json = self._serialize.body(group_quota_request, "GroupQuotaLimitList")
            else:
                _json = None

        _request = build_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            resource_provider_name=resource_provider_name,
            location=location,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        group_quota_request: Optional[_models.GroupQuotaLimitList] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotaLimitList]:
        """Create the GroupQuota requests for a specific ResourceProvider/Location/Resource.

        Create the GroupQuota requests for a specific ResourceProvider/Location/Resource. The
        resourceName properties are specified in the request body. Only 1 resource quota can be
        requested. Please note that patch request creates a new groupQuota request.
        Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field, with
        retry-after duration in seconds to check the intermediate status. This API provides the finals
        status with the request details and status.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param group_quota_request: The GroupQuotaRequest body details for specific
         resourceProvider/location/resources. Default value is None.
        :type group_quota_request: ~azure.mgmt.quota.models.GroupQuotaLimitList
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns either GroupQuotaLimitList or the result of
         cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotaLimitList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        group_quota_request: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotaLimitList]:
        """Create the GroupQuota requests for a specific ResourceProvider/Location/Resource.

        Create the GroupQuota requests for a specific ResourceProvider/Location/Resource. The
        resourceName properties are specified in the request body. Only 1 resource quota can be
        requested. Please note that patch request creates a new groupQuota request.
        Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field, with
        retry-after duration in seconds to check the intermediate status. This API provides the finals
        status with the request details and status.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param group_quota_request: The GroupQuotaRequest body details for specific
         resourceProvider/location/resources. Default value is None.
        :type group_quota_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns either GroupQuotaLimitList or the result of
         cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotaLimitList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        group_quota_request: Optional[Union[_models.GroupQuotaLimitList, IO[bytes]]] = None,
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotaLimitList]:
        """Create the GroupQuota requests for a specific ResourceProvider/Location/Resource.

        Create the GroupQuota requests for a specific ResourceProvider/Location/Resource. The
        resourceName properties are specified in the request body. Only 1 resource quota can be
        requested. Please note that patch request creates a new groupQuota request.
        Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field, with
        retry-after duration in seconds to check the intermediate status. This API provides the finals
        status with the request details and status.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param group_quota_request: The GroupQuotaRequest body details for specific
         resourceProvider/location/resources. Is either a GroupQuotaLimitList type or a IO[bytes] type.
         Default value is None.
        :type group_quota_request: ~azure.mgmt.quota.models.GroupQuotaLimitList or IO[bytes]
        :return: An instance of LROPoller that returns either GroupQuotaLimitList or the result of
         cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotaLimitList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.GroupQuotaLimitList] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                resource_provider_name=resource_provider_name,
                location=location,
                group_quota_request=group_quota_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("GroupQuotaLimitList", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotaLimitList].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotaLimitList](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def get(
        self, management_group_id: str, group_quota_name: str, request_id_parameter: str, **kwargs: Any
    ) -> _models.SubmittedResourceRequestStatus:
        """Get the status of a single GroupQuota request by requestId.

        Get API to check the status of a GroupQuota request by requestId.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param request_id_parameter: Request Id. Required.
        :type request_id_parameter: str
        :return: SubmittedResourceRequestStatus or the result of cls(response)
        :rtype: ~azure.mgmt.quota.models.SubmittedResourceRequestStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.SubmittedResourceRequestStatus] = kwargs.pop("cls", None)

        _request = build_get_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            request_id_parameter=request_id_parameter,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SubmittedResourceRequestStatus", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self, management_group_id: str, group_quota_name: str, resource_provider_name: str, filter: str, **kwargs: Any
    ) -> Iterable["_models.SubmittedResourceRequestStatus"]:
        """Get the status of a single GroupQuota request by requestId.

        Get API to check the status of a GroupQuota request by requestId.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param filter: .. list-table::
            :header-rows: 1

            * - Field
              - Supported operators
            * -


          location eq {location} and resource eq {resourceName}
          Example: $filter=location eq eastus and resourceName eq cores. Required.
        :type filter: str
        :return: An iterator like instance of either SubmittedResourceRequestStatus or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.SubmittedResourceRequestStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.SubmittedResourceRequestStatusList] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    management_group_id=management_group_id,
                    group_quota_name=group_quota_name,
                    resource_provider_name=resource_provider_name,
                    filter=filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("SubmittedResourceRequestStatusList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
