# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy

from . import models as _models
from ._configuration import QuotaMgmtClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    GroupQuotaLimitsOperations,
    GroupQuotaLimitsRequestOperations,
    GroupQuotaSubscriptionAllocationOperations,
    GroupQuotaSubscriptionAllocationRequestOperations,
    GroupQuotaSubscriptionRequestsOperations,
    GroupQuotaSubscriptionsOperations,
    GroupQuotasOperations,
    QuotaOperationOperations,
    QuotaOperations,
    QuotaRequestStatusOperations,
    UsagesOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials import TokenCredential


class QuotaMgmtClient:  # pylint: disable=too-many-instance-attributes
    """Microsoft Azure Quota Resource Provider. This Swagger is for Azure Group Quota using GroupQuota
    Entity.

    :ivar group_quotas: GroupQuotasOperations operations
    :vartype group_quotas: azure.mgmt.quota.operations.GroupQuotasOperations
    :ivar group_quota_subscriptions: GroupQuotaSubscriptionsOperations operations
    :vartype group_quota_subscriptions:
     azure.mgmt.quota.operations.GroupQuotaSubscriptionsOperations
    :ivar group_quota_subscription_requests: GroupQuotaSubscriptionRequestsOperations operations
    :vartype group_quota_subscription_requests:
     azure.mgmt.quota.operations.GroupQuotaSubscriptionRequestsOperations
    :ivar group_quota_limits_request: GroupQuotaLimitsRequestOperations operations
    :vartype group_quota_limits_request:
     azure.mgmt.quota.operations.GroupQuotaLimitsRequestOperations
    :ivar group_quota_limits: GroupQuotaLimitsOperations operations
    :vartype group_quota_limits: azure.mgmt.quota.operations.GroupQuotaLimitsOperations
    :ivar group_quota_subscription_allocation_request:
     GroupQuotaSubscriptionAllocationRequestOperations operations
    :vartype group_quota_subscription_allocation_request:
     azure.mgmt.quota.operations.GroupQuotaSubscriptionAllocationRequestOperations
    :ivar group_quota_subscription_allocation: GroupQuotaSubscriptionAllocationOperations
     operations
    :vartype group_quota_subscription_allocation:
     azure.mgmt.quota.operations.GroupQuotaSubscriptionAllocationOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.quota.operations.UsagesOperations
    :ivar quota: QuotaOperations operations
    :vartype quota: azure.mgmt.quota.operations.QuotaOperations
    :ivar quota_request_status: QuotaRequestStatusOperations operations
    :vartype quota_request_status: azure.mgmt.quota.operations.QuotaRequestStatusOperations
    :ivar quota_operation: QuotaOperationOperations operations
    :vartype quota_operation: azure.mgmt.quota.operations.QuotaOperationOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2024-12-18-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = QuotaMgmtClientConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.group_quotas = GroupQuotasOperations(self._client, self._config, self._serialize, self._deserialize)
        self.group_quota_subscriptions = GroupQuotaSubscriptionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.group_quota_subscription_requests = GroupQuotaSubscriptionRequestsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.group_quota_limits_request = GroupQuotaLimitsRequestOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.group_quota_limits = GroupQuotaLimitsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.group_quota_subscription_allocation_request = GroupQuotaSubscriptionAllocationRequestOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.group_quota_subscription_allocation = GroupQuotaSubscriptionAllocationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.usages = UsagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.quota = QuotaOperations(self._client, self._config, self._serialize, self._deserialize)
        self.quota_request_status = QuotaRequestStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.quota_operation = QuotaOperationOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
