# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AADObjectType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of AAD object the object identifier refers to."""

    USER = "User"
    GROUP = "Group"
    SERVICE_PRINCIPAL = "ServicePrincipal"


class CheckNameAvailabilityParametersType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The resource type. Note: This should not be set by the user, as the constant value is
    Microsoft.DataLakeAnalytics/accounts.
    """

    MICROSOFT_DATA_LAKE_ANALYTICS_ACCOUNTS = "Microsoft.DataLakeAnalytics/accounts"


class DataLakeAnalyticsAccountState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the Data Lake Analytics account."""

    ACTIVE = "Active"
    SUSPENDED = "Suspended"


class DataLakeAnalyticsAccountStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning status of the Data Lake Analytics account."""

    FAILED = "Failed"
    CREATING = "Creating"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    PATCHING = "Patching"
    SUSPENDING = "Suspending"
    RESUMING = "Resuming"
    DELETING = "Deleting"
    DELETED = "Deleted"
    UNDELETING = "Undeleting"
    CANCELED = "Canceled"


class DebugDataAccessLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the DebugDataAccessLevel for this account."""

    ALL = "All"
    CUSTOMER = "Customer"
    NONE = "None"


class FirewallAllowAzureIpsState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of allowing or disallowing IPs originating within Azure through the firewall.
    If the firewall is disabled, this is not enforced.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class FirewallState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the IP address firewall for this account."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class NestedResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the NestedResourceProvisioning for this account."""

    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class OperationOrigin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation."""

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class SubscriptionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The subscription state."""

    REGISTERED = "Registered"
    SUSPENDED = "Suspended"
    DELETED = "Deleted"
    UNREGISTERED = "Unregistered"
    WARNED = "Warned"


class TierType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The commitment tier for the next month."""

    CONSUMPTION = "Consumption"
    COMMITMENT100_AU_HOURS = "Commitment_100AUHours"
    COMMITMENT500_AU_HOURS = "Commitment_500AUHours"
    COMMITMENT1000_AU_HOURS = "Commitment_1000AUHours"
    COMMITMENT5000_AU_HOURS = "Commitment_5000AUHours"
    COMMITMENT10000_AU_HOURS = "Commitment_10000AUHours"
    COMMITMENT50000_AU_HOURS = "Commitment_50000AUHours"
    COMMITMENT100000_AU_HOURS = "Commitment_100000AUHours"
    COMMITMENT500000_AU_HOURS = "Commitment_500000AUHours"


class VirtualNetworkRuleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the VirtualNetworkRule for this account."""

    ACTIVE = "Active"
    NETWORK_SOURCE_DELETED = "NetworkSourceDeleted"
    FAILED = "Failed"
