# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._application_insights_management_client_enums import *


class Annotation(msrest.serialization.Model):
    """Annotation associated with an application insights resource.

    :ivar annotation_name: Name of annotation.
    :vartype annotation_name: str
    :ivar category: Category of annotation, free form.
    :vartype category: str
    :ivar event_time: Time when event occurred.
    :vartype event_time: ~datetime.datetime
    :ivar id: Unique Id for annotation.
    :vartype id: str
    :ivar properties: Serialized JSON object for detailed properties.
    :vartype properties: str
    :ivar related_annotation: Related parent annotation if any.
    :vartype related_annotation: str
    """

    _attribute_map = {
        'annotation_name': {'key': 'AnnotationName', 'type': 'str'},
        'category': {'key': 'Category', 'type': 'str'},
        'event_time': {'key': 'EventTime', 'type': 'iso-8601'},
        'id': {'key': 'Id', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': 'str'},
        'related_annotation': {'key': 'RelatedAnnotation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        annotation_name: Optional[str] = None,
        category: Optional[str] = None,
        event_time: Optional[datetime.datetime] = None,
        id: Optional[str] = None,
        properties: Optional[str] = None,
        related_annotation: Optional[str] = "null",
        **kwargs
    ):
        """
        :keyword annotation_name: Name of annotation.
        :paramtype annotation_name: str
        :keyword category: Category of annotation, free form.
        :paramtype category: str
        :keyword event_time: Time when event occurred.
        :paramtype event_time: ~datetime.datetime
        :keyword id: Unique Id for annotation.
        :paramtype id: str
        :keyword properties: Serialized JSON object for detailed properties.
        :paramtype properties: str
        :keyword related_annotation: Related parent annotation if any.
        :paramtype related_annotation: str
        """
        super(Annotation, self).__init__(**kwargs)
        self.annotation_name = annotation_name
        self.category = category
        self.event_time = event_time
        self.id = id
        self.properties = properties
        self.related_annotation = related_annotation


class AnnotationError(msrest.serialization.Model):
    """Error associated with trying to create annotation with Id that already exist.

    :ivar code: Error detail code and explanation.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar innererror: Inner error.
    :vartype innererror: ~azure.mgmt.applicationinsights.v2015_05_01.models.InnerError
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        innererror: Optional["InnerError"] = None,
        **kwargs
    ):
        """
        :keyword code: Error detail code and explanation.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword innererror: Inner error.
        :paramtype innererror: ~azure.mgmt.applicationinsights.v2015_05_01.models.InnerError
        """
        super(AnnotationError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.innererror = innererror


class AnnotationsListResult(msrest.serialization.Model):
    """Annotations list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of annotations.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.Annotation]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Annotation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AnnotationsListResult, self).__init__(**kwargs)
        self.value = None


class APIKeyRequest(msrest.serialization.Model):
    """An Application Insights component API Key creation request definition.

    :ivar name: The name of the API Key.
    :vartype name: str
    :ivar linked_read_properties: The read access rights of this API Key.
    :vartype linked_read_properties: list[str]
    :ivar linked_write_properties: The write access rights of this API Key.
    :vartype linked_write_properties: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'linked_read_properties': {'key': 'linkedReadProperties', 'type': '[str]'},
        'linked_write_properties': {'key': 'linkedWriteProperties', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        linked_read_properties: Optional[List[str]] = None,
        linked_write_properties: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the API Key.
        :paramtype name: str
        :keyword linked_read_properties: The read access rights of this API Key.
        :paramtype linked_read_properties: list[str]
        :keyword linked_write_properties: The write access rights of this API Key.
        :paramtype linked_write_properties: list[str]
        """
        super(APIKeyRequest, self).__init__(**kwargs)
        self.name = name
        self.linked_read_properties = linked_read_properties
        self.linked_write_properties = linked_write_properties


class ComponentsResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(ComponentsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicationInsightsComponent(ComponentsResource):
    """An Application Insights component definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: Required. The kind of application that this component refers to, used to customize
     UI. This value is a freeform string, values should typically be one of the following: web, ios,
     other, store, java, phone.
    :vartype kind: str
    :ivar application_id: The unique ID of your application. This field mirrors the 'Name' field
     and cannot be changed.
    :vartype application_id: str
    :ivar app_id: Application Insights Unique ID for your Application.
    :vartype app_id: str
    :ivar application_type: Type of application being monitored. Possible values include: "web",
     "other". Default value: "web".
    :vartype application_type: str or
     ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationType
    :ivar flow_type: Used by the Application Insights system to determine what kind of flow this
     component was created by. This is to be set to 'Bluefield' when creating/updating a component
     via the REST API. Possible values include: "Bluefield". Default value: "Bluefield".
    :vartype flow_type: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.FlowType
    :ivar request_source: Describes what tool created this Application Insights component.
     Customers using this API should set this to the default 'rest'. Possible values include:
     "rest". Default value: "rest".
    :vartype request_source: str or
     ~azure.mgmt.applicationinsights.v2015_05_01.models.RequestSource
    :ivar instrumentation_key: Application Insights Instrumentation key. A read-only value that
     applications can use to identify the destination for all telemetry sent to Azure Application
     Insights. This value will be supplied upon construction of each new Application Insights
     component.
    :vartype instrumentation_key: str
    :ivar creation_date: Creation Date for the Application Insights component, in ISO 8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar tenant_id: Azure Tenant Id.
    :vartype tenant_id: str
    :ivar hockey_app_id: The unique application ID created when a new application is added to
     HockeyApp, used for communications with HockeyApp.
    :vartype hockey_app_id: str
    :ivar hockey_app_token: Token used to authenticate communications with between Application
     Insights and HockeyApp.
    :vartype hockey_app_token: str
    :ivar provisioning_state: Current state of this component: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    :ivar sampling_percentage: Percentage of the data produced by the application being monitored
     that is being sampled for Application Insights telemetry.
    :vartype sampling_percentage: float
    :ivar connection_string: Application Insights component connection string.
    :vartype connection_string: str
    :ivar retention_in_days: Retention period in days.
    :vartype retention_in_days: int
    :ivar disable_ip_masking: Disable IP masking.
    :vartype disable_ip_masking: bool
    :ivar immediate_purge_data_on30_days: Purge data immediately after 30 days.
    :vartype immediate_purge_data_on30_days: bool
    :ivar private_link_scoped_resources: List of linked private link scope resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.PrivateLinkScopedResource]
    :ivar ingestion_mode: Indicates the flow of the ingestion. Possible values include:
     "ApplicationInsights", "ApplicationInsightsWithDiagnosticSettings", "LogAnalytics". Default
     value: "ApplicationInsights".
    :vartype ingestion_mode: str or
     ~azure.mgmt.applicationinsights.v2015_05_01.models.IngestionMode
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'required': True},
        'application_id': {'readonly': True},
        'app_id': {'readonly': True},
        'instrumentation_key': {'readonly': True},
        'creation_date': {'readonly': True},
        'tenant_id': {'readonly': True},
        'hockey_app_token': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'connection_string': {'readonly': True},
        'private_link_scoped_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'application_id': {'key': 'properties.ApplicationId', 'type': 'str'},
        'app_id': {'key': 'properties.AppId', 'type': 'str'},
        'application_type': {'key': 'properties.Application_Type', 'type': 'str'},
        'flow_type': {'key': 'properties.Flow_Type', 'type': 'str'},
        'request_source': {'key': 'properties.Request_Source', 'type': 'str'},
        'instrumentation_key': {'key': 'properties.InstrumentationKey', 'type': 'str'},
        'creation_date': {'key': 'properties.CreationDate', 'type': 'iso-8601'},
        'tenant_id': {'key': 'properties.TenantId', 'type': 'str'},
        'hockey_app_id': {'key': 'properties.HockeyAppId', 'type': 'str'},
        'hockey_app_token': {'key': 'properties.HockeyAppToken', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sampling_percentage': {'key': 'properties.SamplingPercentage', 'type': 'float'},
        'connection_string': {'key': 'properties.ConnectionString', 'type': 'str'},
        'retention_in_days': {'key': 'properties.RetentionInDays', 'type': 'int'},
        'disable_ip_masking': {'key': 'properties.DisableIpMasking', 'type': 'bool'},
        'immediate_purge_data_on30_days': {'key': 'properties.ImmediatePurgeDataOn30Days', 'type': 'bool'},
        'private_link_scoped_resources': {'key': 'properties.PrivateLinkScopedResources', 'type': '[PrivateLinkScopedResource]'},
        'ingestion_mode': {'key': 'properties.IngestionMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: str,
        tags: Optional[Dict[str, str]] = None,
        application_type: Optional[Union[str, "ApplicationType"]] = "web",
        flow_type: Optional[Union[str, "FlowType"]] = "Bluefield",
        request_source: Optional[Union[str, "RequestSource"]] = "rest",
        hockey_app_id: Optional[str] = None,
        sampling_percentage: Optional[float] = None,
        retention_in_days: Optional[int] = 90,
        disable_ip_masking: Optional[bool] = None,
        immediate_purge_data_on30_days: Optional[bool] = None,
        ingestion_mode: Optional[Union[str, "IngestionMode"]] = "ApplicationInsights",
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: Required. The kind of application that this component refers to, used to
         customize UI. This value is a freeform string, values should typically be one of the following:
         web, ios, other, store, java, phone.
        :paramtype kind: str
        :keyword application_type: Type of application being monitored. Possible values include: "web",
         "other". Default value: "web".
        :paramtype application_type: str or
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationType
        :keyword flow_type: Used by the Application Insights system to determine what kind of flow this
         component was created by. This is to be set to 'Bluefield' when creating/updating a component
         via the REST API. Possible values include: "Bluefield". Default value: "Bluefield".
        :paramtype flow_type: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.FlowType
        :keyword request_source: Describes what tool created this Application Insights component.
         Customers using this API should set this to the default 'rest'. Possible values include:
         "rest". Default value: "rest".
        :paramtype request_source: str or
         ~azure.mgmt.applicationinsights.v2015_05_01.models.RequestSource
        :keyword hockey_app_id: The unique application ID created when a new application is added to
         HockeyApp, used for communications with HockeyApp.
        :paramtype hockey_app_id: str
        :keyword sampling_percentage: Percentage of the data produced by the application being
         monitored that is being sampled for Application Insights telemetry.
        :paramtype sampling_percentage: float
        :keyword retention_in_days: Retention period in days.
        :paramtype retention_in_days: int
        :keyword disable_ip_masking: Disable IP masking.
        :paramtype disable_ip_masking: bool
        :keyword immediate_purge_data_on30_days: Purge data immediately after 30 days.
        :paramtype immediate_purge_data_on30_days: bool
        :keyword ingestion_mode: Indicates the flow of the ingestion. Possible values include:
         "ApplicationInsights", "ApplicationInsightsWithDiagnosticSettings", "LogAnalytics". Default
         value: "ApplicationInsights".
        :paramtype ingestion_mode: str or
         ~azure.mgmt.applicationinsights.v2015_05_01.models.IngestionMode
        """
        super(ApplicationInsightsComponent, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = kind
        self.application_id = None
        self.app_id = None
        self.application_type = application_type
        self.flow_type = flow_type
        self.request_source = request_source
        self.instrumentation_key = None
        self.creation_date = None
        self.tenant_id = None
        self.hockey_app_id = hockey_app_id
        self.hockey_app_token = None
        self.provisioning_state = None
        self.sampling_percentage = sampling_percentage
        self.connection_string = None
        self.retention_in_days = retention_in_days
        self.disable_ip_masking = disable_ip_masking
        self.immediate_purge_data_on30_days = immediate_purge_data_on30_days
        self.private_link_scoped_resources = None
        self.ingestion_mode = ingestion_mode


class ApplicationInsightsComponentAnalyticsItem(msrest.serialization.Model):
    """Properties that define an Analytics item that is associated to an Application Insights component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Internally assigned unique id of the item definition.
    :vartype id: str
    :ivar name: The user-defined name of the item.
    :vartype name: str
    :ivar content: The content of this item.
    :vartype content: str
    :ivar version: This instance's version of the data model. This can change as new features are
     added.
    :vartype version: str
    :ivar scope: Enum indicating if this item definition is owned by a specific user or is shared
     between all users with access to the Application Insights component. Possible values include:
     "shared", "user".
    :vartype scope: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScope
    :ivar type: Enum indicating the type of the Analytics item. Possible values include: "none",
     "query", "recent", "function".
    :vartype type: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemType
    :ivar time_created: Date and time in UTC when this item was created.
    :vartype time_created: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this item.
    :vartype time_modified: str
    :ivar properties: A set of properties that can be defined in the context of a specific item
     type. Each type may have its own properties.
    :vartype properties:
     ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItemProperties
    """

    _validation = {
        'version': {'readonly': True},
        'time_created': {'readonly': True},
        'time_modified': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'scope': {'key': 'Scope', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'time_created': {'key': 'TimeCreated', 'type': 'str'},
        'time_modified': {'key': 'TimeModified', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': 'ApplicationInsightsComponentAnalyticsItemProperties'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        content: Optional[str] = None,
        scope: Optional[Union[str, "ItemScope"]] = None,
        type: Optional[Union[str, "ItemType"]] = None,
        properties: Optional["ApplicationInsightsComponentAnalyticsItemProperties"] = None,
        **kwargs
    ):
        """
        :keyword id: Internally assigned unique id of the item definition.
        :paramtype id: str
        :keyword name: The user-defined name of the item.
        :paramtype name: str
        :keyword content: The content of this item.
        :paramtype content: str
        :keyword scope: Enum indicating if this item definition is owned by a specific user or is
         shared between all users with access to the Application Insights component. Possible values
         include: "shared", "user".
        :paramtype scope: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScope
        :keyword type: Enum indicating the type of the Analytics item. Possible values include: "none",
         "query", "recent", "function".
        :paramtype type: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemType
        :keyword properties: A set of properties that can be defined in the context of a specific item
         type. Each type may have its own properties.
        :paramtype properties:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItemProperties
        """
        super(ApplicationInsightsComponentAnalyticsItem, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.content = content
        self.version = None
        self.scope = scope
        self.type = type
        self.time_created = None
        self.time_modified = None
        self.properties = properties


class ApplicationInsightsComponentAnalyticsItemProperties(msrest.serialization.Model):
    """A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.

    :ivar function_alias: A function alias, used when the type of the item is Function.
    :vartype function_alias: str
    """

    _attribute_map = {
        'function_alias': {'key': 'functionAlias', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        function_alias: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword function_alias: A function alias, used when the type of the item is Function.
        :paramtype function_alias: str
        """
        super(ApplicationInsightsComponentAnalyticsItemProperties, self).__init__(**kwargs)
        self.function_alias = function_alias


class ApplicationInsightsComponentAPIKey(msrest.serialization.Model):
    """Properties that define an API key of an Application Insights Component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique ID of the API key inside an Application Insights component. It is auto
     generated when the API key is created.
    :vartype id: str
    :ivar api_key: The API key value. It will be only return once when the API Key was created.
    :vartype api_key: str
    :ivar created_date: The create date of this API key.
    :vartype created_date: str
    :ivar name: The name of the API key.
    :vartype name: str
    :ivar linked_read_properties: The read access rights of this API Key.
    :vartype linked_read_properties: list[str]
    :ivar linked_write_properties: The write access rights of this API Key.
    :vartype linked_write_properties: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'api_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'api_key': {'key': 'apiKey', 'type': 'str'},
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'linked_read_properties': {'key': 'linkedReadProperties', 'type': '[str]'},
        'linked_write_properties': {'key': 'linkedWriteProperties', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        created_date: Optional[str] = None,
        name: Optional[str] = None,
        linked_read_properties: Optional[List[str]] = None,
        linked_write_properties: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword created_date: The create date of this API key.
        :paramtype created_date: str
        :keyword name: The name of the API key.
        :paramtype name: str
        :keyword linked_read_properties: The read access rights of this API Key.
        :paramtype linked_read_properties: list[str]
        :keyword linked_write_properties: The write access rights of this API Key.
        :paramtype linked_write_properties: list[str]
        """
        super(ApplicationInsightsComponentAPIKey, self).__init__(**kwargs)
        self.id = None
        self.api_key = None
        self.created_date = created_date
        self.name = name
        self.linked_read_properties = linked_read_properties
        self.linked_write_properties = linked_write_properties


class ApplicationInsightsComponentAPIKeyListResult(msrest.serialization.Model):
    """Describes the list of API Keys of an Application Insights Component.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of API Key definitions.
    :vartype value:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAPIKey]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationInsightsComponentAPIKey]'},
    }

    def __init__(
        self,
        *,
        value: List["ApplicationInsightsComponentAPIKey"],
        **kwargs
    ):
        """
        :keyword value: Required. List of API Key definitions.
        :paramtype value:
         list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAPIKey]
        """
        super(ApplicationInsightsComponentAPIKeyListResult, self).__init__(**kwargs)
        self.value = value


class ApplicationInsightsComponentAvailableFeatures(msrest.serialization.Model):
    """An Application Insights component available features.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar result: A list of Application Insights component feature.
    :vartype result:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentFeature]
    """

    _validation = {
        'result': {'readonly': True},
    }

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[ApplicationInsightsComponentFeature]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplicationInsightsComponentAvailableFeatures, self).__init__(**kwargs)
        self.result = None


class ApplicationInsightsComponentBillingFeatures(msrest.serialization.Model):
    """An Application Insights component billing features.

    :ivar data_volume_cap: An Application Insights component daily data volume cap.
    :vartype data_volume_cap:
     ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentDataVolumeCap
    :ivar current_billing_features: Current enabled pricing plan. When the component is in the
     Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
    :vartype current_billing_features: list[str]
    """

    _attribute_map = {
        'data_volume_cap': {'key': 'DataVolumeCap', 'type': 'ApplicationInsightsComponentDataVolumeCap'},
        'current_billing_features': {'key': 'CurrentBillingFeatures', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        data_volume_cap: Optional["ApplicationInsightsComponentDataVolumeCap"] = None,
        current_billing_features: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword data_volume_cap: An Application Insights component daily data volume cap.
        :paramtype data_volume_cap:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentDataVolumeCap
        :keyword current_billing_features: Current enabled pricing plan. When the component is in the
         Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
        :paramtype current_billing_features: list[str]
        """
        super(ApplicationInsightsComponentBillingFeatures, self).__init__(**kwargs)
        self.data_volume_cap = data_volume_cap
        self.current_billing_features = current_billing_features


class ApplicationInsightsComponentDataVolumeCap(msrest.serialization.Model):
    """An Application Insights component daily data volume cap.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cap: Daily data volume cap in GB.
    :vartype cap: float
    :ivar reset_time: Daily data volume cap UTC reset hour.
    :vartype reset_time: int
    :ivar warning_threshold: Reserved, not used for now.
    :vartype warning_threshold: int
    :ivar stop_send_notification_when_hit_threshold: Reserved, not used for now.
    :vartype stop_send_notification_when_hit_threshold: bool
    :ivar stop_send_notification_when_hit_cap: Do not send a notification email when the daily data
     volume cap is met.
    :vartype stop_send_notification_when_hit_cap: bool
    :ivar max_history_cap: Maximum daily data volume cap that the user can set for this component.
    :vartype max_history_cap: float
    """

    _validation = {
        'reset_time': {'readonly': True},
        'max_history_cap': {'readonly': True},
    }

    _attribute_map = {
        'cap': {'key': 'Cap', 'type': 'float'},
        'reset_time': {'key': 'ResetTime', 'type': 'int'},
        'warning_threshold': {'key': 'WarningThreshold', 'type': 'int'},
        'stop_send_notification_when_hit_threshold': {'key': 'StopSendNotificationWhenHitThreshold', 'type': 'bool'},
        'stop_send_notification_when_hit_cap': {'key': 'StopSendNotificationWhenHitCap', 'type': 'bool'},
        'max_history_cap': {'key': 'MaxHistoryCap', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        cap: Optional[float] = None,
        warning_threshold: Optional[int] = None,
        stop_send_notification_when_hit_threshold: Optional[bool] = None,
        stop_send_notification_when_hit_cap: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword cap: Daily data volume cap in GB.
        :paramtype cap: float
        :keyword warning_threshold: Reserved, not used for now.
        :paramtype warning_threshold: int
        :keyword stop_send_notification_when_hit_threshold: Reserved, not used for now.
        :paramtype stop_send_notification_when_hit_threshold: bool
        :keyword stop_send_notification_when_hit_cap: Do not send a notification email when the daily
         data volume cap is met.
        :paramtype stop_send_notification_when_hit_cap: bool
        """
        super(ApplicationInsightsComponentDataVolumeCap, self).__init__(**kwargs)
        self.cap = cap
        self.reset_time = None
        self.warning_threshold = warning_threshold
        self.stop_send_notification_when_hit_threshold = stop_send_notification_when_hit_threshold
        self.stop_send_notification_when_hit_cap = stop_send_notification_when_hit_cap
        self.max_history_cap = None


class ApplicationInsightsComponentExportConfiguration(msrest.serialization.Model):
    """Properties that define a Continuous Export configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar export_id: The unique ID of the export configuration inside an Application Insights
     component. It is auto generated when the Continuous Export configuration is created.
    :vartype export_id: str
    :ivar instrumentation_key: The instrumentation key of the Application Insights component.
    :vartype instrumentation_key: str
    :ivar record_types: This comma separated list of document types that will be exported. The
     possible values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews',
     'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
    :vartype record_types: str
    :ivar application_name: The name of the Application Insights component.
    :vartype application_name: str
    :ivar subscription_id: The subscription of the Application Insights component.
    :vartype subscription_id: str
    :ivar resource_group: The resource group of the Application Insights component.
    :vartype resource_group: str
    :ivar destination_storage_subscription_id: The destination storage account subscription ID.
    :vartype destination_storage_subscription_id: str
    :ivar destination_storage_location_id: The destination account location ID.
    :vartype destination_storage_location_id: str
    :ivar destination_account_id: The name of destination account.
    :vartype destination_account_id: str
    :ivar destination_type: The destination type.
    :vartype destination_type: str
    :ivar is_user_enabled: This will be 'true' if the Continuous Export configuration is enabled,
     otherwise it will be 'false'.
    :vartype is_user_enabled: str
    :ivar last_user_update: Last time the Continuous Export configuration was updated.
    :vartype last_user_update: str
    :ivar notification_queue_enabled: Deprecated.
    :vartype notification_queue_enabled: str
    :ivar export_status: This indicates current Continuous Export configuration status. The
     possible values are 'Preparing', 'Success', 'Failure'.
    :vartype export_status: str
    :ivar last_success_time: The last time data was successfully delivered to the destination
     storage container for this Continuous Export configuration.
    :vartype last_success_time: str
    :ivar last_gap_time: The last time the Continuous Export configuration started failing.
    :vartype last_gap_time: str
    :ivar permanent_error_reason: This is the reason the Continuous Export configuration started
     failing. It can be 'AzureStorageNotFound' or 'AzureStorageAccessDenied'.
    :vartype permanent_error_reason: str
    :ivar storage_name: The name of the destination storage account.
    :vartype storage_name: str
    :ivar container_name: The name of the destination storage container.
    :vartype container_name: str
    """

    _validation = {
        'export_id': {'readonly': True},
        'instrumentation_key': {'readonly': True},
        'application_name': {'readonly': True},
        'subscription_id': {'readonly': True},
        'resource_group': {'readonly': True},
        'destination_storage_subscription_id': {'readonly': True},
        'destination_storage_location_id': {'readonly': True},
        'destination_account_id': {'readonly': True},
        'destination_type': {'readonly': True},
        'is_user_enabled': {'readonly': True},
        'last_user_update': {'readonly': True},
        'export_status': {'readonly': True},
        'last_success_time': {'readonly': True},
        'last_gap_time': {'readonly': True},
        'permanent_error_reason': {'readonly': True},
        'storage_name': {'readonly': True},
        'container_name': {'readonly': True},
    }

    _attribute_map = {
        'export_id': {'key': 'ExportId', 'type': 'str'},
        'instrumentation_key': {'key': 'InstrumentationKey', 'type': 'str'},
        'record_types': {'key': 'RecordTypes', 'type': 'str'},
        'application_name': {'key': 'ApplicationName', 'type': 'str'},
        'subscription_id': {'key': 'SubscriptionId', 'type': 'str'},
        'resource_group': {'key': 'ResourceGroup', 'type': 'str'},
        'destination_storage_subscription_id': {'key': 'DestinationStorageSubscriptionId', 'type': 'str'},
        'destination_storage_location_id': {'key': 'DestinationStorageLocationId', 'type': 'str'},
        'destination_account_id': {'key': 'DestinationAccountId', 'type': 'str'},
        'destination_type': {'key': 'DestinationType', 'type': 'str'},
        'is_user_enabled': {'key': 'IsUserEnabled', 'type': 'str'},
        'last_user_update': {'key': 'LastUserUpdate', 'type': 'str'},
        'notification_queue_enabled': {'key': 'NotificationQueueEnabled', 'type': 'str'},
        'export_status': {'key': 'ExportStatus', 'type': 'str'},
        'last_success_time': {'key': 'LastSuccessTime', 'type': 'str'},
        'last_gap_time': {'key': 'LastGapTime', 'type': 'str'},
        'permanent_error_reason': {'key': 'PermanentErrorReason', 'type': 'str'},
        'storage_name': {'key': 'StorageName', 'type': 'str'},
        'container_name': {'key': 'ContainerName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        record_types: Optional[str] = None,
        notification_queue_enabled: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword record_types: This comma separated list of document types that will be exported. The
         possible values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews',
         'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
        :paramtype record_types: str
        :keyword notification_queue_enabled: Deprecated.
        :paramtype notification_queue_enabled: str
        """
        super(ApplicationInsightsComponentExportConfiguration, self).__init__(**kwargs)
        self.export_id = None
        self.instrumentation_key = None
        self.record_types = record_types
        self.application_name = None
        self.subscription_id = None
        self.resource_group = None
        self.destination_storage_subscription_id = None
        self.destination_storage_location_id = None
        self.destination_account_id = None
        self.destination_type = None
        self.is_user_enabled = None
        self.last_user_update = None
        self.notification_queue_enabled = notification_queue_enabled
        self.export_status = None
        self.last_success_time = None
        self.last_gap_time = None
        self.permanent_error_reason = None
        self.storage_name = None
        self.container_name = None


class ApplicationInsightsComponentExportRequest(msrest.serialization.Model):
    """An Application Insights component Continuous Export configuration request definition.

    :ivar record_types: The document types to be exported, as comma separated values. Allowed
     values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews',
     'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
    :vartype record_types: str
    :ivar destination_type: The Continuous Export destination type. This has to be 'Blob'.
    :vartype destination_type: str
    :ivar destination_address: The SAS URL for the destination storage container. It must grant
     write permission.
    :vartype destination_address: str
    :ivar is_enabled: Set to 'true' to create a Continuous Export configuration as enabled,
     otherwise set it to 'false'.
    :vartype is_enabled: str
    :ivar notification_queue_enabled: Deprecated.
    :vartype notification_queue_enabled: str
    :ivar notification_queue_uri: Deprecated.
    :vartype notification_queue_uri: str
    :ivar destination_storage_subscription_id: The subscription ID of the destination storage
     container.
    :vartype destination_storage_subscription_id: str
    :ivar destination_storage_location_id: The location ID of the destination storage container.
    :vartype destination_storage_location_id: str
    :ivar destination_account_id: The name of destination storage account.
    :vartype destination_account_id: str
    """

    _attribute_map = {
        'record_types': {'key': 'RecordTypes', 'type': 'str'},
        'destination_type': {'key': 'DestinationType', 'type': 'str'},
        'destination_address': {'key': 'DestinationAddress', 'type': 'str'},
        'is_enabled': {'key': 'IsEnabled', 'type': 'str'},
        'notification_queue_enabled': {'key': 'NotificationQueueEnabled', 'type': 'str'},
        'notification_queue_uri': {'key': 'NotificationQueueUri', 'type': 'str'},
        'destination_storage_subscription_id': {'key': 'DestinationStorageSubscriptionId', 'type': 'str'},
        'destination_storage_location_id': {'key': 'DestinationStorageLocationId', 'type': 'str'},
        'destination_account_id': {'key': 'DestinationAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        record_types: Optional[str] = None,
        destination_type: Optional[str] = None,
        destination_address: Optional[str] = None,
        is_enabled: Optional[str] = None,
        notification_queue_enabled: Optional[str] = None,
        notification_queue_uri: Optional[str] = None,
        destination_storage_subscription_id: Optional[str] = None,
        destination_storage_location_id: Optional[str] = None,
        destination_account_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword record_types: The document types to be exported, as comma separated values. Allowed
         values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews',
         'PageViewPerformance', 'Rdd', 'PerformanceCounters', 'Availability', 'Messages'.
        :paramtype record_types: str
        :keyword destination_type: The Continuous Export destination type. This has to be 'Blob'.
        :paramtype destination_type: str
        :keyword destination_address: The SAS URL for the destination storage container. It must grant
         write permission.
        :paramtype destination_address: str
        :keyword is_enabled: Set to 'true' to create a Continuous Export configuration as enabled,
         otherwise set it to 'false'.
        :paramtype is_enabled: str
        :keyword notification_queue_enabled: Deprecated.
        :paramtype notification_queue_enabled: str
        :keyword notification_queue_uri: Deprecated.
        :paramtype notification_queue_uri: str
        :keyword destination_storage_subscription_id: The subscription ID of the destination storage
         container.
        :paramtype destination_storage_subscription_id: str
        :keyword destination_storage_location_id: The location ID of the destination storage container.
        :paramtype destination_storage_location_id: str
        :keyword destination_account_id: The name of destination storage account.
        :paramtype destination_account_id: str
        """
        super(ApplicationInsightsComponentExportRequest, self).__init__(**kwargs)
        self.record_types = record_types
        self.destination_type = destination_type
        self.destination_address = destination_address
        self.is_enabled = is_enabled
        self.notification_queue_enabled = notification_queue_enabled
        self.notification_queue_uri = notification_queue_uri
        self.destination_storage_subscription_id = destination_storage_subscription_id
        self.destination_storage_location_id = destination_storage_location_id
        self.destination_account_id = destination_account_id


class ApplicationInsightsComponentFavorite(msrest.serialization.Model):
    """Properties that define a favorite that is associated to an Application Insights component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The user-defined name of the favorite.
    :vartype name: str
    :ivar config: Configuration of this particular favorite, which are driven by the Azure portal
     UX. Configuration data is a string containing valid JSON.
    :vartype config: str
    :ivar version: This instance's version of the data model. This can change as new features are
     added that can be marked favorite. Current examples include MetricsExplorer (ME) and Search.
    :vartype version: str
    :ivar favorite_id: Internally assigned unique id of the favorite definition.
    :vartype favorite_id: str
    :ivar favorite_type: Enum indicating if this favorite definition is owned by a specific user or
     is shared between all users with access to the Application Insights component. Possible values
     include: "shared", "user".
    :vartype favorite_type: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.FavoriteType
    :ivar source_type: The source of the favorite definition.
    :vartype source_type: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     favorite definition.
    :vartype time_modified: str
    :ivar tags: A set of tags. A list of 0 or more tags that are associated with this favorite
     definition.
    :vartype tags: list[str]
    :ivar category: Favorite category, as defined by the user at creation time.
    :vartype category: str
    :ivar is_generated_from_template: Flag denoting wether or not this favorite was generated from
     a template.
    :vartype is_generated_from_template: bool
    :ivar user_id: Unique user id of the specific user that owns this favorite.
    :vartype user_id: str
    """

    _validation = {
        'favorite_id': {'readonly': True},
        'time_modified': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'config': {'key': 'Config', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'favorite_id': {'key': 'FavoriteId', 'type': 'str'},
        'favorite_type': {'key': 'FavoriteType', 'type': 'str'},
        'source_type': {'key': 'SourceType', 'type': 'str'},
        'time_modified': {'key': 'TimeModified', 'type': 'str'},
        'tags': {'key': 'Tags', 'type': '[str]'},
        'category': {'key': 'Category', 'type': 'str'},
        'is_generated_from_template': {'key': 'IsGeneratedFromTemplate', 'type': 'bool'},
        'user_id': {'key': 'UserId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        config: Optional[str] = None,
        version: Optional[str] = None,
        favorite_type: Optional[Union[str, "FavoriteType"]] = None,
        source_type: Optional[str] = None,
        tags: Optional[List[str]] = None,
        category: Optional[str] = None,
        is_generated_from_template: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: The user-defined name of the favorite.
        :paramtype name: str
        :keyword config: Configuration of this particular favorite, which are driven by the Azure
         portal UX. Configuration data is a string containing valid JSON.
        :paramtype config: str
        :keyword version: This instance's version of the data model. This can change as new features
         are added that can be marked favorite. Current examples include MetricsExplorer (ME) and
         Search.
        :paramtype version: str
        :keyword favorite_type: Enum indicating if this favorite definition is owned by a specific user
         or is shared between all users with access to the Application Insights component. Possible
         values include: "shared", "user".
        :paramtype favorite_type: str or
         ~azure.mgmt.applicationinsights.v2015_05_01.models.FavoriteType
        :keyword source_type: The source of the favorite definition.
        :paramtype source_type: str
        :keyword tags: A set of tags. A list of 0 or more tags that are associated with this favorite
         definition.
        :paramtype tags: list[str]
        :keyword category: Favorite category, as defined by the user at creation time.
        :paramtype category: str
        :keyword is_generated_from_template: Flag denoting wether or not this favorite was generated
         from a template.
        :paramtype is_generated_from_template: bool
        """
        super(ApplicationInsightsComponentFavorite, self).__init__(**kwargs)
        self.name = name
        self.config = config
        self.version = version
        self.favorite_id = None
        self.favorite_type = favorite_type
        self.source_type = source_type
        self.time_modified = None
        self.tags = tags
        self.category = category
        self.is_generated_from_template = is_generated_from_template
        self.user_id = None


class ApplicationInsightsComponentFeature(msrest.serialization.Model):
    """An Application Insights component daily data volume cap status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar feature_name: The pricing feature name.
    :vartype feature_name: str
    :ivar meter_id: The meter id used for the feature.
    :vartype meter_id: str
    :ivar meter_rate_frequency: The meter rate for the feature's meter.
    :vartype meter_rate_frequency: str
    :ivar resouce_id: Reserved, not used now.
    :vartype resouce_id: str
    :ivar is_hidden: Reserved, not used now.
    :vartype is_hidden: bool
    :ivar capabilities: A list of Application Insights component feature capability.
    :vartype capabilities:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentFeatureCapability]
    :ivar title: Display name of the feature.
    :vartype title: str
    :ivar is_main_feature: Whether can apply addon feature on to it.
    :vartype is_main_feature: bool
    :ivar supported_addon_features: The add on features on main feature.
    :vartype supported_addon_features: str
    """

    _validation = {
        'feature_name': {'readonly': True},
        'meter_id': {'readonly': True},
        'meter_rate_frequency': {'readonly': True},
        'resouce_id': {'readonly': True},
        'is_hidden': {'readonly': True},
        'capabilities': {'readonly': True},
        'title': {'readonly': True},
        'is_main_feature': {'readonly': True},
        'supported_addon_features': {'readonly': True},
    }

    _attribute_map = {
        'feature_name': {'key': 'FeatureName', 'type': 'str'},
        'meter_id': {'key': 'MeterId', 'type': 'str'},
        'meter_rate_frequency': {'key': 'MeterRateFrequency', 'type': 'str'},
        'resouce_id': {'key': 'ResouceId', 'type': 'str'},
        'is_hidden': {'key': 'IsHidden', 'type': 'bool'},
        'capabilities': {'key': 'Capabilities', 'type': '[ApplicationInsightsComponentFeatureCapability]'},
        'title': {'key': 'Title', 'type': 'str'},
        'is_main_feature': {'key': 'IsMainFeature', 'type': 'bool'},
        'supported_addon_features': {'key': 'SupportedAddonFeatures', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplicationInsightsComponentFeature, self).__init__(**kwargs)
        self.feature_name = None
        self.meter_id = None
        self.meter_rate_frequency = None
        self.resouce_id = None
        self.is_hidden = None
        self.capabilities = None
        self.title = None
        self.is_main_feature = None
        self.supported_addon_features = None


class ApplicationInsightsComponentFeatureCapabilities(msrest.serialization.Model):
    """An Application Insights component feature capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar support_export_data: Whether allow to use continuous export feature.
    :vartype support_export_data: bool
    :ivar burst_throttle_policy: Reserved, not used now.
    :vartype burst_throttle_policy: str
    :ivar metadata_class: Reserved, not used now.
    :vartype metadata_class: str
    :ivar live_stream_metrics: Reserved, not used now.
    :vartype live_stream_metrics: bool
    :ivar application_map: Reserved, not used now.
    :vartype application_map: bool
    :ivar work_item_integration: Whether allow to use work item integration feature.
    :vartype work_item_integration: bool
    :ivar power_bi_integration: Reserved, not used now.
    :vartype power_bi_integration: bool
    :ivar open_schema: Reserved, not used now.
    :vartype open_schema: bool
    :ivar proactive_detection: Reserved, not used now.
    :vartype proactive_detection: bool
    :ivar analytics_integration: Reserved, not used now.
    :vartype analytics_integration: bool
    :ivar multiple_step_web_test: Whether allow to use multiple steps web test feature.
    :vartype multiple_step_web_test: bool
    :ivar api_access_level: Reserved, not used now.
    :vartype api_access_level: str
    :ivar tracking_type: The application insights component used tracking type.
    :vartype tracking_type: str
    :ivar daily_cap: Daily data volume cap in GB.
    :vartype daily_cap: float
    :ivar daily_cap_reset_time: Daily data volume cap UTC reset hour.
    :vartype daily_cap_reset_time: float
    :ivar throttle_rate: Reserved, not used now.
    :vartype throttle_rate: float
    """

    _validation = {
        'support_export_data': {'readonly': True},
        'burst_throttle_policy': {'readonly': True},
        'metadata_class': {'readonly': True},
        'live_stream_metrics': {'readonly': True},
        'application_map': {'readonly': True},
        'work_item_integration': {'readonly': True},
        'power_bi_integration': {'readonly': True},
        'open_schema': {'readonly': True},
        'proactive_detection': {'readonly': True},
        'analytics_integration': {'readonly': True},
        'multiple_step_web_test': {'readonly': True},
        'api_access_level': {'readonly': True},
        'tracking_type': {'readonly': True},
        'daily_cap': {'readonly': True},
        'daily_cap_reset_time': {'readonly': True},
        'throttle_rate': {'readonly': True},
    }

    _attribute_map = {
        'support_export_data': {'key': 'SupportExportData', 'type': 'bool'},
        'burst_throttle_policy': {'key': 'BurstThrottlePolicy', 'type': 'str'},
        'metadata_class': {'key': 'MetadataClass', 'type': 'str'},
        'live_stream_metrics': {'key': 'LiveStreamMetrics', 'type': 'bool'},
        'application_map': {'key': 'ApplicationMap', 'type': 'bool'},
        'work_item_integration': {'key': 'WorkItemIntegration', 'type': 'bool'},
        'power_bi_integration': {'key': 'PowerBIIntegration', 'type': 'bool'},
        'open_schema': {'key': 'OpenSchema', 'type': 'bool'},
        'proactive_detection': {'key': 'ProactiveDetection', 'type': 'bool'},
        'analytics_integration': {'key': 'AnalyticsIntegration', 'type': 'bool'},
        'multiple_step_web_test': {'key': 'MultipleStepWebTest', 'type': 'bool'},
        'api_access_level': {'key': 'ApiAccessLevel', 'type': 'str'},
        'tracking_type': {'key': 'TrackingType', 'type': 'str'},
        'daily_cap': {'key': 'DailyCap', 'type': 'float'},
        'daily_cap_reset_time': {'key': 'DailyCapResetTime', 'type': 'float'},
        'throttle_rate': {'key': 'ThrottleRate', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplicationInsightsComponentFeatureCapabilities, self).__init__(**kwargs)
        self.support_export_data = None
        self.burst_throttle_policy = None
        self.metadata_class = None
        self.live_stream_metrics = None
        self.application_map = None
        self.work_item_integration = None
        self.power_bi_integration = None
        self.open_schema = None
        self.proactive_detection = None
        self.analytics_integration = None
        self.multiple_step_web_test = None
        self.api_access_level = None
        self.tracking_type = None
        self.daily_cap = None
        self.daily_cap_reset_time = None
        self.throttle_rate = None


class ApplicationInsightsComponentFeatureCapability(msrest.serialization.Model):
    """An Application Insights component feature capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the capability.
    :vartype name: str
    :ivar description: The description of the capability.
    :vartype description: str
    :ivar value: The value of the capability.
    :vartype value: str
    :ivar unit: The unit of the capability.
    :vartype unit: str
    :ivar meter_id: The meter used for the capability.
    :vartype meter_id: str
    :ivar meter_rate_frequency: The meter rate of the meter.
    :vartype meter_rate_frequency: str
    """

    _validation = {
        'name': {'readonly': True},
        'description': {'readonly': True},
        'value': {'readonly': True},
        'unit': {'readonly': True},
        'meter_id': {'readonly': True},
        'meter_rate_frequency': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
        'unit': {'key': 'Unit', 'type': 'str'},
        'meter_id': {'key': 'MeterId', 'type': 'str'},
        'meter_rate_frequency': {'key': 'MeterRateFrequency', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplicationInsightsComponentFeatureCapability, self).__init__(**kwargs)
        self.name = None
        self.description = None
        self.value = None
        self.unit = None
        self.meter_id = None
        self.meter_rate_frequency = None


class ApplicationInsightsComponentListResult(msrest.serialization.Model):
    """Describes the list of Application Insights Resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of Application Insights component definitions.
    :vartype value:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponent]
    :ivar next_link: The URI to get the next set of Application Insights component definitions if
     too many components where returned in the result set.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationInsightsComponent]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ApplicationInsightsComponent"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. List of Application Insights component definitions.
        :paramtype value:
         list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponent]
        :keyword next_link: The URI to get the next set of Application Insights component definitions
         if too many components where returned in the result set.
        :paramtype next_link: str
        """
        super(ApplicationInsightsComponentListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationInsightsComponentProactiveDetectionConfiguration(msrest.serialization.Model):
    """Properties that define a ProactiveDetection configuration.

    :ivar name: The rule name.
    :vartype name: str
    :ivar enabled: A flag that indicates whether this rule is enabled by the user.
    :vartype enabled: bool
    :ivar send_emails_to_subscription_owners: A flag that indicated whether notifications on this
     rule should be sent to subscription owners.
    :vartype send_emails_to_subscription_owners: bool
    :ivar custom_emails: Custom email addresses for this rule notifications.
    :vartype custom_emails: list[str]
    :ivar last_updated_time: The last time this rule was updated.
    :vartype last_updated_time: str
    :ivar rule_definitions: Static definitions of the ProactiveDetection configuration rule (same
     values for all components).
    :vartype rule_definitions:
     ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'send_emails_to_subscription_owners': {'key': 'SendEmailsToSubscriptionOwners', 'type': 'bool'},
        'custom_emails': {'key': 'CustomEmails', 'type': '[str]'},
        'last_updated_time': {'key': 'LastUpdatedTime', 'type': 'str'},
        'rule_definitions': {'key': 'RuleDefinitions', 'type': 'ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        enabled: Optional[bool] = None,
        send_emails_to_subscription_owners: Optional[bool] = None,
        custom_emails: Optional[List[str]] = None,
        last_updated_time: Optional[str] = None,
        rule_definitions: Optional["ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions"] = None,
        **kwargs
    ):
        """
        :keyword name: The rule name.
        :paramtype name: str
        :keyword enabled: A flag that indicates whether this rule is enabled by the user.
        :paramtype enabled: bool
        :keyword send_emails_to_subscription_owners: A flag that indicated whether notifications on
         this rule should be sent to subscription owners.
        :paramtype send_emails_to_subscription_owners: bool
        :keyword custom_emails: Custom email addresses for this rule notifications.
        :paramtype custom_emails: list[str]
        :keyword last_updated_time: The last time this rule was updated.
        :paramtype last_updated_time: str
        :keyword rule_definitions: Static definitions of the ProactiveDetection configuration rule
         (same values for all components).
        :paramtype rule_definitions:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions
        """
        super(ApplicationInsightsComponentProactiveDetectionConfiguration, self).__init__(**kwargs)
        self.name = name
        self.enabled = enabled
        self.send_emails_to_subscription_owners = send_emails_to_subscription_owners
        self.custom_emails = custom_emails
        self.last_updated_time = last_updated_time
        self.rule_definitions = rule_definitions


class ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions(msrest.serialization.Model):
    """Static definitions of the ProactiveDetection configuration rule (same values for all components).

    :ivar name: The rule name.
    :vartype name: str
    :ivar display_name: The rule name as it is displayed in UI.
    :vartype display_name: str
    :ivar description: The rule description.
    :vartype description: str
    :ivar help_url: URL which displays additional info about the proactive detection rule.
    :vartype help_url: str
    :ivar is_hidden: A flag indicating whether the rule is hidden (from the UI).
    :vartype is_hidden: bool
    :ivar is_enabled_by_default: A flag indicating whether the rule is enabled by default.
    :vartype is_enabled_by_default: bool
    :ivar is_in_preview: A flag indicating whether the rule is in preview.
    :vartype is_in_preview: bool
    :ivar supports_email_notifications: A flag indicating whether email notifications are supported
     for detections for this rule.
    :vartype supports_email_notifications: bool
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'help_url': {'key': 'HelpUrl', 'type': 'str'},
        'is_hidden': {'key': 'IsHidden', 'type': 'bool'},
        'is_enabled_by_default': {'key': 'IsEnabledByDefault', 'type': 'bool'},
        'is_in_preview': {'key': 'IsInPreview', 'type': 'bool'},
        'supports_email_notifications': {'key': 'SupportsEmailNotifications', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        help_url: Optional[str] = None,
        is_hidden: Optional[bool] = None,
        is_enabled_by_default: Optional[bool] = None,
        is_in_preview: Optional[bool] = None,
        supports_email_notifications: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: The rule name.
        :paramtype name: str
        :keyword display_name: The rule name as it is displayed in UI.
        :paramtype display_name: str
        :keyword description: The rule description.
        :paramtype description: str
        :keyword help_url: URL which displays additional info about the proactive detection rule.
        :paramtype help_url: str
        :keyword is_hidden: A flag indicating whether the rule is hidden (from the UI).
        :paramtype is_hidden: bool
        :keyword is_enabled_by_default: A flag indicating whether the rule is enabled by default.
        :paramtype is_enabled_by_default: bool
        :keyword is_in_preview: A flag indicating whether the rule is in preview.
        :paramtype is_in_preview: bool
        :keyword supports_email_notifications: A flag indicating whether email notifications are
         supported for detections for this rule.
        :paramtype supports_email_notifications: bool
        """
        super(ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitions, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.description = description
        self.help_url = help_url
        self.is_hidden = is_hidden
        self.is_enabled_by_default = is_enabled_by_default
        self.is_in_preview = is_in_preview
        self.supports_email_notifications = supports_email_notifications


class ApplicationInsightsComponentQuotaStatus(msrest.serialization.Model):
    """An Application Insights component daily data volume cap status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar app_id: The Application ID for the Application Insights component.
    :vartype app_id: str
    :ivar should_be_throttled: The daily data volume cap is met, and data ingestion will be
     stopped.
    :vartype should_be_throttled: bool
    :ivar expiration_time: Date and time when the daily data volume cap will be reset, and data
     ingestion will resume.
    :vartype expiration_time: str
    """

    _validation = {
        'app_id': {'readonly': True},
        'should_be_throttled': {'readonly': True},
        'expiration_time': {'readonly': True},
    }

    _attribute_map = {
        'app_id': {'key': 'AppId', 'type': 'str'},
        'should_be_throttled': {'key': 'ShouldBeThrottled', 'type': 'bool'},
        'expiration_time': {'key': 'ExpirationTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplicationInsightsComponentQuotaStatus, self).__init__(**kwargs)
        self.app_id = None
        self.should_be_throttled = None
        self.expiration_time = None


class ApplicationInsightsComponentWebTestLocation(msrest.serialization.Model):
    """Properties that define a web test location available to an Application Insights Component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: The display name of the web test location.
    :vartype display_name: str
    :ivar tag: Internally defined geographic location tag.
    :vartype tag: str
    """

    _validation = {
        'display_name': {'readonly': True},
        'tag': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'tag': {'key': 'Tag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplicationInsightsComponentWebTestLocation, self).__init__(**kwargs)
        self.display_name = None
        self.tag = None


class ApplicationInsightsWebTestLocationsListResult(msrest.serialization.Model):
    """Describes the list of web test locations available to an Application Insights Component.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of web test locations.
    :vartype value:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentWebTestLocation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationInsightsComponentWebTestLocation]'},
    }

    def __init__(
        self,
        *,
        value: List["ApplicationInsightsComponentWebTestLocation"],
        **kwargs
    ):
        """
        :keyword value: Required. List of web test locations.
        :paramtype value:
         list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentWebTestLocation]
        """
        super(ApplicationInsightsWebTestLocationsListResult, self).__init__(**kwargs)
        self.value = value


class ComponentPurgeBody(msrest.serialization.Model):
    """Describes the body of a purge request for an App Insights component.

    All required parameters must be populated in order to send to Azure.

    :ivar table: Required. Table from which to purge data.
    :vartype table: str
    :ivar filters: Required. The set of columns and filters (queries) to run over them to purge the
     resulting data.
    :vartype filters:
     list[~azure.mgmt.applicationinsights.v2015_05_01.models.ComponentPurgeBodyFilters]
    """

    _validation = {
        'table': {'required': True},
        'filters': {'required': True},
    }

    _attribute_map = {
        'table': {'key': 'table', 'type': 'str'},
        'filters': {'key': 'filters', 'type': '[ComponentPurgeBodyFilters]'},
    }

    def __init__(
        self,
        *,
        table: str,
        filters: List["ComponentPurgeBodyFilters"],
        **kwargs
    ):
        """
        :keyword table: Required. Table from which to purge data.
        :paramtype table: str
        :keyword filters: Required. The set of columns and filters (queries) to run over them to purge
         the resulting data.
        :paramtype filters:
         list[~azure.mgmt.applicationinsights.v2015_05_01.models.ComponentPurgeBodyFilters]
        """
        super(ComponentPurgeBody, self).__init__(**kwargs)
        self.table = table
        self.filters = filters


class ComponentPurgeBodyFilters(msrest.serialization.Model):
    """User-defined filters to return data which will be purged from the table.

    :ivar column: The column of the table over which the given query should run.
    :vartype column: str
    :ivar operator: A query operator to evaluate over the provided column and value(s). Supported
     operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as they would
     in a KQL query.
    :vartype operator: str
    :ivar value: the value for the operator to function over. This can be a number (e.g., > 100), a
     string (timestamp >= '2017-09-01') or array of values.
    :vartype value: any
    :ivar key: When filtering over custom dimensions, this key will be used as the name of the
     custom dimension.
    :vartype key: str
    """

    _attribute_map = {
        'column': {'key': 'column', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        column: Optional[str] = None,
        operator: Optional[str] = None,
        value: Optional[Any] = None,
        key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword column: The column of the table over which the given query should run.
        :paramtype column: str
        :keyword operator: A query operator to evaluate over the provided column and value(s).
         Supported operators are ==, =~, in, in~, >, >=, <, <=, between, and have the same behavior as
         they would in a KQL query.
        :paramtype operator: str
        :keyword value: the value for the operator to function over. This can be a number (e.g., >
         100), a string (timestamp >= '2017-09-01') or array of values.
        :paramtype value: any
        :keyword key: When filtering over custom dimensions, this key will be used as the name of the
         custom dimension.
        :paramtype key: str
        """
        super(ComponentPurgeBodyFilters, self).__init__(**kwargs)
        self.column = column
        self.operator = operator
        self.value = value
        self.key = key


class ComponentPurgeResponse(msrest.serialization.Model):
    """Response containing operationId for a specific purge action.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Id to use when querying for status for a particular purge
     operation.
    :vartype operation_id: str
    """

    _validation = {
        'operation_id': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Id to use when querying for status for a particular purge
         operation.
        :paramtype operation_id: str
        """
        super(ComponentPurgeResponse, self).__init__(**kwargs)
        self.operation_id = operation_id


class ComponentPurgeStatusResponse(msrest.serialization.Model):
    """Response containing status for a specific purge operation.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Status of the operation represented by the requested Id. Possible
     values include: "pending", "completed".
    :vartype status: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.PurgeState
    """

    _validation = {
        'status': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "PurgeState"],
        **kwargs
    ):
        """
        :keyword status: Required. Status of the operation represented by the requested Id. Possible
         values include: "pending", "completed".
        :paramtype status: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.PurgeState
        """
        super(ComponentPurgeStatusResponse, self).__init__(**kwargs)
        self.status = status


class ErrorFieldContract(msrest.serialization.Model):
    """Error Field contract.

    :ivar code: Property level error code.
    :vartype code: str
    :ivar message: Human-readable representation of property-level error.
    :vartype message: str
    :ivar target: Property name.
    :vartype target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Property level error code.
        :paramtype code: str
        :keyword message: Human-readable representation of property-level error.
        :paramtype message: str
        :keyword target: Property name.
        :paramtype target: str
        """
        super(ErrorFieldContract, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates Insights service is not able to process the incoming request. The reason is provided in the error message.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class InnerError(msrest.serialization.Model):
    """Inner error.

    :ivar diagnosticcontext: Provides correlation for request.
    :vartype diagnosticcontext: str
    :ivar time: Request time.
    :vartype time: ~datetime.datetime
    """

    _attribute_map = {
        'diagnosticcontext': {'key': 'diagnosticcontext', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        diagnosticcontext: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword diagnosticcontext: Provides correlation for request.
        :paramtype diagnosticcontext: str
        :keyword time: Request time.
        :paramtype time: ~datetime.datetime
        """
        super(InnerError, self).__init__(**kwargs)
        self.diagnosticcontext = diagnosticcontext
        self.time = time


class LinkProperties(msrest.serialization.Model):
    """Contains a sourceId and workbook resource id to link two resources.

    :ivar source_id: The source Azure resource id.
    :vartype source_id: str
    :ivar target_id: The workbook Azure resource id.
    :vartype target_id: str
    :ivar category: The category of workbook.
    :vartype category: str
    """

    _attribute_map = {
        'source_id': {'key': 'sourceId', 'type': 'str'},
        'target_id': {'key': 'targetId', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_id: Optional[str] = None,
        target_id: Optional[str] = None,
        category: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source_id: The source Azure resource id.
        :paramtype source_id: str
        :keyword target_id: The workbook Azure resource id.
        :paramtype target_id: str
        :keyword category: The category of workbook.
        :paramtype category: str
        """
        super(LinkProperties, self).__init__(**kwargs)
        self.source_id = source_id
        self.target_id = target_id
        self.category = category


class MyWorkbookResource(msrest.serialization.Model):
    """An azure resource object.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Azure resource Id.
        :paramtype id: str
        :keyword name: Azure resource name.
        :paramtype name: str
        :keyword type: Azure resource type.
        :paramtype type: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(MyWorkbookResource, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.tags = tags


class MyWorkbook(MyWorkbookResource):
    """An Application Insights private workbook definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: The kind of workbook. Choices are user and shared. Possible values include: "user",
     "shared".
    :vartype kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.SharedTypeKind
    :ivar display_name: The user-defined name of the private workbook.
    :vartype display_name: str
    :ivar serialized_data: Configuration of this particular private workbook. Configuration data is
     a string containing valid JSON.
    :vartype serialized_data: str
    :ivar version: This instance's version of the data model. This can change as new features are
     added that can be marked private workbook.
    :vartype version: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     private workbook definition.
    :vartype time_modified: str
    :ivar category: Workbook category, as defined by the user at creation time.
    :vartype category: str
    :ivar tags_properties_tags: A list of 0 or more tags that are associated with this private
     workbook definition.
    :vartype tags_properties_tags: list[str]
    :ivar user_id: Unique user id of the specific user that owns this private workbook.
    :vartype user_id: str
    :ivar source_id: Optional resourceId for a source resource.
    :vartype source_id: str
    """

    _validation = {
        'time_modified': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'serialized_data': {'key': 'properties.serializedData', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'time_modified': {'key': 'properties.timeModified', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '[str]'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
        'source_id': {'key': 'properties.sourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "SharedTypeKind"]] = None,
        display_name: Optional[str] = None,
        serialized_data: Optional[str] = None,
        version: Optional[str] = None,
        category: Optional[str] = None,
        tags_properties_tags: Optional[List[str]] = None,
        source_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Azure resource Id.
        :paramtype id: str
        :keyword name: Azure resource name.
        :paramtype name: str
        :keyword type: Azure resource type.
        :paramtype type: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: The kind of workbook. Choices are user and shared. Possible values include:
         "user", "shared".
        :paramtype kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.SharedTypeKind
        :keyword display_name: The user-defined name of the private workbook.
        :paramtype display_name: str
        :keyword serialized_data: Configuration of this particular private workbook. Configuration data
         is a string containing valid JSON.
        :paramtype serialized_data: str
        :keyword version: This instance's version of the data model. This can change as new features
         are added that can be marked private workbook.
        :paramtype version: str
        :keyword category: Workbook category, as defined by the user at creation time.
        :paramtype category: str
        :keyword tags_properties_tags: A list of 0 or more tags that are associated with this private
         workbook definition.
        :paramtype tags_properties_tags: list[str]
        :keyword source_id: Optional resourceId for a source resource.
        :paramtype source_id: str
        """
        super(MyWorkbook, self).__init__(id=id, name=name, type=type, location=location, tags=tags, **kwargs)
        self.kind = kind
        self.display_name = display_name
        self.serialized_data = serialized_data
        self.version = version
        self.time_modified = None
        self.category = category
        self.tags_properties_tags = tags_properties_tags
        self.user_id = None
        self.source_id = source_id


class MyWorkbookError(msrest.serialization.Model):
    """Error message body that will indicate why the operation failed.

    :ivar code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :vartype code: str
    :ivar message: Human-readable representation of the error.
    :vartype message: str
    :ivar details: The list of invalid fields send in request, in case of validation error.
    :vartype details: list[~azure.mgmt.applicationinsights.v2015_05_01.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["ErrorFieldContract"]] = None,
        **kwargs
    ):
        """
        :keyword code: Service-defined error code. This code serves as a sub-status for the HTTP error
         code specified in the response.
        :paramtype code: str
        :keyword message: Human-readable representation of the error.
        :paramtype message: str
        :keyword details: The list of invalid fields send in request, in case of validation error.
        :paramtype details: list[~azure.mgmt.applicationinsights.v2015_05_01.models.ErrorFieldContract]
        """
        super(MyWorkbookError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class MyWorkbooksListResult(msrest.serialization.Model):
    """Workbook list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of private workbooks.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.MyWorkbook]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MyWorkbook]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MyWorkbooksListResult, self).__init__(**kwargs)
        self.value = None


class Operation(msrest.serialization.Model):
    """CDN REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.applicationinsights.v2015_05_01.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.applicationinsights.v2015_05_01.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Cdn.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft.Cdn.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list CDN operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of CDN operations supported by the CDN resource provider.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of CDN operations supported by the CDN resource provider.
        :paramtype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkScopedResource(msrest.serialization.Model):
    """The private link scope resource reference.

    :ivar resource_id: The full resource Id of the private link scope resource.
    :vartype resource_id: str
    :ivar scope_id: The private link scope unique Identifier.
    :vartype scope_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'ResourceId', 'type': 'str'},
        'scope_id': {'key': 'ScopeId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        scope_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_id: The full resource Id of the private link scope resource.
        :paramtype resource_id: str
        :keyword scope_id: The private link scope unique Identifier.
        :paramtype scope_id: str
        """
        super(PrivateLinkScopedResource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.scope_id = scope_id


class TagsResource(msrest.serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a WebTest instance.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(TagsResource, self).__init__(**kwargs)
        self.tags = tags


class WebtestsResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(WebtestsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class WebTest(WebtestsResource):
    """An Application Insights web test definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: The kind of web test that this web test watches. Choices are ping and multistep.
     Possible values include: "ping", "multistep".
    :vartype kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestKind
    :ivar synthetic_monitor_id: Unique ID of this WebTest. This is typically the same value as the
     Name field.
    :vartype synthetic_monitor_id: str
    :ivar web_test_name: User defined name if this WebTest.
    :vartype web_test_name: str
    :ivar description: Purpose/user defined descriptive test for this WebTest.
    :vartype description: str
    :ivar enabled: Is the test actively being monitored.
    :vartype enabled: bool
    :ivar frequency: Interval in seconds between test runs for this WebTest. Default value is 300.
    :vartype frequency: int
    :ivar timeout: Seconds until this WebTest will timeout and fail. Default value is 30.
    :vartype timeout: int
    :ivar web_test_kind: The kind of web test this is, valid choices are ping and multistep.
     Possible values include: "ping", "multistep".
    :vartype web_test_kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestKind
    :ivar retry_enabled: Allow for retries should this WebTest fail.
    :vartype retry_enabled: bool
    :ivar locations: A list of where to physically run the tests from to give global coverage for
     accessibility of your application.
    :vartype locations: list[~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestGeolocation]
    :ivar configuration: An XML configuration specification for a WebTest.
    :vartype configuration:
     ~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestPropertiesConfiguration
    :ivar provisioning_state: Current state of this component, whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'synthetic_monitor_id': {'key': 'properties.SyntheticMonitorId', 'type': 'str'},
        'web_test_name': {'key': 'properties.Name', 'type': 'str'},
        'description': {'key': 'properties.Description', 'type': 'str'},
        'enabled': {'key': 'properties.Enabled', 'type': 'bool'},
        'frequency': {'key': 'properties.Frequency', 'type': 'int'},
        'timeout': {'key': 'properties.Timeout', 'type': 'int'},
        'web_test_kind': {'key': 'properties.Kind', 'type': 'str'},
        'retry_enabled': {'key': 'properties.RetryEnabled', 'type': 'bool'},
        'locations': {'key': 'properties.Locations', 'type': '[WebTestGeolocation]'},
        'configuration': {'key': 'properties.Configuration', 'type': 'WebTestPropertiesConfiguration'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "WebTestKind"]] = None,
        synthetic_monitor_id: Optional[str] = None,
        web_test_name: Optional[str] = None,
        description: Optional[str] = None,
        enabled: Optional[bool] = None,
        frequency: Optional[int] = 300,
        timeout: Optional[int] = 30,
        web_test_kind: Optional[Union[str, "WebTestKind"]] = None,
        retry_enabled: Optional[bool] = None,
        locations: Optional[List["WebTestGeolocation"]] = None,
        configuration: Optional["WebTestPropertiesConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: The kind of web test that this web test watches. Choices are ping and multistep.
         Possible values include: "ping", "multistep".
        :paramtype kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestKind
        :keyword synthetic_monitor_id: Unique ID of this WebTest. This is typically the same value as
         the Name field.
        :paramtype synthetic_monitor_id: str
        :keyword web_test_name: User defined name if this WebTest.
        :paramtype web_test_name: str
        :keyword description: Purpose/user defined descriptive test for this WebTest.
        :paramtype description: str
        :keyword enabled: Is the test actively being monitored.
        :paramtype enabled: bool
        :keyword frequency: Interval in seconds between test runs for this WebTest. Default value is
         300.
        :paramtype frequency: int
        :keyword timeout: Seconds until this WebTest will timeout and fail. Default value is 30.
        :paramtype timeout: int
        :keyword web_test_kind: The kind of web test this is, valid choices are ping and multistep.
         Possible values include: "ping", "multistep".
        :paramtype web_test_kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestKind
        :keyword retry_enabled: Allow for retries should this WebTest fail.
        :paramtype retry_enabled: bool
        :keyword locations: A list of where to physically run the tests from to give global coverage
         for accessibility of your application.
        :paramtype locations:
         list[~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestGeolocation]
        :keyword configuration: An XML configuration specification for a WebTest.
        :paramtype configuration:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.WebTestPropertiesConfiguration
        """
        super(WebTest, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = kind
        self.synthetic_monitor_id = synthetic_monitor_id
        self.web_test_name = web_test_name
        self.description = description
        self.enabled = enabled
        self.frequency = frequency
        self.timeout = timeout
        self.web_test_kind = web_test_kind
        self.retry_enabled = retry_enabled
        self.locations = locations
        self.configuration = configuration
        self.provisioning_state = None


class WebTestGeolocation(msrest.serialization.Model):
    """Geo-physical location to run a web test from. You must specify one or more locations for the test to run from.

    :ivar location: Location ID for the webtest to run from.
    :vartype location: str
    """

    _attribute_map = {
        'location': {'key': 'Id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location ID for the webtest to run from.
        :paramtype location: str
        """
        super(WebTestGeolocation, self).__init__(**kwargs)
        self.location = location


class WebTestListResult(msrest.serialization.Model):
    """A list of 0 or more Application Insights web test definitions.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Set of Application Insights web test definitions.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.WebTest]
    :ivar next_link: The link to get the next part of the returned list of web tests, should the
     return set be too large for a single request. May be null.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebTest]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["WebTest"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. Set of Application Insights web test definitions.
        :paramtype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.WebTest]
        :keyword next_link: The link to get the next part of the returned list of web tests, should the
         return set be too large for a single request. May be null.
        :paramtype next_link: str
        """
        super(WebTestListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WebTestPropertiesConfiguration(msrest.serialization.Model):
    """An XML configuration specification for a WebTest.

    :ivar web_test: The XML specification of a WebTest to run against an application.
    :vartype web_test: str
    """

    _attribute_map = {
        'web_test': {'key': 'WebTest', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        web_test: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword web_test: The XML specification of a WebTest to run against an application.
        :paramtype web_test: str
        """
        super(WebTestPropertiesConfiguration, self).__init__(**kwargs)
        self.web_test = web_test


class WorkbookResource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(WorkbookResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Workbook(WorkbookResource):
    """An Application Insights workbook definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: The kind of workbook. Choices are user and shared. Possible values include: "user",
     "shared".
    :vartype kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.SharedTypeKind
    :ivar name_properties_name: The user-defined name of the workbook.
    :vartype name_properties_name: str
    :ivar serialized_data: Configuration of this particular workbook. Configuration data is a
     string containing valid JSON.
    :vartype serialized_data: str
    :ivar version: This instance's version of the data model. This can change as new features are
     added that can be marked workbook.
    :vartype version: str
    :ivar workbook_id: Internally assigned unique id of the workbook definition.
    :vartype workbook_id: str
    :ivar shared_type_kind: Enum indicating if this workbook definition is owned by a specific user
     or is shared between all users with access to the Application Insights component. Possible
     values include: "user", "shared".
    :vartype shared_type_kind: str or
     ~azure.mgmt.applicationinsights.v2015_05_01.models.SharedTypeKind
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     workbook definition.
    :vartype time_modified: str
    :ivar category: Workbook category, as defined by the user at creation time.
    :vartype category: str
    :ivar tags_properties_tags: A list of 0 or more tags that are associated with this workbook
     definition.
    :vartype tags_properties_tags: list[str]
    :ivar user_id: Unique user id of the specific user that owns this workbook.
    :vartype user_id: str
    :ivar source_resource_id: Optional resourceId for a source resource.
    :vartype source_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time_modified': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'serialized_data': {'key': 'properties.serializedData', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'workbook_id': {'key': 'properties.workbookId', 'type': 'str'},
        'shared_type_kind': {'key': 'properties.kind', 'type': 'str'},
        'time_modified': {'key': 'properties.timeModified', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '[str]'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
        'source_resource_id': {'key': 'properties.sourceResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "SharedTypeKind"]] = None,
        name_properties_name: Optional[str] = None,
        serialized_data: Optional[str] = None,
        version: Optional[str] = None,
        workbook_id: Optional[str] = None,
        shared_type_kind: Optional[Union[str, "SharedTypeKind"]] = None,
        category: Optional[str] = None,
        tags_properties_tags: Optional[List[str]] = None,
        user_id: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: The kind of workbook. Choices are user and shared. Possible values include:
         "user", "shared".
        :paramtype kind: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.SharedTypeKind
        :keyword name_properties_name: The user-defined name of the workbook.
        :paramtype name_properties_name: str
        :keyword serialized_data: Configuration of this particular workbook. Configuration data is a
         string containing valid JSON.
        :paramtype serialized_data: str
        :keyword version: This instance's version of the data model. This can change as new features
         are added that can be marked workbook.
        :paramtype version: str
        :keyword workbook_id: Internally assigned unique id of the workbook definition.
        :paramtype workbook_id: str
        :keyword shared_type_kind: Enum indicating if this workbook definition is owned by a specific
         user or is shared between all users with access to the Application Insights component. Possible
         values include: "user", "shared".
        :paramtype shared_type_kind: str or
         ~azure.mgmt.applicationinsights.v2015_05_01.models.SharedTypeKind
        :keyword category: Workbook category, as defined by the user at creation time.
        :paramtype category: str
        :keyword tags_properties_tags: A list of 0 or more tags that are associated with this workbook
         definition.
        :paramtype tags_properties_tags: list[str]
        :keyword user_id: Unique user id of the specific user that owns this workbook.
        :paramtype user_id: str
        :keyword source_resource_id: Optional resourceId for a source resource.
        :paramtype source_resource_id: str
        """
        super(Workbook, self).__init__(location=location, tags=tags, **kwargs)
        self.kind = kind
        self.name_properties_name = name_properties_name
        self.serialized_data = serialized_data
        self.version = version
        self.workbook_id = workbook_id
        self.shared_type_kind = shared_type_kind
        self.time_modified = None
        self.category = category
        self.tags_properties_tags = tags_properties_tags
        self.user_id = user_id
        self.source_resource_id = source_resource_id


class WorkbookError(msrest.serialization.Model):
    """Error message body that will indicate why the operation failed.

    :ivar code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :vartype code: str
    :ivar message: Human-readable representation of the error.
    :vartype message: str
    :ivar details: The list of invalid fields send in request, in case of validation error.
    :vartype details: list[~azure.mgmt.applicationinsights.v2015_05_01.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["ErrorFieldContract"]] = None,
        **kwargs
    ):
        """
        :keyword code: Service-defined error code. This code serves as a sub-status for the HTTP error
         code specified in the response.
        :paramtype code: str
        :keyword message: Human-readable representation of the error.
        :paramtype message: str
        :keyword details: The list of invalid fields send in request, in case of validation error.
        :paramtype details: list[~azure.mgmt.applicationinsights.v2015_05_01.models.ErrorFieldContract]
        """
        super(WorkbookError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class WorkbooksListResult(msrest.serialization.Model):
    """Workbook list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of workbooks.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.Workbook]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workbook]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(WorkbooksListResult, self).__init__(**kwargs)
        self.value = None


class WorkItemConfiguration(msrest.serialization.Model):
    """Work item configuration associated with an application insights resource.

    :ivar connector_id: Connector identifier where work item is created.
    :vartype connector_id: str
    :ivar config_display_name: Configuration friendly name.
    :vartype config_display_name: str
    :ivar is_default: Boolean value indicating whether configuration is default.
    :vartype is_default: bool
    :ivar id: Unique Id for work item.
    :vartype id: str
    :ivar config_properties: Serialized JSON object for detailed properties.
    :vartype config_properties: str
    """

    _attribute_map = {
        'connector_id': {'key': 'ConnectorId', 'type': 'str'},
        'config_display_name': {'key': 'ConfigDisplayName', 'type': 'str'},
        'is_default': {'key': 'IsDefault', 'type': 'bool'},
        'id': {'key': 'Id', 'type': 'str'},
        'config_properties': {'key': 'ConfigProperties', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connector_id: Optional[str] = None,
        config_display_name: Optional[str] = None,
        is_default: Optional[bool] = None,
        id: Optional[str] = None,
        config_properties: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword connector_id: Connector identifier where work item is created.
        :paramtype connector_id: str
        :keyword config_display_name: Configuration friendly name.
        :paramtype config_display_name: str
        :keyword is_default: Boolean value indicating whether configuration is default.
        :paramtype is_default: bool
        :keyword id: Unique Id for work item.
        :paramtype id: str
        :keyword config_properties: Serialized JSON object for detailed properties.
        :paramtype config_properties: str
        """
        super(WorkItemConfiguration, self).__init__(**kwargs)
        self.connector_id = connector_id
        self.config_display_name = config_display_name
        self.is_default = is_default
        self.id = id
        self.config_properties = config_properties


class WorkItemConfigurationError(msrest.serialization.Model):
    """Error associated with trying to get work item configuration or configurations.

    :ivar code: Error detail code and explanation.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar innererror: Inner error.
    :vartype innererror: ~azure.mgmt.applicationinsights.v2015_05_01.models.InnerError
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        innererror: Optional["InnerError"] = None,
        **kwargs
    ):
        """
        :keyword code: Error detail code and explanation.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword innererror: Inner error.
        :paramtype innererror: ~azure.mgmt.applicationinsights.v2015_05_01.models.InnerError
        """
        super(WorkItemConfigurationError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.innererror = innererror


class WorkItemConfigurationsListResult(msrest.serialization.Model):
    """Work item configuration list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of work item configurations.
    :vartype value: list[~azure.mgmt.applicationinsights.v2015_05_01.models.WorkItemConfiguration]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkItemConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(WorkItemConfigurationsListResult, self).__init__(**kwargs)
        self.value = None


class WorkItemCreateConfiguration(msrest.serialization.Model):
    """Work item configuration creation payload.

    :ivar connector_id: Unique connector id.
    :vartype connector_id: str
    :ivar connector_data_configuration: Serialized JSON object for detailed properties.
    :vartype connector_data_configuration: str
    :ivar validate_only: Boolean indicating validate only.
    :vartype validate_only: bool
    :ivar work_item_properties: Custom work item properties.
    :vartype work_item_properties: dict[str, str]
    """

    _attribute_map = {
        'connector_id': {'key': 'ConnectorId', 'type': 'str'},
        'connector_data_configuration': {'key': 'ConnectorDataConfiguration', 'type': 'str'},
        'validate_only': {'key': 'ValidateOnly', 'type': 'bool'},
        'work_item_properties': {'key': 'WorkItemProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        connector_id: Optional[str] = None,
        connector_data_configuration: Optional[str] = None,
        validate_only: Optional[bool] = None,
        work_item_properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword connector_id: Unique connector id.
        :paramtype connector_id: str
        :keyword connector_data_configuration: Serialized JSON object for detailed properties.
        :paramtype connector_data_configuration: str
        :keyword validate_only: Boolean indicating validate only.
        :paramtype validate_only: bool
        :keyword work_item_properties: Custom work item properties.
        :paramtype work_item_properties: dict[str, str]
        """
        super(WorkItemCreateConfiguration, self).__init__(**kwargs)
        self.connector_id = connector_id
        self.connector_data_configuration = connector_data_configuration
        self.validate_only = validate_only
        self.work_item_properties = work_item_properties
