# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .partition_scheme_description import PartitionSchemeDescription


class UniformInt64RangePartitionSchemeDescription(PartitionSchemeDescription):
    """Describes a partitioning scheme where an integer range is allocated evenly
    across a number of partitions.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Constant filled by server.
    :type partition_scheme: str
    :param count: Required. The number of partitions.
    :type count: int
    :param low_key: Required. String indicating the lower bound of the
     partition key range that
     should be split between the partition ‘Count’
    :type low_key: str
    :param high_key: Required. String indicating the upper bound of the
     partition key range that
     should be split between the partition ‘Count’
    :type high_key: str
    """

    _validation = {
        'partition_scheme': {'required': True},
        'count': {'required': True},
        'low_key': {'required': True},
        'high_key': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'PartitionScheme', 'type': 'str'},
        'count': {'key': 'Count', 'type': 'int'},
        'low_key': {'key': 'LowKey', 'type': 'str'},
        'high_key': {'key': 'HighKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UniformInt64RangePartitionSchemeDescription, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.low_key = kwargs.get('low_key', None)
        self.high_key = kwargs.get('high_key', None)
        self.partition_scheme = 'UniformInt64Range'
