# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .data_item_migration_summary_result import DataItemMigrationSummaryResult


class DatabaseSummaryResult(DataItemMigrationSummaryResult):
    """Summary of database results in the migration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of the item
    :vartype name: str
    :ivar started_on: Migration start time
    :vartype started_on: datetime
    :ivar ended_on: Migration end time
    :vartype ended_on: datetime
    :ivar state: Current state of migration. Possible values include: 'None',
     'InProgress', 'Failed', 'Warning', 'Completed', 'Skipped', 'Stopped'
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar status_message: Status message
    :vartype status_message: str
    :ivar items_count: Number of items
    :vartype items_count: long
    :ivar items_completed_count: Number of successfully completed items
    :vartype items_completed_count: long
    :ivar error_prefix: Wildcard string prefix to use for querying all errors
     of the item
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all
     sub-tem results of the item
    :vartype result_prefix: str
    :ivar size_mb: Size of the database in megabytes
    :vartype size_mb: float
    """

    _validation = {
        'name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'state': {'readonly': True},
        'status_message': {'readonly': True},
        'items_count': {'readonly': True},
        'items_completed_count': {'readonly': True},
        'error_prefix': {'readonly': True},
        'result_prefix': {'readonly': True},
        'size_mb': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'items_count': {'key': 'itemsCount', 'type': 'long'},
        'items_completed_count': {'key': 'itemsCompletedCount', 'type': 'long'},
        'error_prefix': {'key': 'errorPrefix', 'type': 'str'},
        'result_prefix': {'key': 'resultPrefix', 'type': 'str'},
        'size_mb': {'key': 'sizeMB', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(DatabaseSummaryResult, self).__init__(**kwargs)
        self.size_mb = None
