# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserAccountSettings(Model):
    """Settings for user account that gets created on each on the nodes of a
    cluster.

    All required parameters must be populated in order to send to Azure.

    :param admin_user_name: Required. Specifies the name of the administrator
     account.
    :type admin_user_name: str
    :param admin_user_ssh_public_key: SSH public keys used to authenticate
     with linux based VMs. This does not get returned in a GET response body.
    :type admin_user_ssh_public_key: str
    :param admin_user_password: Admin user Password (linux only). This does
     not get returned in a GET response body.
    :type admin_user_password: str
    """

    _validation = {
        'admin_user_name': {'required': True},
    }

    _attribute_map = {
        'admin_user_name': {'key': 'adminUserName', 'type': 'str'},
        'admin_user_ssh_public_key': {'key': 'adminUserSshPublicKey', 'type': 'str'},
        'admin_user_password': {'key': 'adminUserPassword', 'type': 'str'},
    }

    def __init__(self, *, admin_user_name: str, admin_user_ssh_public_key: str=None, admin_user_password: str=None, **kwargs) -> None:
        super(UserAccountSettings, self).__init__(**kwargs)
        self.admin_user_name = admin_user_name
        self.admin_user_ssh_public_key = admin_user_ssh_public_key
        self.admin_user_password = admin_user_password
