
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2458849.5,
          {-0.1236785226,-0.001016382169,7.601207659,0.116215565,0.0006052121852,0.05759342871}, /*cmx*/
          {3.79347948,2.300920297,0.4284915499,4.691905155}, /*cfx*/
          {0.1218839756,-0.0009230147803,5.739423972,0.0480356922,0.0005533921366,0.03662314683}, /*cmy*/
          {0.2920792081,4.388321019,2.242052813,1.456848873}, /*cfy*/
          {0.1257331564,-0.0005428457301,9.232235862,0.1031705688,0.0006254344751,0.06811920941}, /*cmz*/
          {5.235103476,3.730096081,1.850552142,-0.05205542309} /*cfz*/
     },
     {
          2458899.5,
          {-0.176493889,-0.000616036071,8.538110557,0.1135788802,0.0007312462257,0.06575093831}, /*cmx*/
          {1.780603091,0.4064090392,4.573534588,1.055270769}, /*cfx*/
          {0.07388958874,-0.001450854143,3.943429004,0.05099802078,0.0005048922886,0.02310080754}, /*cmy*/
          {5.074571653,1.725723777,-0.3114216137,4.860975139}, /*cfy*/
          {0.0988398401,-0.0007888187733,9.359611461,0.1035837644,0.00063798516,0.06715494732}, /*cmz*/
          {3.37812654,1.773185686,-0.01006406773,2.677226808} /*cfz*/
     },
     {
          2458949.5,
          {-0.206903313,2.431117791e-05,9.354652805,0.09616418702,0.0006268018208,0.06829485708}, /*cmx*/
          {-0.09872106463,4.640150167,2.637482,3.822795184}, /*cfx*/
          {-0.001002896672,-0.001258734808,2.681569485,0.05134430696,-0.0004817751788,0.02606993245}, /*cmy*/
          {4.327824899,-0.7223387586,12.72618668,2.449549953}, /*cfy*/
          {0.05884470771,-0.0009884777588,9.017949002,0.1104036753,0.0005943966982,0.06390071768}, /*cmz*/
          {1.496641611,-0.1794332586,4.28982201,-0.9256849955} /*cfz*/
     },
     {
          2458999.5,
          {-0.2041791615,0.0003400639658,9.092289586,0.0898684784,0.000429003306,0.06382155753}, /*cmx*/
          {4.382154778,2.607248729,0.5548787613,0.3356721148}, /*cfx*/
          {-0.06393023993,-0.0007049720976,4.352769033,0.0402205105,-0.0003620158026,0.03818547111}, /*cmy*/
          {3.330155392,3.045094283,3.96676886,5.698345855}, /*cfy*/
          {0.007247829869,-0.0007944259446,8.641986938,0.1123229252,0.0005168947828,0.06289344004}, /*cmz*/
          {-0.4397591835,4.202540113,1.980968589,1.724973091} /*cfz*/
     },
     {
          2459049.5,
          {-0.1861332183,0.0002367851622,8.284006025,0.08254906206,0.0006722854116,0.05912112952}, /*cmx*/
          {2.594185604,0.7405454571,3.985222774,3.178636084}, /*cfx*/
          {-0.09749964071,-0.0004494571193,5.670501557,0.03148131897,0.0002564224693,0.04387423598}, /*cmy*/
          {1.815406944,0.6033240638,10.21945482,2.482993042}, /*cfy*/
          {-0.03654459014,0.0002982466467,8.723820427,0.09123864682,0.0007624234954,0.06538072308}, /*cmz*/
          {3.946603607,2.36046048,-0.6693052578,4.52112371} /*cfz*/
     },
     {
          2459099.5,
          {-0.1805962083,0.0008105671397,7.788220794,-0.0109402029,0.0004585327973,0.05976158878}, /*cmx*/
          {0.9612578645,5.443315461,2.504717102,0.09026333638}, /*cfx*/
          {-0.1217158568,-0.0003197655529,5.974415489,-0.002714886452,5.562952526e-05,0.04502765154}, /*cmy*/
          {0.3311756896,4.553098086,2.24887799,5.679191844}, /*cfy*/
          {-0.01902519983,0.002224814238,8.897875327,-0.009307944137,0.0004537545091,0.06627229365}, /*cmz*/
          {2.310684265,0.7145313786,4.259025123,1.427126838} /*cfz*/
     },
     {
          2459149.5,
          {-0.1299210654,0.001005863464,8.079017464,-0.02767082583,-0.0009329698079,0.06027298712}, /*cmx*/
          {6.116688079,4.24382457,1.163132063,3.398181834}, /*cfx*/
          {-0.1355694149,-4.32149508e-05,5.989547509,-0.004060627114,-0.0003463388365,0.0454357624}, /*cmy*/
          {5.325560682,1.722167957,-5.569633206,2.562447885}, /*cfy*/
          {0.1006537212,0.0008376831212,8.611514952,-0.02362176142,-0.0009912966535,0.06313964502}, /*cmz*/
          {1.151701478,6.108249144,2.760968558,4.698314159} /*cfz*/
     },
     {
          2459199.5,
          {-0.08065703707,-0.0001003877381,7.964505294,0.06551155577,-0.0005389321529,0.05540215058}, /*cmx*/
          {4.679629018,2.997939994,5.143283065,-0.05074989189}, /*cfx*/
          {-0.1388546082,7.727177287e-05,6.301341732,-0.03942453638,0.0003296077728,0.04700898863}, /*cmy*/
          {3.852879901,-6.855295766,-11.5724313,5.484633034}, /*cfy*/
          {0.1374828027,6.0066004e-06,8.482505514,0.07640055361,0.0004856351458,0.06249157264}, /*cmz*/
          {5.959758721,4.491353112,-2.998083332,1.222150363} /*cfz*/
     },
     {
          2459249.5,
          {-0.08716526913,-0.0007888201127,7.445040933,0.1068100735,-0.0005980469242,0.05267486198}, /*cmx*/
          {2.817455006,1.195158186,2.747109007,2.444525385}, /*cfx*/
          {-0.1360770244,0.0005487819817,6.423425856,-0.05332849804,0.0004702957915,0.04401988333}, /*cmy*/
          {2.19773354,3.596578624,4.589894901,2.027350968}, /*cfy*/
          {0.1373979857,-0.0001328421591,8.8899371,0.1038725945,0.0006208382405,0.0656251654}, /*cmz*/
          {4.13017556,2.669254986,0.8412833071,3.844564047} /*cfz*/
     },
     {
          2459299.5,
          {-0.1288964076,-0.0008872807416,7.703914355,0.1227227058,-0.000708959859,0.05867593892}, /*cmx*/
          {0.7541667985,5.602527085,0.4527020376,4.875740536}, /*cfx*/
          {-0.1086126821,0.001209941978,5.45442379,-0.04827597853,0.0005403308015,0.03331346319}, /*cmy*/
          {0.5338674091,1.180199148,2.142567976,4.9793218}, /*cfy*/
          {0.1312463921,-0.0003100441685,9.328133736,0.1065002941,0.0006752117417,0.06738619879}, /*cmz*/
          {2.251753157,0.7171615189,5.127486772,0.1836989073} /*cfz*/
     },
     {
          2459349.5,
          {-0.1745589852,-0.0003997077144,8.811137585,0.1106979322,-0.0007248093674,0.06648414758}, /*cmx*/
          {5.035089353,3.633201352,4.656761566,1.181266783}, /*cfx*/
          {-0.04596685587,0.001519688872,3.513353717,-0.04728728952,0.0004633872183,0.02324047952}, /*cmy*/
          {5.454414967,4.819957064,-0.4421841439,2.167663725}, /*cfy*/
          {0.1158272632,-0.0005897099176,9.279690667,0.1076169702,0.0006512884257,0.06530599886}, /*cmz*/
          {0.3763693886,5.014121087,3.206856319,2.805218696} /*cfz*/
     },
     {
          2459399.5,
          {-0.1935971625,0.0001037796519,9.382594279,0.09356643338,-0.0005992991531,0.06727682514}, /*cmx*/
          {3.176821718,1.587941166,2.8027755,3.890254188}, /*cfx*/
          {0.03165284664,0.001221147811,3.222883221,-0.04438836421,0.0004624045396,0.03076815353}, /*cmy*/
          {4.721098752,2.35562315,3.320402183,5.75141891}, /*cfy*/
          {0.08602751524,-0.000832185214,8.800687084,0.111830732,0.0006133188041,0.06171158176}, /*cmz*/
          {4.751664074,3.073405092,1.278157171,-0.89464008} /*cfz*/
     },
     {
          2459449.5,
          {-0.1871823623,0.0002650285429,8.92517587,0.09090951214,-0.0005150880578,0.06142001524}, /*cmx*/
          {1.372187349,-0.3938541312,1.103146491,0.3258126308}, /*cfx*/
          {0.09312763254,0.0006167857133,4.988004889,-0.0421260702,0.0004495296494,0.04201070252}, /*cmy*/
          {3.481792932,-0.1836030138,1.00316724,2.545564072}, /*cfy*/
          {0.04381722571,-0.0009244589839,8.437563347,0.114977209,0.0006061792763,0.06108461662}, /*cmz*/
          {2.787153718,1.189343369,5.610778238,1.659494234} /*cfz*/
     },
     {
          2459499.5,
          {-0.1732591085,0.0001177168332,7.948479069,0.1020585901,-0.0005395191666,0.05458094846}, /*cmx*/
          {-0.494893545,4.034689258,5.660476241,2.934843536}, /*cfx*/
          {0.1239708877,-2.235759003e-05,6.164322218,-0.05028084423,0.0004592070011,0.04581352999}, /*cmy*/
          {1.87633431,3.677486428,4.800741984,5.453711537}, /*cfy*/
          {-0.002712462884,-0.0008684077588,8.635461746,0.1137448727,0.0006453991621,0.06436382275}, /*cmz*/
          {0.8090606455,5.598058888,3.677309803,4.256453078} /*cfz*/
     },
     {
          2459549.5,
          {-0.1679199292,-5.969506955e-05,7.454671561,0.1215712136,-0.0006589217659,0.0554973109}, /*cmx*/
          {3.761815798,2.225244144,3.567241594,-0.8706206527}, /*cfx*/
          {0.1222230616,-0.0005801184472,6.046790325,-0.0528826511,0.0006100871195,0.03922415158}, /*cmy*/
          {0.1853249093,1.309449067,2.264139724,2.104010722}, /*cfy*/
          {-0.04617173272,-0.0007630316046,9.154297479,0.1102053036,0.0007082680302,0.06744691135}, /*cmz*/
          {5.16210449,3.672813694,1.785127429,0.639376777} /*cfz*/
     },
     {
          2459599.5,
          {-0.1722907359,9.972564025e-05,8.330834795,0.1250905622,-0.0008527343094,0.06413839314}, /*cmx*/
          {1.681674297,0.3164267205,1.341674949,1.693414662}, /*cfx*/
          {0.09152032426,-0.0007945589003,4.346261492,-0.05502325596,0.0005998401547,0.02471330314}, /*cmy*/
          {4.89682575,-1.410403143,-0.332062608,5.405025381}, /*cfy*/
          {-0.08401930946,-0.0007145169056,9.370979272,0.1116401338,0.0007500063347,0.06660259835}, /*cmz*/
          {3.268148093,1.676646669,-0.1171280146,3.318702908} /*cfz*/
     },
     {
          2459649.5,
          {-0.1675232569,0.0005109255826,9.333522957,0.1062448646,-0.0007693582716,0.06734035137}, /*cmx*/
          {-0.258010611,4.498445679,-0.63158145,4.398281962}, /*cfx*/
          {0.0504023084,-0.000476660074,2.696801769,-0.05764518274,-0.000607894925,0.02609565106}, /*cmy*/
          {4.080396732,2.306199423,0.0252455706,3.001657441}, /*cfy*/
          {-0.1196947752,-0.0007124107114,9.033595457,0.1209847915,0.0007444314914,0.06288782111}, /*cmz*/
          {1.34373853,-0.3268606927,4.170077193,-0.3485643357} /*cfz*/
     },
     {
          2459699.5,
          {-0.141652253,0.0008807260256,9.05383674,0.101478728,-0.0005993741803,0.06196820062}, /*cmx*/
          {4.168579198,2.411501361,3.804362488,0.8278164381}, /*cfx*/
          {0.02722481644,-6.071380035e-05,4.462610221,0.04815649983,-0.0005531390281,0.03925252924}, /*cmy*/
          {3.126412979,-3.504686612,3.823358309,-0.08129840599}, /*cfy*/
          {-0.1559503792,-0.0006341517014,8.606059084,0.128021444,0.0007164244926,0.06158656465}, /*cmz*/
          {-0.6613048324,3.998379943,2.06031065,2.19717796} /*cfz*/
     },
     {
          2459749.5,
          {-0.0964421555,0.001052720038,8.068435697,0.1091191629,-0.0005062218481,0.05562224632}, /*cmx*/
          {2.261546126,0.4957362733,1.796859377,3.439978193}, /*cfx*/
          {0.02602617562,-5.010109532e-05,5.910982671,0.0511034662,0.0004391596025,0.04420916756}, /*cmy*/
          {1.516251775,0.1730045901,-1.981739843,2.839628124}, /*cfy*/
          {-0.1879983121,-0.0003952990554,8.730225058,0.1207969522,0.0006588471729,0.06478325919}, /*cmz*/
          {3.595035286,2.062629745,-0.08432112181,4.788338371} /*cfz*/
     },
     {
          2459799.5,
          {-0.04081352987,0.0006089570083,7.60099897,0.1080162474,-0.0005200467133,0.05652721722}, /*cmx*/
          {0.2591469019,4.941358712,-0.7742630234,-0.2456601819}, /*cfx*/
          {0.02387092821,-0.000426260765,5.876092341,0.04162261173,-0.0003267687433,0.04013397285}, /*cmy*/
          {-0.1731189519,4.060214905,-1.509040792,-0.4825509657}, /*cfy*/
          {-0.2075921066,-0.0001149928038,9.188505704,0.09960915551,0.0005379794835,0.06838428873}, /*cmz*/
          {1.671729388,0.1205352663,3.865514577,1.244977751} /*cfz*/
     },
     {
          2459849.5,
          {-0.005910592327,-0.0009983590769,8.033166429,0.06989716528,-0.001038899929,0.06127559792}, /*cmx*/
          {4.661307068,3.19512292,3.208026177,2.655552611}, /*cfx*/
          {0.001555279862,-0.0005980401183,4.883271698,0.02552168175,0.0003749615314,0.03451075984}, /*cmy*/
          {4.562931595,1.764916096,4.586460086,2.622523422}, /*cfy*/
          {-0.2147611888,0.00020260659,9.383250133,0.0632209782,0.0008783321708,0.07035518272}, /*cmz*/
          {-0.07708389472,4.576150513,1.440815017,4.218021546} /*cfz*/
     },
     {
          2459899.5,
          {-0.07002169973,-0.001816976771,8.192250298,-0.07011350289,0.0003932447938,0.05940054651}, /*cmx*/
          {3.213015854,1.922857071,1.693482918,-0.2345108241}, /*cfx*/
          {-0.02709162239,-0.001118754689,4.602210643,-0.02932845857,-0.0001786359245,0.03905559304}, /*cmy*/
          {3.144250942,-0.09213912994,2.66349988,5.799989375}, /*cfy*/
          {-0.2063637286,0.001629804358,9.389309698,-0.05348958604,-0.0003278041987,0.0702797971}, /*cmz*/
          {4.768374543,3.291267844,-0.08299147744,1.261578974} /*cfz*/
     },
     {
          2459949.5,
          {-0.1554935533,-0.0003060838378,7.648252944,-0.00269752796,0.0008673324601,0.05688079}, /*cmx*/
          {2.195270503,-1.56342028,0.5384803514,2.990495658}, /*cfx*/
          {-0.08701610525,-0.0003592339851,5.635452604,-0.008980203108,-0.0003323898268,0.04116615392}, /*cmy*/
          {1.828744405,4.019931452,2.23376818,2.673662352}, /*cfy*/
          {-0.1176248678,0.0008694271088,9.205887047,0.006310587446,-0.000723812803,0.06861482719}, /*cmz*/
          {3.63904646,2.665893434,5.068914055,4.453941695} /*cfz*/
     },
     {
          2459999.5,
          {-0.1690733464,-0.0002385984726,7.852999077,-0.0866085041,-0.0004927997857,0.05956148034}, /*cmx*/
          {0.5934136048,-22.79881584,-5.422032068,-0.5894641219}, /*cfx*/
          {-0.1035152625,0.0003830958286,5.195681635,-0.03337267034,-0.000359398751,0.03330365867}, /*cmy*/
          {0.3767915856,-17.78353793,-0.8825986733,-0.5635841213}, /*cfy*/
          {-0.07706066002,9.742523724e-05,9.315338747,0.07564583452,0.0004912647062,0.06827032465}, /*cmz*/
          {2.098193414,-5.67606293,-0.8157407648,0.9838815792} /*cfz*/
     },
     {
          2460049.5,
          {-0.1820678982,-0.0001799335163,8.685010188,-0.1029844101,-0.000622441539,0.06575397608}, /*cmx*/
          {5.000226828,0.4657610198,4.749131816,2.034171388}, /*cfx*/
          {-0.08323340055,0.0007640927028,3.671268389,-0.04055653719,-0.0004103817471,0.02340097153}, /*cmy*/
          {5.277068888,4.861039913,2.842340981,2.801635052}, /*cfy*/
          {-0.07260175794,-0.0001989898335,9.325394321,0.09634331419,0.0005893050664,0.0663237557}, /*cmz*/
          {0.3285236965,4.998597083,3.303018997,3.661864231} /*cfz*/
     },
     {
          2460099.5,
          {-0.1915414532,0.0001261089414,9.345969145,-0.0939934041,-0.0006031156464,0.06788417369}, /*cmx*/
          {3.153582854,4.762223996,2.813999739,4.725425126}, /*cfx*/
          {-0.04383356846,0.000785698955,2.978372284,-0.04332228354,-0.0004338508625,0.02800947157}, /*cmy*/
          {4.4599438,2.419702462,0.2936899777,0.1467784748}, /*cfy*/
          {-0.08247952115,-0.0004718039217,8.922629285,0.106853313,0.0006082827538,0.06239961333}, /*cmz*/
          {4.752761109,3.071763686,1.344544082,-0.01874272902} /*cfz*/
     },
     {
          2460149.5,
          {-0.1853478456,0.0005229613825,9.127829515,-0.09008472966,-0.0005464281962,0.06346449677}, /*cmx*/
          {1.353016537,2.769163472,1.074026718,1.153600493}, /*cfx*/
          {-0.003810587869,0.0005020277781,4.597362364,-0.0423075974,-0.0004605002302,0.04027899446}, /*cmy*/
          {3.354445419,-0.05767481647,4.239112618,3.280005099}, /*cfy*/
          {-0.1064593504,-0.0007090359312,8.440471143,0.1147827763,0.0006161155379,0.06037300326}, /*cmz*/
          {2.810804221,1.179451922,-0.6221429163,2.517602532} /*cfz*/
     },
     {
          2460199.5,
          {-0.158938571,0.0008834105285,8.201867148,-0.09999620939,-0.000570692047,0.05592599348}, /*cmx*/
          {-0.4895056496,0.8700090736,5.651394506,3.773610424}, /*cfx*/
          {0.02106236724,0.0001405448428,6.062993421,-0.05004568617,-0.0004670242323,0.04675872474}, /*cmy*/
          {1.793083127,3.767309049,1.812842513,-0.09913853501}, /*cfy*/
          {-0.1427664762,-0.0007409263636,8.464745597,0.1176722327,0.0006679940874,0.063189591}, /*cmz*/
          {0.8156867158,5.586694881,3.684995617,5.059565594} /*cfz*/
     },
     {
          2460249.5,
          {-0.1140387183,0.001104727997,7.398593272,-0.1222658142,-0.0006768584194,0.05407710881}, /*cmx*/
          {3.788687189,5.320079779,3.623196684,-0.06497129937}, /*cfx*/
          {0.02633599837,7.768314543e-05,6.326601768,-0.05629389272,-0.0006201695072,0.0429935817}, /*cmy*/
          {0.09936269856,1.420231397,-0.7932730931,2.786817599}, /*cfy*/
          {-0.1808369256,-0.0004877934823,9.007043119,0.1154628139,0.0007584293592,0.06745982248}, /*cmz*/
          {5.131920428,3.661962531,1.750224417,1.3904786} /*cfz*/
     },
     {
          2460299.5,
          {-0.05742430239,0.0009938305359,7.985588245,-0.1343524677,-0.0009061996621,0.06279278121}, /*cmx*/
          {1.654853974,3.421648963,1.311787202,2.411031614}, /*cfx*/
          {0.02935103384,0.0004787039808,4.951117534,0.05566104567,-0.0006678672489,0.02872244986}, /*cmy*/
          {4.74605124,-4.434576666,2.913937373,-0.3356959928}, /*cfy*/
          {-0.2053632645,-5.902440988e-05,9.374886877,0.1158872263,0.0008223525997,0.06767983085}, /*cmz*/
          {3.211420702,1.643205908,-0.1779826132,4.036241671} /*cfz*/
     },
     {
          2460349.5,
          {-0.008033682308,0.0006864176968,9.231578425,-0.1141486048,-0.0008780248457,0.06811572726}, /*cmx*/
          {-0.3481078849,1.316961392,5.551110404,5.063227141}, /*cfx*/
          {0.05478622213,0.0007633954392,2.855906888,0.06198610474,0.0006510594317,0.0255728037}, /*cmy*/
          {3.734904483,-0.8219715558,-53.37860521,3.513762287}, /*cfy*/
          {-0.2078126787,0.0003230965805,9.093737042,0.1255044145,0.0008167191864,0.06365891604}, /*cmz*/
          {1.270444813,-0.4029944851,4.088643047,0.3401478728} /*cfz*/
     },
     {
          2460399.5,
          {0.02487728583,0.0006775896273,9.151475491,-0.1052315335,-0.0006720098891,0.06297586495}, /*cmx*/
          {4.052581157,5.450832552,3.691759269,1.465994335}, /*cfx*/
          {0.094371102,0.0005598418048,4.288411961,-0.05072525313,0.0006272656104,0.03911526943}, /*cmy*/
          {2.940061481,-0.3691427743,0.6312614527,0.5097570534}, /*cfy*/
          {-0.1910676234,0.0005076196228,8.589954211,0.1341495861,0.000792192609,0.06150723866}, /*cmz*/
          {5.524806124,3.889964656,1.96936824,2.841663564} /*cfz*/
     },
     {
          2460449.5,
          {0.05850649317,0.000955237065,8.110470288,-0.1142663756,-0.0006005425199,0.0554503585}, /*cmx*/
          {2.128854593,3.500932109,1.795157368,4.034832449}, /*cfx*/
          {0.1234243909,2.466092471e-06,5.931325832,-0.0554849126,0.0005259101746,0.044780501}, /*cmy*/
          {1.354367108,3.207720608,-8.312059839,3.410073635}, /*cfy*/
          {-0.1651868409,0.000528880596,8.667961144,0.1290752016,0.0007638374453,0.0644234507}, /*cmz*/
          {3.456345115,1.928510206,-0.1264635141,-0.9122501015} /*cfz*/
     },
     {
          2460499.5,
          {0.1078431527,0.001033100112,7.556186956,-0.1230004749,-0.0006092074994,0.05628011822}, /*cmx*/
          {0.0663444658,1.639574406,-0.4108413545,0.2279575721}, /*cfx*/
          {0.1235415058,-0.000741059419,5.936729315,-0.05210185676,0.0005363171198,0.03917202823}, /*cmy*/
          {-0.3721027781,0.7546479419,1.631849555,0.03603559898}, /*cfy*/
          {-0.138621874,0.0004736936132,9.167835297,0.1134755289,0.0006599343905,0.06792415876}, /*cmz*/
          {1.472843429,-0.04929820996,4.127620013,1.733377195} /*cfz*/
     },
     {
          2460549.5,
          {0.1611253569,0.0005557004721,8.281785135,-0.1066409887,-0.0005865132572,0.06417855976}, /*cmx*/
          {4.309769741,-0.2465861477,3.572356993,2.874571695}, /*cfx*/
          {0.08440881756,-0.00116326615,4.441027609,-0.04229195591,0.0003415402114,0.02680029505}, /*cmy*/
          {4.323540025,4.405768475,-0.9222164092,3.222960402}, /*cfy*/
          {-0.1140862431,0.0002866048738,9.392818536,0.09643257964,0.0004799952242,0.06861342884}, /*cmz*/
          {-0.3988766394,4.261934909,1.964232506,4.490392082} /*cfz*/
     },
     {
          2460599.5,
          {0.1899687897,-0.0002379162727,9.131615667,-0.07021619467,-0.0006153309845,0.06941398051}, /*cmx*/
          {2.498939836,4.134294957,1.096980745,-0.4965162738}, /*cfx*/
          {0.02346661649,-0.0008288901808,2.819337238,-0.03327703303,-0.0003024745567,0.01969113478}, /*cmy*/
          {3.183486802,2.1019365,5.192933196,0.5268001674}, /*cfy*/
          {-0.09676375887,-0.0004389357522,9.233213991,0.07490780674,0.0006284426284,0.06831924529}, /*cmz*/
          {4.11670597,2.398918352,-0.6768925182,1.110005206} /*cfz*/
     },
     {
          2460649.5,
          {0.1829061678,-0.001963649195,9.316789037,0.006067256174,-0.0006356922765,0.07029978241}, /*cmx*/
          {0.9560684796,1.871637836,6.01465424,2.741836488}, /*cfx*/
          {-0.01780318541,0.0001476275301,2.496967077,-0.01306501537,-0.0004176498712,0.0175199002}, /*cmy*/
          {2.183619922,-9.954419362,4.075764079,3.707139598}, /*cfy*/
          {-0.1224368251,-0.001591015726,9.066891717,-0.007980893924,0.0006473346514,0.06972008888}, /*cmz*/
          {2.550286365,0.157176667,4.266996269,4.34039335} /*cfz*/
     },
     {
          2460699.5,
          {0.06857427695,-0.001819984391,9.121244016,0.05096530741,0.00100907437,0.0677107645}, /*cmx*/
          {6.096646217,7.923599923,4.731484307,-0.1679073561}, /*cfx*/
          {-0.006406149666,-0.00050579436,2.551051766,-0.03370416779,0.0004958820501,0.02177674822}, /*cmy*/
          {0.3602937962,-3.555161391,2.664931753,0.2296031926}, /*cfy*/
          {-0.2054815422,-0.0001758145592,9.289658175,-0.04975684412,-0.0009760663283,0.07020443784}, /*cmz*/
          {1.418344692,12.39613423,2.973214353,1.436896438} /*cfz*/
     },
     {
          2460749.5,
          {-0.01729385109,-0.0004266235131,8.964644363,-0.05322966956,0.0004221776863,0.06758234982}, /*cmx*/
          {4.776187852,0.2604025286,2.408286685,2.792574785}, /*cfx*/
          {-0.0341990224,-0.0005678876595,2.964430005,0.01741507043,0.0002359291089,0.02091808403}, /*cmy*/
          {5.225546832,1.380178234,0.1522812476,3.589558248}, /*cfy*/
          {-0.210605433,0.0001999477927,9.275979126,0.05010512106,-0.0004968484078,0.06768385279}, /*cmz*/
          {0.1030517438,4.842799107,0.8117539494,4.40792793} /*cfz*/
     },
     {
          2460799.5,
          {-0.03719170443,-8.171905594e-05,9.32121119,-0.08258926173,0.0004960896928,0.06836070016}, /*cmx*/
          {3.088695594,4.725188747,-0.1891781849,-0.7275970671}, /*cfx*/
          {-0.06260140836,-0.0003907998885,2.756672138,0.03565351268,-0.0003445587278,0.02541213597}, /*cmy*/
          {4.308626258,-0.7870151171,0.4233059446,0.8822947591}, /*cfy*/
          {-0.200478242,0.0001732331556,9.006019194,0.09006104072,-0.000532380931,0.06363723648}, /*cmz*/
          {4.68962436,3.033148097,4.665203001,0.8320244345} /*cfz*/
     },
     {
          2460849.5,
          {-0.04197267379,0.0002095332796,9.244329408,-0.08670476086,0.0005345928883,0.06487210529}, /*cmx*/
          {1.324612035,2.791519926,4.228343487,1.997384141}, /*cfx*/
          {-0.08207493844,-0.000221818637,4.165806539,0.0409856377,-0.0004329704092,0.0374076577}, /*cmy*/
          {3.239632113,3.144498994,4.330972041,4.04776561}, /*cfy*/
          {-0.1915255686,6.958191756e-05,8.532248582,0.1081525583,-0.0005939390044,0.06021993104}, /*cmz*/
          {2.819707821,1.168499434,2.617527766,3.404148752} /*cfz*/
     },
     {
          2460899.5,
          {-0.03229174777,0.0007406513227,8.489959234,-0.09596626491,0.0005851494011,0.05746196034}, /*cmx*/
          {5.795146013,0.8786383601,2.505548738,4.641374605}, /*cfx*/
          {-0.09335413695,-5.367185834e-05,5.796320359,0.04900165555,-0.000468938874,0.04573896241}, /*cmy*/
          {1.719090045,0.7263841185,1.968409021,0.6685110037}, /*cfy*/
          {-0.1883745254,-2.266463271e-05,8.361880382,0.1177426663,-0.0006600518384,0.06122379025}, /*cmz*/
          {0.8448099227,5.582164331,0.5987143749,-0.363013252} /*cfz*/
     },
     {
          2460949.5,
          {0.00510723722,0.001367702832,7.535067583,-0.1186200743,0.0006915590068,0.05269908723}, /*cmx*/
          {3.838180682,5.300318942,0.5680266254,0.8111761336}, /*cfx*/
          {-0.09778467195,0.0003863135867,6.436212531,0.0585812395,-0.0005945799672,0.0450056179}, /*cmy*/
          {0.02977888244,4.678615809,-0.6571309574,3.511144585}, /*cfy*/
          {-0.1907171691,0.0001067361042,8.809146476,0.1194307945,-0.0007734463443,0.06569015715}, /*cmz*/
          {5.136160643,3.672801966,4.893855951,2.197942781} /*cfz*/
     },
     {
          2460999.5,
          {0.07703403867,0.001408453869,7.65969074,-0.1403368519,0.0009066726766,0.05948065207}, /*cmx*/
          {1.689341775,3.407266381,4.499265688,3.202581524}, /*cfx*/
          {-0.07911330375,0.001300230777,5.515777959,0.05589133858,-0.0007306135075,0.03280310142}, /*cmy*/
          {4.624178455,2.05666066,3.052619121,0.2517896001}, /*cfy*/
          {-0.1862098184,0.000566918238,9.332732175,0.118938674,-0.0008761176382,0.06743868727}, /*cmz*/
          {3.189480638,1.658397558,2.939536788,4.808500506} /*cfz*/
     },
     {
          2461049.5,
          {0.148787493,0.0005779091387,9.009107623,-0.1239798103,0.0009781029262,0.06740670282}, /*cmx*/
          {-0.38808888,1.334326733,2.352589996,-0.4978240355}, /*cfx*/
          {-0.01015166587,0.001668376241,3.228773646,-0.06407301874,0.0006660958022,0.02460013175}, /*cmy*/
          {3.37850649,-3.89691919,40.9820331,3.980491715}, /*cfy*/
          {-0.1575509655,0.001128674311,9.197181167,0.127218804,-0.0008805852208,0.06379370487}, /*cmz*/
          {1.24218334,-0.4262460902,0.9214581263,1.096680364} /*cfz*/
     },
     {
          2461099.5,
          {0.1755253988,-4.776351049e-05,9.290369349,-0.1076538257,0.0007465509988,0.06407447839}, /*cmx*/
          {3.982268222,-0.8645765573,0.4578127618,2.171890855}, /*cfx*/
          {0.07548564714,0.0009834795262,3.963112598,-0.05397110389,0.0006791243362,0.03766441608}, /*cmy*/
          {2.728217836,-19.12494437,0.6485232537,1.122469666}, /*cfy*/
          {-0.09963713468,0.001379207741,8.599107651,0.1381127614,-0.0008388712764,0.06056775932}, /*cmz*/
          {5.491285708,3.829443345,5.067051981,3.569593203} /*cfz*/
     },
     {
          2461149.5,
          {0.171750592,-7.96580577e-05,8.272984636,-0.1148524651,0.0006403773127,0.05553759839}, /*cmx*/
          {2.064971735,3.409543987,4.87954361,4.743832199}, /*cfx*/
          {0.1242424108,9.052175021e-05,5.887820247,0.05598413538,0.00056062044,0.04540728852}, /*cmy*/
          {1.222807729,0.07502027515,4.306292264,4.044254308}, /*cfy*/
          {-0.02938384106,0.00119070409,8.54075584,0.1348694981,-0.0008180640579,0.06315638774}, /*cmz*/
          {3.390493756,1.854125324,2.950973954,-0.2318883876} /*cfz*/
     },
     {
          2461199.5,
          {0.1677469406,9.656294214e-05,7.465026702,-0.1276343893,0.0006599578528,0.0543944975}, /*cmx*/
          {-0.003398965509,1.534178323,2.744176243,0.8907261256}, /*cfx*/
          {0.1275059396,-0.0005203592358,6.171173259,0.05690465014,0.0006006177699,0.04100930273}, /*cmy*/
          {5.776289689,3.883092948,1.623196419,0.6414655853}, /*cfy*/
          {0.03018592528,0.0008088882339,9.082975551,0.1198628328,-0.000744911824,0.06703508106}, /*cmz*/
          {1.36665986,-0.137620056,0.948010509,2.36889696} /*cfz*/
     },
     {
          2461249.5,
          {0.1733657589,0.0001086299563,8.11361026,-0.1195461754,0.0007000890485,0.0626032218}, /*cmx*/
          {4.173537473,-0.3638098179,0.5294668836,3.444556959}, /*cfx*/
          {0.1003314218,-0.0007652149086,4.739253588,0.0485114498,0.0004891244324,0.02766934427}, /*cmy*/
          {4.144054601,-23.91376085,-0.8823186993,3.789567494}, /*cfy*/
          {0.07020757734,0.0005015173055,9.385916416,0.1060524508,-0.0006003647078,0.06748082367}, /*cmz*/
          {-0.5461597363,4.141014933,5.268505773,5.063175342} /*cfz*/
     },
     {
          2461299.5,
          {0.1786880392,1.64404683e-05,9.160205409,-0.08992518778,0.0005194273936,0.06820467746}, /*cmx*/
          {2.267193846,3.937091633,4.740212799,-0.05976022703}, /*cfx*/
          {0.06148124104,-0.000721595851,2.828506058,0.04501440355,0.0003264934808,0.02126129218}, /*cmy*/
          {3.03460749,5.02468001,9.006933125,1.265086163}, /*cfy*/
          {0.09525368244,0.0002814101794,9.187595196,0.09580267103,-0.0004324126571,0.06548196476}, /*cmz*/
          {3.886061399,2.201419691,3.165398126,1.532011682} /*cfz*/
     },
     {
          2461349.5,
          {0.1781823258,0.0001335011317,9.373020531,-0.06516235267,0.0004084726223,0.06833160794}, /*cmx*/
          {0.5407382919,1.985380949,2.266412778,2.881673163}, /*cfx*/
          {0.02597701408,-0.0006899273714,3.211107415,0.03086080264,-0.0002314958179,0.02809362332}, /*cmy*/
          {2.302208167,2.812446956,-9.523173526,4.841624972}, /*cfy*/
          {0.1111701665,-0.0001587971156,8.846975963,0.08008533895,-0.0004847489088,0.06444537714}, /*cmz*/
          {2.087714496,0.3856088008,0.5830274602,4.384155934} /*cfz*/
     },
     {
          2461399.5,
          {0.1859252448,0.0004777663915,9.095372696,-0.02482435515,0.0007597849464,0.06828386904}, /*cmx*/
          {5.253716218,0.4016138892,0.3964453774,-0.2423780463}, /*cfx*/
          {-0.01028104414,-0.0006279672857,4.135204696,0.008932830822,-0.0003726202602,0.03017974569}, /*cmy*/
          {1.064781099,1.543995184,1.169127908,1.872247577}, /*cfy*/
          {0.1091599341,-0.001771878946,8.698990108,0.02954685576,-0.0009484614701,0.06572302228}, /*cmz*/
          {0.4424200281,5.216504824,5.15016406,1.233826526} /*cfz*/
     },
     {
          2461449.5,
          {0.21383368,-0.0006598957024,9.22207964,0.06176854491,-0.0007133991876,0.07010314282}, /*cmx*/
          {3.991001553,5.515688466,5.500273765,3.152532285}, /*cfx*/
          {-0.03851319841,-0.0001019052647,3.639764907,-0.0350236743,0.0003889766268,0.0233471054}, /*cmy*/
          {6.055893973,0.09493978926,6.015101834,5.026919197}, /*cfy*/
          {0.003974606805,-0.002394344756,8.850532839,-0.07693865103,0.0008609726074,0.06691775229}, /*cmz*/
          {5.491818434,3.943339435,3.898913199,4.688552614} /*cfz*/
     },
     {
          2461499.5,
          {0.1759074699,-0.0005909163939,9.342978824,-0.02323974786,-0.0005139660623,0.06907313311}, /*cmx*/
          {2.805424247,4.536236441,3.923505706,-0.008918112656}, /*cfx*/
          {-0.04405901679,-0.0007661902326,3.003518212,0.01024636229,0.0002117421877,0.0256671827}, /*cmy*/
          {4.53388422,4.415427363,4.430897765,1.79776774}, /*cfy*/
          {-0.1124726073,-0.000390798038,8.876166509,0.02355714421,0.000641348143,0.06470880573}, /*cmz*/
          {4.357934575,2.834899691,2.33471153,1.524530739} /*cfz*/
     },
     {
          2461549.5,
          {0.1471873281,-0.000270359411,9.228816966,-0.06994208134,-0.0004406425748,0.06576066304}, /*cmx*/
          {1.233140766,2.739804999,1.321397745,2.826449424}, /*cfx*/
          {-0.08449593747,-0.0007948074117,4.015693224,0.03338041627,0.0003247466483,0.03544981718}, /*cmy*/
          {3.174547912,3.002184297,26.43896693,4.868702966}, /*cfy*/
          {-0.1290919003,0.0003883604435,8.604585883,0.0847830654,0.0005062590418,0.06119256065}, /*cmz*/
          {2.730094672,1.101017394,-0.2324142506,4.257195533} /*cfz*/
     },
     {
          2461599.5,
          {0.1331470026,2.377139238e-05,8.667473645,-0.08840140868,-0.0005575037657,0.05932261431}, /*cmx*/
          {5.767942713,0.8849727854,5.688693313,-0.7613826617}, /*cfx*/
          {-0.1251137528,-0.0004031977748,5.495796794,0.04622395883,0.0004397891882,0.04411870061}, /*cmy*/
          {1.65726924,0.7698280577,5.234593487,1.491253768}, /*cfy*/
          {-0.1086890771,0.0006447596039,8.373883479,0.1095802326,0.0006114036646,0.06058810543}, /*cmz*/
          {0.849280296,5.563713274,3.860944536,0.5369410977} /*cfz*/
     },
     {
          2461649.5,
          {0.1338866078,0.0004901951151,7.772232021,-0.1116228889,-0.0006959364156,0.05308972278}, /*cmx*/
          {3.869893095,5.302840743,3.787959149,1.742161671}, /*cfx*/
          {-0.146123216,0.0002283977669,6.35904729,0.05880778856,0.0005527545465,0.04558854254}, /*cmy*/
          {-0.02277450422,4.771227065,2.655794735,4.308910009}, /*cfy*/
          {-0.07628865119,0.000714797682,8.649210345,0.1195627072,0.0007482874144,0.06411450695}, /*cmz*/
          {5.156309798,3.680475298,1.801281051,3.076390475} /*cfz*/
     },
     {
          2461699.5,
          {0.1607132019,0.0007212453902,7.515538049,-0.1404487499,-0.0008834501766,0.05657826806}, /*cmx*/
          {1.756065349,3.406082226,1.472313802,4.094440653}, /*cfx*/
          {-0.1347544522,0.001047797444,5.87273697,0.05819415247,0.0007580917869,0.03602666756}, /*cmy*/
          {4.536457771,2.281539076,0.04232042806,0.9411889059}, /*cfy*/
          {-0.04091272346,0.000828595512,9.228674336,0.1214975509,0.0008951684346,0.06695694837}, /*cmz*/
          {3.191060531,1.694464491,-0.1982768493,-0.6273979371} /*cfz*/
     },
     {
          2461749.5,
          {0.1988779634,0.000169726427,8.710475322,-0.1346332944,-0.001041533026,0.06578263913}, /*cmx*/
          {-0.3821537686,1.367608904,-0.7967385224,0.3104857024}, /*cfx*/
          {-0.07904907977,0.001356250912,3.708166701,0.06271797829,0.0006850867079,0.02401084779}, /*cmy*/
          {3.091060816,30.78594781,-9.087740544,4.471235939}, /*cfy*/
          {0.0001886346338,0.001072240082,9.308762214,0.1274201864,0.0009389784465,0.06430318814}, /*cmz*/
          {1.238352782,-0.4035023879,4.068118456,1.933007392} /*cfz*/
     },
     {
          2461799.5,
          {0.2066760949,-0.0005749442721,9.38138677,-0.1115834933,-0.0008300381311,0.0653373415}, /*cmx*/
          {3.943252871,-0.8374199773,3.532718017,2.946678431}, /*cfx*/
          {-0.009358771968,0.0007679143071,3.508522176,0.05813552016,-0.0007116105574,0.03488278002}, /*cmy*/
          {2.480170012,9.263227975,-2.431328746,1.771677627}, /*cfy*/
          {0.05461181593,0.001239158147,8.700307611,0.1397094296,0.0008827551359,0.05992257209}, /*cmz*/
          {5.498002714,3.807003356,1.934536129,4.389110657} /*cfz*/
     },
     {
          2461849.5,
          {0.1769225508,-0.001009358236,8.549293426,-0.1137019702,-0.0006824109622,0.05696674457}, /*cmx*/
          {2.033354727,3.366170595,1.689940751,-0.7539990964}, /*cfx*/
          {0.02792507953,0.0001095938328,5.681057711,0.05577785587,-0.0005935448105,0.04549448205}, /*cmy*/
          {1.101728352,-6.123420751,1.270773886,4.725960917}, /*cfy*/
          {0.1179237209,0.001058125741,8.406234216,0.1401771327,0.0008514280334,0.061667314}, /*cmz*/
          {3.378779594,1.813747368,-0.2208592005,0.5312561178} /*cfz*/
     },
     {
          2461899.5,
          {0.1250410848,-0.001099140744,7.478270923,-0.128254277,-0.0006747217464,0.05315225599}, /*cmx*/
          {-0.01006307259,1.459525591,-0.3746151702,1.658139754}, /*cfx*/
          {0.03107923228,1.833927188e-05,6.379180714,0.06010730422,0.0006136536966,0.04397814039}, /*cmy*/
          {5.664955416,3.936108517,1.675588291,1.294142458}, /*cfy*/
          {0.1713406661,0.0005833589866,8.925004551,0.1254480742,0.0008002088498,0.06665025558}, /*cmz*/
          {1.31059715,-0.1782090946,4.040498782,3.080088867} /*cfz*/
     },
     {
          2461949.5,
          {0.06892155738,-0.0007836758233,7.805181525,-0.1279778542,-0.000751831614,0.06089965042}, /*cmx*/
          {4.121406461,-0.4322386845,3.66451559,4.126822247}, /*cfx*/
          {0.03177559003,0.0003441543817,5.261339815,0.05055328706,0.0005674975285,0.03150540719}, /*cmy*/
          {3.988012001,1.297592644,-0.8223895888,4.353979512}, /*cfy*/
          {0.199995345,0.0001224109226,9.368549267,0.1108092448,0.0006817882341,0.0680916368}, /*cmz*/
          {5.650599037,4.081447445,2.106550364,-0.5451479801} /*cfz*/
     },
     {
          2461999.5,
          {0.03007906022,-0.0003267487535,9.009970764,-0.1008901538,-0.0006432495283,0.0681238129}, /*cmx*/
          {2.144174177,3.862880808,1.648975491,0.5493179819}, /*cfx*/
          {0.05022461561,0.0004741779473,3.16590235,0.05033973322,-0.0004172067633,0.02244996361}, /*cmy*/
          {2.74922098,4.986829981,-0.3448260058,1.755130576}, /*cfy*/
          {0.2052246518,-0.0001172283414,9.220724345,0.1036678579,0.0005365802669,0.06568833315}, /*cmz*/
          {3.77071716,2.099403057,0.1656384957,2.153900692} /*cfz*/
     },
     {
          2462049.5,
          {0.01444715033,-7.908486064e-05,9.372686943,-0.07870697449,-0.0004030003486,0.06765875302}, /*cmx*/
          {0.3520322351,1.836906489,-0.268842888,3.394734614}, /*cfx*/
          {0.07477144179,0.0002686232869,3.307293577,0.0397448697,-0.0003311199908,0.03088508376}, /*cmy*/
          {2.074278029,2.668831686,3.494840447,5.369958832}, /*cfy*/
          {0.1987433327,-0.0001137001525,8.794518494,0.0974917881,0.0004084122356,0.06328406211}, /*cmz*/
          {1.902290153,0.2236331753,4.390494905,4.876717177} /*cfz*/
     },
     {
          2462099.5,
          {0.009684094009,0.0001441157511,8.893436306,-0.0679789026,-0.000295687278,0.06345348987}, /*cmx*/
          {4.92647517,-0.03800258313,3.615483573,0.02789332042}, /*cfx*/
          {0.0887744734,-0.0001242872792,4.829800322,0.02814244772,-0.0001985014061,0.03962328187}, /*cmy*/
          {0.814964838,0.3137408588,0.9502628224,2.291387376}, /*cfy*/
          {0.1926608412,4.238545536e-05,8.594555177,0.08379729955,0.0003983163638,0.06360757887}, /*cmz*/
          {0.0648228534,4.730319309,1.993162829,1.403137787} /*cfz*/
     },
     {
          2462149.5,
          {0.01262907443,0.001119982739,8.292861667,-0.04634707359,-0.0007439844528,0.061273578}, /*cmx*/
          {3.288821569,4.601346717,1.45473075,3.086134682}, /*cfx*/
          {0.08387224824,-0.0007889940008,5.622884263,0.01563007649,-0.0002883586706,0.04270174039}, /*cmy*/
          {5.644477298,4.534157055,4.557808197,5.481162348}, /*cfy*/
          {0.1970665635,1.121234369e-05,8.698407126,0.05097517823,0.0008405141633,0.06557876449}, /*cmz*/
          {4.643902818,3.101809549,-0.05738229853,4.438899282} /*cfz*/
     },
     {
          2462199.5,
          {0.07792285759,0.002026350053,8.193227204,0.05388226531,0.0002035834477,0.063936895}, /*cmx*/
          {1.900015937,3.295718829,-0.137525162,0.1880466598}, /*cfx*/
          {0.03964596832,-0.001208191337,5.660144278,-0.02282495946,0.0002191779235,0.04042277246}, /*cmy*/
          {4.303686177,3.330756204,2.853461336,2.510039032}, /*cfy*/
          {0.2017811813,-0.001494711616,8.779589557,-0.06214751483,-0.0002635378127,0.06556798579}, /*cmz*/
          {3.257450021,1.783012146,4.418657171,1.567023779} /*cfz*/
     },
     {
          2462249.5,
          {0.1788587567,0.0003313040529,8.690955074,0.01125727168,0.0007443357443,0.06508402873}, /*cmx*/
          {0.8230913018,1.739435104,5.230323876,3.455311373}, /*cfx*/
          {-0.01927118218,-0.0007149585061,5.111582368,0.005986410526,0.0002890226416,0.03929511235}, /*cmy*/
          {3.053557149,1.440969307,2.074159472,5.657895057}, /*cfy*/
          {0.1163029908,-0.0008745693708,8.576282356,-0.01119138637,-0.0008836374738,0.06355492389}, /*cmz*/
          {2.217859132,0.6878559561,3.683750469,4.840047141} /*cfz*/
     },
     {
          2462299.5,
          {0.1925725912,-0.0003016207831,8.551603682,0.06226675655,0.0004983341864,0.06066255334}, /*cmx*/
          {5.630847082,-2.329147415,2.892411637,0.03880316774}, /*cfx*/
          {-0.05566212307,-0.0004529161766,5.539463413,-0.03571645989,-0.0003264437226,0.04402472005}, /*cmy*/
          {1.567115527,-2.542352056,8.549692631,2.30593449}, /*cfy*/
          {0.0756424553,0.0003193687166,8.441053597,0.0763224823,-0.0005081010097,0.06206392385}, /*cmz*/
          {0.7048181011,-0.8289406468,1.165143966,1.350560468} /*cfz*/
     },
     {
          2462349.5,
          {0.1768357161,-0.0005036656219,7.905399369,0.09884211888,0.0006557305855,0.05504124145}, /*cmx*/
          {3.840806616,2.150091134,0.7540200156,2.631960658}, /*cfx*/
          {-0.07846191956,-1.705636619e-05,6.233036249,-0.05478081352,-0.0004853220469,0.04595135434}, /*cmy*/
          {-0.07755446683,1.645619094,-0.3330994444,5.12925359}, /*cfy*/
          {0.09359140877,0.0007234553362,8.604595829,0.1090582621,-0.0006628930656,0.06436825482}, /*cmz*/
          {5.135828483,3.653354748,5.069627724,3.947825525} /*cfz*/
     },
     {
          2462399.5,
          {0.1516047281,-0.0005887331286,7.538302865,0.1338153841,0.0008498702687,0.05618279424}, /*cmx*/
          {1.800744537,0.268086389,4.751476023,5.011143361}, /*cfx*/
          {-0.07794265971,0.0002270329792,5.997631053,-0.06017338919,-0.0007273898225,0.03840716298}, /*cmy*/
          {4.476197844,-0.7133350757,3.302387231,1.698198168}, /*cfy*/
          {0.1309760422,0.0006497354702,9.119584391,0.1203640594,-0.0008599011588,0.06756741099}, /*cmz*/
          {3.193933601,1.714556823,2.982246867,0.2397966112} /*cfz*/
     },
     {
          2462449.5,
          {0.1217443263,-0.000608667296,8.46731292,0.1412310364,0.001053274901,0.06496645209}, /*cmx*/
          {-0.3499572908,4.535474906,2.388502572,1.169665304}, /*cfx*/
          {-0.06529292002,-1.621080607e-06,4.104113773,0.0601302174,0.0007152467972,0.02432847303}, /*cmy*/
          {2.899896092,-31.86832974,-2.607490004,5.028032201}, /*cfy*/
          {0.1636382922,0.0003642464444,9.368873931,0.1269148917,-0.0009657663332,0.06608250992}, /*cmz*/
          {1.242081504,-0.3607171358,0.9452438297,2.797974141} /*cfz*/
     },
     {
          2462499.5,
          {0.09205133506,-0.0006776204111,9.380032632,0.1175048101,0.0008971682408,0.06674564574}, /*cmx*/
          {3.929574,2.353912129,0.3551096772,3.763386629}, /*cfx*/
          {-0.06621421988,-0.0002758362819,3.039792106,0.06070283976,-0.0007216562296,0.03131411425}, /*cmy*/
          {2.21167379,3.085975553,-14.89518253,2.451760931}, /*cfy*/
          {0.1812873324,0.0001571763022,8.879335034,0.1388354085,-0.0009272716245,0.06078999525}, /*cmz*/
          {5.518703629,3.818705945,5.113362563,-1.023213602} /*cfz*/
     },
     {
          2462549.5,
          {0.05906541873,-0.0009991877454,8.840917864,0.1128461336,0.0007280257906,0.05924392119}, /*cmx*/
          {2.015091789,0.2293131416,4.785569848,0.06625077998}, /*cfx*/
          {-0.08115716636,-0.0002277671443,5.275436146,0.05618726569,-0.0006306604564,0.04417046404}, /*cmy*/
          {0.9968961632,-6.001303729,1.387437477,5.447830793}, /*cfy*/
          {0.1889953466,7.241316661e-05,8.3676124,0.1435295414,-0.0008734759874,0.06024615794}, /*cmz*/
          {3.405588166,1.796686281,2.936238448,1.361429705} /*cfz*/
     },
     {
          2462599.5,
          {0.008393827097,-0.001392254348,7.67576724,0.1260163779,0.0006944123623,0.05279302159}, /*cmx*/
          {0.01002651709,4.559674769,2.807760456,2.490005152}, /*cfx*/
          {-0.09438767125,0.0002628161229,6.419217309,0.06264511475,0.0006022367633,0.04580026423}, /*cmy*/
          {5.574329276,4.015467783,-4.498187278,1.982118697}, /*cfy*/
          {0.1931399838,-7.03261003e-05,8.724243303,0.1313062027,-0.000833271345,0.06526548773}, /*cmz*/
          {1.297724409,-0.1929451106,0.8718542389,3.844462571} /*cfz*/
     },
     {
          2462649.5,
          {-0.0637168212,-0.001273222868,7.540037892,0.1332967423,0.0007578912902,0.05813457162}, /*cmx*/
          {4.132026714,2.662331535,0.5527100825,4.879384247}, /*cfx*/
          {-0.08119593699,0.001081909266,5.744374936,0.05244195588,0.0006232616589,0.03563506762}, /*cmy*/
          {3.855101335,1.460699024,-0.739981558,4.939917888}, /*cfy*/
          {0.1898751662,-0.0003406767407,9.302217745,0.1148778242,-0.0007417149053,0.06815930291}, /*cmz*/
          {5.601782846,4.06749459,5.215703263,0.1763590482} /*cfz*/
     },
     {
          2462699.5,
          {-0.1282708633,-0.0005621087639,8.731401516,0.111227003,0.0007301892787,0.06713248282}, /*cmx*/
          {2.080619149,0.6963542116,4.760170675,1.219270109}, /*cfx*/
          {-0.0245373554,0.001465888614,3.686756412,-0.05140529994,-0.0004623316444,0.02383300637}, /*cmy*/
          {2.457781221,-4.399503084,6.057773928,2.169505561}, /*cfy*/
          {0.1725422104,-0.0006140865633,9.295296204,0.1071090392,-0.0006141918815,0.06628132338}, /*cmz*/
          {3.705860571,2.050754405,3.30863651,2.844873455} /*cfz*/
     },
     {
          2462749.5,
          {-0.1549350542,1.057542458e-05,9.385451488,0.0861903655,0.0005171487447,0.06833237659}, /*cmx*/
          {0.2382565641,4.926689456,2.91571077,4.010928671}, /*cfx*/
          {0.05046077488,0.001140328534,3.168935282,-0.04552877796,-0.0004094995843,0.03032287488}, /*cmy*/
          {1.763589266,-0.4873747507,3.525424979,5.877201472}, /*cfy*/
          {0.1411389205,-0.000715037258,8.82648256,0.1050013381,-0.000497472172,0.06306656194}, /*cmz*/
          {1.815524423,0.127803087,1.367262657,-0.7689315115} /*cfz*/
     },
     {
          2462799.5,
          {-0.153081968,0.0001325706841,8.958734648,0.0783605865,0.0003402962492,0.06305456824}, /*cmx*/
          {4.767380759,2.971261136,1.154787771,0.566819614}, /*cfx*/
          {0.1075697169,0.0005732562164,4.834016574,-0.03516898175,-0.000323155786,0.04103971083}, /*cmy*/
          {0.5999297273,3.373207463,1.263197076,2.797958605}, /*cfy*/
          {0.1044564508,-0.0005716163643,8.505986926,0.09971677883,-0.0004201699292,0.06267162878}, /*cmz*/
          {-0.08972660146,4.586477053,-0.6288364313,1.924103829} /*cfz*/
     },
     {
          2462849.5,
          {-0.146240296,1.233549326e-05,8.10535283,0.07807333172,0.0002487514007,0.05727243527}, /*cmx*/
          {3.005908404,1.196955559,5.279731205,3.389045025}, /*cfx*/
          {0.1357157578,8.8711616e-05,5.946078641,-0.03231874685,-0.0002234155219,0.04547795839}, /*cmy*/
          {5.370715084,1.000325433,5.08363509,-0.4216455067}, /*cfy*/
          {0.07507209455,-0.0001829155564,8.665016012,0.08696542936,-0.0003741501672,0.06523179786}, /*cmz*/
          {4.331610169,2.810072496,3.534857267,4.714933435} /*cfz*/
     },
     {
          2462899.5,
          {-0.1479547072,0.0001652941903,7.572966359,0.06922856316,0.0005540026578,0.05578971568}, /*cmx*/
          {1.230840752,5.821461067,2.739133765,-0.01155279994}, /*cfx*/
          {0.1393149952,-0.0001937968764,6.125012176,-0.02522530975,0.0001964788463,0.04472127693}, /*cmy*/
          {3.821893095,5.112488266,36.72623085,2.675906419}, /*cfy*/
          {0.06403592364,0.0005905603668,9.030731196,0.06518733194,-0.0005331162502,0.06797057662}, /*cmz*/
          {2.590163158,1.058577543,1.158339975,1.384962885} /*cfz*/
     },
     {
          2462949.5,
          {-0.1458664243,0.001731785112,7.524178731,0.003225651367,0.0007481569856,0.05676031548}, /*cmx*/
          {5.910706437,-6.314808154,1.354787553,3.225830256}, /*cfx*/
          {0.1310605816,-0.0004249446793,5.862390237,-0.003040334755,0.0002237406609,0.04475851922}, /*cmy*/
          {2.372314898,4.311449605,3.551256853,-0.3820598974}, /*cfy*/
          {0.09624589482,0.001612644174,9.180784502,0.002518783462,-0.0006575054679,0.06853414545}, /*cmz*/
          {1.050834435,7.316088669,6.05139438,4.623076452} /*cfz*/
     },
     {
          2462999.5,
          {-0.04264967594,0.001669706982,7.608167959,-0.061627452,-0.001071462975,0.05759250737}, /*cmx*/
          {4.825537389,34.63243474,0.09632451815,0.4001855663}, /*cfx*/
          {0.1063232322,-0.0007960052355,6.126563069,0.01580290604,-0.0004260026963,0.04643775022}, /*cmy*/
          {1.103823861,2.326656979,2.54665192,2.880234399}, /*cfy*/
          {0.1813383161,0.0004114587943,8.980815524,-0.05477004972,0.00103661346,0.06613784945}, /*cmz*/
          {6.175669237,23.67548833,4.76633171,1.721799382} /*cfz*/
     },
     {
          2463049.5,
          {0.03748967209,-0.0002444680758,7.667640546,0.05017105146,-0.0006746236661,0.05529021221}, /*cmx*/
          {3.556975157,2.026402624,4.396744855,3.340199913}, /*cfx*/
          {0.06703667977,-0.000405932429,6.251607871,-0.03221635629,-0.0003286464835,0.04541931049}, /*cmy*/
          {6.015828599,1.415617256,0.002294066887,-0.4017606178}, /*cfy*/
          {0.1980691965,0.0001575942159,8.768569931,0.05492396493,0.0005702023641,0.06527803901}, /*cmz*/
          {4.86752127,3.458701602,2.613203692,4.676137501} /*cfz*/
     },
     {
          2463099.5,
          {0.02243709933,-0.001137025524,7.588388967,0.1135946196,-0.0007469573624,0.0563187639}, /*cmx*/
          {1.723497698,0.2214246004,1.783634858,-0.4236724898}, /*cfx*/
          {0.04928553776,-0.0005764494787,5.92731965,-0.05394792417,-0.0006051233281,0.0383289254}, /*cmy*/
          {4.387457987,-0.7510892289,-9.19862717,2.480651484}, /*cfy*/
          {0.2072950255,6.148084603e-05,9.098211061,0.1034699076,0.0007207300483,0.06726098965}, /*cmz*/
          {3.117077391,1.6565713,-0.02532768021,1.068203326} /*cfz*/
     },
     {
          2463149.5,
          {-0.03789953763,-0.00106398205,8.382371352,0.137362302,-0.0009913827522,0.06403799862}, /*cmx*/
          {-0.3512409918,4.529086913,-0.6864741938,2.036680397}, /*cfx*/
          {0.02051566139,-0.001244481054,4.244977955,0.05764694314,-0.0007025797662,0.02408263657}, /*cmy*/
          {2.781914055,-0.3398793059,0.6413972536,5.699996826}, /*cfy*/
          {0.2113488971,-0.0004138850394,9.374679824,0.1215912273,0.0009165159023,0.06664238317}, /*cmz*/
          {1.218252439,-0.3536990658,4.12129808,3.65492849} /*cfz*/
     },
     {
          2463199.5,
          {-0.09074639034,-0.0004778315784,9.33832146,0.1208800547,-0.0009110953782,0.06700457982}, /*cmx*/
          {3.921035474,2.380127715,3.493070678,4.61134368}, /*cfx*/
          {-0.04499177097,-0.001302606638,2.69345482,-0.06010147913,0.0007104471422,0.02750529384}, /*cmy*/
          {1.983207726,0.02760734013,-11.64807372,3.189502548}, /*cfy*/
          {0.1898164645,-0.000904502476,9.034056,0.1353048002,0.0009375712453,0.06181168571}, /*cmz*/
          {5.522895239,3.836874496,2.007238079,-0.1385941524} /*cfz*/
     },
     {
          2463249.5,
          {-0.1128083566,-0.0002858313862,9.03861625,0.1127245115,-0.0007516794056,0.06096189985}, /*cmx*/
          {2.000052235,0.2532862611,1.608172368,0.9169920909}, /*cfx*/
          {-0.1112671983,-0.0006633838515,4.78599577,0.05649960853,0.0006517350551,0.04153215773}, /*cmy*/
          {0.9203545757,-56.16238218,4.628300688,-0.05041384469}, /*cfy*/
          {0.1431424627,-0.001028404873,8.448133526,0.1431062834,0.0008845193603,0.05939097263}, /*cmz*/
          {3.43706842,1.794986074,-0.1612246888,2.249088811} /*cfz*/
     },
     {
          2463299.5,
          {-0.1263184671,-0.0005265520796,7.957110445,0.122426187,-0.0007175394297,0.05342302655}, /*cmx*/
          {0.02640180737,4.552060514,-0.3072177203,3.37361343}, /*cfx*/
          {-0.1446106015,0.0001205173014,6.272331615,0.06412473863,-0.0005877597655,0.04577918632}, /*cmy*/
          {5.510997903,4.096317636,-1.207686616,2.74170522}, /*cfy*/
          {0.09122980873,-0.0008244397988,8.573901461,0.1353927489,0.0008429907597,0.06319295526}, /*cmz*/
          {1.315479679,-0.1983756825,4.02223505,4.684484013} /*cfz*/
     },
     {
          2463349.5,
          {-0.1538317924,-0.0007059573824,7.462563512,0.1342970265,-0.0007523663621,0.05531399872}, /*cmx*/
          {4.177110912,2.634646664,3.773209408,-0.5562595863}, /*cfx*/
          {-0.1380683354,0.0008647974569,6.034859297,0.05628912393,-0.0006456954779,0.03838152955}, /*cmy*/
          {3.755462151,1.637473404,2.490441003,-0.674620744}, /*cfy*/
          {0.05038391389,-0.0006203195771,9.179641553,0.1193997662,0.0007772777219,0.06698259817}, /*cmz*/
          {5.583421719,4.076271359,2.053800451,0.9697831253} /*cfz*/
     },
     {
          2463399.5,
          {-0.1906790397,-0.0004104615149,8.41109877,0.1208176019,-0.0007738031392,0.06436477214}, /*cmx*/
          {2.068100954,0.6849163726,1.614170497,1.97616112}, /*cfx*/
          {-0.09316355424,0.001286297756,4.223697872,-0.04964289691,-0.0005090095605,0.02537674201}, /*cmy*/
          {2.21915904,-4.270887747,-0.0605649239,2.63008326}, /*cfy*/
          {0.02015190152,-0.0006216926431,9.364030133,0.1092883229,0.0006752581643,0.06617085486}, /*cmz*/
          {3.669509339,2.04752003,0.1533260917,3.610258985} /*cfz*/
     },
     {
          2463449.5,
          {-0.21111722,0.0001046286771,9.326943528,0.0938776171,-0.0006085025447,0.0679406981}, /*cmx*/
          {0.1682486282,4.929047519,-0.2762122978,4.706228958}, /*cfx*/
          {-0.0271829502,0.001151705285,2.994160243,-0.04878238423,-0.0004399549995,0.0276989913}, /*cmy*/
          {1.392427562,-0.4636479288,3.593722655,6.39015845}, /*cfy*/
          {-0.01077390384,-0.000757094379,8.948533902,0.1080015798,0.0005669179092,0.06259351933}, /*cmz*/
          {1.775357506,0.07900339984,4.528859972,-0.03280358813} /*cfz*/
     },
     {
          2463499.5,
          {-0.2051213859,0.000462824566,9.1371105,0.08284626734,-0.000442021862,0.063755234}, /*cmx*/
          {4.66971928,2.9153925,4.310686765,1.222841894}, /*cfx*/
          {0.03090407934,0.0006998799574,4.535695114,-0.0397516979,-0.0003996665701,0.03976144538}, /*cmy*/
          {0.3926768446,3.404548825,1.28683216,3.368067604}, /*cfy*/
          {-0.04924607599,-0.0008289912045,8.474898236,0.1076134146,0.000497245178,0.06114662192}, /*cmz*/
          {-0.1525399163,4.495511841,2.58326046,2.595534096} /*cfz*/
     },
     {
          2463549.5,
          {-0.1810467057,0.0005616237129,8.226000975,0.08677858642,-0.0003625158567,0.05673723104}, /*cmx*/
          {2.881147751,1.066920876,2.64125283,3.977678163}, /*cfx*/
          {0.06538545719,0.0002628882569,5.959741151,-0.03888975992,-0.0003380253031,0.04610703007}, /*cmy*/
          {5.180784892,0.9486149588,5.225249518,0.1161232355}, /*cfy*/
          {-0.09134821998,-0.000698308706,8.525047477,0.1016540389,0.0004750084955,0.06384758106}, /*cmz*/
          {4.198704875,2.684601161,0.6557195648,5.279329372} /*cfz*/
     },
     {
          2463599.5,
          {-0.1521258955,0.0003981760201,7.463055221,0.09529575884,-0.000341171231,0.05426278263}, /*cmx*/
          {0.9935263936,5.622776088,0.6238612144,0.3580834384}, /*cfx*/
          {0.07784534377,2.040440304e-05,6.272953567,-0.0388006479,-0.0003442662082,0.04414693483}, /*cmy*/
          {3.574985115,4.944477891,2.802019895,3.131891966}, /*cfy*/
          {-0.1266759089,-0.0003983484047,8.997314998,0.09059402818,0.0004433818449,0.06756595568}, /*cmz*/
          {2.337482999,0.8597550646,5.063409624,1.782740857} /*cfz*/
     },
     {
          2463649.5,
          {-0.1315442666,1.873541533e-06,7.690372255,0.09199879758,-0.0004055057422,0.05938149763}, /*cmx*/
          {5.339384594,3.903550833,4.548454252,3.079877438}, /*cfx*/
          {0.07865965414,-7.487728026e-05,5.449467241,-0.03418593902,-0.0002389991738,0.03525627287}, /*cmy*/
          {2.008733901,2.54172508,0.4500912474,-0.03092587602}, /*cfy*/
          {-0.1467901779,-2.801276264e-05,9.350838577,0.0791893431,0.0003546161539,0.06906564126}, /*cmz*/
          {0.5643740617,5.27933248,2.961072199,4.655468623} /*cfz*/
     },
     {
          2463699.5,
          {-0.1305259751,-0.0006298702095,8.528082173,0.06525875631,-0.0006845244898,0.06516291233}, /*cmx*/
          {3.551756107,2.147104433,2.182708271,-0.2554962167}, /*cfx*/
          {0.0743362475,-0.0001124890323,4.002355682,-0.03000421336,-0.0003089017096,0.02603643229}, /*cmy*/
          {0.607529557,0.3776768246,34.5808388,3.219071302}, /*cfy*/
          {-0.1507417227,0.0006552510389,9.364291911,0.0629987497,0.0006110197107,0.0692678292}, /*cmz*/
          {5.158607133,3.482377919,0.3577571786,1.358207131} /*cfz*/
     },
     {
          2463749.5,
          {-0.1696708654,-0.0005474422011,8.886801457,-0.02895673589,-0.000207217223,0.06542991767}, /*cmx*/
          {2.044378435,0.6527287467,1.242663689,3.027719388}, /*cfx*/
          {0.0666563792,0.0004598768736,3.158817596,0.0246269548,-0.0002050784658,0.02597084264}, /*cmy*/
          {5.545541012,4.282266208,2.962124935,-0.004407942022}, /*cfy*/
          {-0.1179642449,0.002263659891,9.316681515,-0.02290469267,0.0001737271317,0.07027500707}, /*cmz*/
          {3.653158987,1.946786531,5.745334055,4.610027408} /*cfz*/
     },
     {
          2463799.5,
          {-0.1889796159,-1.555233085e-05,8.449232063,-0.01470728676,-0.001032271197,0.06300355675}, /*cmx*/
          {0.9229399865,5.6590153,8.842056157,0.000679728142}, /*cfx*/
          {0.0960935632,-0.000391881705,4.023578266,0.01173686772,-0.0004771752374,0.02895095392}, /*cmy*/
          {4.003316801,3.4697733,3.765696034,3.132198732}, /*cfy*/
          {0.005183434198,0.001077291239,9.351322715,-0.01216997213,0.0009092677912,0.06934234846}, /*cmz*/
          {2.481682737,0.6069617833,7.065323951,1.568496569} /*cfz*/
     },
     {
          2463849.5,
          {-0.1927188606,-0.0003460411732,8.731304718,0.09001936517,-0.0006411967609,0.06594810751}, /*cmx*/
          {5.67784787,4.321735991,12.14684881,2.786950105}, /*cfx*/
          {0.07348092478,-0.001288665978,3.42302648,-0.04073490889,0.0004486298805,0.02054551178}, /*cmy*/
          {2.676297751,2.41809745,16.27153285,0.2760121288}, /*cfy*/
          {0.05553983328,-0.000313603924,9.344002649,0.08103581001,-0.0006703404033,0.06708105367}, /*cmz*/
          {0.9834311545,5.732245007,1.26640158,4.396283213} /*cfz*/
     },
     {
          2463899.5,
          {-0.2110332096,6.342588473e-05,9.350343557,0.1072094793,-0.0007575756362,0.06739386503}, /*cmx*/
          {3.833549909,2.295288829,3.53076,-0.844208993}, /*cfx*/
          {0.005904177305,-0.001218080492,2.506870131,-0.05336325729,-0.0006111665666,0.02582896739}, /*cmy*/
          {1.960605526,-0.07092150343,-2.246884296,4.036494795}, /*cfy*/
          {0.03812269373,-0.0009639412492,9.058333036,0.1190647527,-0.000804204654,0.06283853605}, /*cmz*/
          {5.426768529,3.765280675,5.19958308,0.691658584} /*cfz*/
     },
     {
          2463949.5,
          {-0.2070556341,0.0004366268871,9.087892824,0.1077791595,-0.0007025837112,0.06236360749}, /*cmx*/
          {1.956686578,0.2364517189,1.605096401,1.766929766}, /*cfx*/
          {-0.05561276408,-0.0005748485972,4.505993894,-0.05401173812,-0.0006164281717,0.03983358142}, /*cmy*/
          {0.8720172327,3.529512192,1.528729632,0.7839522734}, /*cfy*/
          {-0.01145394479,-0.001170117228,8.540109941,0.1347203786,-0.0008288953787,0.0601842563}, /*cmz*/
          {3.412394361,1.768557806,3.022972975,3.127572531} /*cfz*/
     },
     {
          2463999.5,
          {-0.1844109845,0.000551597182,8.147931377,0.1171443427,-0.0007069121661,0.05529169247}, /*cmx*/
          {0.01718101403,4.551330835,-0.2926797756,4.25775975}, /*cfx*/
          {-0.08344825369,-1.255515335e-05,6.069531057,-0.06341440122,-0.0005639216905,0.04560643161}, /*cmy*/
          {5.469229078,0.9991430073,-1.078749238,3.556447083}, /*cfy*/
          {-0.07097612778,-0.0009812627499,8.532649014,0.1335101947,-0.0008144569485,0.06291550374}, /*cmz*/
          {1.324411038,-0.211054971,0.9186077947,-0.7235489477} /*cfz*/
     },
     {
          2464049.5,
          {-0.1563051852,0.0004617630897,7.530516937,0.1308502199,-0.0007447541366,0.05502290049}, /*cmx*/
          {4.214698126,2.62563442,3.864705394,0.3380859939}, /*cfx*/
          {-0.08275007027,0.0001880685034,6.124486303,-0.06007000006,-0.0006270367554,0.04051748128}, /*cmy*/
          {3.692399713,4.903831325,2.592247273,0.07362914678}, /*cfy*/
          {-0.1204054321,-0.0005947348639,9.060111705,0.1218704498,-0.0007762349137,0.06701271168}, /*cmz*/
          {5.582170895,4.082654756,5.204339687,1.813177744} /*cfz*/
     },
     {
          2464099.5,
          {-0.1331485427,0.00027115652,8.176010373,0.1264886284,-0.0007826528259,0.06291809219}, /*cmx*/
          {2.089394783,0.6787757289,1.661041009,2.806875454}, /*cfx*/
          {-0.07311109099,0.0001437827585,4.629876654,0.04843663334,-0.0005515930555,0.02752996311}, /*cmy*/
          {2.054666649,-0.9219942112,0.08755064071,3.195945525}, /*cfy*/
          {-0.1494409258,-0.0002745227822,9.3812999,0.1114292401,-0.0007100985562,0.06733264287}, /*cmz*/
          {3.651876482,2.067795151,3.287494619,4.428847836} /*cfz*/
     },
     {
          2464149.5,
          {-0.1203806659,0.0002062839031,9.193275512,0.10234299,-0.0006699721821,0.06804601174}, /*cmx*/
          {0.1354442807,4.945924735,-0.3083904917,-0.8113913802}, /*cfx*/
          {-0.06611742203,0.0001066391373,2.913552838,0.04870452563,-0.0004554338522,0.02481381135}, /*cmy*/
          {1.01875919,2.74615654,10.01429412,0.6398792774}, /*cfy*/
          {-0.1623889339,-0.0001772209005,9.113055452,0.1089679997,-0.00062465546,0.06383085723}, /*cmz*/
          {1.756841852,0.07376037892,1.393847102,0.7707618664} /*cfz*/
     },
     {
          2464199.5,
          {-0.1109972996,0.0004024803328,9.292228586,0.08701545878,-0.0005165017515,0.06547790915}, /*cmx*/
          {4.60467904,2.91544507,4.23319722,1.948204458}, /*cfx*/
          {-0.06067919016,9.477451492e-05,4.022050191,0.04318236195,-0.0004369596471,0.03700333128}, /*cmy*/
          {6.472002671,0.3192776912,1.333022662,3.990682451}, /*cfy*/
          {-0.170952418,-0.0002633977735,8.563987351,0.1110323799,-0.0005547288822,0.06083842417}, /*cmz*/
          {-0.1689714507,4.445455782,-0.5311702349,3.364189094} /*cfz*/
     },
     {
          2464249.5,
          {-0.09120771616,0.000799900481,8.50351528,0.08904219417,-0.0004538352236,0.0582259134}, /*cmx*/
          {2.810555225,0.999931279,2.615525539,4.680216639}, /*cfx*/
          {-0.05626994752,9.522318221e-05,5.735110367,0.04232118859,-0.0003977596908,0.04577160668}, /*cmy*/
          {5.026891846,4.127471581,-0.9933972447,0.7251376031}, /*cfy*/
          {-0.1845304522,-0.0003298929981,8.401078661,0.1101033706,-0.0005419092623,0.06239786133}, /*cmz*/
          {4.149739346,2.603876104,3.805448892,-0.3135787596} /*cfz*/
     },
     {
          2464299.5,
          {-0.05058391215,0.00117121062,7.54401483,0.1033401664,-0.0004655442058,0.05363272276}, /*cmx*/
          {0.9130367953,5.495591859,0.7763924001,0.9933585789}, /*cfx*/
          {-0.0526070463,0.0003054690422,6.383416773,0.04591319426,-0.0004474932925,0.04562076269}, /*cmy*/
          {3.403030334,1.790558123,2.776708608,3.687784801}, /*cfy*/
          {-0.2018492644,-0.0001968340667,8.841402807,0.1033564165,-0.0005742441067,0.06680890249}, /*cmz*/
          {2.220240275,0.7592265705,1.932033167,2.378078333} /*cfz*/
     },
     {
          2464349.5,
          {0.009931425465,0.001125542113,7.564666139,0.1149520803,-0.0005805670293,0.05921666333}, /*cmx*/
          {5.161016318,3.729391943,4.851365887,3.554720979}, /*cfx*/
          {-0.03787320307,0.0008235732618,5.650919946,0.04356527178,-0.0005107049061,0.03549173354}, /*cmy*/
          {1.787101822,-0.7096149268,0.4165843806,0.4942981421}, /*cfy*/
          {-0.2120418649,0.0001295250032,9.319316396,0.09683255171,-0.000586161387,0.06893757466}, /*cmz*/
          {0.3654948451,5.125205142,0.1278165735,5.141191192} /*cfz*/
     },
     {
          2464399.5,
          {0.06722403882,0.0005802659542,8.728637772,0.1023540783,-0.0006614581217,0.06767622557}, /*cmx*/
          {3.19481982,1.837777416,2.817867223,-0.005025584075}, /*cfx*/
          {0.005143132286,0.001129591057,3.691154332,0.05131262955,-0.000404274153,0.02340971358}, /*cmy*/
          {0.4398501367,3.009352637,4.083853758,4.076555463}, /*cfy*/
          {-0.2051168021,0.0004346398395,9.288330903,0.09858713202,-0.0005353094273,0.06689764434}, /*cmz*/
          {4.821206453,3.171051122,4.53929477,1.618178667} /*cfz*/
     },
     {
          2464449.5,
          {0.09543600835,5.075273746e-05,9.38999822,0.08429987723,-0.000476678204,0.06863575714}, /*cmx*/
          {1.384658616,-0.222962125,0.8186324781,2.830433094}, /*cfx*/
          {0.06355828057,0.0008093771057,3.034900243,0.04470244692,-0.0003583879103,0.02848587189}, /*cmy*/
          {6.050002232,0.7487286044,1.450037708,1.576849613}, /*cfy*/
          {-0.1817248403,0.0004273940949,8.8788132,0.1029814272,-0.0004391338736,0.0641678234}, /*cmz*/
          {2.961719132,1.277829564,2.309091994,4.339826437} /*cfz*/
     },
     {
          2464499.5,
          {0.09959806821,-0.0005014203839,9.01594441,0.07496785996,0.0005427213303,0.0648902478}, /*cmx*/
          {-0.3457340701,4.093215563,-5.183781448,-0.5499248576}, /*cfx*/
          {0.1050224318,8.39094035e-05,4.4648024,0.02634786259,-0.0002612214311,0.036803821}, /*cmy*/
          {4.949006766,4.663096243,17.36454165,4.863841055}, /*cfy*/
          {-0.1579636456,-0.0001934057448,8.689398338,0.09025248047,-0.0007000952295,0.06485800932}, /*cmz*/
          {1.102951697,5.750494605,-0.4371935215,0.8599303521} /*cfz*/
     },
     {
          2464549.5,
          {0.07705280166,-0.002053750271,8.485935318,-0.002035690475,0.0004654259485,0.06506961254}, /*cmx*/
          {4.338092498,38.51974133,5.765266024,2.613324878}, /*cfx*/
          {0.1076453552,-0.000751372368,5.113867249,-0.008911185344,-0.0001202912561,0.03693248693}, /*cmy*/
          {3.568055013,2.685988386,4.422812203,1.823635141}, /*cfy*/
          {-0.174157193,-0.0005985582537,8.797569307,-0.005551769245,-0.0004983912551,0.06651169125}, /*cmz*/
          {5.737044664,3.35369363,4.439643732,4.027435196} /*cfz*/
     },
     {
          2464599.5,
          {-0.03790248904,-0.001226057475,8.780452109,0.02267798486,-0.000853758902,0.06594034003}, /*cmx*/
          {3.131192365,16.90481997,4.459724246,5.875505444}, /*cfx*/
          {0.06779202414,-0.0003561770807,4.64884467,0.007777265656,-0.0003133184813,0.03581312623}, /*cmy*/
          {2.262724982,0.436389434,-26.7638933,4.944726455}, /*cfy*/
          {-0.1995287422,0.0003072680245,8.751146969,0.02424181816,0.001014837036,0.0645053189}, /*cmz*/
          {4.560505974,6.227807106,2.91976399,1.012433271} /*cfz*/
     },
     {
          2464649.5,
          {-0.09534201671,0.0001421809247,8.706065314,-0.06329969926,-0.0005065905798,0.06148087321}, /*cmx*/
          {1.695284305,3.168476541,2.09011453,2.470308564}, /*cfx*/
          {0.05084644841,-0.0001470079891,5.162502519,-0.03758267257,0.0003597269344,0.04177470548}, /*cmy*/
          {0.7613860099,9.344904706,4.645682135,1.575269359}, /*cfy*/
          {-0.1834521667,-0.0001113318754,8.521568442,-0.07894924079,0.0005332674525,0.0617465577}, /*cmz*/
          {3.086895277,4.666319384,0.3691841137,3.80918323} /*cfz*/
     },
     {
          2464699.5,
          {-0.08692159111,0.0007729396919,8.069974161,-0.09879510843,-0.0005935955959,0.05578850353}, /*cmx*/
          {-0.09141134329,1.341651923,-0.1783749433,5.064337139}, /*cfx*/
          {0.04419413948,-0.0001034904191,6.072303888,-0.05536807774,0.000455449304,0.04535743873}, /*cmy*/
          {5.388209059,0.894092289,2.10977899,4.365061889}, /*cfy*/
          {-0.1902406893,-0.0002911780304,8.579623751,-0.1117735051,0.0006425064645,0.06332890937}, /*cmz*/
          {1.217481454,2.842638302,4.180696795,0.0891091313} /*cfz*/
     },
     {
          2464749.5,
          {-0.04704485695,0.001044608104,7.581572768,-0.1202539142,-0.0006880252284,0.0551288721}, /*cmx*/
          {4.193746503,-0.5364370511,3.957703979,1.202154702}, /*cfx*/
          {0.04034984328,-0.000387037558,6.111069059,-0.05891296066,0.0005544947,0.04120153079}, /*cmy*/
          {3.639553294,4.93243346,-0.4603773676,0.8610043972}, /*cfy*/
          {-0.2056829908,-0.0001651855138,9.01256224,-0.1151713081,0.0007030608301,0.0668501916}, /*cmz*/
          {5.552338572,0.9147779738,2.118314856,2.651150651} /*cfz*/
     },
     {
          2464799.5,
          {0.006956896269,0.0008382367766,8.06223836,-0.1251359199,-0.0007559716888,0.06190093659}, /*cmx*/
          {2.105904822,3.816115105,1.745398773,3.657181399}, /*cfx*/
          {0.02081431487,-0.0008823563731,4.857326302,-0.04864171441,0.0005539072149,0.02914502432}, /*cmy*/
          {1.957551371,2.404752164,3.344528178,3.861410778}, /*cfy*/
          {-0.2140905014,0.0001175596465,9.360977859,-0.110749654,0.0006970182208,0.06798035295}, /*cmz*/
          {3.63736793,5.220310735,0.1671871718,-1.023913158} /*cfz*/
     },
     {
          2464849.5,
          {0.04879009827,0.0003660373911,9.053534447,-0.1082506421,-0.000696601304,0.0678341921}, /*cmx*/
          {0.1278161688,1.817891021,-0.292076884,-0.007249725548}, /*cfx*/
          {-0.02495481207,-0.001062309315,2.958802324,-0.04643110244,0.0004679187032,0.02231841548}, /*cmy*/
          {0.7248559317,6.015269093,0.749887227,1.200042821}, /*cfy*/
          {-0.2079781534,0.0003908660074,9.237833316,-0.1089009738,0.0006548409608,0.06531897236}, /*cmz*/
          {1.746745208,3.233938634,4.545815997,1.595885172} /*cfz*/
     },
     {
          2464899.5,
          {0.06573247775,0.0001266705094,9.366180349,-0.09194403574,-0.0005646942389,0.0668825158}, /*cmx*/
          {4.566431229,-0.204980736,4.175888563,2.716035639}, /*cfx*/
          {-0.07905467406,-0.0008128414306,3.439046286,-0.04427052792,0.0004513060344,0.03311371141}, /*cmy*/
          {6.282455126,3.529054076,4.566791748,4.66134256}, /*cfy*/
          {-0.1878370573,0.0005246177763,8.735502113,-0.1116315315,0.0006031207683,0.06153976342}, /*cmz*/
          {-0.1676100621,1.293234885,2.636916656,4.182917164} /*cfz*/
     },
     {
          2464949.5,
          {0.07075936159,0.0003144016056,8.78565061,-0.09026346141,-0.0005105659762,0.06027919345}, /*cmx*/
          {2.763283986,4.128012541,2.531866292,-0.84613365}, /*cfx*/
          {-0.1201543643,-0.0003719154964,5.305030999,-0.04451032926,0.0004348962885,0.04376422589}, /*cmy*/
          {4.908814474,1.05594599,2.237240506,1.39874401}, /*cfy*/
          {-0.1612623063,0.000505322511,8.39144723,-0.1143625466,0.0005849871769,0.06114473775}, /*cmz*/
          {4.148210859,5.699732721,0.686288754,0.4627988408} /*cfz*/
     },
     {
          2464999.5,
          {0.08595935918,0.0008004612171,7.795494843,-0.1040678335,-0.000543644063,0.05368411001}, /*cmx*/
          {0.8834509437,2.283109142,0.7780892012,1.744988867}, /*cfx*/
          {-0.1394157804,0.0002122666204,6.318824473,-0.05046507088,0.0004732373259,0.04604769686}, /*cmy*/
          {3.277600455,4.978005332,-0.2934692844,4.314337174}, /*cfy*/
          {-0.1362571803,0.00046796813,8.664111504,-0.1119797754,0.0006327345298,0.0648737929}, /*cmz*/
          {2.175045022,3.840748571,5.032222523,3.078778686} /*cfz*/
     },
     {
          2465049.5,
          {0.127964913,0.001076037126,7.452238704,-0.1240224718,-0.0006564860686,0.05658653122}, /*cmx*/
          {5.1158473,0.4760824666,4.854783851,4.220050799}, /*cfx*/
          {-0.1294191358,0.001043366136,5.943654985,-0.04854324423,0.000618624867,0.03764558136}, /*cmy*/
          {1.613016952,2.520298379,3.511868705,1.035280974}, /*cfy*/
          {-0.113660306,0.0006107705421,9.226428901,-0.1064785634,0.0007026736054,0.06786427175}, /*cmz*/
          {0.2640216077,1.914719301,3.168533095,-0.511276093} /*cfz*/
     },
     {
          2465099.5,
          {0.1843281681,0.0005729928627,8.535570394,-0.1188185303,-0.0008290981291,0.06597093373}, /*cmx*/
          {3.05656936,4.846862941,2.687509385,0.5537692406}, /*cfx*/
          {-0.07473881757,0.00160634022,4.025770175,0.05606087158,0.0005415180612,0.02454632706}, /*cmy*/
          {0.170743841,-3.387593766,0.8668450208,4.538261206}, /*cfy*/
          {-0.08361830134,0.0009552905085,9.329380276,-0.1086273978,0.000718040893,0.06599355237}, /*cmz*/
          {4.673246292,-0.09824867324,1.297952374,2.185649144} /*cfz*/
     },
     {
          2465149.5,
          {0.21225263,-0.0002037832452,9.382521039,-0.09797134683,-0.0007049509823,0.06732116273}, /*cmx*/
          {1.165907262,2.728979809,0.8098014896,3.305834808}, /*cfx*/
          {0.008493661631,0.001241372357,3.17314234,0.05591703686,0.0005766899205,0.03118069683}, /*cmy*/
          {5.790103502,0.4612473648,-1.857623591,2.043186112}, /*cfy*/
          {-0.03487355091,0.001240254865,8.823139713,-0.1203937992,0.0006814190904,0.06187283518}, /*cmz*/
          {2.748880418,4.203457887,5.557318694,4.798180964} /*cfz*/
     },
     {
          2465199.5,
          {0.2002962305,-0.0005521016788,8.823059228,-0.09867301533,-0.0005201371244,0.06004457404}, /*cmx*/
          {5.618871965,0.6625537441,5.224138587,-0.2492638914}, /*cfx*/
          {0.07028264134,0.0004884968329,5.124460817,-0.04411473767,0.0004801244745,0.04289877056}, /*cmy*/
          {4.639393817,0.9405553319,1.990211803,5.186762999}, /*cfy*/
          {0.02872425971,0.001122832106,8.480833367,-0.1246414602,0.0006561306041,0.06210055742}, /*cmz*/
          {0.7348781011,2.288503516,3.382733818,1.075925132} /*cfz*/
     },
     {
          2465249.5,
          {0.1709730071,-0.0003790311104,7.752153804,-0.1057392832,-0.0004221831866,0.05424432752}, /*cmx*/
          {3.710347666,5.078894161,2.803596242,2.377367769}, /*cfx*/
          {0.09298257139,8.396022723e-05,6.194147017,-0.04408839549,-0.0003408736817,0.04539467554}, /*cmy*/
          {3.03659161,4.666108122,-3.892527561,1.87039356}, /*cfy*/
          {0.08629909076,0.0005298269352,8.8378021,-0.1094685916,0.0005812234459,0.0661972447}, /*cmz*/
          {5.030899404,0.3704562542,1.112774655,3.744141728} /*cfz*/
     },
     {
          2465299.5,
          {0.1512023435,0.0002401153328,7.472489872,-0.08641135193,-0.0009065323423,0.0561971872}, /*cmx*/
          {1.769777924,3.322523228,6.489838648,5.145550252}, /*cfx*/
          {0.09538057216,0.0002077154505,5.92649311,-0.03083082116,-0.0002603822042,0.04186538548}, /*cmy*/
          {1.422351553,2.332622322,5.424741759,4.909567006}, /*cfy*/
          {0.1159247471,-0.0006328332577,9.267754397,-0.07774642321,0.0007808877564,0.06923611658}, /*cmz*/
          {3.208399896,4.75796604,4.820482885,0.3495865401} /*cfz*/
     },
     {
          2465349.5,
          {0.1719442624,-0.0002053465955,7.68577896,0.03873427479,-0.0002412047332,0.05690836196}, /*cmx*/
          {0.1623977088,1.850854657,5.474918333,2.152657582}, /*cfx*/
          {0.1076784657,0.0006076695081,5.441334122,-0.01172295239,-0.0001205797416,0.04293768402}, /*cmy*/
          {-0.03977734863,-97.60567453,4.466487545,1.808373036}, /*cfy*/
          {0.08139104629,-0.002538244074,9.330130037,0.02806956739,0.0002189566832,0.06930142181}, /*cmz*/
          {1.666133104,3.294572166,3.909125082,3.601881268} /*cfz*/
     },
     {
          2465399.5,
          {0.1513812519,-0.0005064327432,7.495475196,0.02399644548,0.001010106701,0.05548651289}, /*cmx*/
          {5.434655297,0.6062147902,10.08436264,5.484177157}, /*cfx*/
          {0.13873883,-0.000139199758,6.048243586,-0.007571313974,0.0003896061327,0.04480222793}, /*cmy*/
          {4.946578011,1.629863298,-9.794936458,4.980743851}, /*cfy*/
          {-0.05325430184,-0.001129671973,9.079519959,0.01573226578,0.0008870968832,0.06696748429}, /*cmz*/
          {0.5340844833,2.207751346,5.266600349,0.5783552743} /*cfz*/
     },
     {
          2465449.5,
          {0.1275873108,0.0004092191563,7.552231603,-0.07637325028,0.0005236588508,0.05560871027}, /*cmx*/
          {3.941936172,5.609787719,1.294165015,1.952153212}, /*cfx*/
          {0.1315964245,-0.0006155069269,5.92866232,0.03828971268,0.0003298371801,0.04009568539}, /*cmy*/
          {3.481605384,-4.699291758,6.001316384,1.643117765}, /*cfy*/
          {-0.1055734107,-0.0001396902888,9.114102828,-0.07217060521,0.0004772630805,0.06710715697}, /*cmz*/
          {5.340733866,0.7470170604,2.609844478,3.417865457} /*cfz*/
     },
     {
          2465499.5,
          {0.1506599895,0.000633809267,8.056004576,-0.1087990904,0.0006299211328,0.06097668382}, /*cmx*/
          {2.043573933,3.772189167,5.035759757,4.504870618}, /*cfx*/
          {0.1007373541,-0.00113207467,4.855418576,0.04380444121,0.0004616559338,0.02932899433}, /*cmy*/
          {1.882318008,-0.710682362,3.425478769,4.633215807}, /*cfy*/
          {-0.1119342277,0.0002108235482,9.34872918,-0.09728027794,0.0005869526299,0.06755153223}, /*cmz*/
          {3.571445657,5.173575399,0.2876851449,-0.1871725802} /*cfz*/
     },
     {
          2465549.5,
          {0.183309633,0.0003040063549,8.963348667,-0.1065319173,0.0006679025153,0.06684687418}, /*cmx*/
          {0.1128787224,1.816887452,2.916568532,0.8361584124}, /*cfx*/
          {0.04253312668,-0.001372173927,3.049664675,0.04314736097,0.0004506205932,0.0207123492}, /*cmy*/
          {0.5532624671,3.002444234,0.8823288108,1.854387454}, /*cfy*/
          {-0.1014374449,0.0004996510715,9.291066051,-0.1046624115,0.0006293411315,0.06566644502}, /*cmz*/
          {1.725454364,3.238947901,4.592854417,2.446390589} /*cfz*/
     },
     {
          2465599.5,
          {0.1980639255,-9.350621025e-05,9.381335024,-0.09489178486,0.0005830410662,0.06731934158}, /*cmx*/
          {4.545587536,-0.1875579795,1.02978364,3.532803065}, /*cfx*/
          {-0.02739100664,-0.001142006244,2.98135672,0.04264407927,0.0004503799805,0.02923108478}, /*cmy*/
          {6.119742253,0.4793665906,4.685939034,5.398797291}, /*cfy*/
          {-0.07626766618,0.0007743889893,8.88452714,-0.1100192768,0.000624578659,0.0622977486}, /*cmz*/
          {-0.1667670638,1.304053669,2.669309329,5.037686951} /*cfz*/
     },
     {
          2465649.5,
          {0.1925583681,-0.0002686679986,8.980030906,-0.09180414845,0.0005382209415,0.0621825843}, /*cmx*/
          {2.734127522,4.138870906,5.608552124,-0.0425932565}, /*cfx*/
          {-0.0851558993,-0.0006237986645,4.812515764,0.04492378094,0.0004532965255,0.04103943997}, /*cmy*/
          {4.831066078,4.272121083,2.341283404,2.150003441}, /*cfy*/
          {-0.03710182481,0.0009446320148,8.480738093,-0.1152168262,0.0006189284648,0.06090692872}, /*cmz*/
          {4.163841032,5.68719557,0.7263437974,1.304356363} /*cfz*/
     },
     {
          2465699.5,
          {0.1784341373,-0.0002081608306,8.077997179,-0.1027299195,0.0005909148278,0.05521435843}, /*cmx*/
          {0.8690628557,2.260730738,3.891687234,2.56314491}, /*cfx*/
          {-0.1162819434,-2.282057127e-05,6.095778086,0.05307019265,0.0004802420938,0.04571330575}, /*cmy*/
          {3.199748025,1.900749806,-0.1500554783,5.03043399}, /*cfy*/
          {0.01085341703,0.0009324381196,8.561642085,-0.1170185384,0.000662245283,0.06360064029}, /*cmz*/
          {2.174940632,3.808250229,5.040788039,3.871450489} /*cfz*/
     },
     {
          2465749.5,
          {0.1682896867,-7.237216501e-05,7.48659267,-0.1257331891,0.0006998840913,0.05502226302}, /*cmx*/
          {5.124149939,0.4157940978,1.776057654,5.009927668}, /*cfx*/
          {-0.1167954292,0.0004861563975,6.103145134,0.05423231365,0.000652644178,0.03981940786}, /*cmy*/
          {1.493967124,-0.4812983372,3.554566078,1.664308605}, /*cfy*/
          {0.0576481869,0.0007876783883,9.091655721,-0.1141545301,0.0007560986139,0.06715819875}, /*cmz*/
          {0.2199502227,1.885269351,3.106332223,0.2230704744} /*cfz*/
     },
     {
          2465799.5,
          {0.1658383097,-0.0001752365258,8.275661022,-0.130955658,0.0008974790552,0.06392199031}, /*cmx*/
          {3.009310921,4.776929311,-0.518706827,1.248865073}, /*cfx*/
          {-0.09092210203,0.0006481412215,4.453028292,0.05523242023,0.000629861838,0.02585410763}, /*cmy*/
          {-0.07275499684,-3.305812541,0.9414992342,4.98539724}, /*cfy*/
          {0.09661437572,0.0006691603157,9.373735796,-0.1141315907,0.0008123930713,0.06636736919}, /*cmz*/
          {4.593619342,-0.1406756184,1.196068617,2.881983181} /*cfz*/
     },
     {
          2465849.5,
          {0.15762999,-0.0005450054465,9.333772401,-0.1074553321,0.0008136476576,0.06732289278}, /*cmx*/
          {1.048007223,2.665340481,3.800590075,3.93924213}, /*cfx*/
          {-0.05736412201,0.0003641022057,2.97412338,0.06075038197,-0.0006321614668,0.02903332805}, /*cmy*/
          {5.424705388,0.386454708,-5.04666846,2.543228737}, /*cfy*/
          {0.1299756874,0.0006605508954,8.946949443,-0.1249770881,0.0007806478389,0.06167583594}, /*cmz*/
          {2.6540768,4.098905036,5.467855391,-0.8169817826} /*cfz*/
     },
     {
          2465899.5,
          {0.1303741469,-0.0009897010468,8.983878514,-0.1025100759,0.0006370151635,0.06070221024}, /*cmx*/
          {5.471200212,0.5433077638,1.999372774,0.3536593815}, /*cfx*/
          {-0.03997793909,3.69084663e-05,4.925367394,-0.04978264291,-0.0005837587398,0.04242605513}, /*cmy*/
          {4.412062994,0.8597165857,5.030530986,5.715206049}, /*cfy*/
          {0.1634381747,0.0006042704334,8.422988438,-0.1333803514,0.0007522135685,0.06053407941}, /*cmz*/
          {0.6117839745,2.136798884,3.316102789,1.678931591} /*cfz*/
     },
     {
          2465949.5,
          {0.07977329019,-0.001293841343,7.812260486,-0.1155085764,0.00055452549,0.05341552666}, /*cmx*/
          {3.537025681,4.904509834,0.0187788546,2.900680163}, /*cfx*/
          {-0.0399693867,0.0001287974194,6.286121471,-0.05334417702,0.0005018251968,0.04600999093}, /*cmy*/
          {2.798580612,4.508387257,-0.8186518694,2.351901828}, /*cfy*/
          {0.1943697122,0.0003398925933,8.696892242,-0.1239932215,0.0007280134886,0.06511194176}, /*cmz*/
          {4.834221565,0.1970921327,1.221427969,4.242754516} /*cfz*/
     },
     {
          2465999.5,
          {0.01249565101,-0.001006037469,7.436655068,-0.1194805655,0.0005650454706,0.05679396022}, /*cmx*/
          {1.452404729,3.071715096,3.929097001,-0.8818411139}, /*cfx*/
          {-0.03388002789,0.0006259520224,5.941816872,-0.04489067164,0.000456824434,0.03866696573}, /*cmy*/
          {1.121180938,2.005733028,2.937102902,5.345294852}, /*cfy*/
          {0.2110798946,7.693223091e-06,9.269340068,-0.1043597484,0.0005801954069,0.06865521092}, /*cmz*/
          {2.895334811,4.498321831,5.443861368,0.667316446} /*cfz*/
     },
     {
          2466049.5,
          {-0.04025826139,4.498046004e-05,8.373781301,-0.09044084579,0.0006064428971,0.06517664084}, /*cmx*/
          {-0.5239045657,1.218025338,1.491146877,1.881118202}, /*cfx*/
          {0.0002131641538,0.0007194621714,4.318995926,-0.03809705533,0.0002166121764,0.02709827618}, /*cmy*/
          {5.925595485,-0.5785481698,12.40188926,2.331187971}, /*cfy*/
          {0.2100224259,-5.062643614e-05,9.377764598,-0.08453031475,0.0004976628899,0.06900698688}, /*cmz*/
          {1.082927172,2.545147025,2.853012602,3.510748288} /*cfz*/
     },
     {
          2466099.5,
          {-0.04082437411,0.001900690904,9.045587559,-0.03208819514,0.0009363208224,0.06848754236}, /*cmx*/
          {4.088484425,5.878623287,-0.4132176526,4.997357658}, /*cfx*/
          {0.03618737648,0.0001736184137,3.05574515,-0.01845995024,0.00053500623,0.02177498742}, /*cmy*/
          {4.761921774,4.269766547,3.79977962,5.624276316}, /*cfy*/
          {0.2108003753,-0.0001309880159,9.185649175,-0.03442323917,0.0009371789007,0.06973011567}, /*cmz*/
          {5.712613609,0.9880250055,0.93914113,0.3310121891} /*cfz*/
     },
     {
          2466149.5,
          {0.07051189001,0.001789948256,8.963970015,0.0749849699,-0.0009286532745,0.0654523922}, /*cmx*/
          {2.834794095,4.716459013,4.670522681,2.134426377}, /*cfx*/
          {0.04388177744,0.0006067520664,3.044353062,0.04127652498,-0.000439731086,0.02702652276}, /*cmy*/
          {3.225259646,2.60245324,2.599628089,2.284581916}, /*cfy*/
          {0.2016142096,-0.001439715395,9.331158179,0.06745776272,-0.0008579059897,0.07061893603}, /*cmz*/
          {4.444535808,6.042861467,6.032283945,3.724594927} /*cfz*/
     },
     {
          2458849.5,
          {0.001854388307,-7.694427045e-05,18.98909291,0.3230487858,0.002006359843,0.002244174855}, /*cmx*/
          {1.193562942,-0.2924207735,4.171870477,-1.493848774}, /*cfx*/
          {0.0003641889916,1.0442863e-05,14.21475432,0.1353817446,0.001581693142,-0.001422978807}, /*cmy*/
          {4.033283287,1.91878627,-0.2515728493,11.08806871}, /*cfy*/
          {0.007375843856,3.694399796e-06,23.21142774,0.2994099735,0.002061992379,0.002686657197}, /*cmz*/
          {2.656728346,1.134132564,5.581316572,0.1060867677} /*cfz*/
     },
     {
          2458889.5,
          {-0.002467897025,-6.70254612e-05,20.92817121,0.3251930882,0.002315963129,0.002341612721}, /*cmx*/
          {4.939555761,3.554383132,1.542300419,0.5168771463}, /*cfx*/
          {0.0006587456918,-2.906705157e-05,10.6976155,0.1235058027,0.001529173008,-0.001427858082}, /*cmy*/
          {1.902676985,-1.106961629,3.095556134,0.5702580947}, /*cfy*/
          {0.007114853365,-3.537965771e-05,23.43964519,0.302581448,0.002111946878,0.002487462006}, /*cmz*/
          {0.2486001772,4.939009927,3.149203712,2.182436839} /*cfz*/
     },
     {
          2458929.5,
          {-0.004716180506,-3.809655694e-05,23.03002081,0.2948726178,0.002240703417,0.002147451309}, /*cmx*/
          {2.491983028,1.019318394,5.30400271,2.289473757}, /*cfx*/
          {-0.0002791413686,-3.400706566e-05,6.921380168,0.1231375219,0.001421092911,-0.001314178037}, /*cmy*/
          {6.502518189,2.147892526,-0.001759064317,3.559364629}, /*cfy*/
          {0.005446486894,-6.721706673e-05,22.87832088,0.3141189399,0.002075376851,0.001873630065}, /*cmz*/
          {4.108053806,2.460115533,0.6776163046,3.920405502} /*cfz*/
     },
     {
          2458969.5,
          {-0.007093269891,-7.636141641e-07,23.35558163,0.2714870269,0.00183150015,0.002438785338}, /*cmx*/
          {0.1138086345,4.738000904,2.834522806,4.108625727}, /*cfx*/
          {-0.001834768044,-2.312859804e-05,8.414680473,0.1103162969,0.001348685713,-0.001553808877}, /*cmy*/
          {5.097005638,-0.8504695705,3.330222662,6.36844732}, /*cfy*/
          {0.00311112928,-8.256226249e-05,22.03290315,0.3239169725,0.001940238739,0.002252566557}, /*cmz*/
          {1.647240559,0.005709624685,4.398354089,-0.7391271084} /*cfz*/
     },
     {
          2459009.5,
          {-0.007070081718,2.841118866e-05,21.98500213,0.2626134399,0.001382699715,0.002684658813}, /*cmx*/
          {4.035503257,2.256350278,0.2087558061,-0.06487483642}, /*cfx*/
          {-0.002736725203,7.463789114e-06,12.14386416,0.1062881248,0.0009997284453,-0.001637173093}, /*cmy*/
          {3.13642336,2.40992882,0.401992414,2.480228571}, /*cfy*/
          {-0.001079770286,-6.916897862e-05,21.72817277,0.3115445743,0.001715521509,0.002572751972}, /*cmz*/
          {5.451702969,3.861946157,1.675629045,1.27883489} /*cfz*/
     },
     {
          2459049.5,
          {-0.005935737,3.345277162e-05,20.22865074,0.2365113595,0.001622643613,0.001932615839}, /*cmx*/
          {1.672936872,-0.1193184146,3.286535567,2.204568157}, /*cfx*/
          {-0.002538788018,1.211550385e-05,14.29433498,0.09845065812,-0.0007030233686,-0.001320600821}, /*cmy*/
          {0.9857583773,-0.3522020895,-6.138910176,4.625546863}, /*cfy*/
          {-0.003021131975,-3.483905454e-05,22.17352258,0.2569066716,0.001868389598,0.001938294487}, /*cmz*/
          {3.033417489,1.46807713,4.910602861,3.340671298} /*cfz*/
     },
     {
          2459089.5,
          {-0.005386942163,2.152883449e-05,19.25864663,0.09756210327,0.002598031652,0.001885331442}, /*cmx*/
          {5.695131823,4.009281269,0.8235359339,4.234294677}, /*cfx*/
          {-0.002158713114,9.971078109e-06,14.7818735,0.04591654565,-0.0007124391085,-0.001479255419}, /*cmy*/
          {5.15540801,3.59770795,3.598189115,0.4306673843}, /*cfy*/
          {-0.005042661568,-5.909744849e-06,22.61829266,0.1033358773,0.002526012821,0.002490041599}, /*cmz*/
          {0.7896638559,5.537115629,2.445530025,5.602169731} /*cfz*/
     },
     {
          2459129.5,
          {-0.005121726735,-2.332637795e-05,19.45870986,-0.1261057389,-0.001862543052,0.001157428256}, /*cmx*/
          {3.788233639,2.062416376,5.25764187,-0.1031227725}, /*cfx*/
          {-0.002329133013,-3.293712878e-06,14.81893125,-0.01297849907,0.0007586466833,-0.001428781082}, /*cmy*/
          {3.194722725,1.934776164,1.825374805,2.525142661}, /*cfy*/
          {-0.002856008709,-1.123725441e-05,22.44442568,-0.1168691945,-0.001951597816,0.002241111516}, /*cmz*/
          {5.150956367,3.793383588,0.5377170754,1.205483111} /*cfz*/
     },
     {
          2459169.5,
          {-0.005932975755,1.152234547e-05,20.01145972,0.05373957893,-0.001873371579,0.001710625085}, /*cmx*/
          {1.978357083,0.506186106,3.089542023,2.407103888}, /*cfx*/
          {-0.002426526319,1.332272767e-05,14.89983518,0.05707800916,0.0007418698944,-0.001535344516}, /*cmy*/
          {1.238045391,-0.002500020159,5.552901933,4.763453617}, /*cfy*/
          {-0.003592933937,-3.246230718e-05,21.79378495,0.07272974999,-0.001840119942,0.001680420609}, /*cmz*/
          {3.30728545,1.777347895,4.635593053,3.834228645} /*cfz*/
     },
     {
          2459209.5,
          {-0.005788982966,3.632643834e-05,19.45409368,0.1964309167,-0.00138200535,0.002346027633}, /*cmx*/
          {-0.1781839204,4.44839961,0.2091989207,4.322546941}, /*cfx*/
          {-0.002385439776,2.442721349e-05,15.48889407,0.1128080598,0.0009001184442,-0.001910709634}, /*cmy*/
          {5.402270542,3.958433999,2.337486074,0.6110060027}, /*cfy*/
          {-0.003911732477,-5.135212697e-05,21.91355653,0.2174146776,-0.001327037481,0.002535191557}, /*cmz*/
          {1.135156157,5.931876858,1.461465765,-0.5500971649} /*cfz*/
     },
     {
          2459249.5,
          {-0.004537367735,6.107181118e-05,18.80944298,0.2684827314,-0.001577350485,0.002359862998}, /*cmx*/
          {3.7202532,2.143813971,3.741794263,0.1328869459}, /*cfx*/
          {-0.00105995881,2.875820383e-05,15.32246182,0.1336466088,0.001201460353,-0.001942883786}, /*cmy*/
          {3.191905166,1.416873758,-0.6232231084,2.867809781}, /*cfy*/
          {-0.006405284523,-3.926660259e-05,22.61949092,0.2642995839,-0.00162316544,0.00258301318}, /*cmz*/
          {5.085376601,3.59663627,5.009777896,1.542012115} /*cfz*/
     },
     {
          2459289.5,
          {-0.001464388813,7.513314026e-05,19.4637794,0.3029933614,-0.001851313398,0.001952586042}, /*cmx*/
          {1.226404809,-0.2186639035,1.075782312,1.90888429}, /*cfx*/
          {-0.0001861606928,3.443333014e-06,13.39723756,0.1251484171,0.00139489362,-0.001372613872}, /*cmy*/
          {0.9784026223,4.963259284,2.819425505,5.225142189}, /*cfy*/
          {-0.007210327432,-1.121252891e-05,23.30136622,0.2759746559,-0.001780545359,0.002256608699}, /*cmz*/
          {2.717965054,1.186878225,2.529818935,3.400297423} /*cfz*/
     },
     {
          2459329.5,
          {0.000951276705,7.144041211e-05,21.43826765,0.2983321679,-0.00200992609,0.002330415521}, /*cmx*/
          {5.032228367,3.634260887,4.776250028,3.556227995}, /*cfx*/
          {0.0002473635777,-1.981164778e-05,9.667371553,0.1138487856,0.001315718527,-0.0006455414438}, /*cmy*/
          {5.184775492,2.00929693,-0.07934653552,1.6181794}, /*cfy*/
          {-0.007555945622,2.241674493e-05,23.42151497,0.2807774678,-0.00181673439,0.002416244468}, /*cmz*/
          {0.3453512935,5.031323488,0.1082744359,5.118780734} /*cfz*/
     },
     {
          2459369.5,
          {0.004492721171,4.643238972e-05,23.13751385,0.2711983286,-0.001881400729,0.002694896375}, /*cmx*/
          {2.631803867,1.142560158,2.318645948,5.568661719}, /*cfx*/
          {-0.0007070164982,-3.802398859e-05,6.527423611,0.109301217,0.001258859019,-0.0003902595336}, /*cmy*/
          {3.568394409,-0.9445983192,3.238106175,4.385764801}, /*cfy*/
          {-0.006537384501,5.001674188e-05,22.87675312,0.2883783115,-0.001805933346,0.002653448995}, /*cmz*/
          {4.241565068,2.595752213,3.980793093,0.8464441118} /*cfz*/
     },
     {
          2459409.5,
          {0.006141423505,1.982634523e-05,23.36558336,0.2524148039,-0.001652974791,0.00237244443}, /*cmx*/
          {0.2864909631,4.931525853,-0.03490731265,1.329253131}, /*cfx*/
          {-0.002246422729,-2.710580586e-05,8.339409292,0.1042863568,0.001279883174,-0.0007670303605}, /*cmy*/
          {2.103758978,2.390525719,0.4092291799,-0.05566172993}, /*cfy*/
          {-0.003801367435,6.796768544e-05,22.02766062,0.2984284699,-0.00180508653,0.002256432988}, /*cmz*/
          {1.82346151,0.1797993115,1.56425317,2.784887976} /*cfz*/
     },
     {
          2459449.5,
          {0.007028309404,-9.694131472e-06,22.19844815,0.2531134956,-0.001556492717,0.002174447047}, /*cmx*/
          {4.231761082,2.492339576,3.969749422,3.121932716}, /*cfx*/
          {-0.003016645407,-3.392291745e-06,12.07095662,0.114673554,0.001275959871,-0.001488702846}, /*cmy*/
          {0.1255793375,-0.5429851255,3.941465845,2.058002338}, /*cfy*/
          {-0.001213725532,7.697032766e-05,21.49091101,0.3073456422,-0.001853846668,0.002305463446}, /*cmz*/
          {5.652712715,4.062808367,5.415520626,4.420517091} /*cfz*/
     },
     {
          2459489.5,
          {0.007079562541,-3.858301506e-05,20.35542907,0.2728830207,-0.001660550827,0.002240500781}, /*cmx*/
          {1.847032351,0.1083123718,1.687802087,5.057286339}, /*cfx*/
          {-0.003583322829,2.58794359e-05,14.64010979,0.1380299622,0.001292877971,-0.001956172003}, /*cmy*/
          {4.217786217,2.963390112,1.109180338,4.32216582}, /*cfy*/
          {0.00244523041,7.092134307e-05,21.7166386,0.3120455848,-0.001968097003,0.002758928433}, /*cmz*/
          {3.182226092,1.659477988,2.969170242,0.09526417936} /*cfz*/
     },
     {
          2459529.5,
          {0.005318442298,-7.232126824e-05,18.95429657,0.3090471079,-0.001925466855,0.001728372967}, /*cmx*/
          {5.64630497,4.026167638,5.540537162,0.6184531629}, /*cfx*/
          {-0.001773448299,3.489268819e-05,15.25093072,0.1507764381,0.001513852095,-0.001696319853}, /*cmy*/
          {1.956294556,0.264161126,4.444560342,0.2868760194}, /*cfy*/
          {0.005699496663,4.490160871e-05,22.55879024,0.3124605123,-0.002130571328,0.002464772315}, /*cmz*/
          {0.724548692,5.511542595,0.5203995524,2.086929865} /*cfz*/
     },
     {
          2459569.5,
          {0.002757578941,-9.044265233e-05,19.41172543,0.3435608002,-0.002332409138,0.002087081643}, /*cmx*/
          {3.073625601,1.626959146,2.892852399,1.91620218}, /*cfx*/
          {-0.001233836818,1.160208582e-05,13.43471431,0.1395242695,0.001784446486,-0.001043471083}, /*cmy*/
          {-0.2934914812,3.685469806,1.518715063,2.43950858}, /*cfy*/
          {0.007393787009,4.63056211e-06,23.3303501,0.3137732342,-0.002289797856,0.002387574253}, /*cmz*/
          {4.571666737,3.035977535,4.355421093,3.724952317} /*cfz*/
     },
     {
          2459609.5,
          {-0.0008681557922,-9.304237387e-05,21.71330443,0.3385455968,-0.002652293934,0.003134053532}, /*cmx*/
          {0.5285145467,5.415419253,0.2408167983,3.907135178}, /*cfx*/
          {0.0002921876989,-2.593261207e-05,9.205753213,0.1344190654,0.001693846558,-0.0004321507944}, /*cmy*/
          {3.925965603,0.5556472631,4.737591125,4.772163943}, /*cfy*/
          {0.008542562837,-4.130081461e-05,23.36095065,0.3234986941,-0.002388094238,0.002826322695}, /*cmz*/
          {2.137204701,0.5262965802,1.889666807,5.605676069} /*cfz*/
     },
     {
          2459649.5,
          {-0.004684453649,-5.665809991e-05,23.40158294,0.3054897388,-0.002429214269,0.002949589108}, /*cmx*/
          {4.359638172,2.817333134,4.004934904,-0.2681026316}, /*cfx*/
          {-0.002068310376,-3.704644567e-05,6.619429216,0.13273224,0.001708092565,-0.000614727615}, /*cmy*/
          {2.502388898,3.764777803,1.594531166,1.186010593}, /*cfy*/
          {0.006462101898,-8.650761022e-05,22.58407136,0.3418386541,-0.002403430854,0.002390680848}, /*cmz*/
          {-0.3293828978,4.300646317,5.657617703,1.319789298} /*cfz*/
     },
     {
          2459689.5,
          {-0.006416218266,-1.590608579e-05,22.87885004,0.2918697037,-0.002036219853,0.002263273784}, /*cmx*/
          {1.956716169,0.2378413179,1.579007925,1.519028266}, /*cfx*/
          {-0.002753182163,-1.617780373e-05,10.25217727,0.1251133022,0.001653392977,-0.001349049361}, /*cmy*/
          {0.8788246815,0.6418029191,4.938801444,3.476318279}, /*cfy*/
          {0.003670869925,-0.000105573701,21.74108656,0.3556140236,-0.002363570446,0.001955622614}, /*cmz*/
          {3.434615088,1.814741537,3.08518385,2.768465698} /*cfz*/
     },
     {
          2459729.5,
          {-0.00743618135,2.189953316e-05,20.89050504,0.3000043425,-0.00180347686,0.002442102}, /*cmx*/
          {-0.4695249595,4.046341667,5.437269631,3.245609077}, /*cfx*/
          {-0.004317592696,1.822564685e-05,13.86807687,0.1409076601,0.001414704349,-0.001935222376}, /*cmy*/
          {5.018840452,3.903674225,1.976948054,5.686120406}, /*cfy*/
          {-0.0003750090732,-9.995448853e-05,21.75063053,0.3488657411,-0.002262057959,0.002810274696}, /*cmz*/
          {0.8922901546,5.626429101,0.4976429207,4.468621694} /*cfz*/
     },
     {
          2459769.5,
          {-0.005963376021,5.164418785e-05,19.15622139,0.3103216375,-0.001656785773,0.002326326503}, /*cmx*/
          {3.313052067,1.642837943,2.832568408,5.249804015}, /*cfx*/
          {-0.002701750321,3.164267619e-05,15.06889355,0.143935885,0.001258882342,-0.001859282679}, /*cmy*/
          {2.754434755,1.119725386,-1.058577701,1.616873503}, /*cfy*/
          {-0.00451157984,-6.878443286e-05,22.56278312,0.3190512769,-0.001993877405,0.0030189993}, /*cmz*/
          {4.677512567,3.154184245,4.189457616,0.2699524419} /*cfz*/
     },
     {
          2459809.5,
          {-0.003960988872,5.297423292e-05,19.17146443,0.2882402278,-0.001627212009,0.001629533613}, /*cmx*/
          {0.7866251283,5.546699016,-0.0765862263,0.756027028}, /*cfx*/
          {-0.00205080992,1.787622256e-05,13.92134469,0.1125582156,0.0008688408241,-0.001516228938}, /*cmy*/
          {0.5160657166,4.653643382,2.232234513,3.781478078}, /*cfy*/
          {-0.006309594349,-3.447898885e-05,23.30588135,0.2720024717,-0.001575747317,0.002499934623}, /*cmz*/
          {2.265121921,0.6930855914,1.405873886,2.291405979} /*cfz*/
     },
     {
          2459849.5,
          {-0.001906320266,1.678520043e-05,20.44796682,0.2016144505,-0.002466419018,0.002303906066}, /*cmx*/
          {4.677891805,3.206014599,3.285927965,2.393627645}, /*cfx*/
          {-0.0005537152846,-5.915620893e-08,11.58166424,0.07098938999,-0.0008136411568,-0.0009350793148}, /*cmy*/
          {4.676334819,2.047901021,1.560313389,5.816704404}, /*cfy*/
          {-0.008411413307,-4.115825791e-06,23.4983735,0.1948125691,-0.00215758232,0.002838573979}, /*cmz*/
          {-0.03460289047,4.611473686,4.666655632,4.054699817} /*cfz*/
     },
     {
          2459889.5,
          {-0.001527100494,-5.025614427e-05,20.99095859,-0.03902255045,-0.001551107784,0.002528323139}, /*cmx*/
          {2.565049005,1.303448107,1.374319254,4.273793424}, /*cfx*/
          {-0.0006495926341,-2.393462328e-05,10.46432594,-0.05389871227,-0.000694021568,-0.001230895813}, /*cmy*/
          {2.637073043,11.06471392,6.431120386,2.419505244}, /*cfy*/
          {-0.007727482596,3.459147276e-05,23.43658476,-0.01872409463,-0.001306665325,0.001624866378}, /*cmz*/
          {4.149606748,2.297194353,2.787279243,-0.08996881902} /*cfz*/
     },
     {
          2459929.5,
          {-0.003262430619,1.159683352e-06,19.9668543,-0.1229701284,0.002878600064,0.002307867305}, /*cmx*/
          {0.8376802305,5.798251706,5.749548916,1.274428493}, /*cfx*/
          {-0.0009482974633,-8.366914926e-06,12.50731646,-0.05417748808,0.001104516329,-0.001662135391}, /*cmy*/
          {0.6352539118,3.823740537,4.246508338,4.144222773}, /*cfy*/
          {-0.007884650298,1.612473902e-05,23.36694222,0.08922604005,0.002407767158,0.002742086521}, /*cmz*/
          {2.352252609,4.029949066,0.8572536677,2.771087849} /*cfz*/
     },
     {
          2459969.5,
          {-0.003712143342,3.239084375e-05,19.62670899,0.1174371156,0.001560183157,0.003018246731}, /*cmx*/
          {5.226618492,3.834636625,3.246253819,3.393047563}, /*cfx*/
          {-0.001331852686,4.751924798e-06,13.13019417,0.05349718736,0.0007218771078,-0.001423120954}, /*cmy*/
          {4.957299657,2.94232618,1.569410034,-0.01749687579}, /*cfy*/
          {-0.007115465415,-1.277134161e-05,23.24268866,-0.1128943691,0.001390054356,0.00303280192}, /*cmz*/
          {0.4318531893,2.115091204,4.597841328,4.852352514} /*cfz*/
     },
     {
          2460009.5,
          {-0.001978788436,6.196534878e-05,20.59458836,0.2317468582,0.001388071227,0.002726714312}, /*cmx*/
          {2.978755886,1.590996394,0.04220419508,5.606770193}, /*cfx*/
          {-0.0003695076804,-1.61679039e-06,11.24209765,0.08840263687,0.0009545189964,-0.001291725181}, /*cmy*/
          {2.903262766,0.2356800558,4.622142701,2.32146337}, /*cfy*/
          {-0.00861265807,1.770982246e-06,23.43286769,-0.2116713284,0.001336510162,0.002812309538}, /*cmz*/
          {4.531986457,-0.1494872513,1.569939937,0.7948997137} /*cfz*/
     },
     {
          2460049.5,
          {0.000870058853,6.409329966e-05,22.23968914,0.2590621945,0.001672272824,0.002368047878}, /*cmx*/
          {0.6272055158,5.495183104,3.616983404,1.146153373}, /*cfx*/
          {-0.001008477269,-2.128125345e-05,7.917413598,0.09874089259,0.001074070623,-0.0009919818864}, /*cmy*/
          {0.978519622,3.686009821,1.685564889,4.984550578}, /*cfy*/
          {-0.008351362628,2.782163175e-05,23.30943256,-0.2518359689,0.001560805017,0.002471259613}, /*cmz*/
          {2.235109674,3.770907632,5.279517295,2.662157819} /*cfz*/
     },
     {
          2460089.5,
          {0.003378951888,5.249179934e-05,23.36886865,0.2517892208,0.001670913374,0.002668395598}, /*cmx*/
          {4.568096692,3.039661047,1.162736693,2.955276822}, /*cfx*/
          {-0.001373745164,-3.384053561e-05,6.280689248,0.1009302172,0.001158533662,-0.001041727478}, /*cmy*/
          {5.801565636,0.8181086531,5.066922958,1.696466497}, /*cfy*/
          {-0.007799430573,5.525003245e-05,22.69682799,-0.2750515296,0.001683880894,0.002719679454}, /*cmz*/
          {-0.1204069832,1.377514661,2.833480339,4.477105049} /*cfz*/
     },
     {
          2460129.5,
          {0.005964933803,3.026196995e-05,23.19676719,0.245789979,0.001563372282,0.002808980289}, /*cmx*/
          {2.243925777,0.580193465,5.10750686,4.986313937}, /*cfx*/
          {-0.00338457731,-2.630527755e-05,9.08005681,0.1027332169,0.001239695475,-0.001223149622}, /*cmy*/
          {4.184820474,4.186733775,2.286731951,4.111212023}, /*cfy*/
          {-0.005789725246,8.174081952e-05,21.90596959,-0.2932320623,0.001768668582,0.00290825253}, /*cmz*/
          {3.756830468,5.265900782,0.3996167444,0.1844486458} /*cfz*/
     },
     {
          2460169.5,
          {0.007052667741,6.670699726e-06,21.86326036,0.2543925624,0.001575029564,0.002339195471}, /*cmx*/
          {-0.0940891968,4.448343184,2.835501359,0.646759868}, /*cfx*/
          {-0.004222415612,2.554002179e-06,12.64659672,0.1194607975,0.001282085165,-0.001332058217}, /*cmy*/
          {2.129104828,1.307921245,-0.460075245,-0.2871158594}, /*cfy*/
          {-0.002428219222,0.0001004118433,21.49845771,-0.3068975797,0.001876055476,0.002445149064}, /*cmz*/
          {1.30671049,2.871746976,4.240862037,2.039148858} /*cfz*/
     },
     {
          2460209.5,
          {0.007289182391,-2.60881203e-05,20.05720255,0.2813751904,0.001767635572,0.00229854731}, /*cmx*/
          {3.787948899,2.07082771,0.5238979112,2.325257688}, /*cfx*/
          {-0.004533002181,2.814768007e-05,14.85111813,0.1446882894,0.001364863896,-0.001887161145}, /*cmy*/
          {-0.08947474059,4.849397528,2.956946749,1.536306851}, /*cfy*/
          {0.0007555301109,9.895025098e-05,21.84756391,-0.3150929019,0.00204154692,0.002718819802}, /*cmz*/
          {5.119887154,0.4633316523,1.784409957,3.698492649} /*cfz*/
     },
     {
          2460249.5,
          {0.00687924464,-6.258057956e-05,18.95214382,0.3243127292,0.002106054024,0.002626409409}, /*cmx*/
          {1.276175297,-0.3061015,4.311269985,4.191937819}, /*cfx*/
          {-0.003426712315,4.400767142e-05,15.00565298,0.1549370874,0.001679370666,-0.002350735194}, /*cmy*/
          {3.918300187,2.128679169,-0.01439151463,3.735330828}, /*cfy*/
          {0.00503288401,7.566375823e-05,22.72586189,-0.3188080967,0.002258847311,0.003148478397}, /*cmz*/
          {2.658990858,4.301871902,5.605444025,5.692323742} /*cfz*/
     },
     {
          2460289.5,
          {0.003377511428,-9.892199508e-05,19.91535419,0.3575628673,0.002579587134,0.002257368857}, /*cmx*/
          {4.969030831,3.54597409,1.613471891,-0.321485267}, /*cfx*/
          {-0.001544776621,8.530275213e-06,12.54940793,0.142307044,0.001917128305,-0.001961739486}, /*cmy*/
          {1.674477328,-0.8261024754,3.301403662,6.216072729}, /*cfy*/
          {0.007622848908,3.218024939e-05,23.40442071,-0.3242327666,0.002458627327,0.002572470155}, /*cmz*/
          {0.2129800923,1.806210241,3.133133832,1.319173716} /*cfz*/
     },
     {
          2460329.5,
          {0.0005132126413,-0.0001018974925,22.33902415,0.3421099435,0.002794769386,0.00266628106}, /*cmx*/
          {2.427610486,1.002598285,5.247821749,1.256962182}, /*cfx*/
          {-0.001177110201,-2.610017546e-05,7.909636278,0.1419272377,0.001809475442,-0.001474559185}, /*cmy*/
          {5.996665581,2.282122423,0.1407706886,2.931008943}, /*cfy*/
          {0.008429754017,-2.065272694e-05,23.24990878,-0.3384899833,0.00255688186,0.002399016393}, /*cmz*/
          {4.042209164,5.558813465,0.6297182145,2.841863174} /*cfz*/
     },
     {
          2460369.5,
          {-0.004242222438,-6.784265332e-05,23.48031747,0.3085300183,0.00243102165,0.003174798638}, /*cmx*/
          {-0.02238010455,4.660885061,2.744877078,3.215056358}, /*cfx*/
          {-0.002299487126,-5.115888134e-05,7.113282118,0.135379542,0.001854722952,-0.00147289968}, /*cmy*/
          {4.714364539,-0.8264300696,3.305451227,5.709396725}, /*cfy*/
          {0.007893451294,-7.468649479e-05,22.35148466,-0.3578677642,0.002543947911,0.003003405507}, /*cmz*/
          {1.546319739,3.034173564,4.362693153,4.681134864} /*cfz*/
     },
     {
          2460409.5,
          {-0.006568475463,-2.488788702e-05,22.369294,0.3013293687,0.002074861093,0.002666257381}, /*cmx*/
          {3.843199561,2.098197435,0.3372502469,5.250748201}, /*cfx*/
          {-0.00432380002,-1.442561577e-05,11.52737375,0.1354168217,0.001726600551,-0.001250594659}, /*cmy*/
          {2.871170976,2.293555226,0.3608245316,1.479349258}, /*cfy*/
          {0.003702295346,-0.0001027743941,21.6320909,-0.3671217765,0.002489876695,0.002617264816}, /*cmz*/
          {5.280474536,0.5357336803,1.778923495,0.3200647815} /*cfz*/
     },
     {
          2460449.5,
          {-0.007294251611,1.70288074e-05,20.24316314,0.3164325011,0.001961328139,0.002061617968}, /*cmx*/
          {1.379389978,-0.3607906367,4.200395197,0.5845675576}, /*cfx*/
          {-0.004561980224,1.812822614e-05,14.55133696,0.1562811556,0.001551161516,-0.001282494312}, /*cmy*/
          {0.6467679805,-0.6657877725,3.62006113,2.920654073}, /*cfy*/
          {4.558060752e-05,-9.919479382e-05,21.914419,-0.3553335745,0.002404154919,0.002483264412}, /*cmz*/
          {2.72320326,4.333013841,5.497587855,1.853939653} /*cfz*/
     },
     {
          2460489.5,
          {-0.007094731406,5.236919584e-05,19.00096295,0.3342718757,0.00197828511,0.002572760485}, /*cmx*/
          {5.106644375,3.510824889,1.630603433,2.280777086}, /*cfx*/
          {-0.003912093373,3.826538128e-05,14.84064146,0.152343297,0.001564707501,-0.00182799949}, /*cmy*/
          {4.635300489,2.816103474,0.6003897617,4.883984665}, /*cfy*/
          {-0.004764331355,-7.101241822e-05,22.8350695,-0.3279602405,0.002203720954,0.003191801691}, /*cmz*/
          {0.2196688072,1.841392928,2.97839249,3.725782857} /*cfz*/
     },
     {
          2460529.5,
          {-0.003973158684,7.565100002e-05,19.94942211,0.3221848291,0.001971464831,0.002654090844}, /*cmx*/
          {2.533900722,1.090541067,5.237563115,4.226219993}, /*cfx*/
          {-0.001886628511,1.288597811e-05,12.4837589,0.122035053,0.001319106473,-0.001775544334}, /*cmy*/
          {2.402897223,-0.09410658408,3.974947385,0.9100669412}, /*cfy*/
          {-0.007647448604,-2.638181089e-05,23.44164773,-0.2974642829,0.001839768928,0.003254072877}, /*cmz*/
          {4.068057863,5.635242157,0.4555670537,5.815840954} /*cfz*/
     },
     {
          2460569.5,
          {-0.00150986774,6.431069509e-05,21.98397066,0.267470166,0.001655543334,0.002484356774}, /*cmx*/
          {0.07831194202,4.924097512,2.527571029,-0.227800939}, /*cfx*/
          {-0.001628173207,-3.204310199e-06,8.659043937,0.09718731587,0.0008015059248,-0.001364587531}, /*cmy*/
          {0.3919251657,3.238697495,0.8598760557,3.56022598}, /*cfy*/
          {-0.008793150764,9.492648544e-06,23.35415085,-0.2642778065,0.001397731304,0.002586379319}, /*cmz*/
          {1.689987146,3.187525393,4.015353081,1.50546651} /*cfz*/
     },
     {
          2460609.5,
          {0.00178166218,2.617029003e-05,23.21462681,0.1911605595,0.001687024317,0.003049542623}, /*cmx*/
          {4.059132982,2.507483765,-0.4663820668,1.616341914}, /*cfx*/
          {-0.001610536116,-4.678393301e-06,6.285709595,0.0633750158,0.0008253078183,-0.001011355481}, /*cmy*/
          {5.030983091,0.5530562586,9.8459312,6.458850352}, /*cfy*/
          {-0.009398500554,1.422885182e-05,22.92537325,-0.2069479825,0.001796548486,0.002872009319}, /*cmz*/
          {5.665384262,0.8422485958,0.9359167132,3.30075723} /*cfz*/
     },
     {
          2460649.5,
          {0.002910435314,-5.994583869e-05,23.41077609,0.04425718678,0.002114318987,0.002738051245}, /*cmx*/
          {1.934234035,0.4689008645,3.628425846,4.065392954}, /*cfx*/
          {-0.001869684223,2.469682172e-05,5.954471205,0.02590791668,0.001177760288,-0.001073745505}, /*cmy*/
          {3.315117586,-5.794581494,1.632324283,2.396289961}, /*cfy*/
          {-0.00865077956,-4.180104957e-06,22.71080829,-0.04331227555,0.00225493267,0.002433375745}, /*cmz*/
          {3.517233732,5.275557752,5.081670328,5.469352087} /*cfz*/
     },
     {
          2460689.5,
          {0.0007252537792,-3.38587328e-05,23.2616703,-0.135121997,-0.002015523029,0.004016162711}, /*cmx*/
          {0.08656560903,5.008720409,1.800403876,0.4024250951}, /*cfx*/
          {-0.0005029699705,-1.341218661e-05,5.218165847,0.1080461756,-0.001215922205,-0.0008875713339}, /*cmy*/
          {0.9877675166,-0.293829835,5.865862846,3.635574738}, /*cfy*/
          {-0.01039016021,2.974087586e-05,23.12441231,0.1397601981,-0.002074745106,0.003514487414}, /*cmz*/
          {1.682897974,3.223678749,3.215237906,2.0086088} /*cfz*/
     },
     {
          2460729.5,
          {-0.001220593264,3.591491212e-05,22.6828396,0.05299580757,-0.001646261274,0.003424202325}, /*cmx*/
          {4.552161234,3.151900008,5.979456217,2.636807501}, /*cfx*/
          {-0.001160879569,-1.008683615e-05,6.517273956,-0.003188545753,-0.0008116500457,-0.0003985013079}, /*cmy*/
          {5.01166337,31.13487679,3.957528088,6.180166045}, /*cfy*/
          {-0.009116343329,6.173223681e-06,23.263518,-0.05015994131,-0.001746397389,0.00357370794}, /*cmz*/
          {6.153784831,1.564256492,1.114952006,4.142762148} /*cfz*/
     },
     {
          2460769.5,
          {0.0006249842676,6.346655423e-05,23.08686101,0.1810999082,-0.001161169424,0.003038966248}, /*cmx*/
          {2.44061789,0.9837525081,-9.801750127,4.894252888}, /*cfx*/
          {-0.001368490471,-2.569438846e-05,5.939382569,0.06526792147,-0.0006949068279,-0.0006627481851}, /*cmy*/
          {3.270935674,-13.67961303,19.28680057,2.436219499}, /*cfy*/
          {-0.009463200515,1.579828624e-05,23.03844962,-0.1852377136,-0.001272900249,0.003086432875}, /*cmz*/
          {4.044304851,5.585261371,4.438938526,0.1311404012} /*cfz*/
     },
     {
          2460809.5,
          {0.002847444706,6.171119527e-05,23.45425231,0.2192825105,-0.001369864251,0.002793382816}, /*cmx*/
          {0.194488191,4.907074112,0.08521818892,0.4766240703}, /*cfx*/
          {-0.002686519503,-3.62287797e-05,6.750846478,0.0876416276,-0.0009798658671,-0.001130193131}, /*cmy*/
          {1.782945542,2.484681815,3.751707694,5.222324856}, /*cfy*/
          {-0.00818697832,4.01492189e-05,22.45377836,-0.2465907806,-0.001476203967,0.002708712918}, /*cmz*/
          {1.76359295,3.269927996,1.752548083,1.971240422} /*cfz*/
     },
     {
          2460849.5,
          {0.00497697399,4.9541364e-05,22.91830058,0.2340295912,-0.001451168872,0.002896584382}, /*cmx*/
          {4.187832543,2.50439911,3.995599789,2.380096417}, /*cfx*/
          {-0.003696400922,-3.306170716e-05,10.02485751,0.1011458972,-0.001164919119,-0.001764192655}, /*cmy*/
          {6.23726014,-0.3341466364,1.006984882,1.386567581}, /*cfy*/
          {-0.00683208597,7.20015897e-05,21.77526553,-0.2806878979,-0.0016765993,0.003029690315}, /*cmz*/
          {5.671558436,0.912094241,5.541023331,3.798132255} /*cfz*/
     },
     {
          2460889.5,
          {0.006985534695,2.840380654e-05,21.48951971,0.2535911876,-0.001582152798,0.002729689128}, /*cmx*/
          {1.854507794,0.1175112909,1.70670388,4.402972464}, /*cfx*/
          {-0.005401920519,-9.308355678e-06,13.23511582,0.1241599594,-0.001266921615,-0.001996456807}, /*cmy*/
          {4.119465615,3.150817191,4.543029261,3.651273189}, /*cfy*/
          {-0.003654597416,9.655557587e-05,21.51474353,-0.3026025837,-0.001870770876,0.003074818064}, /*cmz*/
          {3.23487098,4.815363332,3.073030864,5.794918797} /*cfz*/
     },
     {
          2460929.5,
          {0.007647489271,-8.130848105e-06,19.78768902,0.2887690851,-0.001865758467,0.002164187161}, /*cmx*/
          {5.721932342,4.030663889,5.638821776,-0.142001448}, /*cfx*/
          {-0.004879527869,2.469621185e-05,15.01043227,0.1500445966,-0.001423898908,-0.001724633015}, /*cmy*/
          {1.879684649,0.4429179646,1.647315574,5.646134818}, /*cfy*/
          {0.0005577195441,9.91858499e-05,21.98177597,-0.3160750859,-0.002101412697,0.002617921069}, /*cmz*/
          {0.7710065822,2.40592332,0.5960743313,1.320904923} /*cfz*/
     },
     {
          2460969.5,
          {0.007214690372,-5.029911274e-05,19.04107411,0.3375439966,-0.002284576523,0.002832831125}, /*cmx*/
          {3.18653105,1.643124318,3.075027963,1.357149259}, /*cfx*/
          {-0.004536122721,3.633617909e-05,14.65743927,0.156488185,-0.001808731175,-0.001630189842}, /*cmy*/
          {5.878684802,3.975216774,4.949957479,1.112943887}, /*cfy*/
          {0.004231794698,7.80567613e-05,22.88124864,-0.3234638675,-0.002359637474,0.00301771793}, /*cmz*/
          {4.593670851,-0.05113125723,4.40115136,2.986899218} /*cfz*/
     },
     {
          2461009.5,
          {0.005163684418,-9.857427183e-05,20.46715237,0.3666432884,-0.002791811781,0.003600511561}, /*cmx*/
          {0.5888820728,5.463026953,0.3382188834,3.382315438}, /*cfx*/
          {-0.001631492146,1.450857013e-05,11.5453639,0.144322537,-0.001968886158,-0.001375349714}, /*cmy*/
          {3.652582588,0.9318190812,1.933522923,3.238039518}, /*cfy*/
          {0.008381574229,3.66431987e-05,23.45022348,-0.3324549308,-0.00257208181,0.003329333229}, /*cmz*/
          {2.140598364,3.718977833,1.908541439,4.968152786} /*cfz*/
     },
     {
          2461049.5,
          {0.000397881743,-9.676344299e-05,22.82258769,0.3413785783,-0.002839695551,0.003059140114}, /*cmx*/
          {4.340774487,2.879134882,3.987840345,5.329794688}, /*cfx*/
          {-0.002419843813,-3.436047834e-05,6.846063727,0.1457426221,-0.001878756815,-0.001172685219}, /*cmy*/
          {1.841583062,4.028748126,-1.284097011,6.070433963}, /*cfy*/
          {0.00925609435,-2.674115539e-05,23.11591469,-0.3491760419,-0.002655493882,0.002583000298}, /*cmz*/
          {-0.3294594194,1.175396154,5.665146833,0.5348363112} /*cfz*/
     },
     {
          2461089.5,
          {-0.003300368627,-6.994746668e-05,23.39392039,0.3099523026,-0.00237673408,0.002738922368}, /*cmx*/
          {1.8943483,0.247844539,1.50491069,0.6777381312}, /*cfx*/
          {-0.00279690933,-4.321644848e-05,7.977945681,0.1358334597,-0.001901713144,-0.001736634554}, /*cmy*/
          {6.84809449,0.8854095466,1.925462717,2.647897341}, /*cfy*/
          {0.008697076885,-8.505691312e-05,22.14778667,-0.3675383194,-0.00261973778,0.002696407823}, /*cmz*/
          {3.435436519,4.92794544,3.090532697,1.964050771} /*cfz*/
     },
     {
          2461129.5,
          {-0.006982787954,-2.738527089e-05,21.88066135,0.3077161377,-0.002075277706,0.003008944177}, /*cmx*/
          {5.747078647,3.991958994,5.395487336,2.548623825}, /*cfx*/
          {-0.005833437025,-7.917792893e-06,12.49763513,0.144253677,-0.001718050372,-0.002193271122}, /*cmy*/
          {4.84204699,4.01802992,-1.032960403,4.981918885}, /*cfy*/
          {0.005366393931,-0.000121916987,21.59633843,-0.3715987588,-0.002544998965,0.003496996165}, /*cmz*/
          {0.8695275573,2.424585131,0.4977657921,3.849322739} /*cfz*/
     },
     {
          2461169.5,
          {-0.008019539641,1.522244318e-05,19.81594454,0.326297579,-0.002047551576,0.002370179064}, /*cmx*/
          {3.253967867,1.546877629,2.96182337,4.452769843}, /*cfx*/
          {-0.005361856031,3.527096801e-05,14.86686498,0.1631910884,-0.001615177421,-0.001823502357}, /*cmy*/
          {2.571832959,1.118007531,2.199782819,0.8114405866}, /*cfy*/
          {4.098329694e-05,-0.0001176803997,22.09545741,-0.3544932857,-0.002435901861,0.003132145227}, /*cmz*/
          {4.59531922,-0.06857289155,4.233797848,-0.4840443474} /*cfz*/
     },
     {
          2461209.5,
          {-0.007580913097,5.981048459e-05,19.1228148,0.3447448651,-0.002148018429,0.002302449219}, /*cmx*/
          {0.6705568561,5.411414717,0.3625609119,-0.4537916257}, /*cfx*/
          {-0.004823225234,4.359530787e-05,14.37498505,0.1509620187,-0.001682094023,-0.001370676425}, /*cmy*/
          {0.2698872371,4.574660788,-0.792199923,2.591645029}, /*cfy*/
          {-0.00400629976,-9.005659225e-05,23.02968054,-0.3273823022,-0.00224391023,0.002956433311}, /*cmz*/
          {2.099303407,3.715087976,1.742529069,1.189103093} /*cfz*/
     },
     {
          2461249.5,
          {-0.005801331887,9.637212591e-05,20.64433238,0.3292305791,-0.002186379854,0.003326732995}, /*cmx*/
          {4.382280086,2.963688605,4.004964226,1.378521252}, /*cfx*/
          {-0.002362815643,2.076736365e-05,11.21032551,0.1237182395,-0.001439796904,-0.001139052313}, /*cmy*/
          {4.353381576,1.57422909,2.558125754,4.555997177}, /*cfy*/
          {-0.008155191769,-4.279456703e-05,23.47451549,-0.3036159086,-0.001964257865,0.003458969163}, /*cmz*/
          {-0.3367846955,1.219426984,5.5602683,3.061140751} /*cfz*/
     },
     {
          2461289.5,
          {-0.001726704593,9.207577816e-05,22.68681953,0.2794872255,-0.00183733834,0.003513273785}, /*cmx*/
          {1.930869739,0.4708723678,1.456400935,3.448763973}, /*cfx*/
          {-0.002282293232,-1.673387306e-05,7.145935756,0.108227416,-0.001086916734,-0.0009783271078}, /*cmy*/
          {2.504641585,4.860164371,-0.4707688065,0.960142371}, /*cfy*/
          {-0.009353935247,5.67688581e-07,23.17130744,-0.2848573958,-0.001616422653,0.003283326142}, /*cmz*/
          {3.545234491,5.042911602,3.062648981,5.098101812} /*cfz*/
     },
     {
          2461329.5,
          {0.001141626424,6.771923217e-05,23.48612209,0.2296482166,-0.001287118918,0.003090704559}, /*cmx*/
          {-0.4071258775,4.273967258,5.117406812,5.448972068}, /*cfx*/
          {-0.002547355782,-2.862796482e-05,6.655239462,0.08626377281,-0.0007881910901,-0.001256346877}, /*cmy*/
          {1.115306622,1.99765042,2.809685154,3.885139338}, /*cfy*/
          {-0.009308683736,2.331607906e-05,22.51636405,-0.2606562921,-0.001280893509,0.002650285001}, /*cmz*/
          {1.168287113,2.645628338,0.3507509239,0.7142451695} /*cfz*/
     },
     {
          2461369.5,
          {0.004319810226,3.146723131e-05,23.10820916,0.1791979697,-0.00133719756,0.003398643805}, /*cmx*/
          {3.624411018,1.901258265,2.083817207,1.074234998}, /*cfx*/
          {-0.003959716698,-1.632670726e-05,9.078830644,0.06028574917,0.000680467822,-0.001744002501}, /*cmy*/
          {5.647832119,-0.7871940592,-9.918907876,0.1913158857}, /*cfy*/
          {-0.008434326378,1.534512427e-05,22.07214498,-0.2089802374,-0.001649941395,0.003056638367}, /*cmz*/
          {5.128734767,0.3344804837,3.612983302,2.547965265} /*cfz*/
     },
     {
          2461409.5,
          {0.005365277972,-3.287271556e-05,22.52922506,0.06556051452,-0.002054059911,0.002964081776}, /*cmx*/
          {1.493796715,6.134575768,-0.2410937197,3.468753483}, /*cfx*/
          {-0.004492222175,2.447632866e-05,10.39205534,0.005684755044,0.0009244970095,-0.001367779697}, /*cmy*/
          {3.68798786,2.566281973,0.5033164633,2.339389848}, /*cfy*/
          {-0.007023639284,-3.851041799e-05,22.00968963,-0.06657257475,-0.002482443336,0.003005416111}, /*cmz*/
          {2.957930202,4.610234653,1.381292525,4.855315249} /*cfz*/
     },
     {
          2461449.5,
          {0.005031734288,-6.278428615e-05,22.88147622,-0.1188716765,0.001348725603,0.004383775753}, /*cmx*/
          {5.888732299,4.182595083,4.158358852,6.095235422}, /*cfx*/
          {-0.00341434849,1.988428611e-05,9.078867901,0.08365820293,-0.0008764725828,-0.0009368325335}, /*cmy*/
          {1.763086914,-13.70202114,4.662664864,5.416412167}, /*cfy*/
          {-0.009474206326,-1.250183529e-05,22.28977394,0.1545539125,0.001697402494,0.004033634068}, /*cmz*/
          {1.099731164,2.660613254,5.735276705,1.21867871} /*cfz*/
     },
     {
          2461489.5,
          {0.002294676871,2.920996221e-06,23.31196136,0.02088537318,0.001701474474,0.003535740271}, /*cmx*/
          {4.088015654,2.880125741,2.279098944,2.001391707}, /*cfx*/
          {-0.0027481541,-1.453726953e-05,7.28803985,-0.02248376949,-0.0007437816652,-0.001048572699}, /*cmy*/
          {5.980753838,57.96132164,3.0583726,1.051445725}, /*cfy*/
          {-0.009292759625,5.354208762e-06,22.40488231,-0.01371972511,0.002055385601,0.003749655761}, /*cmz*/
          {5.62670947,1.16497183,3.83310945,3.54465071} /*cfz*/
     },
     {
          2461529.5,
          {0.003590897528,3.55391521e-05,23.18100585,-0.1524153944,0.001105751428,0.003123657281}, /*cmx*/
          {2.032585639,-2.712867382,-0.6538153219,4.300055096}, /*cfx*/
          {-0.003681692875,-3.03026813e-05,8.569341715,-0.06384091535,-0.0006523101107,-0.001084087892}, /*cmy*/
          {3.992551419,19.59049312,5.72423609,3.047122874}, /*cfy*/
          {-0.009078064532,3.594357681e-05,22.08446964,-0.1758690781,0.001308926175,0.003177470196}, /*cmz*/
          {3.550332811,-1.194929966,0.9664147919,5.811290761} /*cfz*/
     },
     {
          2461569.5,
          {0.005160227826,4.165233533e-05,22.43868724,-0.2088240134,0.001303658225,0.002802936489}, /*cmx*/
          {-0.1864943655,1.261678478,2.975744314,-0.09802513249}, /*cfx*/
          {-0.004924044565,-2.33478468e-05,11.30982087,-0.09657408212,-0.00101627318,-0.001718453426}, /*cmy*/
          {1.966138091,4.498282217,2.869876215,5.126066982}, /*cfy*/
          {-0.006999478043,7.044427348e-05,21.62737513,-0.2513696894,0.00150048757,0.002822048827}, /*cmz*/
          {1.257448449,2.805745046,4.468410197,1.318927851} /*cfz*/
     },
     {
          2461609.5,
          {0.006954022448,2.448221219e-05,21.03159395,-0.2478370061,0.001576604276,0.0029713749}, /*cmx*/
          {3.781378018,5.199019067,0.5931021862,1.806947534}, /*cfx*/
          {-0.006011785148,-1.392251401e-06,13.87712419,-0.126963411,-0.001229455056,-0.002403908756}, /*cmy*/
          {-0.194967554,1.830179526,0.1011792057,0.9868481055}, /*cfy*/
          {-0.00467844351,9.909792942e-05,21.5530845,-0.2907571791,0.00180075189,0.003308682326}, /*cmz*/
          {5.139638012,0.4555644939,1.915195668,3.157817359} /*cfz*/
     },
     {
          2461649.5,
          {0.00875751113,-7.848327657e-06,19.53668306,-0.2945821583,0.001949146429,0.002813808665}, /*cmx*/
          {1.356017955,2.838977216,4.457465904,3.72948835}, /*cfx*/
          {-0.006457989694,3.787957779e-05,15.10699742,-0.1532688046,-0.00149118022,-0.002647888119}, /*cmy*/
          {3.836129276,5.443918042,3.458091945,3.230318224}, /*cfy*/
          {-0.0001484780009,0.0001095115711,22.13563242,-0.312444465,0.002120606251,0.00335170385}, /*cmz*/
          {2.69252633,4.336247972,-0.5886128457,5.155025365} /*cfz*/
     },
     {
          2461689.5,
          {0.007913720432,-6.559501616e-05,19.24167522,-0.3485790772,0.002427981152,0.002429568616}, /*cmx*/
          {5.086509819,0.4385378679,1.818633229,5.289871695}, /*cfx*/
          {-0.00449554491,4.663687673e-05,14.16215808,-0.1562198633,-0.001926397355,-0.001859000674}, /*cmy*/
          {1.551429042,2.651777796,0.469626713,5.542131455}, /*cfy*/
          {0.004308868949,9.273112198e-05,23.02919954,-0.3252928145,0.002437376121,0.002824078997}, /*cmz*/
          {0.2383191929,1.871981704,3.194360677,0.6209424225} /*cfz*/
     },
     {
          2461729.5,
          {0.006621089615,-0.000110894092,21.07232174,-0.3690907103,0.002919722165,0.003507978889}, /*cmx*/
          {2.491965025,4.227157945,5.352767124,0.6443797434}, /*cfx*/
          {-0.00313688718,2.038054906e-05,10.38672918,-0.1470149727,-0.001995856989,-0.0007639382327}, /*cmy*/
          {5.645453908,-0.4658311952,3.679051134,2.091510069}, /*cfy*/
          {0.007859756699,5.045859673e-05,23.46131652,-0.3385831488,0.002656273782,0.003309068085}, /*cmz*/
          {4.065088224,5.628896868,0.6787789115,2.249103936} /*cfz*/
     },
     {
          2461769.5,
          {0.001480941722,-0.0001215403406,23.17954178,-0.3361934176,0.002788654578,0.003891479203}, /*cmx*/
          {-0.02361655809,1.614683836,2.746783929,2.661122543}, /*cfx*/
          {-0.001969694207,-4.577684407e-05,6.156882569,-0.1471643794,-0.001947776562,-0.0005434970676}, /*cmy*/
          {4.038787102,2.640566797,0.4491067882,5.101071927}, /*cfy*/
          {0.01063595696,-2.064499011e-05,22.95433,-0.3573226092,0.002702008249,0.003672525687}, /*cmz*/
          {1.582241808,3.076694443,4.413408639,4.179393886} /*cfz*/
     },
     {
          2461809.5,
          {-0.002671574807,-9.440830804e-05,23.187571,-0.3098790254,0.002305722482,0.003101081894}, /*cmx*/
          {3.818116657,5.277893525,0.2838251211,4.581899971}, /*cfx*/
          {-0.00429445958,-4.410445719e-05,9.014122068,-0.137239024,-0.001912706358,-0.0009926323995}, /*cmy*/
          {2.63844158,-0.5324292974,3.703194019,0.1958788795}, /*cfy*/
          {0.008960149367,-8.820524538e-05,21.96589959,-0.3730727941,0.00263137964,0.00291966289}, /*cmz*/
          {5.329836957,0.5450002725,1.824567851,-0.3023522721} /*cfz*/
     },
     {
          2461849.5,
          {-0.006092615114,-5.422239982e-05,21.41280037,-0.3125446788,0.002073559059,0.002758075521}, /*cmx*/
          {1.375794273,2.763710599,4.179940321,-0.07901880088}, /*cfx*/
          {-0.005690098319,-1.545102266e-05,13.27071835,-0.1525681581,-0.001702470438,-0.002043340334}, /*cmy*/
          {0.5195442075,2.648173457,0.7269637903,2.065854069}, /*cfy*/
          {0.006336640787,-0.0001258629507,21.60553658,-0.370809068,0.002540519875,0.003159708167}, /*cmz*/
          {2.755400267,4.325794163,5.524151666,1.204458449} /*cfz*/
     },
     {
          2461889.5,
          {-0.008572589843,-1.08152741e-05,19.53704175,-0.3332991774,0.002094139886,0.003013274893}, /*cmx*/
          {5.141724102,0.326925721,1.720458709,1.74269669}, /*cfx*/
          {-0.006722229249,3.233836401e-05,14.98123859,-0.166375769,-0.001667051753,-0.002646402106}, /*cmy*/
          {4.50562468,-0.2081036917,3.953910407,4.264777641}, /*cfy*/
          {0.0008171582487,-0.0001282809282,22.26987946,-0.3498106953,0.002420391533,0.003812568626}, /*cmz*/
          {0.2056708499,1.831559569,2.995165035,3.131340253} /*cfz*/
     },
     {
          2461929.5,
          {-0.007923297433,4.560340154e-05,19.37759762,-0.3483991875,0.002234166569,0.002595973927}, /*cmx*/
          {2.545848373,4.184277288,5.384057869,3.508788775}, /*cfx*/
          {-0.004459670818,3.910223915e-05,13.79942102,-0.147305189,-0.001718894158,-0.00221473098}, /*cmy*/
          {2.207837824,3.216007067,0.9911695976,0.2798112786}, /*cfy*/
          {-0.004120686465,-9.808448527e-05,23.16951772,-0.323893178,0.002235825978,0.003363338021}, /*cmz*/
          {4.00468752,5.6137158,0.5187825882,5.079846011} /*cfz*/
     },
     {
          2461969.5,
          {-0.006409069586,8.165614728e-05,21.22747723,-0.326363235,0.002255708771,0.00303940011}, /*cmx*/
          {-0.009917665709,1.718128623,2.773134788,5.089085159}, /*cfx*/
          {-0.003372763249,1.669758705e-05,10.07287267,-0.1240388184,-0.00145388792,-0.001313270465}, /*cmy*/
          {0.05421066423,0.169703419,4.313411144,2.835908744}, /*cfy*/
          {-0.007684374455,-5.335402667e-05,23.46512606,-0.304599664,0.002000010481,0.003111474681}, /*cmz*/
          {1.572765194,3.118435371,4.359342519,0.5256202957} /*cfz*/
     },
     {
          2462009.5,
          {-0.002478874971,8.672345348e-05,23.06373307,-0.2797093305,0.00190234511,0.00374588252}, /*cmx*/
          {3.836927972,5.488425832,0.2770239394,0.7897541505}, /*cfx*/
          {-0.002058641712,-2.532923505e-05,6.359162822,-0.111980658,-0.001209278004,-0.0009237399591}, /*cmy*/
          {4.658634047,3.457132142,1.297499762,5.687116712}, /*cfy*/
          {-0.010206492,-5.309044968e-06,23.01657248,-0.2934195409,0.001745972252,0.003462854915}, /*cmz*/
          {5.445969693,0.6571798071,1.915311374,2.409185178} /*cfz*/
     },
     {
          2462049.5,
          {0.001341552355,6.728937946e-05,23.42385976,-0.2431310523,0.001419627286,0.003664569183}, /*cmx*/
          {1.490906511,2.996422546,4.122494529,2.902194086}, /*cfx*/
          {-0.003655418149,-3.486467785e-05,7.57166836,-0.09604533623,-0.001018101648,-0.001224949755}, /*cmy*/
          {3.262809115,0.5384676272,4.726501505,1.775613084}, /*cfy*/
          {-0.00977128137,3.305979975e-05,22.26753373,-0.2823500119,0.001486542473,0.003250734932}, /*cmz*/
          {3.039198735,4.530378482,-0.5774164314,4.414969777} /*cfz*/
     },
     {
          2462089.5,
          {0.004100326166,4.454346389e-05,22.54927208,-0.218745452,0.001028060687,0.003091889772}, /*cmx*/
          {5.473602871,0.5910595975,1.553873321,4.896741464}, /*cfx*/
          {-0.004717209114,-2.456523514e-05,10.8852314,-0.08735580918,-0.0007282824631,-0.001693264779}, /*cmy*/
          {1.350038773,3.948398656,1.89371097,3.907555589}, /*cfy*/
          {-0.008618661452,5.417044663e-05,21.80410845,-0.2597575764,0.001246960457,0.002839920487}, /*cmz*/
          {0.6452564676,2.171168456,3.052676576,-0.02897203823} /*cfz*/
     },
     {
          2462129.5,
          {0.006756859184,2.095304521e-05,21.2993668,-0.1866561888,0.001214744166,0.003315437744}, /*cmx*/
          {3.206547472,4.569207691,4.801748754,0.5556256729}, /*cfx*/
          {-0.006290052468,-5.412141539e-06,13.10621541,-0.07767945327,-0.0005859695441,-0.002174205693}, /*cmy*/
          {5.541558987,1.280997329,4.889151295,-0.1520245593}, /*cfy*/
          {-0.006401468015,4.302587582e-05,21.8651078,-0.2119666646,0.001486950067,0.003403150447}, /*cmz*/
          {4.593862217,-0.1338189231,0.1007858298,1.864482503} /*cfz*/
     },
     {
          2462169.5,
          {0.007566754914,-1.912752406e-05,20.45664583,-0.08818956015,0.002230184639,0.003121737644}, /*cmx*/
          {1.032869752,2.461467458,2.393721933,2.898553646}, /*cfx*/
          {-0.006457137811,8.141746724e-06,13.90213263,-0.03506930691,-0.0008217642622,-0.002055183171}, /*cmy*/
          {3.471889873,5.198301027,2.343570161,2.145486211}, /*cfy*/
          {-0.004111894993,-3.288842511e-05,22.11518677,-0.0935107885,0.002464576043,0.003323614261}, /*cmz*/
          {2.403457795,4.017109808,4.017528577,4.271062462} /*cfz*/
     },
     {
          2462209.5,
          {0.00838950926,-5.852666449e-05,20.68527452,0.1225075642,-0.0008886780332,0.004157958548}, /*cmx*/
          {5.3996956,0.4723527616,0.4319102779,5.503232714}, /*cfx*/
          {-0.006808023607,2.870082869e-05,13.59122298,-0.04527074958,0.0006018996466,-0.00205743304}, /*cmy*/
          {1.544102728,7.121017431,0.3112817693,4.84097389}, /*cfy*/
          {-0.006148310564,-4.974588547e-05,22.12943782,0.1420810786,-0.001070825063,0.004982898571}, /*cmz*/
          {0.4955859514,2.165871173,1.980563159,0.5412512593} /*cfz*/
     },
     {
          2462249.5,
          {0.005152859692,2.976170404e-06,21.61759631,0.0199430133,-0.001988157236,0.003570536731}, /*cmx*/
          {3.644833112,4.346267982,4.931186393,1.439736363}, /*cfx*/
          {-0.005539532905,-3.047209889e-06,12.54920701,0.02088819191,0.0007605539063,-0.002120341527}, /*cmy*/
          {5.937339339,10.4756651,4.991550677,0.6779448702}, /*cfy*/
          {-0.007818962452,1.396123665e-05,21.76976231,0.01770707136,-0.002333520901,0.003729580276}, /*cmz*/
          {5.047468542,0.4693044146,0.2548447232,2.915550531} /*cfz*/
     },
     {
          2462289.5,
          {0.00589848652,4.141171179e-05,21.451811,-0.1421744016,-0.001311454684,0.003055170167}, /*cmx*/
          {1.61917533,-3.182867352,2.240355058,3.735215365}, /*cfx*/
          {-0.006293767033,-1.733935249e-05,13.19405177,-0.07925345416,-0.0007538527303,-0.001943677702}, /*cmy*/
          {3.890359817,-6.544815061,36.26821335,2.853174019}, /*cfy*/
          {-0.007235675771,6.692846644e-05,21.5305743,0.1698590428,-0.001398631892,0.003234816074}, /*cmz*/
          {3.000494001,7.745086349,3.724131839,5.199278635} /*cfz*/
     },
     {
          2462329.5,
          {0.0071118385,3.863925068e-05,20.39003016,-0.2263690015,-0.001548745581,0.00279206584}, /*cmx*/
          {5.650774946,0.8200935691,-0.4493691239,5.499448162}, /*cfx*/
          {-0.006585166167,5.349772689e-06,14.6175225,-0.1225899688,-0.001105943261,-0.002152482272}, /*cmy*/
          {1.72878652,3.580776109,1.917463982,4.792864252}, /*cfy*/
          {-0.004370216506,0.0001022505321,21.66053792,0.258218373,-0.001624226973,0.003053505622}, /*cmz*/
          {0.7022496403,5.47367166,0.8248331939,0.6123010779} /*cfz*/
     },
     {
          2462369.5,
          {0.008510519007,8.606266276e-06,19.30508429,-0.2944270409,-0.002003914375,0.003380175135}, /*cmx*/
          {3.233569931,4.765335146,3.266712737,1.003700197}, /*cfx*/
          {-0.007000810331,3.37555279e-05,15.09270709,-0.1506883384,-0.001513903227,-0.002537504306}, /*cmy*/
          {5.76604306,0.9656359383,-1.050690796,0.4950351096}, /*cfy*/
          {-0.001112249671,0.0001199614451,22.34127011,0.2998151602,-0.002059340991,0.003652186702}, /*cmz*/
          {4.583036478,3.094923428,4.507342483,2.461569552} /*cfz*/
     },
     {
          2462409.5,
          {0.009278142381,-5.060318343e-05,19.59480841,-0.3547503498,-0.002547662531,0.003566457668}, /*cmx*/
          {0.6786893088,2.354412358,0.532368716,2.97736194}, /*cfx*/
          {-0.004639276734,5.281651513e-05,13.40560767,-0.1516374749,-0.001968206348,-0.002300067605}, /*cmy*/
          {3.496295917,4.406370443,2.240729852,2.748181707}, /*cfy*/
          {0.004306340676,0.0001110784168,23.18529632,0.3219421234,-0.002446810075,0.003614311874}, /*cmz*/
          {2.147515755,0.6310039615,1.978056303,4.447900591} /*cfz*/
     },
     {
          2462449.5,
          {0.006123844791,-9.764662169e-05,21.73310572,-0.3641014898,-0.002951338629,0.00297508388}, /*cmx*/
          {4.386371043,-0.170998908,4.075181519,4.683323612}, /*cfx*/
          {-0.003467606563,2.138034377e-06,8.993077259,-0.1479517882,-0.001960953568,-0.001590414561}, /*cmy*/
          {1.381594483,1.243257856,-0.8920391943,5.430259131}, /*cfy*/
          {0.007896085514,6.12538334e-05,23.43209547,0.3404967593,-0.0026769247,0.00299784549}, /*cmz*/
          {-0.3062094147,4.382716626,-0.5542124862,-0.1281608417} /*cfz*/
     },
     {
          2462489.5,
          {0.002727371065,-0.0001160951069,23.41112258,-0.3278709315,-0.002650121853,0.003323914376}, /*cmx*/
          {1.893845321,3.484533515,1.504993989,0.01767090593}, /*cfx*/
          {-0.002135114453,-4.433244681e-05,6.042448393,-0.1447175597,-0.001958627655,-0.001627003069}, /*cmy*/
          {6.294090639,4.370555203,2.192935002,2.106230645}, /*cfy*/
          {0.01048723016,-9.157459037e-06,22.7445254,0.3614362982,-0.002700032902,0.003534423983}, /*cmz*/
          {3.485690432,1.831809942,3.160486332,1.459207661} /*cfz*/
     },
     {
          2462529.5,
          {-0.002802894988,-8.961255115e-05,22.88235479,-0.3078763041,-0.002205672897,0.003524670857}, /*cmx*/
          {5.742250929,0.8909936793,5.357787646,1.981441995}, /*cfx*/
          {-0.005059115764,-4.941779851e-05,10.15804141,-0.138859265,-0.001863229789,-0.001863284175}, /*cmy*/
          {4.669662684,1.188946907,-0.7923948229,4.409405019}, /*cfy*/
          {0.009942338672,-8.002455314e-05,21.78573499,0.374144862,-0.002609523933,0.003843594564}, /*cmz*/
          {0.9387086136,5.589610301,0.5630290221,3.415326469} /*cfz*/
     },
     {
          2462569.5,
          {-0.006242925246,-5.586689835e-05,20.95896211,-0.3152843374,-0.002063571048,0.002698734511}, /*cmx*/
          {3.289110839,4.687133927,2.974635392,3.834567731}, /*cfx*/
          {-0.006243476218,-6.414880651e-06,13.9173674,-0.1585082377,-0.001665085511,-0.001725988611}, /*cmy*/
          {2.472536948,4.44306215,2.502097152,-0.05756683952}, /*cfy*/
          {0.00588522446,-0.0001149102312,21.64619705,0.3664475765,-0.002498445203,0.003152421776}, /*cmz*/
          {4.647577061,3.091308869,4.27470099,5.23093172} /*cfz*/
     },
     {
          2462609.5,
          {-0.008557484848,-8.024443486e-06,19.36205968,-0.3379350768,-0.002132747874,0.002839417798}, /*cmx*/
          {0.7529003515,2.257783127,0.4784254799,-0.9671247403}, /*cfx*/
          {-0.007094926029,3.484471202e-05,14.95478887,-0.1655014596,-0.0016950215,-0.002054703964}, /*cmy*/
          {0.1612052784,1.621978194,-0.5377100372,1.643509882}, /*cfy*/
          {0.001581859638,-0.0001202794708,22.44210347,0.3428604389,-0.002362466831,0.003392192547}, /*cmz*/
          {2.111645726,0.5987428741,1.766483842,0.5515145973} /*cfz*/
     },
     {
          2462649.5,
          {-0.009556514834,5.173818713e-05,19.70317575,-0.3480106006,-0.002279848954,0.003586898856}, /*cmx*/
          {4.43899337,-0.1760496359,4.13061172,0.908961518}, /*cfx*/
          {-0.005048499991,5.221717361e-05,13.13878706,-0.1419409143,-0.001703357369,-0.00214134998}, /*cmy*/
          {4.15991675,5.013862457,2.807151589,3.800430561}, /*cfy*/
          {-0.004215155069,-9.481302599e-05,23.27742918,0.3182601519,-0.002188951373,0.003858998151}, /*cmz*/
          {-0.3584003807,4.384140772,5.59484652,2.490653661} /*cfz*/
     },
     {
          2462689.5,
          {-0.006851852746,8.982372039e-05,21.72012275,-0.3200215018,-0.002244712947,0.003480795282}, /*cmx*/
          {1.904996604,3.626288093,1.548088616,2.82193748}, /*cfx*/
          {-0.003453863541,1.377409293e-05,9.042238816,-0.1228803228,-0.001436009615,-0.00165805021}, /*cmy*/
          {2.066050349,1.952583792,-0.1764693396,6.405510645}, /*cfy*/
          {-0.007954272162,-5.127451355e-05,23.42930923,0.3030863377,-0.001998502629,0.003401958579}, /*cmz*/
          {3.499395573,1.894665331,3.166252641,4.448309439} /*cfz*/
     },
     {
          2462729.5,
          {-0.003935711395,0.000100440377,23.28228973,-0.2764698112,-0.00188631025,0.003496919063}, /*cmx*/
          {5.768252212,1.106563238,5.373505815,4.636438306}, /*cfx*/
          {-0.002686845276,-2.258929579e-05,6.056615491,-0.1120999273,-0.001270170178,-0.001542901196}, /*cmy*/
          {0.5434981122,-1.031756022,3.114783663,3.147479494}, /*cfy*/
          {-0.01030993899,-2.364804297e-06,22.87072232,0.2973202837,-0.00181232273,0.003250024355}, /*cmz*/
          {1.086033242,5.72007681,0.7378387216,-0.1074381618} /*cfz*/
     },
     {
          2462769.5,
          {0.0004032559312,8.991430043e-05,23.28539056,-0.2486806553,-0.001498009084,0.003787485478}, /*cmx*/
          {3.420961039,4.902261265,3.009927568,0.3134490092}, /*cfx*/
          {-0.003816363672,-4.143853144e-05,8.438259426,-0.1011766149,-0.001149818486,-0.001840369444}, /*cmy*/
          {5.326703224,2.303406865,0.3006929747,5.725086813}, /*cfy*/
          {-0.01095528805,4.273104657e-05,22.08866494,0.2934815812,-0.001643409734,0.003577008015}, /*cmz*/
          {4.946587159,3.305017259,4.580955837,1.7697747} /*cfz*/
     },
     {
          2462809.5,
          {0.003722088322,7.46655427e-05,22.11313277,-0.2385073179,-0.001229273422,0.00344601506}, /*cmx*/
          {1.0952014,2.494080099,0.6667561638,2.368418332}, /*cfx*/
          {-0.0056181556,-2.93712494e-05,11.92688073,-0.1035913047,-0.0009701654411,-0.001936028726}, /*cmy*/
          {3.312885056,-0.5800523062,3.83517734,1.599976734}, /*cfy*/
          {-0.008976264437,7.715340185e-05,21.68254714,0.2838464274,-0.001486067884,0.003392739098}, /*cmz*/
          {2.518414791,0.926185706,2.111148407,3.738336932} /*cfz*/
     },
     {
          2462849.5,
          {0.006291026188,4.913260909e-05,20.58957869,-0.2345461231,-0.001029274025,0.002945714446}, /*cmx*/
          {5.03948241,0.1556251948,4.449610645,4.274054752}, /*cfx*/
          {-0.006594785584,-9.356502125e-06,14.07643871,-0.1087005863,-0.0007655589571,-0.002056339599}, /*cmy*/
          {1.147012358,3.010729432,0.9996389521,3.56488399}, /*cfy*/
          {-0.006520367515,8.745196175e-05,21.9082686,0.2622643363,-0.001308595728,0.003274090778}, /*cmz*/
          {0.114810144,4.854019997,-0.4406276224,5.575430889} /*cfz*/
     },
     {
          2462889.5,
          {0.008613097439,2.562894217e-05,19.5237023,-0.2169485085,-0.001121301882,0.003263267307}, /*cmx*/
          {2.690322024,4.148824163,1.477151918,-0.1113304263}, /*cfx*/
          {-0.007141027178,8.331460612e-06,14.69556987,-0.09693885138,-0.0005776650008,-0.002261450095}, /*cmy*/
          {5.247241991,0.4650723824,4.219944752,5.631801506}, /*cfy*/
          {-0.002889269083,6.812765925e-05,22.49893069,0.2226165572,-0.001258333541,0.00389133828}, /*cmz*/
          {4.059344202,2.519814553,3.013252828,1.224301535} /*cfz*/
     },
     {
          2462929.5,
          {0.008790513223,1.002832971e-05,19.25629772,-0.1434695877,-0.002326601043,0.003238064489}, /*cmx*/
          {0.4145957697,1.941648156,5.094146995,2.226125003}, /*cfx*/
          {-0.006257577353,-5.451053069e-06,14.31697095,-0.06279232774,-0.0007388895071,-0.002350582374}, /*cmy*/
          {3.121059044,4.409488681,1.046756065,1.684532298}, /*cfy*/
          {0.0002521147914,3.574145379e-06,22.95453719,0.142490242,-0.002111069591,0.003835699473}, /*cmz*/
          {1.834430219,0.2682314239,0.3106132511,3.566663826} /*cfz*/
     },
     {
          2462969.5,
          {0.01027496353,-1.613979003e-06,19.24390778,0.09006843346,-0.0004563290884,0.004052578617}, /*cmx*/
          {4.676807716,-0.02084044806,3.473005956,4.614405161}, /*cfx*/
          {-0.006484097468,-2.852916356e-05,14.24131131,0.02221208302,-0.0001830647921,-0.002906705859}, /*cmy*/
          {1.111562332,7.650317216,6.226085888,3.987995166}, /*cfy*/
          {0.0006102737642,-7.369408387e-05,22.96239389,-0.06782943507,-0.0004962606522,0.005217204379}, /*cmz*/
          {6.101565696,4.682338976,5.121226274,6.129686372} /*cfz*/
     },
     {
          2463009.5,
          {0.008140757823,-1.598986688e-06,19.38557808,0.08263055702,-0.002656703332,0.003283595058}, /*cmx*/
          {2.982453641,4.431708559,29.60188834,0.7673816706}, /*cfx*/
          {-0.006918407516,-8.779040793e-06,14.97407306,0.01359895597,-0.00103912657,-0.002502134046}, /*cmy*/
          {5.514682168,5.895066128,6.886084131,0.1435897432}, /*cfy*/
          {-0.002368601741,-2.331915395e-05,22.35540799,-0.06645514471,-0.002565136963,0.003635047852}, /*cmz*/
          {4.335805108,2.988749545,5.996787595,2.142155462} /*cfz*/
     },
     {
          2463049.5,
          {0.008749399838,2.180443225e-05,19.40760163,-0.1352468611,-0.001787461375,0.002891728483}, /*cmx*/
          {1.026318349,2.61566045,1.923151349,3.025503139}, /*cfx*/
          {-0.007433719018,1.291084939e-05,15.18678864,-0.08307496118,-0.0008697355481,-0.00241061958}, /*cmy*/
          {3.51320375,-1.126032229,3.890728004,2.491106817}, /*cfy*/
          {-0.002397881343,6.311978881e-05,22.1269242,0.1464643771,-0.001569487145,0.003137395519}, /*cmz*/
          {2.36087059,0.912498882,3.300261974,4.466154652} /*cfz*/
     },
     {
          2463089.5,
          {0.008817102923,3.902766479e-07,19.23325386,-0.267396294,-0.001908953142,0.002915994709}, /*cmx*/
          {4.995881326,0.3332742807,-1.032128324,4.619307182}, /*cfx*/
          {-0.006189969409,3.941922845e-05,14.63312541,-0.1307313587,-0.001393748451,-0.001721395678}, /*cmy*/
          {1.34374728,2.621283321,0.6450097052,4.535745269}, /*cfy*/
          {0.0006248383007,9.574843259e-05,22.6841816,0.2555197446,-0.001815341639,0.003147194728}, /*cmz*/
          {0.1020522175,4.915140575,0.2541437113,-0.1480925863} /*cfz*/
     },
     {
          2463129.5,
          {0.009623998419,-4.969455721e-05,20.28373345,-0.3417635129,-0.002499889148,0.004027963006}, /*cmx*/
          {2.492071586,4.212062257,2.363980228,0.2050141295}, /*cfx*/
          {-0.005183015788,4.772703099e-05,12.0204673,-0.1408256743,-0.001860203127,-0.0009567933612}, /*cmy*/
          {5.418466272,-0.26655863,3.909342991,0.05744747919}, /*cfy*/
          {0.004362616713,9.278702088e-05,23.34596905,0.3045525487,-0.002324416659,0.003924048775}, /*cmz*/
          {4.007311193,2.479067648,3.895368579,1.747368348} /*cfz*/
     },
     {
          2463169.5,
          {0.006756860599,-0.0001083965715,22.46949575,-0.3437386721,-0.002781407612,0.003976048224}, /*cmx*/
          {-0.03017109759,1.669717011,-0.349050101,2.203420497}, /*cfx*/
          {-0.002377403158,-7.112620146e-06,7.27129703,-0.1465802954,-0.001875858275,-0.0006556588699}, /*cmy*/
          {3.472568025,2.879983424,0.7333101803,2.132176611}, /*cfy*/
          {0.009238958134,4.52844889e-05,23.32882653,0.3350820891,-0.002577484478,0.003888446651}, /*cmz*/
          {1.573012755,-0.04172763058,1.330237374,3.722920302} /*cfz*/
     },
     {
          2463209.5,
          {0.00271388251,-0.0001173379234,23.47888735,-0.3132373499,-0.002419231468,0.003238165003}, /*cmx*/
          {3.79751707,5.338092813,3.411626385,4.0015304}, /*cfx*/
          {-0.003521989912,-4.155427742e-05,6.7405794,-0.1399642695,-0.00191211554,-0.001275151693}, /*cmy*/
          {2.263978101,-0.2390887616,3.909957715,5.379082116}, /*cfy*/
          {0.01048421876,-2.570540615e-05,22.46845072,0.3588784962,-0.00258839097,0.003124839714}, /*cmz*/
          {5.365382921,3.706854419,5.03377937,5.44045641} /*cfz*/
     },
     {
          2463249.5,
          {-0.002004085927,-9.818632811e-05,22.45706763,-0.3029282512,-0.002082810162,0.003302335809}, /*cmx*/
          {1.374187265,2.787042164,1.012180249,-0.5930470868}, /*cfx*/
          {-0.00487237596,-4.507512448e-05,11.39392941,-0.1420284345,-0.001767364746,-0.00242766995}, /*cmy*/
          {0.3831421115,2.8968917,0.9688279676,1.543046412}, /*cfy*/
          {0.01057514446,-8.882923446e-05,21.61271256,0.3679525505,-0.002505894514,0.003598391135}, /*cmz*/
          {2.816549419,1.1999852,2.445423599,0.757504294} /*cfz*/
     },
     {
          2463289.5,
          {-0.006489528828,-6.658011999e-05,20.50892644,-0.3158566646,-0.002025005689,0.003259972113}, /*cmx*/
          {5.195896125,0.3274845773,4.906119017,1.311655732}, /*cfx*/
          {-0.007586176327,2.059636758e-06,14.46513764,-0.162683134,-0.001614872492,-0.002834827754}, /*cmy*/
          {4.41713341,-0.03966837852,4.259837201,3.78698172}, /*cfy*/
          {0.006681930287,-0.0001270415134,21.71924345,0.3565131439,-0.002409181032,0.003931503179}, /*cmz*/
          {0.2539840887,4.997853061,-0.104264285,2.697342012} /*cfz*/
     },
     {
          2463329.5,
          {-0.008683980711,-1.503981098e-05,19.27897875,-0.3387078922,-0.002136629498,0.002666144709}, /*cmx*/
          {2.646780469,4.18954903,2.383813874,2.971753552}, /*cfx*/
          {-0.006722242466,4.278926563e-05,14.80760504,-0.1617414264,-0.001689194288,-0.002194043635}, /*cmy*/
          {2.102655978,3.448331083,1.258597301,5.90857817}, /*cfy*/
          {0.001822915882,-0.0001339852063,22.61140063,0.3328987666,-0.002281474391,0.003386313088}, /*cmz*/
          {4.022747158,2.512508504,3.692200276,4.507247135} /*cfz*/
     },
     {
          2463369.5,
          {-0.009821143433,4.146535539e-05,20.07532873,-0.3430733773,-0.00228521108,0.00348453713}, /*cmx*/
          {0.05915812249,1.751044846,-0.2473003951,4.538337779}, /*cfx*/
          {-0.00584652113,5.08998637e-05,12.4032774,-0.1361900174,-0.001641234519,-0.001328996403}, /*cmy*/
          {-0.1590932373,0.5264010522,4.622501448,1.674930347}, /*cfy*/
          {-0.002912893151,-0.0001144394746,23.36088297,0.3114881047,-0.002123191894,0.003575916462}, /*cmz*/
          {1.570237472,0.02062845735,1.251493991,-0.07578839566} /*cfz*/
     },
     {
          2463409.5,
          {-0.00805394983,8.70757468e-05,22.13447157,-0.3114159008,-0.00219921384,0.004160234349}, /*cmx*/
          {3.834270776,5.544855031,3.481139754,0.2636233845}, /*cfx*/
          {-0.002889338242,1.095226019e-05,8.112971212,-0.1208586219,-0.001393891,-0.0008081549649}, /*cmy*/
          {4.106328142,3.754779385,1.627887435,3.974019823}, /*cfy*/
          {-0.007762838726,-7.124539963e-05,23.37600191,0.3002280466,-0.001966154877,0.003875661975}, /*cmz*/
          {5.436309347,3.82203642,5.119460897,1.879531007} /*cfz*/
     },
     {
          2463449.5,
          {-0.004469605158,9.773774973e-05,23.40395792,-0.2720946236,-0.001845433984,0.003784417339}, /*cmx*/
          {1.430946475,3.025971084,1.053406442,2.260911394}, /*cfx*/
          {-0.003173174525,-2.777128482e-05,6.10943005,-0.110568599,-0.001286358298,-0.001172102914}, /*cmy*/
          {2.704737494,0.7822611212,4.957810305,0.5631935737}, /*cfy*/
          {-0.009920480974,-2.257926491e-05,22.72427336,0.2984522443,-0.001837276373,0.003382772875}, /*cmz*/
          {3.022078606,1.371290659,2.704500539,3.784121704} /*cfz*/
     },
     {
          2463489.5,
          {-0.0008224652011,9.665139781e-05,23.12153124,-0.2516370073,-0.001535429942,0.003506752927}, /*cmx*/
          {5.367924681,0.547544142,5.009325094,4.121115578}, /*cfx*/
          {-0.003670123435,-4.662214532e-05,9.236453117,-0.1046145206,-0.001214242336,-0.001968074244}, /*cmy*/
          {1.073905487,4.105014731,2.167141007,3.062366221}, /*cfy*/
          {-0.01067949256,2.554411497e-05,21.93305922,0.2998539771,-0.001743910003,0.003296308035}, /*cmz*/
          {0.5897524874,5.239652286,0.2749212301,5.493205479} /*cfz*/
     },
     {
          2463529.5,
          {0.003253065478,8.155865051e-05,21.76140456,-0.2506993145,-0.001399774037,0.003495744605}, /*cmx*/
          {3.025312973,4.425761258,2.731801945,-0.1992508376}, /*cfx*/
          {-0.005906225212,-3.63306885e-05,12.6597534,-0.1146144111,-0.001116283365,-0.002405962296}, /*cmy*/
          {5.276728922,1.235397219,-0.5845658022,5.353139281}, /*cfy*/
          {-0.009521807437,6.6830004e-05,21.61072111,0.297446031,-0.001682965306,0.003696308956}, /*cmz*/
          {4.425154621,2.849456576,4.120817763,1.13088555} /*cfz*/
     },
     {
          2463569.5,
          {0.006499255477,5.613635407e-05,20.1599026,-0.2628354898,-0.001380208622,0.003051895504}, /*cmx*/
          {0.6410586694,2.073642585,0.394520846,1.757881041}, /*cfx*/
          {-0.006966192172,-1.871799083e-06,14.52816334,-0.1270624028,-0.001057870284,-0.002191984934}, /*cmy*/
          {3.068247126,4.818779885,2.871320501,1.193538415}, /*cfy*/
          {-0.006113034771,9.175771351e-05,21.99135139,0.2877482508,-0.001631904979,0.00355126948}, /*cmz*/
          {1.98844975,0.4662085627,1.683605739,3.085746708} /*cfz*/
     },
     {
          2463609.5,
          {0.008581257792,2.249420612e-05,19.2914005,-0.2759763328,-0.001384524348,0.002848518799}, /*cmx*/
          {4.479090425,-0.2591702894,4.175219609,3.483631904}, /*cfx*/
          {-0.007113323538,2.648962107e-05,14.5628004,-0.123095597,-0.001054045001,-0.001881734757}, /*cmy*/
          {0.83453909,2.178637661,0.04009100559,3.118303509}, /*cfy*/
          {-0.002513082055,9.504282083e-05,22.74932773,0.2710597672,-0.001529263317,0.003551567011}, /*cmz*/
          {-0.4101935474,4.359364465,5.523243902,4.924900067} /*cfz*/
     },
     {
          2463649.5,
          {0.009984844042,-1.027305145e-05,19.83455236,-0.2682268717,-0.001365356289,0.003411055437}, /*cmx*/
          {2.021007229,3.683659235,1.484266314,5.353747399}, /*cfx*/
          {-0.005863513522,3.909593739e-05,12.82807534,-0.1022260055,-0.0008363353772,-0.001726168112}, /*cmy*/
          {4.923996466,-0.5295675497,3.527862571,5.154018749}, /*cfy*/
          {0.002037639834,8.098603962e-05,23.33885995,0.2486502131,-0.001298595269,0.00398711819}, /*cmz*/
          {3.522235433,1.964811403,2.972329285,0.6235101618} /*cfz*/
     },
     {
          2463689.5,
          {0.008710018948,-2.679995451e-05,21.25518422,-0.2218040798,-0.001513045279,0.003597718826}, /*cmx*/
          {-0.353605465,1.332704842,4.825191374,1.235282747}, /*cfx*/
          {-0.004376861571,2.466223954e-05,10.01869407,-0.0772335122,0.0004768966047,-0.001686612959}, /*cmy*/
          {2.839557791,3.061199607,3.069900716,1.100944345}, /*cfy*/
          {0.005465644711,4.55010433e-05,23.48667015,0.213436173,-0.001301001443,0.004232232351}, /*cmz*/
          {1.227109675,-0.3987016974,-0.04564068862,2.844210417} /*cfz*/
     },
     {
          2463729.5,
          {0.00813469475,4.999882197e-06,22.23541393,-0.1080651394,-0.002355216589,0.0036476281}, /*cmx*/
          {3.717634169,5.376112128,2.296056621,3.365555278}, /*cfx*/
          {-0.003630715938,1.923031418e-05,7.787492029,-0.04181817462,0.001127155918,-0.001041452967}, /*cmy*/
          {0.8613223025,1.336091958,0.2738251335,3.608008816}, /*cfy*/
          {0.00717954127,7.22854945e-06,23.3724429,0.1131401718,-0.00216730068,0.003827521397}, /*cmz*/
          {5.318171932,3.715097327,3.690008137,4.966259453} /*cfz*/
     },
     {
          2463769.5,
          {0.006940389252,3.542366824e-05,22.10728162,0.1203318196,0.001471057774,0.002405584777}, /*cmx*/
          {1.774374654,3.637782966,0.4037895005,5.856255405}, /*cfx*/
          {-0.003387387167,-2.645906944e-06,7.922108975,0.09176294675,-0.0009082425791,-0.002118722248}, /*cmy*/
          {5.014011521,4.394915194,4.342425582,6.125881529}, /*cfy*/
          {0.007077198821,-3.348289633e-05,23.46797069,-0.09155392085,0.001227761731,0.00278428306}, /*cmz*/
          {3.356881781,1.8205186,1.794823384,1.449267178} /*cfz*/
     },
     {
          2463809.5,
          {0.009801090293,-1.536511532e-05,21.29156106,-0.04557894354,0.002359975944,0.00330942872}, /*cmx*/
          {6.252789858,1.830600798,4.580864567,2.101287153}, /*cfx*/
          {-0.003774579381,2.006292562e-05,9.822643884,-0.01951794048,-0.001150169067,-0.001732255671}, /*cmy*/
          {2.980004498,16.95549268,2.645164538,1.964475733}, /*cfy*/
          {0.005717231866,3.753180455e-05,23.39060409,0.04458290652,0.002137257516,0.003399075834}, /*cmz*/
          {1.516945076,6.477437507,5.968569922,3.501847904} /*cfz*/
     },
     {
          2463849.5,
          {0.008224738828,-6.182295193e-05,22.03637419,0.2351915493,0.001730885941,0.00331528079}, /*cmx*/
          {4.095761587,8.990145138,-5.065535102,3.775463261}, /*cfx*/
          {-0.00357409233,1.393404993e-05,8.033710681,0.09702434443,-0.001169371298,-0.001059287406}, /*cmy*/
          {1.052668148,4.008903899,17.98254779,4.807447307}, /*cfy*/
          {0.00664794786,6.465493922e-05,23.41497231,0.2144622673,0.001794913294,0.003458730207}, /*cmz*/
          {5.677500075,-58.69519611,2.881150558,5.284584029} /*cfz*/
     },
     {
          2463889.5,
          {0.00695306291,-0.000110707199,23.27011169,0.2813483881,0.002079904673,0.003912626825}, /*cmx*/
          {1.746945035,0.2401202301,4.667177357,5.71467165}, /*cfx*/
          {-0.002187441815,-2.12493479e-05,5.474556737,0.1274350636,-0.00153113092,-0.001057602398}, /*cmy*/
          {5.883306077,1.146385,2.223913682,1.481134816}, /*cfy*/
          {0.009291314817,3.994798356e-05,22.99756356,0.2961277339,0.00213480506,0.004117604229}, /*cmz*/
          {3.343763785,1.711422581,0.08708841882,0.9616314193} /*cfz*/
     },
     {
          2463929.5,
          {0.002177000777,-0.0001160908852,23.25341444,0.2814563125,0.001972548953,0.003741989323}, /*cmx*/
          {5.65390416,3.99643553,2.196374954,1.438012676}, /*cfx*/
          {-0.003773543457,-5.678786839e-05,8.574941954,0.1289501036,-0.001671570584,-0.001408496731}, /*cmy*/
          {4.437532853,4.428951078,-0.7117981663,3.638637036}, /*cfy*/
          {0.01102006805,-2.066266366e-05,22.05664612,0.3357575939,0.002258267735,0.003826250552}, /*cmz*/
          {0.8927394458,5.526497199,3.751506917,2.950587837} /*cfz*/
     },
     {
          2463969.5,
          {-0.001939381533,-0.0001029228056,21.83355718,0.2890773823,0.001882973048,0.003053865913}, /*cmx*/
          {3.258087163,1.521682358,-0.1776669691,3.251211468}, /*cfx*/
          {-0.005382303608,-4.155386214e-05,12.78686517,0.1431657591,-0.001577825027,-0.001914400148}, /*cmy*/
          {2.338354633,1.422480944,2.692644263,5.401838418}, /*cfy*/
          {0.009484900377,-7.294618266e-05,21.46464646,0.3475458762,0.002259758827,0.003126851771}, /*cmz*/
          {4.654670061,3.064262996,1.176971734,4.651376829} /*cfz*/
     },
     {
          2464009.5,
          {-0.0058402808,-7.553858055e-05,20.03294106,0.3106982511,0.001948348503,0.003209028413}, /*cmx*/
          {0.7972147224,5.383575382,3.694115055,4.912062503}, /*cfx*/
          {-0.007338480514,-2.898011538e-06,14.91195932,0.1613417865,-0.001533929583,-0.002690996823}, /*cmy*/
          {0.06211605586,4.88999825,-0.2733476579,1.066307338}, /*cfy*/
          {0.006991329552,-0.0001102691062,21.85682312,0.337200844,0.002218342871,0.003632078944}, /*cmz*/
          {2.127208406,0.6057748926,4.946649534,0.03466616557} /*cfz*/
     },
     {
          2464049.5,
          {-0.009192278954,-3.100672059e-05,19.29382356,0.3344586964,0.002095381941,0.003400308358}, /*cmx*/
          {4.530762831,2.973169793,1.139617228,0.5162883663}, /*cfx*/
          {-0.006961626467,4.319031098e-05,14.49901307,0.153640174,-0.001644187171,-0.002689295312}, /*cmy*/
          {4.042625273,2.119156226,3.062986038,3.302783914}, /*cfy*/
          {0.001805101287,-0.0001200101317,22.79522826,0.3176777487,0.002139877811,0.003861626234}, /*cmz*/
          {-0.3527302499,4.420642682,2.48854986,1.991439124} /*cfz*/
     },
     {
          2464089.5,
          {-0.009394922278,2.609882159e-05,20.50155549,0.3334131573,0.002228373606,0.003177900783}, /*cmx*/
          {1.965979316,0.5327808499,4.804458367,2.257917497}, /*cfx*/
          {-0.005136052786,4.087704502e-05,11.55459473,0.1295436698,-0.001556962139,-0.001878135775}, /*cmy*/
          {1.817601707,-0.822775667,0.1572901697,5.756958812}, /*cfy*/
          {-0.002852227969,-0.0001010894864,23.42101803,0.3020146537,0.002034824586,0.00339758281}, /*cmz*/
          {3.501118707,1.942647979,0.06290834906,3.856044072} /*cfz*/
     },
     {
          2464129.5,
          {-0.008731371128,7.036125529e-05,22.49723767,0.3002492806,0.002103877801,0.003701804206}, /*cmx*/
          {-0.5117411833,4.324797087,2.286938838,4.01937787}, /*cfx*/
          {-0.003336981945,1.445615548e-05,7.28791887,0.1177269775,-0.001355522048,-0.0011329651}, /*cmy*/
          {6.182688159,2.430070476,3.448510365,2.368033499}, /*cfy*/
          {-0.007041338409,-6.306266358e-05,23.2959514,0.2959747565,0.001924369131,0.003557971652}, /*cmz*/
          {1.095087504,-0.5274334386,3.938106677,-0.6733418303} /*cfz*/
     },
     {
          2464169.5,
          {-0.005106123298,8.993188541e-05,23.4613172,0.2667358458,0.001786831634,0.003981616864}, /*cmx*/
          {3.385444214,1.814572628,-0.1135806657,-0.2458938636}, /*cfx*/
          {-0.002707440757,-2.716614957e-05,6.444492549,0.108698456,-0.001294114029,-0.001174845928}, /*cmy*/
          {4.84639193,-0.5332013413,0.5327351449,5.001108799}, /*cfy*/
          {-0.01021227707,-1.818608306e-05,22.56686855,0.2984728827,0.001838117392,0.003720817431}, /*cmz*/
          {4.9653104,3.31272541,1.526023715,1.280241589} /*cfz*/
     },
     {
          2464209.5,
          {-0.001362714362,9.48756117e-05,22.93609011,0.2531512422,0.001561329533,0.003496348533}, /*cmx*/
          {1.041486963,5.632555933,3.866458652,1.750114225}, /*cfx*/
          {-0.004249974524,-4.085385145e-05,9.999710682,0.1079459709,-0.00125633802,-0.001573742385}, /*cmy*/
          {3.088224074,2.789779194,4.040525872,0.717558962}, /*cfy*/
          {-0.01062745118,2.925942925e-05,21.78559563,0.3034522802,0.001800107188,0.003237071315}, /*cmz*/
          {2.52617831,0.9002935507,5.387145579,3.14453709} /*cfz*/
     },
     {
          2464249.5,
          {0.002428351453,8.438912489e-05,21.44935688,0.2598116943,0.001529103485,0.003296169883}, /*cmx*/
          {4.968849066,3.231185552,1.603491122,3.577220239}, /*cfx*/
          {-0.005670830516,-2.781645149e-05,13.25162574,0.1236339829,-0.001209597059,-0.002267895311}, /*cmy*/
          {0.9607273777,-0.05868718371,1.267312326,2.714106158}, /*cfy*/
          {-0.009891337811,7.594112184e-05,21.55993307,0.3057127912,0.00181774488,0.003466763381}, /*cmz*/
          {0.06563154838,4.787293957,2.9515786,4.861615193} /*cfz*/
     },
     {
          2464289.5,
          {0.006366839076,6.317024723e-05,19.8613375,0.2831461449,0.001654525992,0.003306358387}, /*cmx*/
          {2.550433735,0.8686367075,5.542243569,5.498293879}, /*cfx*/
          {-0.007659988085,9.300723991e-06,14.78793373,0.1393209683,-0.001261127648,-0.00260281048}, /*cmy*/
          {5.007698822,3.51878124,4.671854571,4.868981239}, /*cfy*/
          {-0.007078944397,0.0001105822133,22.08154583,0.3026888185,0.001875881427,0.003960500516}, /*cmz*/
          {3.893936522,2.385096941,0.513753276,0.5276331262} /*cfz*/
     },
     {
          2464329.5,
          {0.008991463027,2.222515878e-05,19.31205125,0.3119747316,0.00187413095,0.002789886173}, /*cmx*/
          {0.04650630431,4.788584192,3.023455793,1.034540639}, /*cfx*/
          {-0.006729873987,4.466061809e-05,14.22942755,0.1358730538,-0.001446965478,-0.002108792983}, /*cmy*/
          {2.750400308,0.7974084389,1.789512693,0.7852080508}, /*cfy*/
          {-0.002452403298,0.0001238726881,22.93195791,0.2959109201,0.001934836585,0.003677147386}, /*cmz*/
          {1.467120877,-0.04205528954,4.378175811,2.475538596} /*cfz*/
     },
     {
          2464369.5,
          {0.009942280631,-2.981928651e-05,20.55811527,0.3208853057,0.00211217844,0.003177766624}, /*cmx*/
          {3.801483175,2.379396588,0.4028223769,2.609353765}, /*cfx*/
          {-0.005695295173,4.689174651e-05,11.38152522,0.1210434718,-0.001435372849,-0.001284499302}, /*cmy*/
          {0.5610074353,4.156715316,5.196432628,3.021367282}, /*cfy*/
          {0.001835977745,0.0001140962138,23.44509133,0.2922536605,0.001944660204,0.003670239615}, /*cmz*/
          {5.348959867,3.785827859,1.959697015,4.279088637} /*cfz*/
     },
     {
          2464409.5,
          {0.009225753006,-8.340974166e-05,22.55214135,0.2958049805,0.002070827819,0.004003186062}, /*cmx*/
          {1.341889787,-0.1040244926,4.134672076,4.544348187}, /*cfx*/
          {-0.002961187111,1.617205639e-05,7.256851781,0.1157541181,-0.0012370085,-0.0007282898724}, /*cmy*/
          {4.950806116,1.158184667,2.178984509,5.584242503}, /*cfy*/
          {0.006681044819,8.126463216e-05,23.25276962,0.2948847133,0.001852745755,0.004007164543}, /*cmz*/
          {2.951891559,1.32447753,-0.49623417,-0.06439096647} /*cfz*/
     },
     {
          2464449.5,
          {0.005600122985,-9.979466293e-05,23.4807884,0.2624176054,0.001652155243,0.003990786975}, /*cmx*/
          {5.247862494,3.657558569,1.605135804,0.3426110038}, /*cfx*/
          {-0.002962181005,-2.067839282e-05,6.419381572,0.1018566779,-0.001051559506,-0.001063817867}, /*cmy*/
          {3.611477695,4.528795121,-0.8220521251,2.053292505}, /*cfy*/
          {0.009401694553,3.313557107e-05,22.57883366,0.295754966,0.001611753676,0.003650349515}, /*cmz*/
          {0.5410226013,5.170654938,3.19082144,1.9549475} /*cfz*/
     },
     {
          2464489.5,
          {0.002464676873,-7.416150161e-05,22.95632562,0.2329188743,0.001286863438,0.003256710915}, /*cmx*/
          {2.925617574,1.191749324,4.937321653,2.314828378}, /*cfx*/
          {-0.003180067441,-2.620631295e-05,9.461856743,0.08129477496,-0.0007202101965,-0.001658455905}, /*cmy*/
          {1.876519403,1.611088142,2.299962181,4.379510084}, /*cfy*/
          {0.01044231574,2.532577232e-06,22.08148337,0.2724793751,0.001538081562,0.002795791574}, /*cmz*/
          {4.417176209,2.779328351,0.153629463,3.806156784} /*cfz*/
     },
     {
          2464529.5,
          {-0.00138330128,-5.239722688e-06,21.89457937,0.1553949065,0.002262695219,0.003629723624}, /*cmx*/
          {0.6757716773,5.183930799,2.010855311,4.350664587}, /*cfx*/
          {-0.004566170772,1.591200867e-07,11.62170793,0.04452939699,-0.0008013094097,-0.001883615312}, /*cmy*/
          {6.13819309,5.222000696,-0.7702073017,0.5165958053}, /*cfy*/
          {0.0107599538,-7.180480404e-06,22.10676804,0.1704225771,0.002614026235,0.0035719343}, /*cmz*/
          {2.106811903,0.519848896,3.657404384,5.811879277} /*cfz*/
     },
     {
          2464569.5,
          {0.0001913585548,3.948213226e-05,21.62663464,-0.06890903469,-0.0004486598352,0.003347181181}, /*cmx*/
          {4.924232346,3.068004583,-0.06734873049,0.3048639023}, /*cfx*/
          {-0.003653066333,-2.462954503e-06,11.73698678,-0.036695394,0.0006454192471,-0.00221863261}, /*cmy*/
          {4.169303647,4.029374416,3.237988611,2.856520249}, /*cfy*/
          {0.01063691069,-3.312977494e-06,22.2661616,-0.08532380972,-0.0006776987129,0.003956046638}, /*cmz*/
          {0.0713693033,4.827803282,1.425055263,1.449437954} /*cfz*/
     },
     {
          2464609.5,
          {0.0005703172354,-1.785980094e-05,22.2551326,-0.01627589811,-0.001995795053,0.003160766302}, /*cmx*/
          {3.0983866,-7.055030331,4.338840379,2.804814898}, /*cfx*/
          {-0.004052285462,-2.536016104e-05,10.924285,0.03895011475,0.0006697434478,-0.001985521113}, /*cmy*/
          {2.201004273,1.054882613,1.309236566,4.946033703}, /*cfy*/
          {0.01026066675,-1.431812918e-05,21.98308816,0.01510913667,-0.002336095964,0.003362892126}, /*cmz*/
          {4.547325175,2.713907428,5.938155202,4.245667505} /*cfz*/
     },
     {
          2464649.5,
          {8.523116049e-05,-6.40029008e-05,21.94122703,0.1668882083,-0.001327559883,0.003632928393}, /*cmx*/
          {1.033699192,-0.6356074475,1.476670705,4.980866888}, /*cfx*/
          {-0.004603181891,-3.547924158e-05,12.38988806,0.09545924528,0.0008968654058,-0.002352809174}, /*cmy*/
          {0.1085423542,5.531428022,10.34644138,1.006101902}, /*cfy*/
          {0.01045392944,-3.00288805e-05,21.52087037,0.2034623265,-0.001420807291,0.004031765137}, /*cmz*/
          {2.442334334,0.8621825544,2.936215871,0.1040950688} /*cfz*/
     },
     {
          2464689.5,
          {-0.003469211531,-7.182512575e-05,20.75649013,0.2404897331,-0.001497556796,0.003087710509}, /*cmx*/
          {5.037444126,3.330368533,5.047920526,0.7355025104}, /*cfx*/
          {-0.006750038268,-1.813620697e-05,14.40675661,0.1301467185,0.001155589072,-0.002450864282}, /*cmy*/
          {4.207961322,2.966267845,1.203943236,3.147366587}, /*cfy*/
          {0.008966522116,-6.793063492e-05,21.47463511,0.2772382034,-0.001637855175,0.003473708656}, /*cmz*/
          {0.09285902193,4.841497584,0.02881707792,2.124123545} /*cfz*/
     },
     {
          2464729.5,
          {-0.006310559771,-5.793700237e-05,19.52647186,0.2869821501,-0.001735797379,0.00273524903}, /*cmx*/
          {2.619138881,0.9786885071,2.513903296,2.394823703}, /*cfx*/
          {-0.00700174317,1.705022423e-05,15.16581966,0.1474161539,0.001325590079,-0.002093801268}, /*cmy*/
          {1.9532974,0.3297585166,4.581437879,5.113232184}, /*cfy*/
          {0.005917934558,-9.751471897e-05,22.12239521,0.2950048592,-0.001839906419,0.00319481797}, /*cmz*/
          {3.952990772,2.455898967,3.756486027,3.8663488} /*cfz*/
     },
     {
          2464769.5,
          {-0.009156164113,-2.114570428e-05,19.45981044,0.3176557345,-0.001961274562,0.00351696217}, /*cmx*/
          {0.1024392764,4.878890909,-0.09442355064,4.127554995}, /*cfx*/
          {-0.007162169671,4.75549707e-05,13.91550418,0.1384861718,0.001490145283,-0.001845888162}, /*cmy*/
          {-0.3094641182,3.878962568,1.706060173,0.7462969186}, /*cfy*/
          {0.002326919798,-0.0001106588588,23.00649828,0.2925025551,-0.001904064955,0.003715668108}, /*cmz*/
          {1.537296639,0.02571152956,1.300453773,-0.5988603511} /*cfz*/
     },
     {
          2464809.5,
          {-0.01038998358,3.621992173e-05,20.996926,0.3159302514,-0.002103183549,0.003863792343}, /*cmx*/
          {3.867083789,2.447092671,3.586982616,-0.1627822643}, /*cfx*/
          {-0.004493733602,4.652098182e-05,10.52192152,0.1205550511,0.001411846318,-0.001519887906}, /*cmy*/
          {3.809054751,0.9415933413,5.103050858,2.983011573}, /*cfy*/
          {-0.002685877405,-9.687669742e-05,23.45879101,0.2876453203,-0.001890951215,0.003800854922}, /*cmz*/
          {5.426165626,3.856206253,5.170606974,1.393057571} /*cfz*/
     },
     {
          2464849.5,
          {-0.008926851456,7.665245331e-05,22.81871874,0.2865176043,-0.001973630607,0.003521635652}, /*cmx*/
          {1.428018717,-0.03798758783,1.09996171,1.710221922}, /*cfx*/
          {-0.003413880457,1.138267118e-05,6.589894609,0.1126594299,0.001288013903,-0.001282361372}, /*cmy*/
          {2.023380793,4.238361586,2.134031416,5.869526408}, /*cfy*/
          {-0.006325663839,-6.848628659e-05,23.18210032,0.2890600335,-0.001854141215,0.003335530635}, /*cmz*/
          {3.036416035,1.405599747,2.767850648,3.24676996} /*cfz*/
     },
     {
          2464889.5,
          {-0.006500500702,0.0001010478667,23.46726761,0.2604029168,-0.001713062616,0.003629802967}, /*cmx*/
          {5.344511948,3.749869816,5.010790982,3.546554248}, /*cfx*/
          {-0.002399732405,-2.835115509e-05,7.014462777,0.1060845562,0.001279272057,-0.001694844581}, /*cmy*/
          {0.6819010133,1.2903059,-0.7355677969,2.434845391}, /*cfy*/
          {-0.009215228467,-3.124234781e-05,22.38371212,0.2967329069,-0.001827258514,0.003505757508}, /*cmz*/
          {0.6274415256,5.25852648,0.3544917736,5.004023493} /*cfz*/
     },
     {
          2464929.5,
          {-0.002455040574,0.0001065236977,22.72639703,0.2535150755,-0.001575700131,0.003637360163}, /*cmx*/
          {3.003706097,1.300413163,2.729998182,5.557165015}, /*cfx*/
          {-0.003875876438,-4.935872832e-05,10.7655361,0.1109060185,0.001279125219,-0.001958401515}, /*cmy*/
          {5.093839616,4.628800211,2.786713777,4.750315805}, /*cfy*/
          {-0.01071508195,1.579178284e-05,21.63517654,0.3055961607,-0.001837214098,0.003662202426}, /*cmz*/
          {4.467244681,2.849997478,4.211568886,0.659794869} /*cfz*/
     },
     {
          2464969.5,
          {0.001512329658,0.000103737293,21.14562331,0.26760687,-0.001640097332,0.003041190594}, /*cmx*/
          {0.6362974905,5.187307589,0.4572399004,1.152239476}, /*cfx*/
          {-0.00559261977,-3.305456158e-05,13.77501646,0.1312954307,0.001283306623,-0.001889373178}, /*cmy*/
          {2.930548881,1.809560131,-0.01453604483,0.3848121332}, /*cfy*/
          {-0.009595412928,6.609087797e-05,21.52704887,0.3113876291,-0.001910224678,0.003261969779}, /*cmz*/
          {1.99800298,0.4490954928,1.768124749,2.476247451} /*cfz*/
     },
     {
          2465009.5,
          {0.005111957747,8.289197908e-05,19.6246616,0.2999220468,-0.001865460916,0.003035914132}, /*cmx*/
          {4.471680756,2.815276876,4.353681482,2.841333636}, /*cfx*/
          {-0.006773517357,1.388314698e-06,14.94569021,0.1480662044,0.001433847245,-0.002147104894}, /*cmy*/
          {0.6749318995,5.382689739,3.341571309,2.152132928}, /*cfy*/
          {-0.007410420975,0.0001038234235,22.18323783,0.3118452029,-0.002045437948,0.003686493599}, /*cmz*/
          {-0.4678351047,4.315794632,5.605394319,4.212143629} /*cfz*/
     },
     {
          2465049.5,
          {0.009013483487,4.451221643e-05,19.44568566,0.3366658994,-0.002200740899,0.003363861342}, /*cmx*/
          {1.926706485,0.4234826203,1.757872172,4.723317651}, /*cfx*/
          {-0.006814246352,4.572038773e-05,13.80871723,0.1424605286,0.001710728019,-0.002354234756}, /*cmy*/
          {4.691187588,2.583683904,0.4115908428,4.282358728}, /*cfy*/
          {-0.003007655787,0.000122635306,23.07880264,0.3104731844,-0.002200307199,0.004053739998}, /*cmz*/
          {3.373474843,1.861287754,3.162571058,-0.07129377038} /*cfz*/
     },
     {
          2465089.5,
          {0.009560789247,-2.549748681e-05,21.19174035,0.3429864742,-0.002532700763,0.003057142709}, /*cmx*/
          {-0.6296322788,4.243429955,5.377573185,0.2123413523}, /*cfx*/
          {-0.004329078033,3.980407018e-05,10.12674292,0.1321909624,0.001687883021,-0.001953814851}, /*cmy*/
          {2.539263476,-0.4798232953,3.698256014,0.520268575}, /*cfy*/
          {0.002188630244,0.0001126884757,23.46011085,0.3151317362,-0.002308316191,0.003450092256}, /*cmz*/
          {0.9462470301,5.649209487,0.7088226743,1.860643073} /*cfz*/
     },
     {
          2465129.5,
          {0.008826201208,-8.266273755e-05,23.12306061,0.3124842428,-0.002432100032,0.003423089976}, /*cmx*/
          {3.178750925,1.686122599,2.837327962,1.904952625}, /*cfx*/
          {-0.003002306768,5.581352822e-06,6.252373094,0.1317214501,0.001622088985,-0.001714459459}, /*cmy*/
          {0.9126221081,2.724588125,0.5660801782,3.556977223}, /*cfy*/
          {0.006252288099,7.492474389e-05,22.97648427,0.3291573988,-0.002325477054,0.003249960121}, /*cmz*/
          {4.786223652,3.141645303,4.505488729,3.534043676} /*cfz*/
     },
     {
          2465169.5,
          {0.004890484863,-0.0001054402489,23.30416687,0.2900348541,-0.002055647555,0.003840376119}, /*cmx*/
          {0.7715459695,5.394935539,0.3948530074,3.879441273}, /*cfx*/
          {-0.002482819358,-4.17175507e-05,8.477333131,0.122029337,0.00159792447,-0.002049710342}, /*cmy*/
          {5.802273669,-0.3452454311,3.877819962,6.206839742}, /*cfy*/
          {0.01010222666,1.64638582e-05,22.05443006,0.3443469303,-0.002259851595,0.003620856384}, /*cmz*/
          {2.298633816,0.6541064163,1.9541764,5.388322979} /*cfz*/
     },
     {
          2465209.5,
          {0.0001477717555,-9.923996484e-05,21.84729141,0.2895157328,-0.001745625653,0.003378462814}, /*cmx*/
          {4.653181007,2.900630877,4.236032681,-0.3803666111}, /*cfx*/
          {-0.004827547557,-3.590219945e-05,12.5044615,0.1285867455,0.001361136701,-0.002037188518}, /*cmy*/
          {3.757811337,2.880981155,0.9575273436,2.095575845}, /*cfy*/
          {0.009984020514,-4.134990441e-05,21.63794768,0.342671318,-0.002124381557,0.003218716241}, /*cmz*/
          {-0.2250726467,4.474781702,-0.6506880774,1.004801216} /*cfz*/
     },
     {
          2465249.5,
          {-0.00366367149,-7.218256482e-05,20.05914491,0.2920471894,-0.001481794341,0.002714515025}, /*cmx*/
          {2.208153498,0.4852800238,1.567140962,1.364741837}, /*cfx*/
          {-0.006016072921,-1.040247943e-05,14.52561694,0.1340476154,0.001069342735,-0.001887453074}, /*cmy*/
          {1.523740321,0.06167853999,4.203445968,3.95377942}, /*cfy*/
          {0.00872332794,-7.275421536e-05,22.13865949,0.3126889452,-0.001846373445,0.003011633802}, /*cmz*/
          {3.561186374,2.024908682,2.959104101,2.664141713} /*cfz*/
     },
     {
          2465289.5,
          {-0.007867430777,-3.454376134e-05,19.31991381,0.2600478435,-0.001784592608,0.00338294127}, /*cmx*/
          {-0.2511487788,4.406490297,4.72368207,3.159792377}, /*cfx*/
          {-0.006927164918,1.603379176e-05,14.37372683,0.1070065813,0.0006950748184,-0.001893391931}, /*cmy*/
          {5.574230139,3.677821662,0.9387107877,-0.4078994726}, /*cfy*/
          {0.005461822385,-6.507385965e-05,22.92330164,0.2529261994,-0.001750137921,0.00393251852}, /*cmz*/
          {1.161287353,-0.4016136039,-0.03054476285,4.52142298} /*cfz*/
     },
     {
          2465329.5,
          {-0.008829592449,1.747045277e-05,19.59283662,0.1193634462,-0.003021279046,0.003068183334}, /*cmx*/
          {3.72438466,2.189198777,2.216940373,5.39817187}, /*cfx*/
          {-0.005998005492,-1.264365888e-05,13.28864987,0.0579453043,0.0009622131643,-0.00208649247}, /*cmy*/
          {3.44016766,1.50990758,4.081329149,2.022181303}, /*cfy*/
          {0.002488801023,2.785111775e-05,23.25875357,0.1219765301,-0.002592017734,0.003677268558}, /*cmz*/
          {5.206775286,3.630819834,3.675520817,0.6054009103} /*cfz*/
     },
     {
          2465369.5,
          {-0.01023604904,7.213601951e-05,19.48627778,-0.1606138882,0.001623858776,0.0038411055}, /*cmx*/
          {1.808067652,0.3706924035,0.3320305989,1.885304287}, /*cfx*/
          {-0.007016556727,-8.497601271e-06,13.73132753,-0.04913957332,-0.0005396137631,-0.00279859313}, /*cmy*/
          {1.435480004,4.860936753,2.01971437,4.285932053}, /*cfy*/
          {0.003837081034,4.776879984e-05,23.12027786,-0.1200959982,0.001341788289,0.005107042664}, /*cmz*/
          {3.258216688,1.888952866,1.784230609,3.246897242} /*cfz*/
     },
     {
          2465409.5,
          {-0.00640541927,-1.491954093e-05,19.23598383,0.01511218115,0.002276705933,0.0036552239}, /*cmx*/
          {6.375553998,5.350992277,4.625145763,3.987640712}, /*cfx*/
          {-0.007031754799,4.18447278e-06,14.88049489,-0.03148867207,-0.0008945994634,-0.002642132235}, /*cmy*/
          {5.812135657,-23.68721394,0.3826618527,0.334639094}, /*cfy*/
          {0.006001134435,-2.607226425e-05,22.50260057,0.02685996986,0.001987427995,0.0039258133}, /*cmz*/
          {1.460135472,6.279468532,6.094969422,5.458729887} /*cfz*/
     },
     {
          2465449.5,
          {-0.007858359745,-4.428239362e-05,19.28178897,0.193269554,0.001385279886,0.002939367042}, /*cmx*/
          {4.256053196,-3.533041004,1.697352778,-0.1092493602}, /*cfx*/
          {-0.006951647283,2.278197802e-05,14.53433541,-0.09385163692,0.0008337966814,-0.002350138887}, /*cmy*/
          {3.749760474,5.03095768,0.1664648645,2.686476521}, /*cfy*/
          {0.004497307531,-7.627155401e-05,22.70402952,0.184346566,0.001246188423,0.003304361753}, /*cmz*/
          {5.649147028,4.187162155,3.013725266,1.374621866} /*cfz*/
     },
     {
          2465489.5,
          {-0.008782273627,-2.450680058e-05,19.99096578,0.2684135546,0.001588570887,0.003026630142}, /*cmx*/
          {1.88684466,0.4449000394,5.041037927,1.575350036}, /*cfx*/
          {-0.005748128864,3.803150917e-05,12.64925428,-0.1089350863,0.001155420665,-0.001553034084}, /*cmy*/
          {1.601262974,2.38456592,3.479963134,4.911541235}, /*cfy*/
          {0.001704988491,-9.493864669e-05,23.25246214,0.2414008264,0.001499212657,0.003315978704}, /*cmz*/
          {3.377163902,1.862935458,0.2239591037,3.160520617} /*cfz*/
     },
     {
          2465529.5,
          {-0.01021507118,1.792994717e-05,21.62571785,0.2832098481,0.001823400895,0.003746413614}, /*cmx*/
          {5.746757998,4.33226669,2.402310594,3.483486603}, /*cfx*/
          {-0.004330115862,3.876039812e-05,9.150768967,-0.107164463,0.001203766969,-0.0007559646116}, /*cmy*/
          {5.829461623,-0.4885234119,0.5965824809,0.9627002325}, /*cfy*/
          {-0.001654952744,-9.39516157e-05,23.44641901,0.2630502735,0.001669906012,0.003676583968}, /*cmz*/
          {1.046925314,5.747814159,4.027082372,5.068628089} /*cfz*/
     },
     {
          2465569.5,
          {-0.00896063098,5.551959621e-05,23.10800975,0.2670620075,0.001784370898,0.003755412641}, /*cmx*/
          {3.362319143,1.872643053,-0.06510062827,5.515856794}, /*cfx*/
          {-0.002340693229,4.912261223e-06,6.114881262,-0.1055623672,0.001200303472,-0.0006560339451}, /*cmy*/
          {4.213060881,2.879814638,3.951563075,3.595994602}, /*cfy*/
          {-0.005688860242,-7.570482441e-05,23.01456489,0.2775753996,0.001739097056,0.003533471365}, /*cmz*/
          {4.968212946,3.329214785,1.608193471,0.7920765219} /*cfz*/
     },
     {
          2465609.5,
          {-0.00648395944,7.813815937e-05,23.41425106,0.2520179788,0.001628221839,0.00331926715}, /*cmx*/
          {1.020017341,5.685922089,3.866559445,1.164660629}, /*cfx*/
          {-0.002542831131,-2.694185357e-05,7.804508274,-0.1035441342,0.00124749359,-0.001389080504}, /*cmy*/
          {2.777796029,-0.04310248971,1.132076426,6.069856752}, /*cfy*/
          {-0.008092821298,-4.340290903e-05,22.16819542,0.292147683,0.001784811222,0.003065671088}, /*cmz*/
          {2.568254399,0.918100478,5.475197424,2.59742062} /*cfz*/
     },
     {
          2465649.5,
          {-0.003323891032,9.151324635e-05,22.47769924,0.2532478317,0.001582745171,0.003322497979}, /*cmx*/
          {4.967344565,3.253938983,1.593161844,3.031849775}, /*cfx*/
          {-0.0031295064,-4.2094561e-05,11.55933346,-0.1144535812,0.001283676692,-0.002167808619}, /*cmy*/
          {0.8106781041,3.32687515,4.666454001,2.076619982}, /*cfy*/
          {-0.009866295159,2.041178473e-06,21.47927312,0.3057512091,0.001857775771,0.003425529613}, /*cmz*/
          {0.1238987824,4.801422858,3.039097064,4.345254603} /*cfz*/
     },
     {
          2465689.5,
          {0.000858004313,9.544573721e-05,20.82715467,0.274425292,0.001738054216,0.003054249768}, /*cmx*/
          {2.588609035,0.8636359122,5.59087706,5.006862271}, /*cfx*/
          {-0.005593266874,-2.952686562e-05,14.26780586,-0.1382446216,0.001334123536,-0.002339057921}, /*cmy*/
          {4.901981767,0.5415232135,1.841250369,4.290426464}, /*cfy*/
          {-0.00974120204,5.151495223e-05,21.51288192,0.3149591105,0.001987120256,0.003545569553}, /*cmz*/
          {3.932891537,2.398336189,0.5825373215,0.03263503917} /*cfz*/
     },
     {
          2465729.5,
          {0.004933958776,8.102022436e-05,19.41937018,0.3146778038,0.002047680641,0.002343436716}, /*cmx*/
          {0.1131613745,4.767107809,3.148179812,0.4164466697}, /*cfx*/
          {-0.006183993689,1.323014332e-05,15.03403355,-0.1539704497,0.001572391254,-0.001776531168}, /*cmy*/
          {2.632101995,4.108324297,5.163107769,0.01053591563}, /*cfy*/
          {-0.00700615511,9.157779734e-05,22.30460823,0.3182548823,0.002175230726,0.00318001574}, /*cmz*/
          {1.461442389,-0.03174292986,4.403231084,1.85059108} /*cfz*/
     },
     {
          2465769.5,
          {0.008132475136,3.77691862e-05,19.64878393,0.3548138262,0.002461843957,0.003151832472}, /*cmx*/
          {3.820813194,2.34923813,0.4770737557,1.908934317}, /*cfx*/
          {-0.006542165569,4.740601545e-05,13.30147741,-0.1450616055,0.001870706447,-0.00137093226}, /*cmy*/
          {0.3653013698,1.232929457,2.20042258,1.816914048}, /*cfy*/
          {-0.003689013145,0.0001134637906,23.20963064,0.3200511327,0.002376545979,0.003613063267}, /*cmz*/
          {5.294247845,3.773434925,1.939684174,3.59657922} /*cfz*/
     },
     {
          2465809.5,
          {0.01058309337,-4.146328433e-05,21.74286426,0.3512691568,0.002750682791,0.003919958628}, /*cmx*/
          {1.25570592,-0.1595284822,4.084348799,3.902223516}, /*cfx*/
          {-0.00348340862,4.777457884e-05,8.99410695,-0.1387779522,0.001788971994,-0.001057824698}, /*cmy*/
          {4.562816937,4.368238626,-0.8906956016,4.035610607}, /*cfy*/
          {0.001729569094,0.0001118370428,23.41991259,0.3289300804,0.00250629885,0.003785631097}, /*cmz*/
          {2.850404161,1.250907196,-0.5413164588,5.59350988} /*cfz*/
     },
     {
          2465849.5,
          {0.008415986945,-9.47978075e-05,23.38825331,0.3150411662,0.002490145316,0.003478803272}, /*cmx*/
          {5.066613681,3.524855677,1.559868567,-0.4188563962}, /*cfx*/
          {-0.002648567382,-8.131548544e-06,6.309066206,-0.1361447867,0.001787399444,-0.001289444036}, /*cmy*/
          {3.164413912,1.261339717,2.237905799,0.8248546937}, /*cfy*/
          {0.006171622998,7.089468232e-05,22.68938839,0.3473170397,0.002517530825,0.00287492464}, /*cmz*/
          {0.3783621094,5.004712007,3.213711456,1.180927567} /*cfz*/
     },
     {
          2465889.5,
          {0.005426174082,-0.0001189249991,22.96103365,0.2983857334,0.002118010936,0.003200162541}, /*cmx*/
          {2.650363878,0.9484151808,5.430087017,1.312799504}, /*cfx*/
          {-0.002218892628,-4.416101369e-05,10.12841407,-0.1302115284,0.001732197231,-0.002203623692}, /*cmy*/
          {1.539965612,4.405370432,-0.7207249014,3.402971726}, /*cfy*/
          {0.009147613688,1.173938764e-05,21.7125848,0.3622939926,0.002453154799,0.002889816329}, /*cmz*/
          {4.134657737,2.501453983,0.633491142,2.630465036} /*cfz*/
     },
     {
          2465929.5,
          {0.0004562802227,-0.0001176475271,21.11693919,0.3078202297,0.00195778458,0.003399970135}, /*cmx*/
          {0.2148223808,4.74984386,3.028872052,3.197588266}, /*cfx*/
          {-0.00484595853,-4.082152541e-05,13.80132176,-0.1476167072,0.001532479062,-0.002638174261}, /*cmy*/
          {5.658361738,1.380682108,2.586071139,5.688384747}, /*cfy*/
          {0.01033786201,-5.185073051e-05,21.56882049,0.3570577469,0.002355743947,0.003630127731}, /*cmz*/
          {1.576282689,0.02081978517,4.335838686,4.471591721} /*cfz*/
     },
     {
          2465969.5,
          {-0.004152847188,-9.544608041e-05,19.4702861,0.3262984959,0.001904758233,0.002784582369}, /*cmx*/
          {3.983702479,2.32817739,0.4798124449,5.097800819}, /*cfx*/
          {-0.005870568575,2.56709518e-06,14.91621764,-0.1526900258,0.001468389923,-0.002105148112}, /*cmy*/
          {3.373760978,4.852449281,-0.4550769259,1.553289389}, /*cfy*/
          {0.007679755598,-9.312110806e-05,22.38442778,0.3306536196,0.002160032467,0.003420994695}, /*cmz*/
          {5.339229266,3.825853062,1.791699076,0.1253138455} /*cfz*/
     },
     {
          2466009.5,
          {-0.007392746599,-5.375822309e-05,19.58460311,0.3199331264,0.001837736477,0.002549594194}, /*cmx*/
          {1.422201951,-0.08170520241,4.044193886,0.3528734793}, /*cfx*/
          {-0.006100064514,2.95352359e-05,13.40528327,-0.1249625097,0.001244610006,-0.001414186927}, /*cmy*/
          {1.11543821,2.021983985,2.905426727,3.536127381}, /*cfy*/
          {0.004842974233,-0.0001023378516,23.24476476,0.2939119617,0.001780550808,0.003243973472}, /*cmz*/
          {2.896585975,1.347958822,5.514879479,1.905045662} /*cfz*/
     },
     {
          2466049.5,
          {-0.009942476562,-1.016424464e-05,21.20606768,0.2643694403,0.001668096077,0.003391248092}, /*cmx*/
          {5.234924456,3.784939299,1.184461914,2.192774582}, /*cfx*/
          {-0.004213511221,3.293001003e-05,10.13916965,-0.0920239602,0.0006735315621,-0.0009372609514}, /*cmy*/
          {5.286514758,-0.8609225451,-0.3185473734,5.548250324}, /*cfy*/
          {0.0002319029413,-7.647246012e-05,23.49059715,0.2497727772,0.001410763589,0.003898088666}, /*cmz*/
          {0.5325918785,5.190673258,2.643199592,3.814436589} /*cfz*/
     },
     {
          2466089.5,
          {-0.009055135489,-1.156931281e-05,22.51696497,0.1643345898,0.00234375935,0.003407125456}, /*cmx*/
          {2.945467887,1.442450402,4.637234369,4.557323806}, /*cfx*/
          {-0.003072149742,1.010437524e-05,7.348720803,-0.05140546978,0.001120704449,-0.001127264784}, /*cmy*/
          {3.39229801,2.980934616,-22.65258207,1.545271476}, /*cfy*/
          {-0.002758826342,-1.248783858e-05,23.28674679,0.1684017353,0.002300067028,0.003789651936}, /*cmz*/
          {4.555439239,2.894435763,-0.2591360583,6.152338949} /*cfz*/
     },
     {
          2466129.5,
          {-0.01021159367,-3.2616273e-05,22.71749473,-0.06979631586,0.0008606728018,0.004677510303}, /*cmx*/
          {0.9052063483,5.818703043,3.080669007,0.6907692926}, /*cfx*/
          {-0.001860896728,-3.413734919e-05,6.551883181,0.07890329935,0.0006154786714,-0.001406552413}, /*cmy*/
          {1.399743282,6.449892193,1.786722453,3.459647744}, /*cfy*/
          {-0.00413233002,6.427068904e-05,23.26152922,-0.06097512252,0.0007312457824,0.004612779826}, /*cmz*/
          {2.509554951,0.7695810174,4.483711018,2.415572265} /*cfz*/
     }

};

static unsigned idn_list[] = {2,149};
static double freq_list[] = {19.7027,4.9788};
static double delt_list[] = {50.0,40.0};

BDL_Dataset mars_2040 = {
     2, /*nsat*/
     2458849.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};
