# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue, email, or any other method with the owners of this repository before creating a Pull Request.

Please note we have a [code of conduct](https://github.com/ProtonVPN/linux-cli/blob/master/CODE_OF_CONDUCT.md), please follow it in all your interactions with the project.

By making a contribution to this project you agree to the following:

1. I assign any and all copyright related to the contribution to Proton Technologies AG;
2. I certify that the contribution was created in whole by me;
3. I understand and agree that this project and the contribution are public and that a record of the contribution (including all personal information I submit with it) is maintained indefinitely and may be redistributed with this project or the open source license(s) involved.

## Pull Request Process

1. Ensure that your code is [Flake8](https://flake8.pycqa.org/en/latest/) compatible. In cases this doesn't work out, use the `# noqa` comment.
2. Ensure that your code is compatible with the lowest Python Version supported by this project (Currently 3.5)
3. If applicable, update [DOCUMENTATION.md](https://github.com/ProtonVPN/linux-cli/blob/master/DOCUMENTATION.md) and [USAGE.md](https://github.com/ProtonVPN/linux-cli/blob/master/USAGE.md) to reflect changes correctly.
4. If your PR fixes an issue, prefix your commit or the PR title with `Fix #42:` where 42 is the corresponding issue number.
5. Follow [best practices](https://chris.beams.io/posts/git-commit/) in your commit messages.
