#!/usr/bin/awk -f

# set up field and record separators to bring up printcap entries split
# appropriately
BEGIN {
	FS = ":\\\\[^:graph:]+:";
	RS = "[^\\\\]\n";
	gar="sd=" spool "[:\\n]";
};

# There's a better way to do this, but it works.

# blank?  all comment?  Ditch it
/^[^:graph:]*[#$]/ { next }


# find the printer whose spooldir was specified and print the ppdfile to stdout
$0 ~ gar {
	for(i=1; i<=NF; i++) {
		if($i ~ /^ppdfile=/) {
			split($i, a, "=");
			print a[2];
		}
	}
}
