﻿#include "lang.h"

/* Based on BIP-39 with ordinal sorting */

POLYSEED_PRIVATE const polyseed_lang polyseed_lang_jp = {
    .name = u8"日本語",
    .name_en = "Japanese",
    .separator = u8"\u3000",
    .is_sorted = true,
    .has_prefix = false,
    .has_accents = false,
    .compose = false,
    .words = {
        u8"あいこくしん",
        u8"あいさつ",
        u8"あいだ",
        u8"あおぞら",
        u8"あかちゃん",
        u8"あきる",
        u8"あけがた",
        u8"あける",
        u8"あこがれる",
        u8"あさい",
        u8"あさひ",
        u8"あしあと",
        u8"あじわう",
        u8"あずかる",
        u8"あずき",
        u8"あそぶ",
        u8"あたえる",
        u8"あたためる",
        u8"あたりまえ",
        u8"あたる",
        u8"あっしゅく",
        u8"あつい",
        u8"あつかう",
        u8"あつまり",
        u8"あつめる",
        u8"あてな",
        u8"あてはまる",
        u8"あひる",
        u8"あふれる",
        u8"あぶら",
        u8"あぶる",
        u8"あまい",
        u8"あまど",
        u8"あまやかす",
        u8"あまり",
        u8"あみもの",
        u8"あめりか",
        u8"あやまる",
        u8"あゆむ",
        u8"あらいぐま",
        u8"あらし",
        u8"あらすじ",
        u8"あらためる",
        u8"あらゆる",
        u8"あらわす",
        u8"ありがとう",
        u8"あわせる",
        u8"あわてる",
        u8"あんい",
        u8"あんがい",
        u8"あんこ",
        u8"あんぜん",
        u8"あんてい",
        u8"あんない",
        u8"あんまり",
        u8"いいだす",
        u8"いおん",
        u8"いがい",
        u8"いがく",
        u8"いきおい",
        u8"いきなり",
        u8"いきもの",
        u8"いきる",
        u8"いくじ",
        u8"いくぶん",
        u8"いけばな",
        u8"いけん",
        u8"いこう",
        u8"いこく",
        u8"いこつ",
        u8"いさましい",
        u8"いさん",
        u8"いしき",
        u8"いじゅう",
        u8"いじょう",
        u8"いじわる",
        u8"いずみ",
        u8"いずれ",
        u8"いせい",
        u8"いせえび",
        u8"いせかい",
        u8"いせき",
        u8"いぜん",
        u8"いそうろう",
        u8"いそがしい",
        u8"いたずら",
        u8"いたみ",
        u8"いたりあ",
        u8"いだい",
        u8"いだく",
        u8"いちおう",
        u8"いちじ",
        u8"いちど",
        u8"いちば",
        u8"いちぶ",
        u8"いちりゅう",
        u8"いっしゅん",
        u8"いっせい",
        u8"いっそう",
        u8"いったん",
        u8"いっち",
        u8"いってい",
        u8"いっぽう",
        u8"いつか",
        u8"いてざ",
        u8"いてん",
        u8"いとこ",
        u8"いどう",
        u8"いない",
        u8"いなか",
        u8"いねむり",
        u8"いのち",
        u8"いのる",
        u8"いはつ",
        u8"いはん",
        u8"いばる",
        u8"いひん",
        u8"いびき",
        u8"いふく",
        u8"いへん",
        u8"いほう",
        u8"いみん",
        u8"いもうと",
        u8"いもたれ",
        u8"いもり",
        u8"いやがる",
        u8"いやす",
        u8"いよかん",
        u8"いよく",
        u8"いらい",
        u8"いらすと",
        u8"いりぐち",
        u8"いりょう",
        u8"いれい",
        u8"いれもの",
        u8"いれる",
        u8"いろえんぴつ",
        u8"いわい",
        u8"いわう",
        u8"いわかん",
        u8"いわば",
        u8"いわゆる",
        u8"いんげんまめ",
        u8"いんさつ",
        u8"いんしょう",
        u8"いんよう",
        u8"うえき",
        u8"うえる",
        u8"うおざ",
        u8"うかぶ",
        u8"うかべる",
        u8"うがい",
        u8"うきわ",
        u8"うくらいな",
        u8"うくれれ",
        u8"うけたまわる",
        u8"うけつけ",
        u8"うけとる",
        u8"うけもつ",
        u8"うける",
        u8"うこん",
        u8"うごかす",
        u8"うごく",
        u8"うさぎ",
        u8"うしなう",
        u8"うしろがみ",
        u8"うすい",
        u8"うすぎ",
        u8"うすぐらい",
        u8"うすめる",
        u8"うせつ",
        u8"うちあわせ",
        u8"うちがわ",
        u8"うちき",
        u8"うちゅう",
        u8"うっかり",
        u8"うったえる",
        u8"うつくしい",
        u8"うつる",
        u8"うどん",
        u8"うなぎ",
        u8"うなじ",
        u8"うなずく",
        u8"うなる",
        u8"うねる",
        u8"うのう",
        u8"うぶげ",
        u8"うぶごえ",
        u8"うまれる",
        u8"うめる",
        u8"うもう",
        u8"うやまう",
        u8"うよく",
        u8"うらがえす",
        u8"うらぐち",
        u8"うらない",
        u8"うりあげ",
        u8"うりきれ",
        u8"うるさい",
        u8"うれしい",
        u8"うれゆき",
        u8"うれる",
        u8"うろこ",
        u8"うわき",
        u8"うわさ",
        u8"うんこう",
        u8"うんちん",
        u8"うんてん",
        u8"うんどう",
        u8"えいえん",
        u8"えいが",
        u8"えいきょう",
        u8"えいご",
        u8"えいせい",
        u8"えいぶん",
        u8"えいよう",
        u8"えいわ",
        u8"えおり",
        u8"えがお",
        u8"えがく",
        u8"えきたい",
        u8"えくせる",
        u8"えしゃく",
        u8"えすて",
        u8"えつらん",
        u8"えのぐ",
        u8"えほうまき",
        u8"えほん",
        u8"えまき",
        u8"えもじ",
        u8"えもの",
        u8"えらい",
        u8"えらぶ",
        u8"えりあ",
        u8"えんえん",
        u8"えんかい",
        u8"えんぎ",
        u8"えんげき",
        u8"えんしゅう",
        u8"えんぜつ",
        u8"えんそく",
        u8"えんちょう",
        u8"えんとつ",
        u8"おいかける",
        u8"おいこす",
        u8"おいしい",
        u8"おいつく",
        u8"おうえん",
        u8"おうさま",
        u8"おうじ",
        u8"おうせつ",
        u8"おうたい",
        u8"おうふく",
        u8"おうべい",
        u8"おうよう",
        u8"おえる",
        u8"おおい",
        u8"おおう",
        u8"おおどおり",
        u8"おおや",
        u8"おおよそ",
        u8"おかえり",
        u8"おかず",
        u8"おかわり",
        u8"おがむ",
        u8"おきる",
        u8"おぎなう",
        u8"おくさま",
        u8"おくじょう",
        u8"おくりがな",
        u8"おくる",
        u8"おくれる",
        u8"おこす",
        u8"おこなう",
        u8"おこる",
        u8"おさえる",
        u8"おさない",
        u8"おさめる",
        u8"おしいれ",
        u8"おしえる",
        u8"おしゃれ",
        u8"おじぎ",
        u8"おじさん",
        u8"おそらく",
        u8"おそわる",
        u8"おたがい",
        u8"おたく",
        u8"おだやか",
        u8"おちつく",
        u8"おっと",
        u8"おつり",
        u8"おでかけ",
        u8"おとしもの",
        u8"おとなしい",
        u8"おどり",
        u8"おどろかす",
        u8"おばさん",
        u8"おまいり",
        u8"おめでとう",
        u8"おもいで",
        u8"おもう",
        u8"おもたい",
        u8"おもちゃ",
        u8"おやつ",
        u8"おやゆび",
        u8"およぼす",
        u8"おらんだ",
        u8"おろす",
        u8"おんがく",
        u8"おんけい",
        u8"おんしゃ",
        u8"おんせん",
        u8"おんだん",
        u8"おんちゅう",
        u8"おんどけい",
        u8"かあつ",
        u8"かいが",
        u8"かいさつ",
        u8"かいしゃ",
        u8"かいすいよく",
        u8"かいぜん",
        u8"かいぞうど",
        u8"かいつう",
        u8"かいてん",
        u8"かいとう",
        u8"かいふく",
        u8"かいほう",
        u8"かいよう",
        u8"かいわ",
        u8"かえる",
        u8"かおり",
        u8"かかえる",
        u8"かがく",
        u8"かがし",
        u8"かがみ",
        u8"かくご",
        u8"かくとく",
        u8"かざる",
        u8"かたい",
        u8"かたち",
        u8"かなざわし",
        u8"かのう",
        u8"かぶか",
        u8"かほう",
        u8"かほご",
        u8"かまう",
        u8"かまぼこ",
        u8"かめれおん",
        u8"かゆい",
        u8"かようび",
        u8"からい",
        u8"かるい",
        u8"かろう",
        u8"かわく",
        u8"かわら",
        u8"かんけい",
        u8"かんこう",
        u8"かんしゃ",
        u8"かんそう",
        u8"かんたん",
        u8"かんち",
        u8"がいき",
        u8"がいけん",
        u8"がいこう",
        u8"がいへき",
        u8"がいらい",
        u8"がぞう",
        u8"がちょう",
        u8"がっきゅう",
        u8"がっこう",
        u8"がっさん",
        u8"がっしょう",
        u8"がはく",
        u8"がんか",
        u8"がんばる",
        u8"きあい",
        u8"きあつ",
        u8"きいろ",
        u8"きうい",
        u8"きうん",
        u8"きえる",
        u8"きおう",
        u8"きおく",
        u8"きおち",
        u8"きおん",
        u8"きかい",
        u8"きかく",
        u8"きかんしゃ",
        u8"ききて",
        u8"きくばり",
        u8"きくらげ",
        u8"きけんせい",
        u8"きこう",
        u8"きこえる",
        u8"きこく",
        u8"きさい",
        u8"きさく",
        u8"きさま",
        u8"きさらぎ",
        u8"きすう",
        u8"きせい",
        u8"きせき",
        u8"きせつ",
        u8"きそう",
        u8"きぞく",
        u8"きぞん",
        u8"きたえる",
        u8"きちょう",
        u8"きつえん",
        u8"きつつき",
        u8"きつね",
        u8"きてい",
        u8"きどう",
        u8"きどく",
        u8"きない",
        u8"きなが",
        u8"きなこ",
        u8"きぬごし",
        u8"きねん",
        u8"きのう",
        u8"きのした",
        u8"きはく",
        u8"きひん",
        u8"きびしい",
        u8"きふく",
        u8"きぶん",
        u8"きほん",
        u8"きぼう",
        u8"きまる",
        u8"きみつ",
        u8"きむずかしい",
        u8"きめる",
        u8"きもだめし",
        u8"きもち",
        u8"きもの",
        u8"きゃく",
        u8"きやく",
        u8"きょうりゅう",
        u8"きよう",
        u8"きらい",
        u8"きらく",
        u8"きりん",
        u8"きれい",
        u8"きれつ",
        u8"きろく",
        u8"きわめる",
        u8"きんかくじ",
        u8"きんじょ",
        u8"きんようび",
        u8"ぎいん",
        u8"ぎしき",
        u8"ぎじかがく",
        u8"ぎじたいけん",
        u8"ぎじにってい",
        u8"ぎじゅつしゃ",
        u8"ぎっちり",
        u8"ぎゅうにく",
        u8"ぎろん",
        u8"ぎんいろ",
        u8"くいず",
        u8"くうかん",
        u8"くうき",
        u8"くうぐん",
        u8"くうこう",
        u8"くうそう",
        u8"くうふく",
        u8"くうぼ",
        u8"くかん",
        u8"くきょう",
        u8"くげん",
        u8"くさい",
        u8"くさき",
        u8"くさばな",
        u8"くさる",
        u8"くしゃみ",
        u8"くしょう",
        u8"くすのき",
        u8"くすりゆび",
        u8"くせげ",
        u8"くせん",
        u8"くたびれる",
        u8"くださる",
        u8"くちこみ",
        u8"くちさき",
        u8"くつした",
        u8"くつろぐ",
        u8"くとうてん",
        u8"くどく",
        u8"くなん",
        u8"くねくね",
        u8"くのう",
        u8"くふう",
        u8"くみあわせ",
        u8"くみたてる",
        u8"くめる",
        u8"くやくしょ",
        u8"くらす",
        u8"くらべる",
        u8"くるま",
        u8"くれる",
        u8"くろう",
        u8"くわしい",
        u8"ぐあい",
        u8"ぐうせい",
        u8"ぐうたら",
        u8"ぐこう",
        u8"ぐたいてき",
        u8"ぐっすり",
        u8"ぐんかん",
        u8"ぐんしょく",
        u8"ぐんたい",
        u8"ぐんて",
        u8"けあな",
        u8"けいかく",
        u8"けいけん",
        u8"けいこ",
        u8"けいさつ",
        u8"けいたい",
        u8"けいれき",
        u8"けいろ",
        u8"けおとす",
        u8"けおりもの",
        u8"けさき",
        u8"けしき",
        u8"けしごむ",
        u8"けしょう",
        u8"けたば",
        u8"けちゃっぷ",
        u8"けちらす",
        u8"けっこん",
        u8"けっせき",
        u8"けってい",
        u8"けつあつ",
        u8"けつい",
        u8"けつえき",
        u8"けつじょ",
        u8"けつまつ",
        u8"けつろん",
        u8"けとばす",
        u8"けとる",
        u8"けなげ",
        u8"けなす",
        u8"けなみ",
        u8"けぬき",
        u8"けねん",
        u8"けはい",
        u8"けぶかい",
        u8"けまり",
        u8"けみかる",
        u8"けむし",
        u8"けむり",
        u8"けもの",
        u8"けらい",
        u8"けろけろ",
        u8"けわしい",
        u8"けんい",
        u8"けんえつ",
        u8"けんお",
        u8"けんか",
        u8"けんげん",
        u8"けんこう",
        u8"けんさく",
        u8"けんしゅう",
        u8"けんすう",
        u8"けんちく",
        u8"けんてい",
        u8"けんとう",
        u8"けんない",
        u8"けんにん",
        u8"けんま",
        u8"けんみん",
        u8"けんめい",
        u8"けんらん",
        u8"けんり",
        u8"げいじゅつ",
        u8"げいのうじん",
        u8"げきか",
        u8"げきげん",
        u8"げきだん",
        u8"げきちん",
        u8"げきとつ",
        u8"げきは",
        u8"げきやく",
        u8"げこう",
        u8"げこくじょう",
        u8"げざい",
        u8"げざん",
        u8"げすと",
        u8"げつようび",
        u8"げつれい",
        u8"げどく",
        u8"げねつ",
        u8"げひん",
        u8"げぼく",
        u8"げんき",
        u8"げんそう",
        u8"げんぶつ",
        u8"こあくま",
        u8"こいぬ",
        u8"こいびと",
        u8"こうえん",
        u8"こうおん",
        u8"こうかん",
        u8"こうこう",
        u8"こうさい",
        u8"こうじ",
        u8"こうすい",
        u8"こうそく",
        u8"こうたい",
        u8"こうちゃ",
        u8"こうつう",
        u8"こうてい",
        u8"こうどう",
        u8"こうない",
        u8"こうはい",
        u8"こうもく",
        u8"こうりつ",
        u8"こえる",
        u8"こおり",
        u8"こくご",
        u8"こくさい",
        u8"こくとう",
        u8"こくない",
        u8"こくはく",
        u8"こぐま",
        u8"こけい",
        u8"こける",
        u8"ここのか",
        u8"こころ",
        u8"こさめ",
        u8"こしつ",
        u8"こすう",
        u8"こせい",
        u8"こせき",
        u8"こぜん",
        u8"こそだて",
        u8"こたい",
        u8"こたえる",
        u8"こたつ",
        u8"こちょう",
        u8"こっか",
        u8"こつこつ",
        u8"こつばん",
        u8"こつぶ",
        u8"こてい",
        u8"こてん",
        u8"ことがら",
        u8"ことし",
        u8"ことば",
        u8"ことり",
        u8"こなごな",
        u8"こねこね",
        u8"このまま",
        u8"このみ",
        u8"このよ",
        u8"こひつじ",
        u8"こふう",
        u8"こふん",
        u8"こぼれる",
        u8"こまかい",
        u8"こまつな",
        u8"こまる",
        u8"こむぎこ",
        u8"こもじ",
        u8"こもち",
        u8"こもの",
        u8"こもん",
        u8"こやく",
        u8"こやま",
        u8"こゆう",
        u8"こゆび",
        u8"こよい",
        u8"こよう",
        u8"こりる",
        u8"これくしょん",
        u8"ころっけ",
        u8"こわもて",
        u8"こわれる",
        u8"こんいん",
        u8"こんかい",
        u8"こんき",
        u8"こんしゅう",
        u8"こんすい",
        u8"こんだて",
        u8"こんとん",
        u8"こんなん",
        u8"こんびに",
        u8"こんぽん",
        u8"こんまけ",
        u8"こんや",
        u8"こんれい",
        u8"こんわく",
        u8"ごうい",
        u8"ごうきゅう",
        u8"ごうけい",
        u8"ごうせい",
        u8"ごうほう",
        u8"ごうまん",
        u8"ごかい",
        u8"ごかん",
        u8"ごがつ",
        u8"ごはん",
        u8"ごまあぶら",
        u8"ごますり",
        u8"さいかい",
        u8"さいきん",
        u8"さいしょ",
        u8"さいせい",
        u8"さいてき",
        u8"さうな",
        u8"さかいし",
        u8"さかな",
        u8"さかみち",
        u8"さがす",
        u8"さがる",
        u8"さぎょう",
        u8"さくし",
        u8"さくひん",
        u8"さくら",
        u8"さこく",
        u8"さこつ",
        u8"さずかる",
        u8"さたん",
        u8"さっきょく",
        u8"さつえい",
        u8"さつじん",
        u8"さつたば",
        u8"さつまいも",
        u8"さてい",
        u8"さといも",
        u8"さとう",
        u8"さとおや",
        u8"さとし",
        u8"さとる",
        u8"さのう",
        u8"さばく",
        u8"さびしい",
        u8"さべつ",
        u8"さほう",
        u8"さほど",
        u8"さます",
        u8"さみしい",
        u8"さみだれ",
        u8"さむけ",
        u8"さめる",
        u8"さやえんどう",
        u8"さゆう",
        u8"さよう",
        u8"さよく",
        u8"さらだ",
        u8"さわやか",
        u8"さわる",
        u8"さんいん",
        u8"さんか",
        u8"さんきゃく",
        u8"さんこう",
        u8"さんさい",
        u8"さんすう",
        u8"さんせい",
        u8"さんそ",
        u8"さんち",
        u8"さんま",
        u8"さんみ",
        u8"さんらん",
        u8"ざいえき",
        u8"ざいげん",
        u8"ざいこ",
        u8"ざいたく",
        u8"ざいちゅう",
        u8"ざいりょう",
        u8"ざせき",
        u8"ざっか",
        u8"ざっし",
        u8"ざっそう",
        u8"ざつおん",
        u8"ざつがく",
        u8"ざるそば",
        u8"ざんしょ",
        u8"しあい",
        u8"しあげ",
        u8"しあさって",
        u8"しあわせ",
        u8"しいく",
        u8"しいん",
        u8"しうち",
        u8"しえい",
        u8"しおけ",
        u8"しかい",
        u8"しかく",
        u8"しごと",
        u8"しすう",
        u8"したうけ",
        u8"したぎ",
        u8"したて",
        u8"したみ",
        u8"しちょう",
        u8"しちりん",
        u8"しっかり",
        u8"しつじ",
        u8"しつもん",
        u8"してい",
        u8"してき",
        u8"してつ",
        u8"しなぎれ",
        u8"しなもの",
        u8"しなん",
        u8"しねま",
        u8"しねん",
        u8"しのぐ",
        u8"しのぶ",
        u8"しはい",
        u8"しはつ",
        u8"しはらい",
        u8"しはん",
        u8"しばかり",
        u8"しひょう",
        u8"しふく",
        u8"しへい",
        u8"しほう",
        u8"しほん",
        u8"しまう",
        u8"しまる",
        u8"しみん",
        u8"しむける",
        u8"しめい",
        u8"しめる",
        u8"しもん",
        u8"しゃいん",
        u8"しゃうん",
        u8"しゃおん",
        u8"しゃくほう",
        u8"しゃけん",
        u8"しゃこ",
        u8"しゃざい",
        u8"しゃしん",
        u8"しゃせん",
        u8"しゃそう",
        u8"しゃたい",
        u8"しゃちょう",
        u8"しゃっきん",
        u8"しゃりん",
        u8"しゃれい",
        u8"しやくしょ",
        u8"しゅくはく",
        u8"しゅっせき",
        u8"しゅみ",
        u8"しゅらば",
        u8"しょうかい",
        u8"しょくたく",
        u8"しょっけん",
        u8"しょどう",
        u8"しょもつ",
        u8"しらせる",
        u8"しらべる",
        u8"しんか",
        u8"しんこう",
        u8"しんせいじ",
        u8"しんちく",
        u8"しんりん",
        u8"じかん",
        u8"じだい",
        u8"じてん",
        u8"じどう",
        u8"じぶん",
        u8"じむしょ",
        u8"じゃがいも",
        u8"じゃま",
        u8"じゅうしょ",
        u8"じゅしん",
        u8"じゅんばん",
        u8"じゆう",
        u8"じんじゃ",
        u8"すあげ",
        u8"すあし",
        u8"すあな",
        u8"すいえい",
        u8"すいか",
        u8"すいとう",
        u8"すいようび",
        u8"すうがく",
        u8"すうじつ",
        u8"すうせん",
        u8"すおどり",
        u8"すきま",
        u8"すくう",
        u8"すくない",
        u8"すける",
        u8"すこし",
        u8"すごい",
        u8"すすむ",
        u8"すすめる",
        u8"すずしい",
        u8"すっかり",
        u8"すてき",
        u8"すてる",
        u8"すねる",
        u8"すのこ",
        u8"すはだ",
        u8"すばらしい",
        u8"すふれ",
        u8"すぶり",
        u8"すべて",
        u8"すべる",
        u8"すぼん",
        u8"すまい",
        u8"すめし",
        u8"すもう",
        u8"すやき",
        u8"すらすら",
        u8"するめ",
        u8"すれちがう",
        u8"すろっと",
        u8"すわる",
        u8"すんぜん",
        u8"すんぽう",
        u8"ずあん",
        u8"ずいぶん",
        u8"ずさん",
        u8"ずっしり",
        u8"ずっと",
        u8"ずひょう",
        u8"ずぶぬれ",
        u8"ずほう",
        u8"せあぶら",
        u8"せいかつ",
        u8"せいげん",
        u8"せいじ",
        u8"せいよう",
        u8"せおう",
        u8"せかいかん",
        u8"せきにん",
        u8"せきむ",
        u8"せきゆ",
        u8"せきらんうん",
        u8"せけん",
        u8"せこう",
        u8"せすじ",
        u8"せたい",
        u8"せたけ",
        u8"せっかく",
        u8"せっきゃく",
        u8"せっけん",
        u8"せっこつ",
        u8"せっさたくま",
        u8"せっぱん",
        u8"せつぞく",
        u8"せつだん",
        u8"せつでん",
        u8"せつび",
        u8"せつぶん",
        u8"せつめい",
        u8"せつりつ",
        u8"せなか",
        u8"せのび",
        u8"せはば",
        u8"せびろ",
        u8"せぼね",
        u8"せまい",
        u8"せまる",
        u8"せめる",
        u8"せもたれ",
        u8"せりふ",
        u8"せんい",
        u8"せんえい",
        u8"せんか",
        u8"せんきょ",
        u8"せんく",
        u8"せんげん",
        u8"せんさい",
        u8"せんしゅ",
        u8"せんすい",
        u8"せんせい",
        u8"せんぞ",
        u8"せんたく",
        u8"せんちょう",
        u8"せんてい",
        u8"せんとう",
        u8"せんぬき",
        u8"せんねん",
        u8"せんぱい",
        u8"せんむ",
        u8"せんめんじょ",
        u8"せんもん",
        u8"せんやく",
        u8"せんゆう",
        u8"せんよう",
        u8"せんれい",
        u8"せんろ",
        u8"ぜっく",
        u8"ぜんあく",
        u8"ぜんご",
        u8"ぜんぶ",
        u8"ぜんぽう",
        u8"ぜんら",
        u8"ぜんりゃく",
        u8"そあく",
        u8"そいとげる",
        u8"そいね",
        u8"そうがんきょう",
        u8"そうき",
        u8"そうご",
        u8"そうしん",
        u8"そうだん",
        u8"そうなん",
        u8"そうび",
        u8"そうめん",
        u8"そうり",
        u8"そえもの",
        u8"そえん",
        u8"そがい",
        u8"そげき",
        u8"そこう",
        u8"そこそこ",
        u8"そざい",
        u8"そしな",
        u8"そせい",
        u8"そせん",
        u8"そそぐ",
        u8"そだてる",
        u8"そっかん",
        u8"そっけつ",
        u8"そっこう",
        u8"そっせん",
        u8"そっと",
        u8"そつう",
        u8"そつえん",
        u8"そつぎょう",
        u8"そとがわ",
        u8"そとづら",
        u8"そなえる",
        u8"そなた",
        u8"そふぼ",
        u8"そぼく",
        u8"そぼろ",
        u8"そまつ",
        u8"そまる",
        u8"そむく",
        u8"そむりえ",
        u8"そめる",
        u8"そもそも",
        u8"そよかぜ",
        u8"そらまめ",
        u8"そろう",
        u8"そんかい",
        u8"そんけい",
        u8"そんざい",
        u8"そんしつ",
        u8"そんぞく",
        u8"そんちょう",
        u8"そんみん",
        u8"ぞんび",
        u8"ぞんぶん",
        u8"たあい",
        u8"たいいん",
        u8"たいうん",
        u8"たいえき",
        u8"たいおう",
        u8"たいき",
        u8"たいぐう",
        u8"たいけん",
        u8"たいこ",
        u8"たいざい",
        u8"たいせつ",
        u8"たいそう",
        u8"たいちょう",
        u8"たいてい",
        u8"たいない",
        u8"たいねつ",
        u8"たいのう",
        u8"たいはん",
        u8"たいふう",
        u8"たいへん",
        u8"たいほ",
        u8"たいまつばな",
        u8"たいみんぐ",
        u8"たいむ",
        u8"たいめん",
        u8"たいやき",
        u8"たいよう",
        u8"たいら",
        u8"たいりょく",
        u8"たいる",
        u8"たいわん",
        u8"たうえ",
        u8"たえる",
        u8"たおす",
        u8"たおる",
        u8"たおれる",
        u8"たかい",
        u8"たかね",
        u8"たきび",
        u8"たくさん",
        u8"たこく",
        u8"たこやき",
        u8"たさい",
        u8"たしざん",
        u8"たすける",
        u8"たずさわる",
        u8"たそがれ",
        u8"たたかう",
        u8"たたく",
        u8"たたみ",
        u8"ただしい",
        u8"たちばな",
        u8"たてる",
        u8"たとえる",
        u8"たなばた",
        u8"たにん",
        u8"たぬき",
        u8"たのしみ",
        u8"たはつ",
        u8"たぶん",
        u8"たべる",
        u8"たぼう",
        u8"たまご",
        u8"たまる",
        u8"ためいき",
        u8"ためす",
        u8"ためる",
        u8"たもつ",
        u8"たやすい",
        u8"たよる",
        u8"たらす",
        u8"たりきほんがん",
        u8"たりょう",
        u8"たりる",
        u8"たると",
        u8"たれる",
        u8"たれんと",
        u8"たろっと",
        u8"たわむれる",
        u8"たんい",
        u8"たんおん",
        u8"たんか",
        u8"たんき",
        u8"たんけん",
        u8"たんご",
        u8"たんさん",
        u8"たんじょうび",
        u8"たんそく",
        u8"たんたい",
        u8"たんてい",
        u8"たんとう",
        u8"たんにん",
        u8"たんのう",
        u8"たんぴん",
        u8"たんまつ",
        u8"たんめい",
        u8"だいがく",
        u8"だいじょうぶ",
        u8"だいすき",
        u8"だいたい",
        u8"だいどころ",
        u8"だいひょう",
        u8"だじゃれ",
        u8"だっかい",
        u8"だっきゃく",
        u8"だっこ",
        u8"だっしゅつ",
        u8"だったい",
        u8"だむる",
        u8"だんあつ",
        u8"だんせい",
        u8"だんち",
        u8"だんな",
        u8"だんねつ",
        u8"だんぼう",
        u8"だんれつ",
        u8"だんろ",
        u8"だんわ",
        u8"ちあい",
        u8"ちあん",
        u8"ちいき",
        u8"ちいさい",
        u8"ちえん",
        u8"ちかい",
        u8"ちから",
        u8"ちきゅう",
        u8"ちきん",
        u8"ちけいず",
        u8"ちけん",
        u8"ちこく",
        u8"ちさい",
        u8"ちしき",
        u8"ちしりょう",
        u8"ちせい",
        u8"ちそう",
        u8"ちたい",
        u8"ちたん",
        u8"ちちおや",
        u8"ちつじょ",
        u8"ちてき",
        u8"ちてん",
        u8"ちぬき",
        u8"ちぬり",
        u8"ちのう",
        u8"ちひょう",
        u8"ちへいせん",
        u8"ちほう",
        u8"ちまた",
        u8"ちみつ",
        u8"ちみどろ",
        u8"ちめいど",
        u8"ちゃんこなべ",
        u8"ちゅうい",
        u8"ちゆりょく",
        u8"ちょうし",
        u8"ちょさくけん",
        u8"ちらし",
        u8"ちらみ",
        u8"ちりがみ",
        u8"ちりょう",
        u8"ちるど",
        u8"ちわわ",
        u8"ちんたい",
        u8"ちんもく",
        u8"ついか",
        u8"ついたち",
        u8"つうか",
        u8"つうじょう",
        u8"つうはん",
        u8"つうわ",
        u8"つかう",
        u8"つかれる",
        u8"つくね",
        u8"つくる",
        u8"つけね",
        u8"つける",
        u8"つごう",
        u8"つたえる",
        u8"つつじ",
        u8"つつむ",
        u8"つづく",
        u8"つとめる",
        u8"つながる",
        u8"つなみ",
        u8"つねづね",
        u8"つのる",
        u8"つぶす",
        u8"つまらない",
        u8"つまる",
        u8"つみき",
        u8"つめたい",
        u8"つもり",
        u8"つもる",
        u8"つよい",
        u8"つるぼ",
        u8"つるみく",
        u8"つわもの",
        u8"つわり",
        u8"てあし",
        u8"てあて",
        u8"てあみ",
        u8"ていおん",
        u8"ていか",
        u8"ていき",
        u8"ていけい",
        u8"ていこく",
        u8"ていさつ",
        u8"ていし",
        u8"ていせい",
        u8"ていたい",
        u8"ていど",
        u8"ていねい",
        u8"ていひょう",
        u8"ていへん",
        u8"ていぼう",
        u8"てうち",
        u8"ておくれ",
        u8"てきとう",
        u8"てくび",
        u8"てさぎょう",
        u8"てさげ",
        u8"てすり",
        u8"てそう",
        u8"てちがい",
        u8"てちょう",
        u8"てつがく",
        u8"てつづき",
        u8"てつぼう",
        u8"てつや",
        u8"てぬき",
        u8"てぬぐい",
        u8"てのひら",
        u8"てはい",
        u8"てふだ",
        u8"てぶくろ",
        u8"てほどき",
        u8"てほん",
        u8"てまえ",
        u8"てまきずし",
        u8"てみじか",
        u8"てみやげ",
        u8"てらす",
        u8"てれび",
        u8"てわけ",
        u8"てわたし",
        u8"てんいん",
        u8"てんかい",
        u8"てんき",
        u8"てんぐ",
        u8"てんけん",
        u8"てんごく",
        u8"てんさい",
        u8"てんし",
        u8"てんすう",
        u8"てんてき",
        u8"てんとう",
        u8"てんない",
        u8"てんぷら",
        u8"てんぼうだい",
        u8"てんめつ",
        u8"てんらんかい",
        u8"でこぼこ",
        u8"でっぱ",
        u8"でぬかえ",
        u8"でんあつ",
        u8"でんち",
        u8"でんりょく",
        u8"でんわ",
        u8"といれ",
        u8"とうきゅう",
        u8"とうし",
        u8"とうむぎ",
        u8"とおい",
        u8"とおか",
        u8"とおく",
        u8"とおす",
        u8"とおる",
        u8"とかい",
        u8"とかす",
        u8"ときおり",
        u8"ときどき",
        u8"とくい",
        u8"とくしゅう",
        u8"とくてん",
        u8"とくに",
        u8"とくべつ",
        u8"とけい",
        u8"とける",
        u8"とこや",
        u8"とさか",
        u8"としょかん",
        u8"とそう",
        u8"とたん",
        u8"とちゅう",
        u8"とっきゅう",
        u8"とっくん",
        u8"とつぜん",
        u8"とつにゅう",
        u8"ととのえる",
        u8"とどける",
        u8"とない",
        u8"となえる",
        u8"となり",
        u8"とのさま",
        u8"とばす",
        u8"とほう",
        u8"とまる",
        u8"とめる",
        u8"ともだち",
        u8"ともる",
        u8"とらえる",
        u8"とんかつ",
        u8"どあい",
        u8"どうかん",
        u8"どうぐ",
        u8"どぶがわ",
        u8"どようび",
        u8"どんぶり",
        u8"ないかく",
        u8"ないこう",
        u8"ないしょ",
        u8"ないす",
        u8"ないせん",
        u8"ないそう",
        u8"なおす",
        u8"ながい",
        u8"なくす",
        u8"なげる",
        u8"なこうど",
        u8"なさけ",
        u8"なたでここ",
        u8"なっとう",
        u8"なつやすみ",
        u8"ななおし",
        u8"なにごと",
        u8"なにもの",
        u8"なにわ",
        u8"なのか",
        u8"なふだ",
        u8"なまいき",
        u8"なまえ",
        u8"なまみ",
        u8"なみだ",
        u8"なめらか",
        u8"なめる",
        u8"なやむ",
        u8"ならう",
        u8"ならび",
        u8"ならぶ",
        u8"なれる",
        u8"なわとび",
        u8"なわばり",
        u8"にあう",
        u8"にいがた",
        u8"にうけ",
        u8"におい",
        u8"にかい",
        u8"にがて",
        u8"にきび",
        u8"にくしみ",
        u8"にくまん",
        u8"にげる",
        u8"にさんかたんそ",
        u8"にしき",
        u8"にせもの",
        u8"にちじょう",
        u8"にちようび",
        u8"にっか",
        u8"にっき",
        u8"にっけい",
        u8"にっこう",
        u8"にっさん",
        u8"にっしょく",
        u8"にっすう",
        u8"にっせき",
        u8"にってい",
        u8"になう",
        u8"にほん",
        u8"にまめ",
        u8"にもつ",
        u8"にやり",
        u8"にゅういん",
        u8"にりんしゃ",
        u8"にわとり",
        u8"にんい",
        u8"にんか",
        u8"にんき",
        u8"にんげん",
        u8"にんしき",
        u8"にんずう",
        u8"にんそう",
        u8"にんたい",
        u8"にんち",
        u8"にんてい",
        u8"にんにく",
        u8"にんぷ",
        u8"にんまり",
        u8"にんむ",
        u8"にんめい",
        u8"にんよう",
        u8"ぬいくぎ",
        u8"ぬかす",
        u8"ぬくもり",
        u8"ぬぐいとる",
        u8"ぬぐう",
        u8"ぬすむ",
        u8"ぬまえび",
        u8"ぬめり",
        u8"ぬらす",
        u8"ぬんちゃく",
        u8"ねあげ",
        u8"ねいき",
        u8"ねいる",
        u8"ねいろ",
        u8"ねくたい",
        u8"ねくら",
        u8"ねぐせ",
        u8"ねこぜ",
        u8"ねこむ",
        u8"ねさげ",
        u8"ねすごす",
        u8"ねそべる",
        u8"ねだん",
        u8"ねっしん",
        u8"ねったいぎょ",
        u8"ねつい",
        u8"ねつぞう",
        u8"ねふだ",
        u8"ねぶそく",
        u8"ねほりはほり",
        u8"ねぼう",
        u8"ねまき",
        u8"ねまわし",
        u8"ねみみ",
        u8"ねむい",
        u8"ねむたい",
        u8"ねもと",
        u8"ねらう",
        u8"ねわざ",
        u8"ねんいり",
        u8"ねんおし",
        u8"ねんかん",
        u8"ねんきん",
        u8"ねんぐ",
        u8"ねんざ",
        u8"ねんし",
        u8"ねんちゃく",
        u8"ねんど",
        u8"ねんぴ",
        u8"ねんぶつ",
        u8"ねんまつ",
        u8"ねんりょう",
        u8"ねんれい",
        u8"のいず",
        u8"のおづま",
        u8"のがす",
        u8"のきなみ",
        u8"のこぎり",
        u8"のこす",
        u8"のこる",
        u8"のせる",
        u8"のぞく",
        u8"のぞむ",
        u8"のたまう",
        u8"のちほど",
        u8"のっく",
        u8"のはら",
        u8"のばす",
        u8"のべる",
        u8"のぼる",
        u8"のみもの",
        u8"のやま",
        u8"のらいぬ",
        u8"のらねこ",
        u8"のりもの",
        u8"のりゆき",
        u8"のれん",
        u8"のんき",
        u8"はあく",
        u8"はいけん",
        u8"はいご",
        u8"はいしん",
        u8"はいすい",
        u8"はいせん",
        u8"はいそう",
        u8"はいち",
        u8"はいれつ",
        u8"はえる",
        u8"はおる",
        u8"はかい",
        u8"はかる",
        u8"はくしゅ",
        u8"はけん",
        u8"はこぶ",
        u8"はさみ",
        u8"はさん",
        u8"はしご",
        u8"はしる",
        u8"はせる",
        u8"はそん",
        u8"はたん",
        u8"はちみつ",
        u8"はっかく",
        u8"はっきり",
        u8"はっくつ",
        u8"はっけん",
        u8"はっこう",
        u8"はっさん",
        u8"はっしん",
        u8"はったつ",
        u8"はっちゅう",
        u8"はってん",
        u8"はっぴょう",
        u8"はっぽう",
        u8"はつおん",
        u8"はづき",
        u8"はなす",
        u8"はなび",
        u8"はにかむ",
        u8"はぶらし",
        u8"はみがき",
        u8"はむかう",
        u8"はめつ",
        u8"はやい",
        u8"はやし",
        u8"はらう",
        u8"はろうぃん",
        u8"はわい",
        u8"はんい",
        u8"はんえい",
        u8"はんおん",
        u8"はんかく",
        u8"はんきょう",
        u8"はんこ",
        u8"はんしゃ",
        u8"はんすう",
        u8"はんだん",
        u8"はんてい",
        u8"はんとし",
        u8"はんのう",
        u8"はんぱ",
        u8"はんぶん",
        u8"はんぺん",
        u8"はんぼうき",
        u8"はんめい",
        u8"はんらん",
        u8"はんろん",
        u8"ばあい",
        u8"ばあさん",
        u8"ばいか",
        u8"ばいく",
        u8"ばいばい",
        u8"ばかり",
        u8"ばしょ",
        u8"ばんぐみ",
        u8"ぱそこん",
        u8"ぱんち",
        u8"ぱんつ",
        u8"ひいき",
        u8"ひうん",
        u8"ひえる",
        u8"ひかく",
        u8"ひかり",
        u8"ひかる",
        u8"ひかん",
        u8"ひくい",
        u8"ひけつ",
        u8"ひこうき",
        u8"ひこく",
        u8"ひさい",
        u8"ひさしぶり",
        u8"ひさん",
        u8"ひしょ",
        u8"ひそか",
        u8"ひそむ",
        u8"ひたむき",
        u8"ひたる",
        u8"ひだり",
        u8"ひっこし",
        u8"ひっし",
        u8"ひっす",
        u8"ひつぎ",
        u8"ひつじゅひん",
        u8"ひつぜん",
        u8"ひつよう",
        u8"ひてい",
        u8"ひとごみ",
        u8"ひなまつり",
        u8"ひなん",
        u8"ひねる",
        u8"ひはん",
        u8"ひひょう",
        u8"ひびく",
        u8"ひほう",
        u8"ひまわり",
        u8"ひまん",
        u8"ひみつ",
        u8"ひめい",
        u8"ひめじし",
        u8"ひやけ",
        u8"ひやす",
        u8"ひよう",
        u8"ひらがな",
        u8"ひらく",
        u8"ひりつ",
        u8"ひりょう",
        u8"ひるま",
        u8"ひるやすみ",
        u8"ひれい",
        u8"ひろい",
        u8"ひろう",
        u8"ひろき",
        u8"ひろゆき",
        u8"ひんかく",
        u8"ひんけつ",
        u8"ひんこん",
        u8"ひんしゅ",
        u8"ひんそう",
        u8"ひんぱん",
        u8"びじゅつかん",
        u8"びょうき",
        u8"びんぼう",
        u8"ぴったり",
        u8"ぴっちり",
        u8"ぴんち",
        u8"ふあん",
        u8"ふいうち",
        u8"ふうけい",
        u8"ふうせん",
        u8"ふうとう",
        u8"ふうふ",
        u8"ふえる",
        u8"ふおん",
        u8"ふかい",
        u8"ふきん",
        u8"ふくざつ",
        u8"ふくぶくろ",
        u8"ふこう",
        u8"ふさい",
        u8"ふしぎ",
        u8"ふじみ",
        u8"ふすま",
        u8"ふせい",
        u8"ふせぐ",
        u8"ふそく",
        u8"ふたん",
        u8"ふちょう",
        u8"ふっかつ",
        u8"ふっき",
        u8"ふっこく",
        u8"ふつう",
        u8"ふつか",
        u8"ふとる",
        u8"ふとん",
        u8"ふのう",
        u8"ふはい",
        u8"ふひょう",
        u8"ふへん",
        u8"ふまん",
        u8"ふみん",
        u8"ふめつ",
        u8"ふめん",
        u8"ふよう",
        u8"ふりこ",
        u8"ふりる",
        u8"ふるい",
        u8"ふんいき",
        u8"ふんしつ",
        u8"ふんそう",
        u8"ぶたにく",
        u8"ぶどう",
        u8"ぶんがく",
        u8"ぶんぐ",
        u8"ぶんせき",
        u8"ぶんぽう",
        u8"ぷうたろう",
        u8"へいあん",
        u8"へいおん",
        u8"へいがい",
        u8"へいき",
        u8"へいげん",
        u8"へいこう",
        u8"へいさ",
        u8"へいしゃ",
        u8"へいせつ",
        u8"へいそ",
        u8"へいたく",
        u8"へいてん",
        u8"へいねつ",
        u8"へいわ",
        u8"へきが",
        u8"へこむ",
        u8"へらす",
        u8"へんかん",
        u8"へんさい",
        u8"へんたい",
        u8"べにいろ",
        u8"べにしょうが",
        u8"べんきょう",
        u8"べんごし",
        u8"べんり",
        u8"ほあん",
        u8"ほいく",
        u8"ほうこく",
        u8"ほうそう",
        u8"ほうほう",
        u8"ほうもん",
        u8"ほうりつ",
        u8"ほえる",
        u8"ほおん",
        u8"ほかん",
        u8"ほきょう",
        u8"ほくろ",
        u8"ほけつ",
        u8"ほけん",
        u8"ほこう",
        u8"ほこる",
        u8"ほしい",
        u8"ほしつ",
        u8"ほしゅ",
        u8"ほしょう",
        u8"ほせい",
        u8"ほそい",
        u8"ほそく",
        u8"ほたて",
        u8"ほたる",
        u8"ほっきょく",
        u8"ほっさ",
        u8"ほったん",
        u8"ほとんど",
        u8"ほめる",
        u8"ほんい",
        u8"ほんき",
        u8"ほんけ",
        u8"ほんしつ",
        u8"ほんやく",
        u8"ぼうぎょ",
        u8"ぼきん",
        u8"ぽちぶくろ",
        u8"まいにち",
        u8"まかい",
        u8"まかせる",
        u8"まがる",
        u8"まける",
        u8"まこと",
        u8"まさつ",
        u8"まじめ",
        u8"ますく",
        u8"まぜる",
        u8"まつり",
        u8"まとめ",
        u8"まなぶ",
        u8"まぬけ",
        u8"まねく",
        u8"まほう",
        u8"まもる",
        u8"まゆげ",
        u8"まよう",
        u8"まろやか",
        u8"まわす",
        u8"まわり",
        u8"まわる",
        u8"まんが",
        u8"まんきつ",
        u8"まんぞく",
        u8"まんなか",
        u8"みいら",
        u8"みうち",
        u8"みえる",
        u8"みかた",
        u8"みかん",
        u8"みがく",
        u8"みけん",
        u8"みこん",
        u8"みじかい",
        u8"みすい",
        u8"みすえる",
        u8"みせる",
        u8"みっか",
        u8"みつかる",
        u8"みつける",
        u8"みてい",
        u8"みとめる",
        u8"みなと",
        u8"みなみかさい",
        u8"みねらる",
        u8"みのう",
        u8"みのがす",
        u8"みほん",
        u8"みもと",
        u8"みやげ",
        u8"みらい",
        u8"みりょく",
        u8"みわく",
        u8"みんか",
        u8"みんぞく",
        u8"むいか",
        u8"むえき",
        u8"むえん",
        u8"むかい",
        u8"むかう",
        u8"むかえ",
        u8"むかし",
        u8"むぎちゃ",
        u8"むける",
        u8"むげん",
        u8"むさぼる",
        u8"むしあつい",
        u8"むしば",
        u8"むしろ",
        u8"むじゅん",
        u8"むすう",
        u8"むすこ",
        u8"むすぶ",
        u8"むすめ",
        u8"むせる",
        u8"むせん",
        u8"むちゅう",
        u8"むなしい",
        u8"むのう",
        u8"むやみ",
        u8"むよう",
        u8"むらさき",
        u8"むりょう",
        u8"むろん",
        u8"めいあん",
        u8"めいうん",
        u8"めいえん",
        u8"めいかく",
        u8"めいきょく",
        u8"めいさい",
        u8"めいし",
        u8"めいそう",
        u8"めいぶつ",
        u8"めいれい",
        u8"めいわく",
        u8"めぐまれる",
        u8"めざす",
        u8"めした",
        u8"めずらしい",
        u8"めだつ",
        u8"めまい",
        u8"めやす",
        u8"めんきょ",
        u8"めんせき",
        u8"めんどう",
        u8"もうしあげる",
        u8"もうどうけん",
        u8"もえる",
        u8"もくし",
        u8"もくてき",
        u8"もくようび",
        u8"もちろん",
        u8"もどる",
        u8"もらう",
        u8"もんく",
        u8"もんだい",
        u8"やおや",
        u8"やける",
        u8"やさい",
        u8"やさしい",
        u8"やすい",
        u8"やすたろう",
        u8"やすみ",
        u8"やせる",
        u8"やそう",
        u8"やたい",
        u8"やちん",
        u8"やっと",
        u8"やっぱり",
        u8"やぶる",
        u8"やめる",
        u8"ややこしい",
        u8"やよい",
        u8"やわらかい",
        u8"ゆうき",
        u8"ゆうびんきょく",
        u8"ゆうべ",
        u8"ゆうめい",
        u8"ゆけつ",
        u8"ゆしゅつ",
        u8"ゆせん",
        u8"ゆそう",
        u8"ゆたか",
        u8"ゆちゃく",
        u8"ゆでる",
        u8"ゆにゅう",
        u8"ゆびわ",
        u8"ゆらい",
        u8"ゆれる",
        u8"ようい",
        u8"ようか",
        u8"ようきゅう",
        u8"ようじ",
        u8"ようす",
        u8"ようちえん",
        u8"よかぜ",
        u8"よかん",
        u8"よきん",
        u8"よくせい",
        u8"よくぼう",
        u8"よけい",
        u8"よごれる",
        u8"よさん",
        u8"よしゅう",
        u8"よそう",
        u8"よそく",
        u8"よっか",
        u8"よてい",
        u8"よどがわく",
        u8"よねつ",
        u8"よやく",
        u8"よゆう",
        u8"よろこぶ",
        u8"よろしい",
        u8"らいう",
        u8"らくがき",
        u8"らくご",
        u8"らくさつ",
        u8"らくだ",
        u8"らしんばん",
        u8"らせん",
        u8"らぞく",
        u8"らたい",
        u8"らっか",
        u8"られつ",
        u8"りえき",
        u8"りかい",
        u8"りきさく",
        u8"りきせつ",
        u8"りくぐん",
        u8"りくつ",
        u8"りけん",
        u8"りこう",
        u8"りせい",
        u8"りそう",
        u8"りそく",
        u8"りてん",
        u8"りねん",
        u8"りゅうがく",
        u8"りゆう",
        u8"りょうり",
        u8"りょかん",
        u8"りょくちゃ",
        u8"りょこう",
        u8"りよう",
        u8"りりく",
        u8"りれき",
        u8"りろん",
        u8"りんご",
        u8"るいけい",
        u8"るいさい",
        u8"るいじ",
        u8"るいせき",
        u8"るすばん",
        u8"るりがわら",
        u8"れいかん",
        u8"れいぎ",
        u8"れいせい",
        u8"れいぞうこ",
        u8"れいとう",
        u8"れいぼう",
        u8"れきし",
        u8"れきだい",
        u8"れんあい",
        u8"れんけい",
        u8"れんこん",
        u8"れんさい",
        u8"れんしゅう",
        u8"れんぞく",
        u8"れんらく",
        u8"ろうか",
        u8"ろうご",
        u8"ろうじん",
        u8"ろうそく",
        u8"ろくが",
        u8"ろこつ",
        u8"ろしゅつ",
        u8"ろじうら",
        u8"ろせん",
        u8"ろてん",
        u8"ろめん",
        u8"ろれつ",
        u8"ろんぎ",
        u8"ろんぱ",
        u8"ろんぶん",
        u8"ろんり",
        u8"わかす",
        u8"わかめ",
        u8"わかやま",
        u8"わかれる",
        u8"わしつ",
        u8"わじまし",
        u8"わすれもの",
        u8"わらう",
        u8"われる",
    }
};
