dnl This is m4 source.
dnl Process using m4 to produce 'C' language file.
dnl
dnl If you see this line, you can ignore the next one.
/* Do not edit this file. It is produced from the corresponding .m4 source */
dnl
/*
 *  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id$ */


ifdef(`PNETCDF',`dnl
#define NC_ERR_CODE_NAME ncmpi_strerrno',`dnl
#define NC_ERR_CODE_NAME nc_err_code_name')

define(`EXPECT_ERR',`error("expecting $1 but got %s",NC_ERR_CODE_NAME($2));')dnl

define(`IntType', `ifdef(`PNETCDF',`MPI_Offset',`size_t')')dnl
define(`PTRDType',`ifdef(`PNETCDF',`MPI_Offset',`ptrdiff_t')')dnl
define(`TestFunc',`ifdef(`PNETCDF',`test_ncmpi_iget_$1',`test_nc_iget_$1')')dnl
define(`APIFunc',` ifdef(`PNETCDF',`ncmpi_$1',`nc_$1')')dnl

define(`FileOpen', `ifdef(`PNETCDF',`ncmpi_open(comm, $1, $2, info, &ncid)', `fi
le_open($1, $2, &ncid)')')dnl

define(`VarArgs',   `ifdef(`PNETCDF',`int numVars',`void')')dnl
define(`AttVarArgs',`ifdef(`PNETCDF',`int numGatts,int numVars',`void')')dnl

define(`iGetVar1',`ifdef(`PNETCDF',`ncmpi_iget_var1_$1',`nc_iget_var1_$1')')dnl
define(`iGetVar', `ifdef(`PNETCDF',`ncmpi_iget_var_$1', `nc_iget_var_$1')')dnl
define(`iGetVara',`ifdef(`PNETCDF',`ncmpi_iget_vara_$1',`nc_iget_vara_$1')')dnl
define(`iGetVars',`ifdef(`PNETCDF',`ncmpi_iget_vars_$1',`nc_iget_vars_$1')')dnl
define(`iGetVarm',`ifdef(`PNETCDF',`ncmpi_iget_varm_$1',`nc_iget_varm_$1')')dnl

undefine(`index')dnl
dnl dnl dnl
dnl
dnl Macros
dnl
dnl dnl dnl
dnl
dnl Upcase(str)
dnl
define(`Upcase',dnl
`dnl
translit($1, abcdefghijklmnopqrstuvwxyz, ABCDEFGHIJKLMNOPQRSTUVWXYZ)')dnl
dnl dnl dnl
dnl
dnl NCT_ITYPE(type)
dnl
define(`NCT_ITYPE', ``NCT_'Upcase($1)')dnl
dnl

define(`CheckText', `ifelse(`$1',`text', , `== (NCT_ITYPE($1) == NCT_TEXT)')')dnl
define(`CheckRange',`ifelse(`$1',`text', `1', `($2 >= $1_min && $2 <= $1_max)')')dnl
define(`IfCheckTextChar', `ifelse(`$1',`text', `if ($2 != NC_CHAR)')')dnl
define(`CheckNumRange',
       `ifelse(`$1',`text', `1',
               `inRange3(cdf_format, $2,$3,NCT_ITYPE($1)) && ($2 >= $1_min && $2 <= $1_max)')')dnl

#include "tests.h"

int
TestFunc(var1)(VarArgs)
{
    int i, j, err, st, ncid, nok=0, reqid;
    IntType index[MAX_RANK];
    double expect, value[1];
    MPI_Datatype datatype;

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iget_var1)(BAD_ID, 0, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iget_var1)(ncid, BAD_VARID, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = APIFunc(iget_var1)(BAD_ID, i, NULL, value, 1, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

ifdef(`PNETCDF',`dnl
        err = APIFunc(iget_var1)(ncid, i, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) {
            index[j] = var_shape[i][j]; /* make an out-of-boundary starts[] */
            err = APIFunc(iget_var1)(ncid, i, index, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            index[j] = 0;
        }
        err = APIFunc(iget_var1)(ncid, i, index, value, 1, datatype, &reqid);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK
        err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
        assert(err == st);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash(var_type[i], var_rank[i], index);
            err = APIFunc(iget_var1)(ncid, i, index, value, 1, datatype, &reqid);
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
            ELSE_NOK
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
            ELSE_NOK
            err = nc2dbl(var_type[i], value, value);
            IF (err)
                error("error in nc2dbl");
            if (inRange(expect,var_type[i])) {
                ifelse(`$1', `uchar', `
                /* in put_vars(), API _put_vara_double() is used to
                 * write the NC_BYTE variables to files. In this
                 * case, NC_BYTE variables are treated as signed
                 * for CDF-1 and 2 formats. Thus, we must skip the
                 * equal test below for uchar.
                 */
                if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect > schar_max) continue;')
                IF (!equal2(value[0],expect,var_type[i])) {
                    error("expected: %G, got: %G", expect, value[0]);
                }
                ELSE_NOK
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}

dnl TEST_NC_IGET_VAR1(TYPE)
dnl
define(`TEST_NC_IGET_VAR1',dnl
`dnl
int
TestFunc(var1)_$1(VarArgs)
{
    int i, err, st, ncid, cdf_format, reqid;
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j, index[MAX_RANK];
    double expect;
    $1 value[1];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iGetVar1($1)(BAD_ID, 0, NULL, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iGetVar1($1)(ncid, BAD_VARID, NULL, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = iGetVar1($1)(BAD_ID, i, NULL, value, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = iGetVar1($1)(ncid, i, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR) EXPECT_ERR(NC_ECHAR, err)
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            index[0] = 0;
            expect = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect, var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect)) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            index[j] = var_shape[i][j]; /* make an out-of-boundary starts[] */
            err = iGetVar1($1)(ncid, i, index, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
            } else IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            index[j] = 0;
        }

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            /* when file is created the variable contents are generated by
             * hash functions */
            expect = hash4(cdf_format, var_type[i], var_rank[i], index,
                           NCT_ITYPE($1));
            err = iGetVar1($1)(ncid, i, index, value, &reqid);
            if (canConvert) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
                err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
                assert(err == st);
                if (inRange3(cdf_format, expect,var_type[i], NCT_ITYPE($1))) {
                    if (CheckRange($1, expect)) {
                        IF (err != NC_NOERR) {
                            EXPECT_ERR(NC_NOERR, err)
                        } else {
                            ifelse(`$1', `uchar', `
                            /* in put_vars(), API _put_vara_double() is used to
                             * write the NC_BYTE variables to files. In this
                             * case, NC_BYTE variables are treated as signed
                             * for CDF-1 and 2 formats. Thus, we must skip the
                             * equal test below for uchar.
                             */
                            if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect > schar_max) continue;')
                            IF (!equal(value[0],expect,var_type[i],NCT_ITYPE($1)))
                                error("expected: %G, got: %G", expect, (double)value[0]);
                            ELSE_NOK
                        }
                    } else {
                        IF (err != NC_ERANGE)
                            EXPECT_ERR(NC_ERANGE, err)
                        ELSE_NOK
                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                    ELSE_NOK
                }
            } else {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_IGET_VAR1(text)
TEST_NC_IGET_VAR1(uchar)
TEST_NC_IGET_VAR1(schar)
TEST_NC_IGET_VAR1(short)
TEST_NC_IGET_VAR1(int)
TEST_NC_IGET_VAR1(long)
TEST_NC_IGET_VAR1(float)
TEST_NC_IGET_VAR1(double)
TEST_NC_IGET_VAR1(ushort)
TEST_NC_IGET_VAR1(uint)
TEST_NC_IGET_VAR1(longlong)
TEST_NC_IGET_VAR1(ulonglong)

int
TestFunc(var)(VarArgs)
{
    int i, err, st, ncid, nok=0, reqid;
    IntType j, index[MAX_RANK];
    MPI_Datatype datatype;
    double value[MAX_NELS], expect[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iget_var)(BAD_ID, 0, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iget_var)(ncid, BAD_VARID, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = APIFunc(iget_var)(BAD_ID, i, NULL, 0, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

        /* check if the contents are supposed to be */
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash(var_type[i], var_rank[i], index);
        }
        err = APIFunc(iget_var)(ncid, i, value, var_nels[i], datatype, &reqid);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK
        err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
        assert(err == st);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK

        for (j = 0; j < var_nels[i]; j++) {
            double got;
            char *p = (char *) value;
            p += j * nctypelen(var_type[i]);
            if (inRange(expect[j],var_type[i])) {
                err = nc2dbl(var_type[i], p, &got);
                IF (err != NC_NOERR)
                    error("error in nc2dbl");
                ifelse(`$1', `uchar', `
                /* in put_vars(), API _put_vara_double() is used to
                 * write the NC_BYTE variables to files. In this
                 * case, NC_BYTE variables are treated as signed
                 * for CDF-1 and 2 formats. Thus, we must skip the
                 * equal test below for uchar.
                 */
                if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                IF (!equal2(got,expect[j],var_type[i])) {
                    error("value read not that expected");
                    if (verbose) {
                        error("\n");
                        error("varid: %d, ", i);
                        error("var_name: %s, ", var_name[i]);
                        error("element number: %d ", j);
                        error("expect: %g", expect[j]);
                        error("got: %g", got);
                    }
                }
                ELSE_NOK
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}

dnl TEST_NC_IGET_VAR(TYPE)
dnl
define(`TEST_NC_IGET_VAR',dnl
`dnl
int
TestFunc(var)_$1(VarArgs)
{
    int i, err, st, ncid, cdf_format, reqid;
    int allInExtRange;  /* all values within range of external data type */
    int allInIntRange;  /* all values within range of internal data type */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j, index[MAX_RANK];
    double expect[MAX_NELS];
    $1 value[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iGetVar($1)(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iGetVar($1)(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = iGetVar($1)(BAD_ID, i, value, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        /* check if the contents are supposed to be */
        allInExtRange = allInIntRange = 1;
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                              NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[j],var_type[i], NCT_ITYPE($1))) {
                IfCheckTextChar($1, var_type[i])
                    allInIntRange &= CheckRange($1, expect[j]);
            } else
                allInExtRange = 0;
        }
        err = iGetVar($1)(ncid, i, value, &reqid);
        if (canConvert) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            if (allInExtRange) {
                if (allInIntRange) {
                    IF (err != NC_NOERR)
                        EXPECT_ERR(NC_NOERR, err)
                    ELSE_NOK
                } else {
                    IF (err != NC_ERANGE)
                        EXPECT_ERR(NC_ERANGE, err)
                    ELSE_NOK
                }
            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                ELSE_NOK
            }
            for (j = 0; j < var_nels[i]; j++) {
                if (CheckNumRange($1, expect[j], var_type[i])) {
                    ifelse(`$1', `uchar', `
                    /* in put_vars(), API _put_vara_double() is used to
                     * write the NC_BYTE variables to files. In this
                     * case, NC_BYTE variables are treated as signed
                     * for CDF-1 and 2 formats. Thus, we must skip the
                     * equal test below for uchar.
                     */
                    if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                    IF (!equal(value[j],expect[j],var_type[i],NCT_ITYPE($1))){
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("element number: %d ", j);
                            error("expect: %g", expect[j]);
                            error("got: %g", (double) value[j]);
                        }
                    }
                    ELSE_NOK
                }
            }
        } else {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_IGET_VAR(text)
TEST_NC_IGET_VAR(uchar)
TEST_NC_IGET_VAR(schar)
TEST_NC_IGET_VAR(short)
TEST_NC_IGET_VAR(int)
TEST_NC_IGET_VAR(long)
TEST_NC_IGET_VAR(float)
TEST_NC_IGET_VAR(double)
TEST_NC_IGET_VAR(ushort)
TEST_NC_IGET_VAR(uint)
TEST_NC_IGET_VAR(longlong)
TEST_NC_IGET_VAR(ulonglong)


int
TestFunc(vara)(VarArgs)
{
    int i, j, k, err, st, ncid, nok=0, nslabs, reqid;
    double value[MAX_NELS], expect[MAX_NELS];
    IntType start[MAX_RANK], edge[MAX_RANK], mid[MAX_RANK], index[MAX_RANK];
    MPI_Datatype datatype;

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iget_vara)(BAD_ID, 0, NULL, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iget_vara)(ncid, BAD_VARID, NULL, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = APIFunc(iget_vara)(BAD_ID, i, NULL, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        err = APIFunc(iget_vara)(ncid, i, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        err = APIFunc(iget_vara)(ncid, i, start, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
        }
        else IF (err != NC_EEDGE)
            EXPECT_ERR(NC_EEDGE, err)
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS, first when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = APIFunc(iget_vara)(ncid, i, start, edge, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = APIFunc(iget_vara)(ncid, i, start, edge, value, 1, datatype, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            ELSE_NOK
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = APIFunc(iget_vara)(ncid, i, start, edge, value, 0, datatype, &reqid);
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1;  /* out of boundary check */
            err = APIFunc(iget_vara)(ncid, i, start, edge, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        err = APIFunc(iget_vara)(ncid, i, start, edge, value, 1, datatype, &reqid);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK
        err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
        assert(err == st);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            IntType nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash(var_type[i], var_rank[i], index);
            }
            err = APIFunc(iget_vara)(ncid, i, start, edge, value, nels, datatype, &reqid);
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
            ELSE_NOK
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
            ELSE_NOK

            for (j = 0; j < nels; j++) {
                double got;
                char *p = (char *) value;
                p += j * nctypelen(var_type[i]);
                if (inRange(expect[j],var_type[i])) {
                    err = nc2dbl(var_type[i], p, &got);
                    IF (err != NC_NOERR)
                        error("error in nc2dbl");
                    ifelse(`$1', `uchar', `
                    /* in put_vars(), API _put_vara_double() is used to
                     * write the NC_BYTE variables to files. In this
                     * case, NC_BYTE variables are treated as signed
                     * for CDF-1 and 2 formats. Thus, we must skip the
                     * equal test below for uchar.
                     */
                    if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                    IF (!equal2(got,expect[j],var_type[i])) {
                        error("value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("var_name: %s, ", var_name[i]);
                            error("element number: %d ", j);
                            error("expect: %g", expect[j]);
                            error("got: %g", got);
                        }
                    }
                    ELSE_NOK
                }
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}

dnl TEST_NC_IGET_VARA(TYPE)
dnl
define(`TEST_NC_IGET_VARA',dnl
`dnl
int
TestFunc(vara)_$1(VarArgs)
{
    int i, k, err, st, nslabs, ncid, cdf_format, reqid;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j;
    IntType start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK], mid[MAX_RANK];
    double expect[MAX_NELS];
    $1 value[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iGetVara($1)(BAD_ID, 0, NULL, NULL, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iGetVara($1)(ncid, BAD_VARID, NULL, NULL, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = iGetVara($1)(BAD_ID, i, NULL, NULL, value, &reqid);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        err = iGetVara($1)(ncid, i, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EINVALCOORDS)
            EXPECT_ERR(NC_EINVALCOORDS, err)
        ELSE_NOK

        err = iGetVara($1)(ncid, i, start, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EEDGE)
            EXPECT_ERR(NC_EEDGE, err)
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS and NC_EEDGE, first when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = iGetVara($1)(ncid, i, start, edge, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = iGetVara($1)(ncid, i, start, edge, value, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            ELSE_NOK
            edge[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = iGetVara($1)(ncid, i, start, edge, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1; /* out of boundary check */
            err = iGetVara($1)(ncid, i, start, edge, value, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        err = iGetVara($1)(ncid, i, start, edge, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
        } else if (var_rank[i] == 0) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        } else {
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            IntType nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            allInExtRange = allInIntRange = 1;
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_ITYPE($1));
                if (inRange3(cdf_format, expect[j],var_type[i], NCT_ITYPE($1))) {
                    IfCheckTextChar($1, var_type[i])
                        allInIntRange &= CheckRange($1, expect[j]);
                } else {
                    allInExtRange = 0;
                }
            }
            err = iGetVara($1)(ncid, i, start, edge, value, &reqid);
            if (canConvert) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
                err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
                assert(err == st);
                if (allInExtRange) {
                    if (allInIntRange) {
                        IF (err != NC_NOERR)
                            EXPECT_ERR(NC_NOERR, err)
                        ELSE_NOK
                    } else {
                        IF (err != NC_ERANGE)
                            EXPECT_ERR(NC_ERANGE, err)
                        ELSE_NOK
                    }
                } else {
                    IF (err != NC_NOERR && err != NC_ERANGE)
                        EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                    ELSE_NOK
                }
                for (j = 0; j < nels; j++) {
                    if (CheckNumRange($1, expect[j], var_type[i])) {
                        ifelse(`$1', `uchar', `
                        /* in put_vars(), API _put_vara_double() is used to
                         * write the NC_BYTE variables to files. In this
                         * case, NC_BYTE variables are treated as signed
                         * for CDF-1 and 2 formats. Thus, we must skip the
                         * equal test below for uchar.
                         */
                        if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                        IF (!equal(value[j],expect[j],var_type[i],NCT_ITYPE($1))){
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("element number: %d ", j);
                                error("expect: %g", expect[j]);
                                error("got: %g", (double) value[j]);
                            }
                        }
                        ELSE_NOK
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_IGET_VARA(text)
TEST_NC_IGET_VARA(uchar)
TEST_NC_IGET_VARA(schar)
TEST_NC_IGET_VARA(short)
TEST_NC_IGET_VARA(int)
TEST_NC_IGET_VARA(long)
TEST_NC_IGET_VARA(float)
TEST_NC_IGET_VARA(double)
TEST_NC_IGET_VARA(ushort)
TEST_NC_IGET_VARA(uint)
TEST_NC_IGET_VARA(longlong)
TEST_NC_IGET_VARA(ulonglong)

int
TestFunc(vars)(VarArgs)
{
    int i, j, k, err, st, ncid, nok=0, nslabs, reqid;
    double value[MAX_NELS], expect[MAX_NELS];
    IntType m, start[MAX_RANK], index[MAX_RANK], index2[MAX_RANK];
    IntType count[MAX_RANK], edge[MAX_RANK], mid[MAX_RANK], sstride[MAX_RANK];
    PTRDType nstarts;   /* number of different starts */
    PTRDType stride[MAX_RANK];
    MPI_Datatype datatype;

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iget_vars)(BAD_ID, 0, NULL, NULL, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iget_vars)(ncid, BAD_VARID, NULL, NULL, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = APIFunc(iget_vars)(BAD_ID, i, NULL, NULL, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        err = APIFunc(iget_vars)(ncid, i, NULL, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        err = APIFunc(iget_vars)(ncid, i, start, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
        }
        else IF (err != NC_EEDGE)
            EXPECT_ERR(NC_EEDGE, err)
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS, first when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = APIFunc(iget_vars)(ncid, i, start, edge, stride, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = APIFunc(iget_vars)(ncid, i, start, edge, stride, value, 1, datatype, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;
            err = APIFunc(iget_vars)(ncid, i, start, edge, stride, value, 1, datatype, &reqid);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            ELSE_NOK
            stride[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = APIFunc(iget_vars)(ncid, i, start, edge, stride, value, 0, datatype, &reqid);
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1;  /* out of boundary check */
            err = APIFunc(iget_vars)(ncid, i, start, edge, stride, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        err = APIFunc(iget_vars)(ncid, i, start, edge, stride, value, 1, datatype, &reqid);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK
        err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
        assert(err == st);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                IntType nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                for (j = 0; j < nels; j++) {
                    int d;
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    expect[j] = hash(var_type[i], var_rank[i], index2);
                }
                err = APIFunc(iget_vars)(ncid, i, index, count, stride, value, nels, datatype, &reqid);
                IF (err != NC_NOERR)
                    EXPECT_ERR(NC_NOERR, err)
                ELSE_NOK
                err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
                assert(err == st);
                IF (err != NC_NOERR)
                    EXPECT_ERR(NC_NOERR, err)
                ELSE_NOK

                for (j = 0; j < nels; j++) {
                    double got;
                    char *p = (char *) value;
                    p += j * nctypelen(var_type[i]);
                    if (inRange(expect[j],var_type[i])) {
                        err = nc2dbl(var_type[i], p, &got);
                        IF (err != NC_NOERR)
                            error("error in nc2dbl");
                        ifelse(`$1', `uchar', `
                        /* in put_vars(), API _put_vara_double() is used to
                         * write the NC_BYTE variables to files. In this
                         * case, NC_BYTE variables are treated as signed
                         * for CDF-1 and 2 formats. Thus, we must skip the
                         * equal test below for uchar.
                         */
                        if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                        IF (!equal2(got,expect[j],var_type[i])) {
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("element number: %d ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", got);
                            }
                        }
                        ELSE_NOK
                    }
                }
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}

dnl TEST_NC_IGET_VARS(TYPE)
dnl
define(`TEST_NC_IGET_VARS',dnl
`dnl
int
TestFunc(vars)_$1(VarArgs)
{
    int i, k, err, st, nslabs, ncid, cdf_format, reqid;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j, m;
    IntType start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    IntType index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    IntType sstride[MAX_RANK];
    PTRDType nstarts;   /* number of different starts */
    PTRDType stride[MAX_RANK];
    double expect[MAX_NELS];
    $1 value[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iGetVars($1)(BAD_ID, 0, NULL, NULL, NULL, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iGetVars($1)(ncid, BAD_VARID, NULL, NULL, NULL, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = iGetVars($1)(BAD_ID, i, NULL, NULL, NULL, value, &reqid);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        err = iGetVars($1)(ncid, i, NULL, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EINVALCOORDS)
            EXPECT_ERR(NC_EINVALCOORDS, err)
        ELSE_NOK

        err = iGetVars($1)(ncid, i, start, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EEDGE)
            EXPECT_ERR(NC_EEDGE, err)
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS, NC_EEDGE and NC_ESTRIDE, first when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = iGetVars($1)(ncid, i, start, edge, stride, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = iGetVars($1)(ncid, i, start, edge, stride, value, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;
            err = iGetVars($1)(ncid, i, start, edge, stride, value, &reqid);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            ELSE_NOK
            stride[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = iGetVars($1)(ncid, i, start, edge, stride, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1; /* out of boundary check */
            err = iGetVars($1)(ncid, i, start, edge, stride, value, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        err = iGetVars($1)(ncid, i, start, edge, stride, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
        } else if (var_rank[i] == 0) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        } else {
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                IntType nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    int d;
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i],
                                      index2, NCT_ITYPE($1));
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_ITYPE($1))) {
                        IfCheckTextChar($1, var_type[i])
                            allInIntRange &= CheckRange($1, expect[j]);
                    } else {
                        allInExtRange = 0;
                    }
                }
                err = iGetVars($1)(ncid, i, index, count, stride, value, &reqid);
                if (canConvert) {
                    IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
                    err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
                    assert(err == st);
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                EXPECT_ERR(NC_NOERR, err)
                            ELSE_NOK
                        } else {
                            IF (err != NC_ERANGE)
                                EXPECT_ERR(NC_ERANGE, err)
                            ELSE_NOK
                        }
                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                        ELSE_NOK
                    }
                    for (j = 0; j < nels; j++) {
                        if (CheckNumRange($1, expect[j], var_type[i])) {
                            ifelse(`$1', `uchar', `
                            /* in put_vars(), API _put_vara_double() is used to
                             * write the NC_BYTE variables to files. In this
                             * case, NC_BYTE variables are treated as signed
                             * for CDF-1 and 2 formats. Thus, we must skip the
                             * equal test below for uchar.
                             */
                            if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                            IF (!equal(value[j],expect[j],var_type[i], NCT_ITYPE($1))){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("element number: %d ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        EXPECT_ERR(NC_ECHAR, err)
                    ELSE_NOK
                }
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_IGET_VARS(text)
TEST_NC_IGET_VARS(uchar)
TEST_NC_IGET_VARS(schar)
TEST_NC_IGET_VARS(short)
TEST_NC_IGET_VARS(int)
TEST_NC_IGET_VARS(long)
TEST_NC_IGET_VARS(float)
TEST_NC_IGET_VARS(double)
TEST_NC_IGET_VARS(ushort)
TEST_NC_IGET_VARS(uint)
TEST_NC_IGET_VARS(longlong)
TEST_NC_IGET_VARS(ulonglong)

int
TestFunc(varm)(VarArgs)
{
    int i, j, k, err, st, ncid, nok=0, nslabs, reqid;
    double value[MAX_NELS], expect[MAX_NELS];
    IntType m, start[MAX_RANK], index[MAX_RANK], index2[MAX_RANK];
    IntType count[MAX_RANK], edge[MAX_RANK], mid[MAX_RANK], sstride[MAX_RANK];
    PTRDType nstarts;   /* number of different starts */
    PTRDType stride[MAX_RANK], imap[MAX_RANK];
    MPI_Datatype datatype;

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iget_varm)(BAD_ID, 0, NULL, NULL, NULL, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iget_varm)(ncid, BAD_VARID, NULL, NULL, NULL, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = APIFunc(iget_varm)(BAD_ID, i, NULL, NULL, NULL, NULL, NULL, 0, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        err = APIFunc(iget_varm)(ncid, i, NULL, NULL, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        err = APIFunc(iget_varm)(ncid, i, start, NULL, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
        }
        else IF (err != NC_EEDGE)
            EXPECT_ERR(NC_EEDGE, err)
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS, first when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = APIFunc(iget_varm)(ncid, i, start, edge, stride, imap, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = APIFunc(iget_varm)(ncid, i, start, edge, stride, imap, value, 1, datatype, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;
            err = APIFunc(iget_varm)(ncid, i, start, edge, stride, imap, value, 1, datatype, &reqid);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            ELSE_NOK
            stride[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = APIFunc(iget_varm)(ncid, i, start, edge, stride, imap, value, 0, datatype, &reqid);
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1;  /* out of boundary check */
            err = APIFunc(iget_varm)(ncid, i, start, edge, stride, imap, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        err = APIFunc(iget_varm)(ncid, i, start, edge, stride, imap, value, 1, datatype, &reqid);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK
        err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
        assert(err == st);
        IF (err != NC_NOERR)
            EXPECT_ERR(NC_NOERR, err)
        ELSE_NOK

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                IntType nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    index[j] += start[j];
                    nels *= count[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    j = var_rank[i] - 1;
                    imap[j] = 1;
                    for (; j > 0; j--)
                        imap[j-1] = imap[j] * count[j];
                }
                for (j = 0; j < nels; j++) {
                    int d;
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    expect[j] = hash(var_type[i], var_rank[i], index2);
                }
                err = APIFunc(iget_varm)(ncid,i,index,count,stride,imap,value, nels, datatype, &reqid);
                IF (err != NC_NOERR)
                    EXPECT_ERR(NC_NOERR, err)
                ELSE_NOK
                err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
                assert(err == st);
                IF (err != NC_NOERR)
                    EXPECT_ERR(NC_NOERR, err)
                ELSE_NOK

                for (j = 0; j < nels; j++) {
                    double got;
                    char *p = (char *) value;
                    p += j * nctypelen(var_type[i]);
                    if (inRange(expect[j],var_type[i])) {
                        err = nc2dbl(var_type[i], p, &got);
                        IF (err != NC_NOERR)
                            error("error in nc2dbl");
                        ifelse(`$1', `uchar', `
                        /* in put_vars(), API _put_vara_double() is used to
                         * write the NC_BYTE variables to files. In this
                         * case, NC_BYTE variables are treated as signed
                         * for CDF-1 and 2 formats. Thus, we must skip the
                         * equal test below for uchar.
                         */
                        if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                        IF (!equal2(got,expect[j],var_type[i])) {
                            error("value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("element number: %d ", j);
                                error("expect: %g, ", expect[j]);
                                error("got: %g", got);
                            }
                        }
                        ELSE_NOK
                    }
                }
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}

dnl TEST_NC_IGET_VARM(TYPE)
dnl
define(`TEST_NC_IGET_VARM',dnl
`dnl
int
TestFunc(varm)_$1(VarArgs)
{
    int i, k, err, st, nslabs, ncid, cdf_format, reqid;
    int allInExtRange;  /* all values within external range? */
    int allInIntRange;  /* all values within internal range? */
    int nok = 0;        /* count of valid comparisons */
    int canConvert;     /* Both text or both numeric */
    IntType j, m;
    IntType start[MAX_RANK], edge[MAX_RANK], index[MAX_RANK];
    IntType index2[MAX_RANK], mid[MAX_RANK], count[MAX_RANK];
    IntType sstride[MAX_RANK];
    PTRDType nstarts;   /* number of different starts */
    PTRDType stride[MAX_RANK], imap[MAX_RANK];
    double expect[MAX_NELS];
    $1 value[MAX_NELS];

    err = FileOpen(testfile, NC_NOWRITE);
    IF (err != NC_NOERR) error("open: %s", APIFunc(strerror)(err));

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR) error("inq_format: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iGetVarm($1)(BAD_ID, 0, NULL, NULL, NULL, NULL, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iGetVarm($1)(ncid, BAD_VARID, NULL, NULL, NULL, NULL, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        /* check if can detect a bad file ID */
        err = iGetVarm($1)(BAD_ID, i, NULL, NULL, NULL, NULL, value, &reqid);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        err = iGetVarm($1)(ncid, i, NULL, NULL, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EINVALCOORDS)
            EXPECT_ERR(NC_EINVALCOORDS, err)
        ELSE_NOK

        err = iGetVarm($1)(ncid, i, start, NULL, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            index[0] = 0;
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        }
        else IF (err != NC_EEDGE)
            EXPECT_ERR(NC_EEDGE, err)
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS, NC_EEDGE and NC_ESTRIDE, first when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = var_shape[i][j];
            err = iGetVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = iGetVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;
            err = iGetVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            ELSE_NOK
            stride[j] = 1;
        }
        /* Check non-scalars for correct error returned even when there is
         * nothing to get (edge[j]==0) */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_rank[i] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = iGetVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1; /* out of boundary check */
            err = iGetVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        err = iGetVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
        } else if (var_rank[i] == 0) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
            assert(err == st);
            expect[0] = hash4(cdf_format, var_type[i], 0, index, NCT_ITYPE($1));
            if (inRange3(cdf_format, expect[0], var_type[i], NCT_ITYPE($1)) &&
                CheckRange($1, expect[0])) {
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
            else IF (err != NC_ERANGE) EXPECT_ERR(NC_ERANGE, err)
        } else {
            IF (err != NC_NOERR)
                EXPECT_ERR(NC_NOERR, err)
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* get 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to get lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                IntType nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
 */
                if (var_rank[i] > 0) {
                    j = var_rank[i] - 1;
                    imap[j] = 1;
                    for (; j > 0; j--)
                        imap[j-1] = imap[j] * count[j];
                }
                allInExtRange = allInIntRange = 1;
                for (j = 0; j < nels; j++) {
                    int d;
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    expect[j] = hash4(cdf_format, var_type[i], var_rank[i], index2,
                        NCT_ITYPE($1));
                    if (inRange3(cdf_format, expect[j],var_type[i],NCT_ITYPE($1))) {
                        IfCheckTextChar($1, var_type[i])
                            allInIntRange &= CheckRange($1, expect[j]);
                    } else {
                        allInExtRange = 0;
                    }
                }
                err = iGetVarm($1)(ncid,i,index,count,stride,imap,value, &reqid);
                if (canConvert) {
                    IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
                    err = APIFunc(wait_all)(ncid, 1, &reqid, &st);
                    assert(err == st);
                    if (allInExtRange) {
                        if (allInIntRange) {
                            IF (err != NC_NOERR)
                                EXPECT_ERR(NC_NOERR, err)
                            ELSE_NOK
                        } else {
                            IF (err != NC_ERANGE)
                                EXPECT_ERR(NC_ERANGE, err)
                            ELSE_NOK
                        }
                    } else {
                        IF (err != NC_NOERR && err != NC_ERANGE)
                            EXPECT_ERR(NC_NOERR or NC_ERANGE, err)
                        ELSE_NOK
                    }
                    for (j = 0; j < nels; j++) {
                        if (CheckNumRange($1, expect[j], var_type[i])) {
                            ifelse(`$1', `uchar', `
                            /* in put_vars(), API _put_vara_double() is used to
                             * write the NC_BYTE variables to files. In this
                             * case, NC_BYTE variables are treated as signed
                             * for CDF-1 and 2 formats. Thus, we must skip the
                             * equal test below for uchar.
                             */
                            if (cdf_format < NC_FORMAT_CDF5 && var_type[i] == NC_BYTE && expect[j] > schar_max) continue;')
                            IF (!equal(value[j],expect[j],var_type[i], NCT_ITYPE($1))){
                                error("value read not that expected");
                                if (verbose) {
                                    error("\n");
                                    error("varid: %d, ", i);
                                    error("var_name: %s, ", var_name[i]);
                                    error("element number: %d ", j);
                                    error("expect: %g, ", expect[j]);
                                    error("got: %g", (double) value[j]);
                                }
                            }
                            ELSE_NOK
                        }
                    }
                } else {
                    IF (err != NC_ECHAR)
                        EXPECT_ERR(NC_ECHAR, err)
                    ELSE_NOK
                }
            }
        }
    }
    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));
    return nok;
}
')dnl

TEST_NC_IGET_VARM(text)
TEST_NC_IGET_VARM(uchar)
TEST_NC_IGET_VARM(schar)
TEST_NC_IGET_VARM(short)
TEST_NC_IGET_VARM(int)
TEST_NC_IGET_VARM(long)
TEST_NC_IGET_VARM(float)
TEST_NC_IGET_VARM(double)
TEST_NC_IGET_VARM(ushort)
TEST_NC_IGET_VARM(uint)
TEST_NC_IGET_VARM(longlong)
TEST_NC_IGET_VARM(ulonglong)


