
# Pumbaa: framework for [PlatformIO](https://platformio.org)

Pumbaa is Python on top of Simba. The implementation is a port of MicroPython, designed for embedded devices with limited amount of RAM and code memory.

* [Home](https://platformio.org/frameworks/pumbaa) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/frameworks/pumbaa.html)

# Examples

- [Espressif 32](https://github.com/platformio/platform-espressif32)
  * [arduino-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-blink)
  * [arduino-briki-internal-libs](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-briki-internal-libs)
  * [arduino-wifiscan](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-wifiscan)
  * [espidf-arduino-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-arduino-blink)
  * [espidf-arduino-wifiscan](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-arduino-wifiscan)
  * [espidf-aws-iot](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-aws-iot)
  * [espidf-ble-eddystone](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ble-eddystone)
  * [espidf-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-blink)
  * [espidf-coap-server](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-coap-server)
  * [espidf-exceptions](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-exceptions)
  * [espidf-hello-world](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-hello-world)
  * [espidf-http-request](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-http-request)
  * [espidf-peripherals-uart](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-peripherals-uart)
  * [espidf-storage-sdcard](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-storage-sdcard)
  * [espidf-ulp-adc](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ulp-adc)
  * [espidf-ulp-pulse](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ulp-pulse)
  * [pumbaa-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/pumbaa-blink)
  * [simba-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/simba-blink)

