/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#ifndef TIMEUTILS_H
#define TIMEUTILS_H

// Qt
#include <QDateTime>

class QLocale;

namespace TimeUtils
{

/**
 * Format a date time according to the messaging menu spec.
 * @param dateTime the date to format
 * @param now defines the current date, useful for unittesting
 */
QString formatDateTime(const QDateTime& dateTime, const QDateTime& now = QDateTime());

/**
 * Return a duration of a few minutes formated according to the messaging menu
 * spec
 * @param minutes the duration
 */
QString formatShortDuration(int minutes);

/**
 * Return the format string used to represent a date in a short way,
 * without including the year
 * @param locale the locale to use, useful for unittesting
 */
QString shortDateFormat(const QLocale* locale = 0);

} // namespace

#endif /* TIMEUTILS_H */
