<?php
header("Content-type: text/css");

if(isset($_GET['image'])){
	// Accomidate uppercase & lowercase file extensions
	$image = strtolower($_GET['image']);

	// Set the mimetype and cache the image for a year
	header("Content-type: image/png");
	header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 60 * 60 *24 * 365) . ' GMT');

	// Deliver the correct image ...
	if($image == 'logo')		echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAAA0AAAAZCAYAAADqrKTxAAAACXBIWXMAAAsSAAALEgHS3X78AAABVElEQVR4nJXUPUhWURgH8J+oiJDkC4I6OBiESuAsKrgLNbUFTUW4hDg1OQpS4OciTuLkILgL1gtSCBFI4NCi6KAgWENR4sdteYTj633VO5zhcP8/znOec86VZZmi4/aPlPAe63hyJ0IHNpHF+IH2qihW+Bzhc5zgEhO5CLVYDHCBrziOebkaeobTCH3Dx6TElRsITRHM8BOT+JegF3noFc6i/nlsJeAYrdcQGvElAgcYCXyFllBbiYbwOwJj2E7AXwxcOyfUYCYC+3iZgAyraKhED5MGjKOcgF/ov3GN8AiH0bHnScvPMI26PPQUu1jDVKAtjKI55yzV4B328BY70b3vGK5yzZSwjCO8xp9o9UJlWSl6gI0o50PsZRulW16ABsxhBZ9ihZY73pn6KGs29pRbUiWqwyDeoPHezx1d6Cv0j0AneoqiDjwuitrQXRQ1o/e+6D+5oluoWPVVVgAAAABJRU5ErkJggg==');
	elseif($image == 'del')		echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAHMSURBVHjapFO/S0JRFP4UIUJIqMWgLQzalAyKIN4TxNXJoZaGIPwHXNMt/A+C1pZabKgQQd9kQ4pS0KBUi4MNNgT+ev54nXPeVTRoqQvfu+ee7zvnnnPvfQ7LsvCf4ZLvSZi/ScIpQScYv+g1QoGQEv15zk4wHo0k2BmJYJzNskB3XuTnkoyPQxKsNLwRnJTEycZwOJRgDAbgmdYF82hfmwSzzb4fGkni4DPoHu5K9sVw2I5wu9HNZKDagXDRKNBuy6Kbywm3ePlgSAUD0zQI+tftLdDrAa0WOIB8BYYEk4851rCWY1Qb1IJpYum6bNCsf97f0xZdoNHAUiwmYJt9zLFGaTFNMOj3ZbF882yQrX9ks0CnA9RqNshmH3OsmY1xqRampz21PR6g2bRtr3dOM6ubq+B9b1Uju7AWjwNvb3YVDLLZxxxrZmPkFurbK9NH4kskgHxeyHqpJLMvGLS3DYVQT6cnt2P4HluY3ILGpy3Bd3dy2i/F4uS0dbbldohjjbod+51wBU+bC5Z1dWZZBzsCXhM05hSviUbxrJU1cdJCZcMlTzng96NSrUqJZM89ZfJLizOaVKA2TEqC8rrjTz/T1quq4D/jW4ABAF7lQOO4C9PnAAAAAElFTkSuQmCC');
	elseif($image == 'edit')	echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAAA0AAAAMCAYAAAC5tzfZAAAACXBIWXMAAA7DAAAOwwHHb6hkAAABEElEQVR4nIXSsUrDUACF4Zs9W8GhUBURXFtLM9Qhj9AXEHURBV+hYB7icskSwYhDQaWBIikt3GYsnQRJd0VMlRDI5vQ7tVhsm+GM33L4BSAKZg8tS0vD0IANiEIgDUOnSpEqhRRCFyHbcRydKsVbq0W/0SCs15FCbAbT1ymj8wuGlkVQqxFUq2uRHbZL+uflmsl4Qv855On4hIdmk6FlacBeC5LBPuOeJAh6dE7PcBxn5RELMBtsk9yUSd09gsfOEviL/oHMrZDIHcJ2aQksUOwJlSddstER3/e7ZG6FmSyvBHO0FXtC50mXz/iSj7vDjWCO7Mg3vyLfJE+6vN8ebARzdBX5JpFvEnuC2BMUpfULJyi1o5NPs3wAAAAASUVORK5CYII=');
	elseif($image == 'audio')	echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAdRJREFUeNqkU89rE1EQ/maz2STbQKTV1AqRWovFBgKCQsFToEfRmxfBP0DwIl56KkUPglfP0lOhBQVpDz305EmpeNAWPAQaSBoDTUuz2SabZN97nRdN0uqmFhz49s3Oj+8x82ZIKYX/EbOrPNwYGKNvGGEcdA0rs32ncc6LnulPva5weChPOc5LMMe4f2YJmn2QFAo/c6nU2JIQyPLvZiBBsegPJIhGk3e2t0vriURyzXHkLSBS+osgHnMRMsPwpY1crnWKIBIhxzQvZnd3yx8N49IrNj0e2APbNjAxYUEpowfPI/i+0SQafaRU40FgCSclHjcwNWWhst+3xWJAq4WyEJbxT4JfdQNXxoA2t4aIA0MdvdZo4NpZz5hQUrxmbDEUQSjLFAiHBDp6uJOcDyTw2000G+6yHXOfT07K9M1p4jIIbnVP1GsHkNInnVxaXQieg/1yUR/ZdCaNvYqeNomjqqPtO9ohvn3AzruXv6PnewTUXSYrlYF9b2Hz6vXU7eHL46hVayjkfsDLf33qfVl+0y5+7y/HiQXsERDRBUreyNDdJy9gDc1wWAX5T4vy89v37NaD4TCqDJdz/CCCqJ4Z/QCM0B/NFYwmw9NknNPbqGMBBgDJpb7OvDYMdwAAAABJRU5ErkJggg==');
	elseif($image == 'image')	echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAdlJREFUeNqkkz9v00AYxp9zzvblLnac0lLiUKpmKFKDqGBgQ0KCoQsDCxJVP0A/RAcGRsTMgtQpEh3oF+haNia2qiukCzSlieP4b987d+hIk5Ne2Wf5+d3z/jlWliXmWRbmXPz9wcFrerZn1A94lmXhh+3tz7Oo9/r9XZ6lKSuoDs8/MVgMsGtkiyLJAF0dX1TBKdnuItAjr1kBvH1aQmt5kiTICbB5n8Hl9HMdWFTA2T+gbldiEHgYAY9CYLMDRCmMRmv5NEmY3oSNY6zfW0NLhebkh8vAsleBJiTo3qlgU3IWiAqgtXwaxywvChz9+ILvQmLryRu86L00lh1e2daABQmkOX2j9KRLANJorQGktDk5PUHQDPD1ch8Xl7+wsvQA7YUV3PVbqDs6D2mAygEEpRbn14A4ji1j56KDPyOO8V8H34Y/URenUFJBKQWv4Zloej6BQ6wtdfBs1YXWagDLyEG3/QqO48B1XUgp4XkKQeCbaLVI3FTwqQhS2rCERZ2INMA4MG28ufR4Z9SrKErA2ITeLYzHJc7PcwghzCGPe2UFOBsMajXbxuHHd/85PjQEmKBmO9Ba5m9s7FiNRjjLJBaj0W8aEVBdEeh7cUs9TQSGbN7rfCXAAJNovyFuktgQAAAAAElFTkSuQmCC');
	elseif($image == 'video')	echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAdxJREFUeNqMU81KI0EQ7t9EhNU3CHjw4s0nyLKEnLz5HotP4AP4AAp5B2FZ2BxCDsoKQm57yhIU3Bwig2IwEyczY3fVVo2dTUY3uzb0dHfV91V9XdUjEVF0u90zIUS92WyeineMTqezT8t5o9H4aNgAAHVaJM3To6OTndksAw5MAwFQ8B4RsFKx6vDw4CfhGVsA5gFEMHxJkhTG48dnIgUyiPneWsNEBXwIYzkAO78655BnkZTIjKUzjEZR7r1nol5WoPhDDhGcynvgBMgf2mOaZv7q6tfs7m5MATBgPDLnTwBWQAaOqhnE2cmEee7h5maUpqnzWluG4wvGy6B6oSDcS5F6YD+Z8Pb2IXNOeGMqgqeUxY3Vizq/qAHdkZySFXR7vW9VWqtRFLnBYCBft5BgGSvA0CYzVxCKcr67u5ckycxvbt5nW1ufYJlsjFbt9rHhIpe6EAJwtu+IEvIcnRAWrLWl7EotalB6B3yFYLj0XlMA4a1dW/UQ9b8U9Ki4TkqN1lb/RmaieaMgp5TB8ANR50pxxXGVggrhywomk0nRBSrsNaKKtTYr2YT5EMdxuQv9fv+iVquxIWq1Pm//72+cTqc4HA4vintzIEq+TvuN+cN6x+D2xsR9+i3AAEgKanVYjEzGAAAAAElFTkSuQmCC');
	elseif($image == 'arch')	echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAC4jAAAuIwF4pT92AAABUUlEQVR4nGP4//8/AyWYVA0VSJhkAyo05mhM99xj/kV9tvoEUg2oUO5TqUw67fw/8ZL7f/+9lr9IMuDCwwvTQ4/Y/ou54Po/+5LHf93FWkeJNuD3n99VjjtMP+Rc9/2fftnjv+1Gww/ff36vwWUAeiBVaM3T2FB5O+R/8lWf/8H7rf9dfXx1Mq5YqDBYp7c57KjDb51l2iv///9fce3xtUnJp93/FT+I+Z97weu/cq9yN3IMYBgQesTuV/mV2P81N8L/6y7X3m+yRv967+uM/w2PYv+brdZ7hK4ZwwDtRVpryy8H/296mPW/7UHC/6Z7Mf/b3+b+jzvi/O/G05sT0DVjDQPNORrrKq+F/u9+U/y/50P5/44nSf/Vpqmtw2Y7rlioUJ+utrzhdtT/aZ9K//tst/qBHOrEJuUK7dkaWwJ32/7cfm37RnzRTFFGGhwGAAC/7+GLJgjBEQAAAABJRU5ErkJggg==');
	elseif($image == 'app')		echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAFiSURBVBgZpcEhbpRRGIXh99x7IU0asGBJWEIdCLaAqcFiCArFCkjA0KRJF0EF26kkFbVVdEj6/985zJ0wBjfp8ygJD6G3n358fP3m5NvtJscJYBObchEHx6QKJ6SKsnn6eLm7urr5/PP76cU4eXVy/ujouD074hDHd5s6By7GZknb3P7mUH+WNLZGKnx595JDvf96zTQSM92vRYA4lMEEO5RNraHWUDH3FV48f0K5mAYJk5pQQpqIgixaE1JDKtRDd2OsYfJaTKNcTA2IBIIesMAOPdDUGYJSqGYml5lGHHYkSGhAJBBIkAoWREAT3Z3JLqZhF3uS2EloQCQ8xLBxoAEWO7aZxros7EgISIIkwlZCY6s1OlAJTWFal5VppMzUgbAlQcIkiT0DXSI2U2ymYZs9AWJL4n+df3pncsI0bn5dX344W05dhctUFbapZcE2ToiLVHBMbGymS7aUhIdoPNBf7Jjw/gQ77u4AAAAASUVORK5CYII=');
	elseif($image == 'bg')	echo base64_decode('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');
	elseif($image == 'title') 		echo base64_decode('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'); 
	else echo base64_decode('iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAQAAAC1+jfqAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAABbSURBVCjPzdAxDoAgEERRzsFp95JbGI2ASA2SCOX3Ahtr8tuXTDIO959bCxRfpOitWS5vA+lMJg9JbKCTTmMQ1QS3ThqVQbBBlsbgpXLYE8lHCXrqLptf9km7Dzv+FwGTaznIAAAAAElFTkSuQmCC');
	
	// Exit this script when the correct image has been served
	exit();
}
define('FILENAME',basename(__FILE__));


$bg = '#fff url('.FILENAME.'?image=bg) fixed no-repeat';
$bgContent = '#D0DCE0';
$tdhead = '#374D53';
$border ='#6C6C6C';
$td1 = '#E7EEEF';
$td2 = '#fff';
$nav = '#E7EEEF';
$radius = 0;
$shadow = 0.2;
$shadow2 = $shadow/2;


if(isset($_GET['blabla'])){
?>
<style>
<?php
}
?>
/*
phpLiteAdmin dynamic_myAdmin Theme
Created by Ayman Teryaki on 11.Nov.2012
*/

/* overall styles for entire page */
body{ margin: 0px; padding: 0px; font-family: Arial, Helvetica, sans-serif; font-size: 14px; color:#000; background: <?php echo $bg; ?>; }
/* general styles for hyperlink */
a{ color: #1E1EF0; text-decoration: none; cursor :pointer; }
a:hover{ color: #FF9900; }

.warning, .empty, .drop, .delete, .delete_db{ color:#ff0000; }

.edit *{ display:none; }
.edit{ background:url(<?php echo FILENAME; ?>?image=edit) no-repeat; padding:0 3px 0 16px; }
.delete *{ display:none; }
.delete{ padding:0 3px 0 16px; background:url(<?php echo FILENAME; ?>?image=del) no-repeat;  }

.sidebar_table *{ display:none; }
.sidebar_table{ font-size:12px; background:url(<?php echo FILENAME; ?>?image=arch) no-repeat;padding:0 3px 0 16px;}

.active_table, .active_db{ font-weight:bold; color:#FF9900; }

.null{ color:#6C6C6C; }

/* horizontal rule */
hr { height: 1px; border: 0; color: #3C3C3C; background-color: <?php echo $bg; ?>; width: 100%; }
/* logo text containing name of project */
h1 {
	margin: 0px; padding: 10px; font-size: 24px;
	background: url(<?php echo FILENAME; ?>?image=title) no-repeat 11px 7px ;
	text-align: center; margin-bottom: 5px; color:#3C3C3C; 
}
/* version text within the logo */
h1 #version { color:#666; font-size: 12px; padding-left:170px; margin-top:20px; font-style:italic; }
/* logo text within logo */
h1 #logo { padding-left:9px; display:none; }
/* general header for various views */
h2 { margin:0px; padding:0px; font-size:14px; margin-bottom:20px; }
/* input buttons and areas for entering text */
input, select, textarea {
	font-family:Arial, Helvetica, sans-serif;
	background-color:<?php echo $nav; ?>; color:<?php echo $tdhead; ?>;
	border-color:<?php echo $border; ?>; border-style:solid;
	border-width:1px; margin:5px;
	border-radius:<?php echo $radius; ?>px; -moz-border-radius:<?php echo $radius; ?>px; padding:1px 3px;
}
select{	border-radius:1px; -moz-border-radius:1px; }
input:focus, textarea:focus, select:focus{ background:<?php echo $bgContent; ?>; }
/* just input buttons */
input.btn { cursor:pointer;
	background: -moz-linear-gradient( top, <?php echo $bgContent; ?> 0%, #ebebeb 50%, #dbdbdb 50%, #b5b5b5);
	background: -webkit-gradient( linear, left top, left bottom, from(<?php echo bgContent; ?>), color-stop(0.50, #ebebeb), color-stop(0.50, #dbdbdb), to(#b5b5b5));
	border: 1px solid #949494;
	<?php
	if(!empty($shadow)){
	?>
	-moz-box-shadow: 0px 1px 3px rgba(000,000,000,<?php echo $shadow; ?>), inset 0px 0px 3px rgba(255,255,255,1);
	-webkit-box-shadow: 0px 1px 3px rgba(000,000,000,<?php echo $shadow; ?>), inset 0px 0px 3px rgba(255,255,255,1);
	box-shadow: 0px 1px 3px rgba(000,000,000,<?php echo $shadow; ?>), inset 0px 0px 3px rgba(255,255,255,1);
	text-shadow: 0px -1px 0px rgba(000,000,000,<?php echo $shadow2; ?>), 0px 1px 0px rgba(255,255,255,1);
	<?php
	}
	?>
}
input.btn:hover { 
	-moz-box-shadow: 0px 0px 0px rgba(000,000,000,<?php echo $shadow; ?>), inset 0px 0px 0px rgba(255,255,255,1);
	-webkit-box-shadow: 0px 0px 0px rgba(000,000,000,<?php echo $shadow; ?>), inset 0px 0px 0px rgba(255,255,255,1);
	box-shadow: 0px 0px 1px rgba(000,000,000,<?php echo $shadow; ?>), inset 0px 0px 0px rgba(255,255,255,1);
	text-shadow: 0px -1px 0px rgba(000,000,000,<?php echo $shadow2; ?>), 0px 1px 0px rgba(255,255,255,1);
}
/* general styles for hyperlink */
#headerlinks{ background:<?php echo $td1; ?>; text-align:center;   }
fieldset{ padding:15px; border:#A7A7A7 1px solid; border-radius:<?php echo $radius; ?>px; -moz-border-radius:<?php echo $radius; ?>px; background-color:#f9f9f9; }
/* outer div that holds everything */
#container { padding:10px; }
/* div of left box with log, list of databases, etc. */
#leftNav{
	float:left; width:250px; padding:0px;
	border:<?php echo $border; ?> 1px solid; background-color:<?php echo $bgContent; ?>; padding-bottom:15px;
	border-radius:<?php echo $radius; ?>px; -moz-border-radius:<?php echo $radius; ?>px;
	<?php
	if(!empty($shadow)){
	?>
	-webkit-box-shadow: 2px 2px 2px 2px rgba(33, 33, 33, <?php echo $shadow; ?>);
	box-shadow: 2px 2px 2px 2px rgba(33, 33, 33, <?php echo $shadow; ?>);
	<?php
	}
	?>
}
/* div holding the content to the right of the leftNav */
#content { overflow:hidden; padding-left:10px; }
/* div holding the login fields */
#loginBox {
	width:500px; margin-left:auto; margin-right:auto;
	margin-top:50px; border:<?php echo $border; ?> 1px solid;
	background-color:<?php echo $bgContent; ?>; border-radius:<?php echo $radius; ?>px; -moz-border-radius:<?php echo $radius; ?>px;
}
/* div under tabs with tab-specific content */
#main {
	border:<?php echo $border; ?> 1px solid; padding:15px; overflow:auto; background-color:<?php echo $bgContent; ?>;
	border-bottom-left-radius:<?php echo $radius; ?>px;
	border-bottom-right-radius:<?php echo $radius; ?>px;
	border-top-right-radius:<?php echo $radius; ?>px;
	-moz-border-radius-bottomleft:<?php echo $radius; ?>px;
	-moz-border-radius-bottomright:<?php echo $radius; ?>px;
	-moz-border-radius-topright:<?php echo $radius; ?>px; 
	<?php
	if(!empty($shadow)){
	?>
	-webkit-box-shadow: 2px 2px 2px 2px rgba(33, 33, 33, <?php echo $shadow; ?>);
	box-shadow: 2px 2px 2px 2px rgba(33, 33, 33, <?php echo $shadow; ?>);
	<?php
	}
	?>
}
td{ padding:2px 6px 2px 6px; }
/* odd-numbered table rows */
.td1 { background-color:<?php echo $td2; ?>; text-align:right; font-size:12px; }
/* even-numbered table rows */
.td2 { background-color:<?php echo $td1; ?>; text-align:right; font-size:12px;  }
/* table column headers */
.tdheader { 
	border:<?php echo $border;?> 1px solid; font-weight:bold; font-size:12px; 
	background-color:<?php echo $tdhead; ?>; color:<?php echo $bgContent; ?>;
}
.tdheader a:link, .tdheader a:visited{ color:<?php echo $bgContent; ?>; }
.tdheader a:hover{ color:#FF9900; }
/* div holding the confirmation text of certain actions */
.confirm { border:<?php echo $border; ?> 1px dashed; padding:15px; background-color:<?php echo $td2; ?>; }
/* tab navigation for each table */
.tab{
	display:block;
	padding:5px 8px;
	border:<?php echo $border; ?> 1px solid;
	margin-right:5px;
	float:left;
	border-bottom-style:none;
	position:relative;
	top:1px;
	padding-bottom:4px;
	background-color:<?php echo $nav; ?>;
	border-top-left-radius:<?php echo $radius; ?>px;
	border-top-right-radius:<?php echo $radius; ?>px;
	-moz-border-radius-topleft:<?php echo $radius; ?>px;
	-moz-border-radius-topright:<?php echo $radius; ?>px;
}
/* pressed state of tab */
.tab_pressed{
	display:block;
	padding:5px;
	padding-right:8px;
	padding-left:8px;
	border:<?php echo $border; ?> 1px solid;
	margin-right:5px;
	float:left;
	border-bottom-style:none;
	position:relative;
	top:1px;
	background-color:<?php echo $bgContent; ?>;
	cursor:default;
	border-top-left-radius:<?php echo $radius; ?>px;
	border-top-right-radius:<?php echo $radius; ?>px;
	-moz-border-radius-topleft:<?php echo $radius; ?>px;
	-moz-border-radius-topright:<?php echo $radius; ?>px;
	<?php
	if(!empty($shadow)){
	?>
	-webkit-box-shadow: 1px -3px 1px 0px rgba(33, 33, 33, <?php echo $shadow2; ?>);
	box-shadow: 1px -3px 1px 0px rgba(33, 33, 33, <?php echo $shadow2; ?>);
	<?php
	}
	?>
}
/* tooltip styles */
#tt{ position:absolute; display:block; }
#tttop { display:block; height:5px; margin-left:5px; overflow:hidden }
#ttcont { display:block; padding:2px 12px 3px 7px; margin-left:5px; background:#f3cece; color:#333 }
#ttbot { display:block; height:5px; margin-left:5px; overflow:hidden }