


#include "Platform.h"
#include "UMDF_USBCommunication.h"

//KS
#pragma warning (disable:4245)

#ifndef UNDER_CE

#include <stdlib.h>
#include <stdio.h>

#include "CCIDReader.h"


#define base CBaseCommunication

#define IOCTL_CCID_INT        0x80722216L
#define IOCTL_CCID_ABORT      0x80722218L
#define IOCTL_CCID_DESCRIPTOR 0x8072221CL
#define IOCTL_CCID_DRIVERVERSION 0x8072221EL




CUmdfUSBCommunication::CUmdfUSBCommunication(UMDF_CALLBACK* p_pcUmdfCallBack,CReader *Owner)
                  :CUSBCommunication("UMDF",Owner)
{
	m_pcUmdfCallBack = p_pcUmdfCallBack;
}

int CUmdfUSBCommunication::Open()
{
	return 1;
}

void CUmdfUSBCommunication::Close(void)
{
}


void CUmdfUSBCommunication::SetCommunicationString(cj_ReaderInfo *ReaderInfo)
{
	int8_t *ptr;
	ReaderInfo->PID=m_pDriverInfo->ProductId;
	ReaderInfo->PortID=atoi(m_cDeviceName+strlen(m_cDeviceName)-2);
	memcpy(ReaderInfo->CommunicationString,"USB",4);
	ptr=((int8_t *)m_pDriverInfo)+m_pDriverInfo->ProductOffs;
	memcpy(ReaderInfo->ProductString,ptr,m_pDriverInfo->ProductLength);
	ptr=((int8_t *)m_pDriverInfo)+m_pDriverInfo->ManufacturerOffs;
	memcpy(ReaderInfo->VendorString,ptr,m_pDriverInfo->ManufacturerLength);

	ReaderInfo->ContentsMask=	RSCT_READER_MASK_PID |
										RSCT_READER_MASK_VENDOR_STRING |
										RSCT_READER_MASK_PRODUCT_STRING |
										RSCT_READER_MASK_COM_TYPE |
										RSCT_READER_MASK_PORT_ID;


}



CUmdfUSBCommunication::~CUmdfUSBCommunication(void)
{
	Close();
	//delete m_pDriverInfo;
}

bool CUmdfUSBCommunication::SetupDeviceInfo()
{
	m_pDriverInfo->length = sizeof USB_DEVICE_T;

	return m_pcUmdfCallBack->m_pfCallbackGetUsbInfo(m_pcUmdfCallBack->m_hContext, m_pDriverInfo)==STATUS_SUCCESS;
	
}

bool CUmdfUSBCommunication::IsConnected()
{
	return true;
}

int CUmdfUSBCommunication::Write(void *Message, uint32_t len)
{
	if (m_pcUmdfCallBack->m_pfCallbackBulkPipeWrite(m_pcUmdfCallBack->m_hContext, Message, len) == STATUS_SUCCESS)
		return CJ_SUCCESS;
	else
		return CJ_ERR_WRITE_DEVICE;
} 

int CUmdfUSBCommunication::Read(void *Response, uint32_t *ResponseLen)
{
	if (m_pcUmdfCallBack->m_pfCallbackBulkPipeRead(m_pcUmdfCallBack->m_hContext,Response, ResponseLen) == STATUS_SUCCESS)
		return CJ_SUCCESS;
	else
		return CJ_ERR_DEVICE_LOST;
}

int CUmdfUSBCommunication::StartInterruptPipe()
{
	return 0;
}

int CUmdfUSBCommunication::HaltInterruptPipe()
{
	return 0;
}


#endif
