#ifndef INCLUDE_CLASS_MIXER_H
#define INCLUDE_CLASS_MIXER_H
/**
 * @brief Class mixer header file - class definition
 *
 * This files contains the class definition of class mixer.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation
 * (http://www.gnu.org/licenses/gpl.html)
 *
 * @file    src/class_mixer.h
 * @author  Matthias Grimm <matthias.grimm@users.sourceforge.net>
 */
#include <pbbtaglist.h>

enum valueinc { VALUE_REL, VALUE_REL_PERCENT, VALUE_ABS, VALUE_ABS_PERCENT };

struct driver_mixer {
	char *	     name;
	void	     (*set_mixer)(char *);
	const char * (*get_mixer)(void);
	void	     (*set_channels)(char *);
	const char * (*get_channels)(void);
	int          (*get_volume)(enum valueinc);
	void         (*set_volume)(enum valueinc, int);
	gboolean     (*is_muted)();
	void         (*driver_exit)();
};

/* public prototypes class mixer */
int mixer_init ();
void mixer_exit ();

/* private prototypes class mixer */
void mixer_query (struct tagitem *taglist);
void mixer_config (struct tagitem *taglist);
void mixer_handle_tags (int cfgure, struct tagitem *taglist);
void mixer_keyboard (struct tagitem *taglist);

#endif    /* INCLUDE_CLASS_MIXER_H */
