/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001, 2005, 2007 SIL International. All rights reserved.

Distributable under the terms of the GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: PangoGrFont.cpp
Responsibility: Daniel Glassey
Last reviewed: Not yet.

Description:
    A Font is an object that represents a font-family + bold + italic setting, that contains
  Graphite tables.
----------------------------------------------------------------------------------------------*/

#include "PangoGrFont.h"
#include <pango/pangofc-font.h>


namespace gr
{


PangoGrFont::PangoGrFont(PangoFcFont * pangoFont)
  : FreetypeFont(NULL), m_fcFont(pangoFont), m_cref(1), m_locked(false)
{
  FT_Face l_face;
  Assert(pangoFont); // shouldn't be null but we play safe anyway
  l_face = lockFace();
  Assert(l_face);
  // Generate cache info (what does that mean?)
    if (m_fcFont)
    {
        int weight = 0, slant = 0;
        FcChar8 * family;
        
        FcPatternGetInteger (m_fcFont->font_pattern, FC_WEIGHT, 0, &weight);
        FcPatternGetInteger (m_fcFont->font_pattern, FC_SLANT, 0, &slant);
        
        setBold(weight > 150 ? true : false);
        setItalic(slant > 50 ? true : false);
        
        FcPatternGetString (m_fcFont->font_pattern, FC_FAMILY, 0, &family);
        strncpy(m_stFace, (const char *)family, kMaxFaceLength);
    }
  setFace(l_face);
}
/*
PangoGrFont::PangoGrFont(FT_Face face)
  : FreetypeFont(face), m_fcFont(NULL), m_cref(1)
{
}
*/

PangoGrFont::~PangoGrFont()
{
  unlockFace();
}
  
gr::Font * PangoGrFont::copyThis()
{
  PangoGrFont * copy = new PangoGrFont(*this);
  return copy;
}

PangoGrFont::PangoGrFont(PangoGrFont & font)
: FreetypeFont(font), m_fcFont(font.m_fcFont), 
    m_cref(1), m_locked(false)
{
  strncpy(m_stFace, font.facename(), kMaxFaceLength);
}

FT_Face PangoGrFont::lockFace()
{
	if (!m_locked)
	{
		setFace(pango_fc_font_lock_face(m_fcFont));
		m_locked = true;
	}
	return getFace();
}

void PangoGrFont::unlockFace()
{
	if (m_fcFont && m_locked)
	{
		pango_fc_font_unlock_face(m_fcFont);
		setFace(NULL);
	}
	m_locked = false;
}


bool PangoGrFont::operator!=(PangoGrFont & font)
{
    float fSize, fMySize;
    font.getFontMetrics(NULL, NULL, &fSize);
    getFontMetrics(NULL, NULL, &fMySize);

    return font.bold()!=bold() || font.italic()!=italic() || 
        strcmp(font.facename(), facename()) != 0 || int(fMySize - fSize) != 0;
}


bool PangoGrFont::FontHasGraphiteTables(PangoFcFont * pangoFont)
{
	bool isGraphiteFont = false;
	PangoFcFont *l_Font;
	Assert(pangoFont); // shouldn't be null but we play safe anyway
	Assert(PANGO_IS_FC_FONT (pangoFont));
	l_Font = PANGO_FC_FONT(pangoFont);
	FT_Face l_Face = pango_fc_font_lock_face(l_Font);
	isGraphiteFont = FreetypeFont::FontHasGraphiteTables(l_Face);
	pango_fc_font_unlock_face(l_Font);

	return isGraphiteFont;
}



} // namespace gr

