# Citing and logo

## Citing pandas

If you use _pandas_ for a scientific publication, we would appreciate citations to the published software and the
following paper:

- [pandas on Zenodo](https://zenodo.org/record/3715232#.XoqFyC2ZOL8),
   Please find us on Zenodo and replace with the citation for the version you are using. You cna replace the full author
   list from there with "The pandas development team" like in the example below.

        @software{reback2020pandas,
            author       = {The pandas development team},
            title        = {pandas-dev/pandas: Pandas},
            month        = feb,
            year         = 2020,
            publisher    = {Zenodo},
            version      = {latest},
            doi          = {10.5281/zenodo.3509134},
            url          = {https://doi.org/10.5281/zenodo.3509134}
        }

- [Data structures for statistical computing in python](https://conference.scipy.org/proceedings/scipy2010/pdfs/mckinney.pdf),
   McKinney, Proceedings of the 9th Python in Science Conference, Volume 445, 2010.

        @InProceedings{ mckinney-proc-scipy-2010,
          author    = { {W}es {M}c{K}inney },
          title     = { {D}ata {S}tructures for {S}tatistical {C}omputing in {P}ython },
          booktitle = { {P}roceedings of the 9th {P}ython in {S}cience {C}onference },
          pages     = { 56 - 61 },
          year      = { 2010 },
          editor    = { {S}t\'efan van der {W}alt and {J}arrod {M}illman },
          doi       = { 10.25080/Majora-92bf1922-00a }
        }

## Brand and logo

When using the project name _pandas_, please use it in lower case, even at the beginning of a sentence.

The official logos of _pandas_ are:

### Primary logo

<table class="table logo">
    <tr>
        <td>
            <img alt="" src="{{ base_url }}/static/img/pandas.svg"/>
        </td>
        <td style="background-color: #150458">
            <img alt="" src="{{ base_url }}/static/img/pandas_white.svg"/>
        </td>
    </tr>
</table>

### Secondary logo

<table class="table logo">
    <tr>
        <td>
            <img alt="" src="{{ base_url }}/static/img/pandas_secondary.svg"/>
        </td>
        <td style="background-color: #150458">
            <img alt="" src="{{ base_url }}/static/img/pandas_secondary_white.svg"/>
        </td>
    </tr>
</table>

### Logo mark

<table class="table logo">
    <tr>
        <td>
            <img alt="" src="{{ base_url }}/static/img/pandas_mark.svg"/>
        </td>
        <td style="background-color: #150458">
            <img alt="" src="{{ base_url }}/static/img/pandas_mark_white.svg"/>
        </td>
    </tr>
</table>

### Logo usage

The pandas logo is available in full color and white accent.
The full color logo should only appear against white backgrounds.
The white accent logo should go against contrasting color background.

When using the logo, please follow the next directives:

- Primary logo should never be seen under 1 inch in size for printing and 72px for web
- The secondary logo should never be seen under 0.75 inch in size for printing and 55px for web
- Leave enough margin around the logo (leave the height of the logo in the top, bottom and both sides)
- Do not distort the logo by changing its proportions
- Do not place text or other elements on top of the logo

### Colors

<table class="table">
    <tr>
        <td style="text-align: center;">
            <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100">
                <circle cx="50" cy="50" r="50" fill="#150458"/>
            </svg>
            <br/>
            <b style="color: #150458;">Blue</b><br/>
            RGB: R21 G4 B88<br/>
            HEX: #150458
        </td>
        <td style="text-align: center;">
            <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100">
                <circle cx="50" cy="50" r="50" fill="#ffca00"/>
            </svg>
            <br/>
            <b style="color: #150458;">Yellow</b><br/>
            RGB: R255 G202 B0<br/>
            HEX: #FFCA00
        </td>
        <td style="text-align: center;">
            <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100">
                <circle cx="50" cy="50" r="50" fill="#e70488"/>
            </svg>
            <br/>
            <b style="color: #150458;">Pink</b><br/>
            RGB: R231 G4 B136<br/>
            HEX: #E70488
        </td>
    </tr>
</table>
