/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Half-precision floating-point negative infinity.
*
* @module @stdlib/constants/float16/ninf
* @type {number}
*
* @example
* var FLOAT16_NINF = require( '@stdlib/constants/float16/ninf' );
* // returns -infinity
*/

// MODULES //

var Number = require( '@stdlib/number/ctor' );


// MAIN //

/**
* Half-precision floating-point negative infinity.
*
* ## Notes
*
* Half-precision floating-point negative infinity has the bit sequence
*
* ```binarystring
* 1 11111 0000000000
* ```
*
* This bit sequence corresponds to the unsigned 16-bit integer `64512` and to the HEX value `0xfc00`.
*
* @constant
* @type {number}
* @default -infinity
* @see [half-precision floating-point format]{@link https://en.wikipedia.org/wiki/Half-precision_floating-point_format}
*/
var FLOAT16_NINF = Number.NEGATIVE_INFINITY; // TODO: if, and when, float16 is natively available, assign the true constant; otherwise, fall back to float64


// EXPORTS //

module.exports = FLOAT16_NINF;
