## Usage

This really just checks to make sure that a pattern is either a string or array, and if it's an array it's either empty or consists of only strings. 

```js
var isValidGlob = require('{%= name %}');

isValidGlob('foo/*.js');
//=> true
```

**Valid patterns**

```js
isValidGlob('a');
isValidGlob('a.js');
isValidGlob('*.js');
isValidGlob(['a', 'b']);
//=> all true
```

**Invalid patterns**

```js
isValidGlob();
isValidGlob('');
isValidGlob(null);
isValidGlob(undefined);
isValidGlob(new Buffer('foo'));
isValidGlob(['foo', [[]]]);
isValidGlob(['foo', [['bar']]]);
isValidGlob(['foo', {}]);
isValidGlob({});
isValidGlob([]);
isValidGlob(['']);
//=> all false
```
