Moderator Guidelines - originally posted on the forum by DarrenHill

As suggested by keith on the slack channel, I thought it might be useful to have a few notes and suggestions for how to moderate around here, especially as we have several new members of the team recently. So below are my thoughts on it - please feel free to add to the thread any additional ones that you may have (or that you may disagree with in mine).

**General stuff:**
- Above all else, try to stay calm and not get emotionally involved. Moderating whilst angry, upset or similar (or drunk etc) can often lead to making situations worse rather than better.
- If you're ever in doubt, take a few moments to check stuff out, or ask for support on the slack channel or this section. We're a moderator team, not a bunch of individuals.
- Don't be too quick to attribute stuff to malice or deviousness that can be accounted for by simple stupidity or ignorance.
- If you do something to a thread or post, make it clear what you have done by adding a note or a new post to it. This includes moving threads and splitting/merging them or chopping posts out for binning.
- All actions performed are recorded in the moderator logs.
- Support one another, and those users who are kind enough to flag up posts and thread (either by the report system or via posts in threads) that may need action.
- Super Moderators (and many Team Kodi members) have mod powers everywhere, whilst normal Moderators have the same powers but in more restricted areas of the forum.

- We do not support any installation containing banned add-ons, with the exception of assisting users in removal of them. If the thread is asking about them directly, then bin it. But if it's more tangential (e.g. evidence in a debug log) then inform the user of their presence and that this precludes any support, but leave the thread open to allow them to react and hopefully be educated about it (binning via the delayed moderation tools can be useful here as well). You can also redirect them to JJD-UK's new sticky threads about such add-ons.
- If you do something right, most people won't notice. But if you do something wrong, don't be surprised if certain of our membership take it upon themselves to give you grief. Don't take it personally, it's a thankless task sometimes (and flameproof Kodi-branded underwear is optional).
- Make use of the wiki, and pages like the forum rules, the banned add-ons list, the Official:Trademark Policy and the notes for the first time user. Also Nate's blog post and Martijn's blog post are both useful educational readings for our more naïve users.
- If an action has been performed by another moderator or team member that you do not agree with, please consult with them on slack or here about it for clarification and discussion. Do not arbitrarily undo actions by other mods without doing so. Whilst everyone makes mistakes sometimes, there may be more to it than initially appears.

**Moderator tools**
- All of the mod tools except goodbye spammer are accessible via the drop-down menu at the bottom-right of your web browser (can't comment about tapatalk as I don't use it, but I think it's more limited).
- If you're on Tapatalk and need something done that you can't do directly, just use the report function, make a thread/post here or ask on slack.
- If you're not sure what a tool does or how it works, ask either on slack or here. And if necessary, make a new thread or two in the garbage section and practice with them on how to split/merge threads etc and how to bin stuff.
- With the exception of "goodbye spammer" and thread/post deletion actions, there's no moderator tool action that cannot be undone again.
- Except for spam posts, always use the garbage section (via the tools to "move to garbage" or "move to spam & rule violation") rather than permanently deleting.
- The "move to garbage" and "move to spam & rule violation" are your most commonly used tools. Both move the thread to the bin and automatically close (lock) it. The only differences are the automatic post that is added to the thread, and that "move to garbage" leaves a redirect whereas "spam & violation" doesn't.
- If you do bin a thread, try to add a post to it first explaining why you're doing so.

- Obvious spam post accounts should be dealt with via the "goodbye spammer" tool (the yellow warning triangle on the right hand side of the post). Note that this (after a confirmation screen) deletes the account, IP blocks its source and removes permanently all posts/threads made by that account. It is permanent and cannot be (easily) undone.
- Goodbye spammer can only be used on users with less than 30 posts. If a spambot has been particularly verbose and exceeded that, you may need to delete a number of their threads manually to bring the count below this so that it can be used. Note this is one of the few cases where thread permanent deletion should be used, as just binning the threads won't bring the count down to re-enable goodbye spammer.
- If you're not sure if a post/account is spam or not, consult with the team and also try a Google (or other engine) search. Spambot posts get spider-scraped and will show up in searches, making multi-site spambots obvious.
- Delayed moderation actions (the first option in the drop-down menu) can be useful for times when you may want to perform an action later (e.g. close a thread temporarily now and then use a delayed moderation action to reopen it at a later time without having to remember then to go and do so.

**Housekeeping**
- Moving threads between sections is one of the most common jobs. Not glamorous, but it is needed.
- If you move a thread (via the move/copy thread tool), generally it's best to leave a redirect (the default option when you select the tool) so the users can still find it. Personally I use 7 days duration for all except the discussions section where I use 3, but it's a matter of personal taste. If you don't set anything, the redirect shortcut will stay forever.
- Also if you move a thread, leave a note in it to say that you've done so.
- Discussions isn't for support requests - that's what the main support sections are for.
- Threads moved to off-topic can still be posted to by anyone, but normal users cannot start threads in that section.
- If you bin a thread that contains dodgy links, please remember to edit it and remove them. The bin is publicly visible, so can be harvested for such things by enterprising idiots.

**Warnings and banning**
- Banning someone is an extreme measure, and should only be done "off the cuff" for short-term duration (certainly no more than a 2 week ban, ideally less) as a direct result of threatening or insulting behaviour (for the latter, something that goes materially beyond a simple breach of 2.1 of the Forum Rules).
- Any longer ban should only be made after discussion (on Slack) with at least one other moderator.
- Consider also the seniority/contribution of the person in question, and thus the proportionality of the penalty.
- While this is not a democracy, we do value our users and owe them some degree of transparency as to our actions. As such, warnings should be used where possible before bans are actioned (although of course that is not always feasible if a user needs removing quickly).
- Where possible, warnings should be used before bans are actioned (the "3 strikes" rule, although of course that is not always feasible if a user needs removing quickly).
- Both can be done either via the buttons below posts or via the profile page of the user.
- Warnings can be set to anything from 10% to 100% (click the "custom reason" button in the warning page to access that, the "points" setting is per 10% so 4 points is 40%). In that page you also put information that will be seen by the user as to what the reason for the warning is, and how long it will last.
- Note that all a warning does practically is increase the figure visible below the user avatar beside posts. A 100% warning does not trigger any other action automatically, it's basically cosmetic.
- Bannings work in a similar fashion, but of course actually deny the user account access to being able to log into the forum. They can be set for anything from 1 hour to a permanent ban.
- Note that banning does not block IP addresses (although admins here can do that if necessary), but the creation of a second account to get around a ban is itself a forum rules violation and can be cause for such an IP block.
- It is possible to reverse both warnings and bans, but do not do so without consulting and discussing with the moderator or team member who initially applied them.

I would hope most of the above is obvious, plus I'm sure there are bits that should be there but I've forgotten. But please feel free to add to the suggestions and guidelines so we can do things consistently and well across the whole team and forum.