#!/bin/sh
#
# start/stop elida daemon.

### BEGIN INIT INFO
# Provides:          elida
# Required-Start:    $network $remote_fs
# Required-Stop:     $network $remote_fs
# Should-Start:      $named
# Should-Stop:       $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: pbuilder mail interface
# Description:       elida accepts commands from email messages from
#                    a user to build debian packages by running
#                    pbuilder. It then runs piuparts, lintian and
#                    the reports are compressed an emailed back to
#                    the user.
### END INIT INFO

test -f /usr/sbin/elidad || exit 0

. /lib/lsb/init-functions

if [ -f /etc/elida/elida.conf ]
then
    . /etc/elida/elida.conf
else
    log_begin_msg "/etc/elida/elida.conf does not exist"
    log_end_msg 0
    exit 0
fi

if [ -z "$ELIDAHOME" ]
then
    log_begin_msg "variable ELIDAHOME is not defined"
    log_end_msg 0
    exit 0
fi

if [ ! -d $ELIDAHOME ]
then
    log_begin_msg "directory $ELIDAHOME does not exist"
    log_end_msg 0
    exit 0
fi

case "$1" in
    start)
        test -f $ELIDAHOME/elida-stop && rm -f $ELIDAHOME/elida-stop
        log_begin_msg "Starting elida daemon..."
        pid=$(pidof elidad)
        if [ -n "$pid" ]
        then
            log_begin_msg "Already running."
            log_end_msg 0
            exit 0
        fi
        if [ -n "$(ps waux | grep /usr/sbin/elidad$)" ]
        then
            log_begin_msg "Already running."
            log_end_msg 0
            exit 0
        fi
        start-stop-daemon --start --quiet --oknodo --exec /usr/bin/setsid -- /usr/sbin/elidad &
        log_end_msg $?
        ;;
    stop)
        log_begin_msg "Stopping elida daemon..."
        touch $ELIDAHOME/elida-stop
        start-stop-daemon --stop --quiet --oknodo --exec /usr/sbin/elidad
        log_end_msg $?
        ;;
    force-reload)
        $0 restart
        ;;
    restart)
        $0 stop
        sleep 11
        $0 start
        ;;
    *)
        log_success_msg "Usage: /etc/init.d/elida {start|stop|force-reload|restart}"
        exit 1
        ;;
esac

exit 0
