use Test::More tests => 4;
use Test::Refcount;

use CipUX::Task;

my $object1 = CipUX::Task->new( { cache_dir => 'blib/cache' } );
is_oneref( $object1, '$object has a refcount of 1' );

my $otherref1 = $object1;
is_refcount( $object1, 2, '$object now has 2 references' );

use CipUX::Task::Client;

my $object2 = CipUX::Task::Client->new(
    { name => 'cipux_task_client', cache_dir => 'blib/cache' } );
is_oneref( $object2, '$object has a refcount of 1' );

my $otherref2 = $object2;
is_refcount( $object2, 2, '$object now has 2 references' );

