
.intel_syntax noprefix

.global write_logo
.global write_usage
.global write_options
.global banner_printed
.global cp_logo

.extern tprintf


.SECTION .text
	.ALIGN	16

write_logo:
	sub	rsp, 40
	cmp	byte ptr [banner_printed+rip], 0
	jnz	$_001
	mov	byte ptr [banner_printed+rip], 1
	mov	r9d, 11
	mov	r8d, 36
	mov	edx, 2
	lea	rcx, [cp_logo+rip]
	call	tprintf@PLT
	lea	rdx, [cp_copyright+rip]
	lea	rcx, [DS0000+rip]
	call	tprintf@PLT
$_001:	add	rsp, 40
	ret

write_usage:
	sub	rsp, 40
	call	write_logo
	lea	rcx, [cp_usage+rip]
	call	tprintf@PLT
	add	rsp, 40
	ret

write_options:
	sub	rsp, 40
	call	write_logo
	lea	rcx, [cp_options+rip]
	call	tprintf@PLT
	add	rsp, 40
	ret


.SECTION .data
	.ALIGN	16

banner_printed:
	.byte  0x00

cp_logo:
	.byte  0x41, 0x73, 0x6D, 0x63, 0x20, 0x4D, 0x61, 0x63
	.byte  0x72, 0x6F, 0x20, 0x41, 0x73, 0x73, 0x65, 0x6D
	.byte  0x62, 0x6C, 0x65, 0x72, 0x20, 0x56, 0x65, 0x72
	.byte  0x73, 0x69, 0x6F, 0x6E, 0x20, 0x25, 0x64, 0x2E
	.byte  0x25, 0x30, 0x32, 0x64, 0x2E, 0x25, 0x30, 0x32
	.byte  0x64, 0x00

cp_copyright:
	.byte  0x43, 0x6F, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68
	.byte  0x74, 0x20, 0x28, 0x43, 0x29, 0x20, 0x54, 0x68
	.byte  0x65, 0x20, 0x41, 0x73, 0x6D, 0x63, 0x20, 0x43
	.byte  0x6F, 0x6E, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74
	.byte  0x6F, 0x72, 0x73, 0x2E, 0x20, 0x41, 0x6C, 0x6C
	.byte  0x20, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x20
	.byte  0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64
	.byte  0x2E, 0x0A, 0x00

cp_usage:
	.byte  0x55, 0x53, 0x41, 0x47, 0x45, 0x3A, 0x20, 0x41
	.byte  0x53, 0x4D, 0x43, 0x20, 0x5B, 0x6F, 0x70, 0x74
	.byte  0x69, 0x6F, 0x6E, 0x73, 0x5D, 0x20, 0x66, 0x69
	.byte  0x6C, 0x65, 0x6E, 0x61, 0x6D, 0x65, 0x20, 0x5B
	.byte  0x20, 0x5B, 0x6F, 0x70, 0x74, 0x69, 0x6F, 0x6E
	.byte  0x73, 0x5D, 0x20, 0x66, 0x69, 0x6C, 0x65, 0x6E
	.byte  0x61, 0x6D, 0x65, 0x5D, 0x20, 0x2E, 0x2E, 0x2E
	.byte  0x20, 0x5B, 0x2D, 0x6C, 0x69, 0x6E, 0x6B, 0x20
	.byte  0x6C, 0x69, 0x6E, 0x6B, 0x5F, 0x6F, 0x70, 0x74
	.byte  0x69, 0x6F, 0x6E, 0x73, 0x5D, 0x0A, 0x55, 0x73
	.byte  0x65, 0x20, 0x6F, 0x70, 0x74, 0x69, 0x6F, 0x6E
	.byte  0x20, 0x2D, 0x68, 0x20, 0x66, 0x6F, 0x72, 0x20
	.byte  0x6D, 0x6F, 0x72, 0x65, 0x20, 0x69, 0x6E, 0x66
	.byte  0x6F, 0x0A, 0x00

cp_options:
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x41, 0x53, 0x4D, 0x43, 0x20, 0x5B, 0x6F, 0x70
	.byte  0x74, 0x69, 0x6F, 0x6E, 0x73, 0x5D, 0x20, 0x66
	.byte  0x69, 0x6C, 0x65, 0x6E, 0x61, 0x6D, 0x65, 0x20
	.byte  0x5B, 0x20, 0x5B, 0x6F, 0x70, 0x74, 0x69, 0x6F
	.byte  0x6E, 0x73, 0x5D, 0x20, 0x66, 0x69, 0x6C, 0x65
	.byte  0x6E, 0x61, 0x6D, 0x65, 0x5D, 0x20, 0x2E, 0x2E
	.byte  0x2E, 0x20, 0x5B, 0x2D, 0x6C, 0x69, 0x6E, 0x6B
	.byte  0x20, 0x6C, 0x69, 0x6E, 0x6B, 0x5F, 0x6F, 0x70
	.byte  0x74, 0x69, 0x6F, 0x6E, 0x73, 0x5D, 0x0A, 0x0A
	.byte  0x2D, 0x3C, 0x30, 0x7C, 0x31, 0x7C, 0x2E, 0x2E
	.byte  0x7C, 0x31, 0x30, 0x3E, 0x5B, 0x70, 0x5D, 0x20
	.byte  0x53, 0x65, 0x74, 0x20, 0x43, 0x50, 0x55, 0x3A
	.byte  0x20, 0x30, 0x3D, 0x38, 0x30, 0x38, 0x36, 0x20
	.byte  0x28, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6C, 0x74
	.byte  0x29, 0x2C, 0x20, 0x31, 0x3D, 0x38, 0x30, 0x31
	.byte  0x38, 0x36, 0x2C, 0x20, 0x32, 0x3D, 0x38, 0x30
	.byte  0x32, 0x38, 0x36, 0x2C, 0x20, 0x33, 0x3D, 0x38
	.byte  0x30, 0x33, 0x38, 0x36, 0x2C, 0x20, 0x34, 0x3D
	.byte  0x38, 0x30, 0x34, 0x38, 0x36, 0x2C, 0x0A, 0x20
	.byte  0x35, 0x3D, 0x50, 0x65, 0x6E, 0x74, 0x69, 0x75
	.byte  0x6D, 0x2C, 0x36, 0x3D, 0x50, 0x50, 0x72, 0x6F
	.byte  0x2C, 0x37, 0x3D, 0x50, 0x32, 0x2C, 0x38, 0x3D
	.byte  0x50, 0x33, 0x2C, 0x39, 0x3D, 0x50, 0x34, 0x2C
	.byte  0x31, 0x30, 0x3D, 0x78, 0x38, 0x36, 0x2D, 0x36
	.byte  0x34, 0x3B, 0x20, 0x3C, 0x70, 0x3E, 0x20, 0x61
	.byte  0x6C, 0x6C, 0x6F, 0x77, 0x73, 0x20, 0x70, 0x72
	.byte  0x69, 0x76, 0x69, 0x6C, 0x65, 0x67, 0x65, 0x64
	.byte  0x20, 0x69, 0x6E, 0x73, 0x74, 0x72, 0x75, 0x63
	.byte  0x74, 0x69, 0x6F, 0x6E, 0x73, 0x0A, 0x2D, 0x61
	.byte  0x73, 0x73, 0x65, 0x72, 0x74, 0x20, 0x47, 0x65
	.byte  0x6E, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x2E
	.byte  0x61, 0x73, 0x73, 0x65, 0x72, 0x74, 0x28, 0x29
	.byte  0x20, 0x63, 0x6F, 0x64, 0x65, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x2D, 0x61, 0x75, 0x74, 0x6F, 0x73, 0x74
	.byte  0x61, 0x63, 0x6B, 0x20, 0x41, 0x75, 0x74, 0x6F
	.byte  0x20, 0x73, 0x74, 0x61, 0x63, 0x6B, 0x20, 0x73
	.byte  0x70, 0x61, 0x63, 0x65, 0x20, 0x66, 0x6F, 0x72
	.byte  0x20, 0x61, 0x72, 0x67, 0x75, 0x6D, 0x65, 0x6E
	.byte  0x74, 0x73, 0x0A, 0x2D, 0x62, 0x69, 0x6E, 0x20
	.byte  0x47, 0x65, 0x6E, 0x65, 0x72, 0x61, 0x74, 0x65
	.byte  0x20, 0x70, 0x6C, 0x61, 0x69, 0x6E, 0x20, 0x62
	.byte  0x69, 0x6E, 0x61, 0x72, 0x79, 0x20, 0x66, 0x69
	.byte  0x6C, 0x65, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x42
	.byte  0x6C, 0x3C, 0x66, 0x69, 0x6C, 0x65, 0x3E, 0x20
	.byte  0x53, 0x65, 0x6C, 0x65, 0x63, 0x74, 0x73, 0x20
	.byte  0x61, 0x6E, 0x20, 0x61, 0x6C, 0x74, 0x65, 0x72
	.byte  0x6E, 0x61, 0x74, 0x65, 0x20, 0x6C, 0x69, 0x6E
	.byte  0x6B, 0x65, 0x72, 0x0A, 0x2D, 0x63, 0x20, 0x41
	.byte  0x73, 0x73, 0x65, 0x6D, 0x62, 0x6C, 0x65, 0x73
	.byte  0x20, 0x6F, 0x6E, 0x6C, 0x79, 0x20, 0x2D, 0x20
	.byte  0x6E, 0x6F, 0x20, 0x6C, 0x69, 0x6E, 0x6B, 0x69
	.byte  0x6E, 0x67, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D
	.byte  0x43, 0x73, 0x20, 0x50, 0x75, 0x73, 0x68, 0x20
	.byte  0x55, 0x53, 0x45, 0x53, 0x20, 0x72, 0x65, 0x67
	.byte  0x69, 0x73, 0x74, 0x65, 0x72, 0x73, 0x20, 0x62
	.byte  0x65, 0x66, 0x6F, 0x72, 0x65, 0x20, 0x70, 0x72
	.byte  0x6F, 0x6C, 0x6F, 0x75, 0x67, 0x65, 0x0A, 0x2D
	.byte  0x63, 0x6F, 0x66, 0x66, 0x20, 0x47, 0x65, 0x6E
	.byte  0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x43, 0x4F
	.byte  0x46, 0x46, 0x20, 0x66, 0x6F, 0x72, 0x6D, 0x61
	.byte  0x74, 0x20, 0x6F, 0x62, 0x6A, 0x65, 0x63, 0x74
	.byte  0x20, 0x66, 0x69, 0x6C, 0x65, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x2D, 0x43, 0x3C, 0x70, 0x7C, 0x75
	.byte  0x7C, 0x78, 0x3E, 0x20, 0x53, 0x65, 0x74, 0x20
	.byte  0x4F, 0x50, 0x54, 0x49, 0x4F, 0x4E, 0x20, 0x43
	.byte  0x41, 0x53, 0x45, 0x4D, 0x41, 0x50, 0x0A, 0x2D
	.byte  0x44, 0x3C, 0x6E, 0x61, 0x6D, 0x65, 0x3E, 0x5B
	.byte  0x3D, 0x74, 0x65, 0x78, 0x74, 0x5D, 0x20, 0x44
	.byte  0x65, 0x66, 0x69, 0x6E, 0x65, 0x20, 0x74, 0x65
	.byte  0x78, 0x74, 0x20, 0x6D, 0x61, 0x63, 0x72, 0x6F
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x2D, 0x64, 0x6F, 0x74, 0x6E, 0x61
	.byte  0x6D, 0x65, 0x20, 0x41, 0x6C, 0x6C, 0x6F, 0x77
	.byte  0x20, 0x64, 0x6F, 0x74, 0x20, 0x2E, 0x69, 0x64
	.byte  0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72
	.byte  0x73, 0x0A, 0x2D, 0x65, 0x3C, 0x6E, 0x75, 0x6D
	.byte  0x62, 0x65, 0x72, 0x3E, 0x20, 0x53, 0x65, 0x74
	.byte  0x20, 0x65, 0x72, 0x72, 0x6F, 0x72, 0x20, 0x6C
	.byte  0x69, 0x6D, 0x69, 0x74, 0x20, 0x6E, 0x75, 0x6D
	.byte  0x62, 0x65, 0x72, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x65, 0x6C
	.byte  0x66, 0x5B, 0x36, 0x34, 0x5D, 0x20, 0x47, 0x65
	.byte  0x6E, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x45
	.byte  0x4C, 0x46, 0x20, 0x6F, 0x62, 0x6A, 0x65, 0x63
	.byte  0x74, 0x20, 0x66, 0x69, 0x6C, 0x65, 0x0A, 0x2D
	.byte  0x65, 0x6E, 0x64, 0x62, 0x72, 0x20, 0x49, 0x6E
	.byte  0x73, 0x65, 0x72, 0x74, 0x20, 0x45, 0x4E, 0x44
	.byte  0x42, 0x52, 0x20, 0x61, 0x74, 0x20, 0x66, 0x75
	.byte  0x6E, 0x63, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x65
	.byte  0x6E, 0x74, 0x72, 0x79, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x2D, 0x45, 0x50, 0x20, 0x4F, 0x75
	.byte  0x74, 0x70, 0x75, 0x74, 0x20, 0x70, 0x72, 0x65
	.byte  0x70, 0x72, 0x6F, 0x63, 0x65, 0x73, 0x73, 0x65
	.byte  0x64, 0x20, 0x6C, 0x69, 0x73, 0x74, 0x69, 0x6E
	.byte  0x67, 0x20, 0x74, 0x6F, 0x20, 0x73, 0x74, 0x64
	.byte  0x6F, 0x75, 0x74, 0x0A, 0x2D, 0x65, 0x71, 0x20
	.byte  0x44, 0x6F, 0x6E, 0x27, 0x74, 0x20, 0x64, 0x69
	.byte  0x73, 0x70, 0x6C, 0x61, 0x79, 0x20, 0x65, 0x72
	.byte  0x72, 0x6F, 0x72, 0x20, 0x6D, 0x65, 0x73, 0x73
	.byte  0x61, 0x67, 0x65, 0x73, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D
	.byte  0x46, 0x64, 0x5B, 0x66, 0x69, 0x6C, 0x65, 0x5D
	.byte  0x20, 0x57, 0x72, 0x69, 0x74, 0x65, 0x20, 0x69
	.byte  0x6D, 0x70, 0x6F, 0x72, 0x74, 0x20, 0x64, 0x65
	.byte  0x66, 0x69, 0x6E, 0x69, 0x74, 0x69, 0x6F, 0x6E
	.byte  0x20, 0x66, 0x69, 0x6C, 0x65, 0x0A, 0x2D, 0x46
	.byte  0x69, 0x3C, 0x66, 0x69, 0x6C, 0x65, 0x3E, 0x20
	.byte  0x46, 0x6F, 0x72, 0x63, 0x65, 0x20, 0x3C, 0x66
	.byte  0x69, 0x6C, 0x65, 0x3E, 0x20, 0x74, 0x6F, 0x20
	.byte  0x62, 0x65, 0x20, 0x69, 0x6E, 0x63, 0x6C, 0x75
	.byte  0x64, 0x65, 0x64, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x2D, 0x46, 0x6C, 0x5B, 0x66, 0x69, 0x6C
	.byte  0x65, 0x5D, 0x20, 0x47, 0x65, 0x6E, 0x65, 0x72
	.byte  0x61, 0x74, 0x65, 0x20, 0x6C, 0x69, 0x73, 0x74
	.byte  0x69, 0x6E, 0x67, 0x0A, 0x2D, 0x46, 0x6F, 0x3C
	.byte  0x66, 0x69, 0x6C, 0x65, 0x3E, 0x20, 0x4E, 0x61
	.byte  0x6D, 0x65, 0x20, 0x6F, 0x62, 0x6A, 0x65, 0x63
	.byte  0x74, 0x20, 0x66, 0x69, 0x6C, 0x65, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D
	.byte  0x46, 0x77, 0x3C, 0x66, 0x69, 0x6C, 0x65, 0x3E
	.byte  0x20, 0x53, 0x65, 0x74, 0x20, 0x65, 0x72, 0x72
	.byte  0x6F, 0x72, 0x73, 0x20, 0x66, 0x69, 0x6C, 0x65
	.byte  0x20, 0x6E, 0x61, 0x6D, 0x65, 0x0A, 0x2D, 0x66
	.byte  0x70, 0x69, 0x63, 0x2C, 0x20, 0x2D, 0x66, 0x6E
	.byte  0x6F, 0x2D, 0x70, 0x69, 0x63, 0x20, 0x50, 0x6F
	.byte  0x73, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x49
	.byte  0x6E, 0x64, 0x65, 0x70, 0x65, 0x6E, 0x64, 0x65
	.byte  0x64, 0x20, 0x43, 0x6F, 0x64, 0x65, 0x20, 0x20
	.byte  0x20, 0x2D, 0x66, 0x72, 0x61, 0x6D, 0x65, 0x20
	.byte  0x41, 0x75, 0x74, 0x6F, 0x20, 0x67, 0x65, 0x6E
	.byte  0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x75, 0x6E
	.byte  0x77, 0x69, 0x6E, 0x64, 0x20, 0x69, 0x6E, 0x66
	.byte  0x6F, 0x72, 0x6D, 0x61, 0x74, 0x69, 0x6F, 0x6E
	.byte  0x0A, 0x2D, 0x46, 0x50, 0x69, 0x20, 0x47, 0x65
	.byte  0x6E, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x38
	.byte  0x30, 0x78, 0x38, 0x37, 0x20, 0x65, 0x6D, 0x75
	.byte  0x6C, 0x61, 0x74, 0x6F, 0x72, 0x20, 0x65, 0x6E
	.byte  0x63, 0x6F, 0x64, 0x69, 0x6E, 0x67, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x2D, 0x46, 0x50, 0x69
	.byte  0x38, 0x37, 0x20, 0x38, 0x30, 0x78, 0x38, 0x37
	.byte  0x20, 0x69, 0x6E, 0x73, 0x74, 0x72, 0x75, 0x63
	.byte  0x74, 0x69, 0x6F, 0x6E, 0x73, 0x20, 0x28, 0x64
	.byte  0x65, 0x66, 0x61, 0x75, 0x6C, 0x74, 0x29, 0x0A
	.byte  0x2D, 0x66, 0x70, 0x63, 0x20, 0x44, 0x69, 0x73
	.byte  0x61, 0x6C, 0x6C, 0x6F, 0x77, 0x20, 0x66, 0x6C
	.byte  0x6F, 0x61, 0x74, 0x69, 0x6E, 0x67, 0x2D, 0x70
	.byte  0x6F, 0x69, 0x6E, 0x74, 0x20, 0x69, 0x6E, 0x73
	.byte  0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6F, 0x6E
	.byte  0x73, 0x20, 0x20, 0x2D, 0x66, 0x70, 0x3C, 0x6E
	.byte  0x3E, 0x20, 0x53, 0x65, 0x74, 0x20, 0x46, 0x50
	.byte  0x55, 0x3A, 0x20, 0x30, 0x3D, 0x38, 0x30, 0x38
	.byte  0x37, 0x2C, 0x20, 0x32, 0x3D, 0x38, 0x30, 0x32
	.byte  0x38, 0x37, 0x2C, 0x20, 0x33, 0x3D, 0x38, 0x30
	.byte  0x33, 0x38, 0x37, 0x0A, 0x2D, 0x47, 0x65, 0x20
	.byte  0x66, 0x6F, 0x72, 0x63, 0x65, 0x20, 0x73, 0x74
	.byte  0x61, 0x63, 0x6B, 0x20, 0x63, 0x68, 0x65, 0x63
	.byte  0x6B, 0x69, 0x6E, 0x67, 0x20, 0x66, 0x6F, 0x72
	.byte  0x20, 0x61, 0x6C, 0x6C, 0x20, 0x66, 0x75, 0x6E
	.byte  0x63, 0x73, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D
	.byte  0x47, 0x3C, 0x63, 0x64, 0x7A, 0x76, 0x73, 0x3E
	.byte  0x20, 0x50, 0x61, 0x73, 0x63, 0x61, 0x6C, 0x2C
	.byte  0x20, 0x43, 0x2C, 0x20, 0x53, 0x74, 0x64, 0x2F
	.byte  0x56, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x2F, 0x53
	.byte  0x79, 0x73, 0x2D, 0x63, 0x61, 0x6C, 0x6C, 0x0A
	.byte  0x2D, 0x68, 0x6F, 0x6D, 0x65, 0x70, 0x61, 0x72
	.byte  0x61, 0x6D, 0x73, 0x20, 0x43, 0x6F, 0x70, 0x79
	.byte  0x20, 0x52, 0x65, 0x67, 0x2E, 0x20, 0x70, 0x61
	.byte  0x72, 0x61, 0x6D, 0x65, 0x74, 0x65, 0x72, 0x73
	.byte  0x20, 0x74, 0x6F, 0x20, 0x53, 0x74, 0x61, 0x63
	.byte  0x6B, 0x20, 0x20, 0x2D, 0x49, 0x3C, 0x6E, 0x61
	.byte  0x6D, 0x65, 0x3E, 0x20, 0x41, 0x64, 0x64, 0x20
	.byte  0x69, 0x6E, 0x63, 0x6C, 0x75, 0x64, 0x65, 0x20
	.byte  0x70, 0x61, 0x74, 0x68, 0x0A, 0x2D, 0x69, 0x64
	.byte  0x64, 0x5B, 0x74, 0x5D, 0x20, 0x41, 0x73, 0x73
	.byte  0x65, 0x6D, 0x62, 0x6C, 0x65, 0x20, 0x61, 0x73
	.byte  0x20, 0x62, 0x69, 0x6E, 0x61, 0x72, 0x79, 0x20
	.byte  0x64, 0x61, 0x74, 0x61, 0x20, 0x5B, 0x6F, 0x72
	.byte  0x20, 0x74, 0x65, 0x78, 0x74, 0x5D, 0x20, 0x20
	.byte  0x2D, 0x6C, 0x6F, 0x67, 0x6F, 0x20, 0x50, 0x72
	.byte  0x69, 0x6E, 0x74, 0x20, 0x6C, 0x6F, 0x67, 0x6F
	.byte  0x20, 0x73, 0x74, 0x72, 0x69, 0x6E, 0x67, 0x20
	.byte  0x61, 0x6E, 0x64, 0x20, 0x65, 0x78, 0x69, 0x74
	.byte  0x0A, 0x2D, 0x6D, 0x3C, 0x74, 0x7C, 0x73, 0x7C
	.byte  0x63, 0x7C, 0x6D, 0x7C, 0x6C, 0x7C, 0x68, 0x7C
	.byte  0x66, 0x3E, 0x20, 0x53, 0x65, 0x74, 0x20, 0x6D
	.byte  0x65, 0x6D, 0x6F, 0x72, 0x79, 0x20, 0x6D, 0x6F
	.byte  0x64, 0x65, 0x6C, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x2D, 0x6D, 0x7A, 0x20
	.byte  0x47, 0x65, 0x6E, 0x65, 0x72, 0x61, 0x74, 0x65
	.byte  0x20, 0x44, 0x4F, 0x53, 0x20, 0x4D, 0x5A, 0x20
	.byte  0x62, 0x69, 0x6E, 0x61, 0x72, 0x79, 0x20, 0x66
	.byte  0x69, 0x6C, 0x65, 0x0A, 0x2D, 0x4D, 0x44, 0x5B
	.byte  0x64, 0x5D, 0x20, 0x28, 0x64, 0x79, 0x6E, 0x61
	.byte  0x6D, 0x69, 0x63, 0x29, 0x20, 0x44, 0x65, 0x66
	.byte  0x69, 0x6E, 0x65, 0x73, 0x20, 0x5F, 0x4D, 0x53
	.byte  0x56, 0x43, 0x52, 0x54, 0x20, 0x5B, 0x5F, 0x44
	.byte  0x45, 0x42, 0x55, 0x47, 0x5D, 0x20, 0x20, 0x2D
	.byte  0x4D, 0x54, 0x5B, 0x64, 0x5D, 0x20, 0x28, 0x73
	.byte  0x74, 0x61, 0x74, 0x69, 0x63, 0x29, 0x20, 0x44
	.byte  0x65, 0x66, 0x69, 0x6E, 0x65, 0x73, 0x20, 0x5F
	.byte  0x4D, 0x54, 0x20, 0x5B, 0x5F, 0x44, 0x45, 0x42
	.byte  0x55, 0x47, 0x5D, 0x0A, 0x2D, 0x6E, 0x63, 0x3C
	.byte  0x6E, 0x61, 0x6D, 0x65, 0x3E, 0x20, 0x53, 0x65
	.byte  0x74, 0x20, 0x63, 0x6C, 0x61, 0x73, 0x73, 0x20
	.byte  0x6E, 0x61, 0x6D, 0x65, 0x20, 0x6F, 0x66, 0x20
	.byte  0x63, 0x6F, 0x64, 0x65, 0x20, 0x73, 0x65, 0x67
	.byte  0x6D, 0x65, 0x6E, 0x74, 0x20, 0x20, 0x20, 0x2D
	.byte  0x6E, 0x64, 0x3C, 0x6E, 0x61, 0x6D, 0x65, 0x3E
	.byte  0x20, 0x53, 0x65, 0x74, 0x20, 0x6E, 0x61, 0x6D
	.byte  0x65, 0x20, 0x6F, 0x66, 0x20, 0x64, 0x61, 0x74
	.byte  0x61, 0x20, 0x73, 0x65, 0x67, 0x6D, 0x65, 0x6E
	.byte  0x74, 0x0A, 0x2D, 0x6E, 0x6D, 0x3C, 0x6E, 0x61
	.byte  0x6D, 0x65, 0x3E, 0x20, 0x53, 0x65, 0x74, 0x20
	.byte  0x6E, 0x61, 0x6D, 0x65, 0x20, 0x6F, 0x66, 0x20
	.byte  0x6D, 0x6F, 0x64, 0x75, 0x6C, 0x65, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x6E, 0x6F
	.byte  0x6C, 0x69, 0x62, 0x20, 0x49, 0x67, 0x6E, 0x6F
	.byte  0x72, 0x65, 0x20, 0x49, 0x4E, 0x43, 0x4C, 0x55
	.byte  0x44, 0x45, 0x4C, 0x49, 0x42, 0x20, 0x64, 0x69
	.byte  0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x0A
	.byte  0x2D, 0x6E, 0x74, 0x3C, 0x6E, 0x61, 0x6D, 0x65
	.byte  0x3E, 0x20, 0x53, 0x65, 0x74, 0x20, 0x6E, 0x61
	.byte  0x6D, 0x65, 0x20, 0x6F, 0x66, 0x20, 0x74, 0x65
	.byte  0x78, 0x74, 0x20, 0x73, 0x65, 0x67, 0x6D, 0x65
	.byte  0x6E, 0x74, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x2D, 0x70, 0x65, 0x5B, 0x63
	.byte  0x7C, 0x67, 0x7C, 0x64, 0x5D, 0x20, 0x47, 0x65
	.byte  0x6E, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x50
	.byte  0x45, 0x20, 0x62, 0x69, 0x6E, 0x61, 0x72, 0x79
	.byte  0x20, 0x66, 0x69, 0x6C, 0x65, 0x0A, 0x2D, 0x71
	.byte  0x2C, 0x20, 0x2D, 0x6E, 0x6F, 0x6C, 0x6F, 0x67
	.byte  0x6F, 0x20, 0x53, 0x75, 0x70, 0x70, 0x72, 0x65
	.byte  0x73, 0x73, 0x20, 0x63, 0x6F, 0x70, 0x79, 0x72
	.byte  0x69, 0x67, 0x68, 0x74, 0x20, 0x6D, 0x65, 0x73
	.byte  0x73, 0x61, 0x67, 0x65, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x2D, 0x72, 0x20, 0x52, 0x65, 0x63, 0x75
	.byte  0x72, 0x73, 0x65, 0x20, 0x73, 0x75, 0x62, 0x64
	.byte  0x69, 0x72, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x69
	.byte  0x65, 0x73, 0x0A, 0x2D, 0x53, 0x61, 0x20, 0x4D
	.byte  0x61, 0x78, 0x69, 0x6D, 0x69, 0x7A, 0x65, 0x20
	.byte  0x73, 0x6F, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6C
	.byte  0x69, 0x73, 0x74, 0x69, 0x6E, 0x67, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x73
	.byte  0x61, 0x66, 0x65, 0x73, 0x65, 0x68, 0x20, 0x41
	.byte  0x73, 0x73, 0x65, 0x72, 0x74, 0x20, 0x65, 0x78
	.byte  0x63, 0x65, 0x70, 0x74, 0x69, 0x6F, 0x6E, 0x20
	.byte  0x68, 0x61, 0x6E, 0x64, 0x6C, 0x65, 0x72, 0x73
	.byte  0x0A, 0x2D, 0x53, 0x66, 0x20, 0x47, 0x65, 0x6E
	.byte  0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x66, 0x69
	.byte  0x72, 0x73, 0x74, 0x20, 0x70, 0x61, 0x73, 0x73
	.byte  0x20, 0x6C, 0x69, 0x73, 0x74, 0x69, 0x6E, 0x67
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x2D, 0x53, 0x67, 0x20
	.byte  0x44, 0x69, 0x73, 0x70, 0x6C, 0x61, 0x79, 0x20
	.byte  0x67, 0x65, 0x6E, 0x65, 0x72, 0x61, 0x74, 0x65
	.byte  0x64, 0x20, 0x63, 0x6F, 0x64, 0x65, 0x20, 0x69
	.byte  0x6E, 0x20, 0x6C, 0x69, 0x73, 0x74, 0x69, 0x6E
	.byte  0x67, 0x0A, 0x2D, 0x53, 0x6E, 0x20, 0x53, 0x75
	.byte  0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x20, 0x73
	.byte  0x79, 0x6D, 0x62, 0x6F, 0x6C, 0x2D, 0x74, 0x61
	.byte  0x62, 0x6C, 0x65, 0x20, 0x6C, 0x69, 0x73, 0x74
	.byte  0x69, 0x6E, 0x67, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x53, 0x70
	.byte  0x5B, 0x6E, 0x5D, 0x20, 0x53, 0x65, 0x74, 0x20
	.byte  0x73, 0x65, 0x67, 0x6D, 0x65, 0x6E, 0x74, 0x20
	.byte  0x61, 0x6C, 0x69, 0x67, 0x6E, 0x6D, 0x65, 0x6E
	.byte  0x74, 0x0A, 0x2D, 0x73, 0x74, 0x61, 0x63, 0x6B
	.byte  0x61, 0x6C, 0x69, 0x67, 0x6E, 0x20, 0x41, 0x6C
	.byte  0x69, 0x67, 0x6E, 0x20, 0x6C, 0x6F, 0x63, 0x61
	.byte  0x6C, 0x73, 0x20, 0x74, 0x6F, 0x20, 0x31, 0x36
	.byte  0x2D, 0x62, 0x79, 0x74, 0x65, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x73, 0x79
	.byte  0x73, 0x76, 0x72, 0x65, 0x67, 0x73, 0x20, 0x53
	.byte  0x74, 0x72, 0x69, 0x70, 0x20, 0x52, 0x44, 0x49
	.byte  0x2F, 0x52, 0x53, 0x49, 0x20, 0x66, 0x72, 0x6F
	.byte  0x6D, 0x20, 0x55, 0x53, 0x45, 0x53, 0x0A, 0x2D
	.byte  0x53, 0x78, 0x20, 0x4C, 0x69, 0x73, 0x74, 0x20
	.byte  0x66, 0x61, 0x6C, 0x73, 0x65, 0x20, 0x63, 0x6F
	.byte  0x6E, 0x64, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x61
	.byte  0x6C, 0x73, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x2D, 0x77, 0x20, 0x53, 0x61, 0x6D
	.byte  0x65, 0x20, 0x61, 0x73, 0x20, 0x2D, 0x57, 0x30
	.byte  0x20, 0x2D, 0x57, 0x58, 0x0A, 0x2D, 0x57, 0x3C
	.byte  0x6E, 0x75, 0x6D, 0x62, 0x65, 0x72, 0x3E, 0x20
	.byte  0x53, 0x65, 0x74, 0x20, 0x77, 0x61, 0x72, 0x6E
	.byte  0x69, 0x6E, 0x67, 0x20, 0x6C, 0x65, 0x76, 0x65
	.byte  0x6C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x2D, 0x77, 0x69, 0x6E, 0x36, 0x34, 0x20, 0x47
	.byte  0x65, 0x6E, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20
	.byte  0x36, 0x34, 0x2D, 0x62, 0x69, 0x74, 0x20, 0x43
	.byte  0x4F, 0x46, 0x46, 0x20, 0x6F, 0x62, 0x6A, 0x65
	.byte  0x63, 0x74, 0x0A, 0x2D, 0x77, 0x73, 0x20, 0x53
	.byte  0x74, 0x6F, 0x72, 0x65, 0x20, 0x71, 0x75, 0x6F
	.byte  0x74, 0x65, 0x64, 0x20, 0x73, 0x74, 0x72, 0x69
	.byte  0x6E, 0x67, 0x73, 0x20, 0x61, 0x73, 0x20, 0x75
	.byte  0x6E, 0x69, 0x63, 0x6F, 0x64, 0x65, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x57
	.byte  0x58, 0x20, 0x54, 0x72, 0x65, 0x61, 0x74, 0x20
	.byte  0x61, 0x6C, 0x6C, 0x20, 0x77, 0x61, 0x72, 0x6E
	.byte  0x69, 0x6E, 0x67, 0x73, 0x20, 0x61, 0x73, 0x20
	.byte  0x65, 0x72, 0x72, 0x6F, 0x72, 0x73, 0x0A, 0x2D
	.byte  0x58, 0x20, 0x49, 0x67, 0x6E, 0x6F, 0x72, 0x65
	.byte  0x20, 0x49, 0x4E, 0x43, 0x4C, 0x55, 0x44, 0x45
	.byte  0x20, 0x65, 0x6E, 0x76, 0x69, 0x72, 0x6F, 0x6E
	.byte  0x6D, 0x65, 0x6E, 0x74, 0x20, 0x70, 0x61, 0x74
	.byte  0x68, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x2D, 0x5A, 0x37, 0x20, 0x41, 0x64
	.byte  0x64, 0x20, 0x66, 0x75, 0x6C, 0x6C, 0x20, 0x73
	.byte  0x79, 0x6D, 0x62, 0x6F, 0x6C, 0x69, 0x63, 0x20
	.byte  0x64, 0x65, 0x62, 0x75, 0x67, 0x20, 0x69, 0x6E
	.byte  0x66, 0x6F, 0x0A, 0x2D, 0x7A, 0x63, 0x77, 0x20
	.byte  0x4E, 0x6F, 0x20, 0x64, 0x65, 0x63, 0x6F, 0x72
	.byte  0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x66, 0x6F
	.byte  0x72, 0x20, 0x43, 0x20, 0x73, 0x79, 0x6D, 0x62
	.byte  0x6F, 0x6C, 0x73, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x5A
	.byte  0x64, 0x20, 0x41, 0x64, 0x64, 0x20, 0x6C, 0x69
	.byte  0x6E, 0x65, 0x20, 0x6E, 0x75, 0x6D, 0x62, 0x65
	.byte  0x72, 0x20, 0x64, 0x65, 0x62, 0x75, 0x67, 0x20
	.byte  0x69, 0x6E, 0x66, 0x6F, 0x0A, 0x2D, 0x5A, 0x66
	.byte  0x20, 0x4D, 0x61, 0x6B, 0x65, 0x20, 0x61, 0x6C
	.byte  0x6C, 0x20, 0x73, 0x79, 0x6D, 0x62, 0x6F, 0x6C
	.byte  0x73, 0x20, 0x70, 0x75, 0x62, 0x6C, 0x69, 0x63
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x2D, 0x7A, 0x66, 0x3C, 0x30, 0x7C, 0x31, 0x3E
	.byte  0x20, 0x53, 0x65, 0x74, 0x20, 0x46, 0x41, 0x53
	.byte  0x54, 0x43, 0x41, 0x4C, 0x4C, 0x20, 0x74, 0x79
	.byte  0x70, 0x65, 0x3A, 0x20, 0x4D, 0x53, 0x2D, 0x4F
	.byte  0x57, 0x0A, 0x2D, 0x5A, 0x67, 0x20, 0x47, 0x65
	.byte  0x6E, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x63
	.byte  0x6F, 0x64, 0x65, 0x20, 0x74, 0x6F, 0x20, 0x6D
	.byte  0x61, 0x74, 0x63, 0x68, 0x20, 0x4D, 0x61, 0x73
	.byte  0x6D, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x5A, 0x69
	.byte  0x5B, 0x30, 0x31, 0x32, 0x33, 0x34, 0x38, 0x5D
	.byte  0x20, 0x41, 0x64, 0x64, 0x20, 0x73, 0x79, 0x6D
	.byte  0x62, 0x6F, 0x6C, 0x69, 0x63, 0x20, 0x64, 0x65
	.byte  0x62, 0x75, 0x67, 0x20, 0x69, 0x6E, 0x66, 0x6F
	.byte  0x0A, 0x2D, 0x7A, 0x6C, 0x63, 0x20, 0x4E, 0x6F
	.byte  0x20, 0x4F, 0x4D, 0x46, 0x20, 0x72, 0x65, 0x63
	.byte  0x6F, 0x72, 0x64, 0x73, 0x20, 0x6F, 0x66, 0x20
	.byte  0x64, 0x61, 0x74, 0x61, 0x20, 0x69, 0x6E, 0x20
	.byte  0x63, 0x6F, 0x64, 0x65, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x2D, 0x7A, 0x6C, 0x64
	.byte  0x20, 0x4E, 0x6F, 0x20, 0x4F, 0x4D, 0x46, 0x20
	.byte  0x72, 0x65, 0x63, 0x6F, 0x72, 0x64, 0x73, 0x20
	.byte  0x6F, 0x66, 0x20, 0x66, 0x61, 0x72, 0x20, 0x63
	.byte  0x61, 0x6C, 0x6C, 0x0A, 0x2D, 0x5A, 0x6D, 0x20
	.byte  0x45, 0x6E, 0x61, 0x62, 0x6C, 0x65, 0x20, 0x4D
	.byte  0x41, 0x53, 0x4D, 0x20, 0x35, 0x2E, 0x31, 0x30
	.byte  0x20, 0x63, 0x6F, 0x6D, 0x70, 0x61, 0x74, 0x69
	.byte  0x62, 0x69, 0x6C, 0x69, 0x74, 0x79, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D
	.byte  0x5A, 0x76, 0x38, 0x20, 0x45, 0x6E, 0x61, 0x62
	.byte  0x6C, 0x65, 0x20, 0x4D, 0x61, 0x73, 0x6D, 0x20
	.byte  0x76, 0x38, 0x2B, 0x20, 0x50, 0x52, 0x4F, 0x43
	.byte  0x20, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6C
	.byte  0x69, 0x74, 0x79, 0x0A, 0x2D, 0x5A, 0x6E, 0x65
	.byte  0x20, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6C, 0x65
	.byte  0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x4D, 0x61, 0x73
	.byte  0x6D, 0x20, 0x65, 0x78, 0x74, 0x65, 0x6E, 0x73
	.byte  0x69, 0x6F, 0x6E, 0x73, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2D
	.byte  0x7A, 0x6C, 0x3C, 0x66, 0x7C, 0x70, 0x7C, 0x73
	.byte  0x3E, 0x20, 0x53, 0x75, 0x70, 0x70, 0x72, 0x65
	.byte  0x73, 0x73, 0x20, 0x69, 0x74, 0x65, 0x6D, 0x73
	.byte  0x20, 0x69, 0x6E, 0x20, 0x43, 0x4F, 0x46, 0x46
	.byte  0x0A, 0x2D, 0x5A, 0x70, 0x5B, 0x6E, 0x5D, 0x20
	.byte  0x53, 0x65, 0x74, 0x20, 0x73, 0x74, 0x72, 0x75
	.byte  0x63, 0x74, 0x75, 0x72, 0x65, 0x20, 0x61, 0x6C
	.byte  0x69, 0x67, 0x6E, 0x6D, 0x65, 0x6E, 0x74, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x2D, 0x5A, 0x73, 0x20
	.byte  0x50, 0x65, 0x72, 0x66, 0x6F, 0x72, 0x6D, 0x20
	.byte  0x73, 0x79, 0x6E, 0x74, 0x61, 0x78, 0x20, 0x63
	.byte  0x68, 0x65, 0x63, 0x6B, 0x20, 0x6F, 0x6E, 0x6C
	.byte  0x79, 0x0A, 0x2D, 0x7A, 0x74, 0x3C, 0x30, 0x7C
	.byte  0x31, 0x7C, 0x32, 0x3E, 0x20, 0x53, 0x65, 0x74
	.byte  0x20, 0x53, 0x54, 0x44, 0x43, 0x41, 0x4C, 0x4C
	.byte  0x20, 0x64, 0x65, 0x63, 0x6F, 0x72, 0x61, 0x74
	.byte  0x69, 0x6F, 0x6E, 0x20, 0x20, 0x20, 0x20, 0x20
	.byte  0x20, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x7A, 0x7A
	.byte  0x65, 0x20, 0x4E, 0x6F, 0x20, 0x65, 0x78, 0x70
	.byte  0x6F, 0x72, 0x74, 0x20, 0x73, 0x79, 0x6D, 0x62
	.byte  0x6F, 0x6C, 0x20, 0x64, 0x65, 0x63, 0x6F, 0x72
	.byte  0x61, 0x74, 0x69, 0x6F, 0x6E, 0x0A, 0x2D, 0x7A
	.byte  0x7A, 0x73, 0x20, 0x53, 0x74, 0x6F, 0x72, 0x65
	.byte  0x20, 0x6E, 0x61, 0x6D, 0x65, 0x20, 0x6F, 0x66
	.byte  0x20, 0x73, 0x74, 0x61, 0x72, 0x74, 0x20, 0x61
	.byte  0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x0A, 0x00

DS0000:
	.byte  0x0A, 0x25, 0x73, 0x0A, 0x00


.att_syntax prefix
